<?php

use App\Http\Controllers\Admin\WhatsappController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\InstagramController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// whatsapp webhooks
Route::get('/webhook', [WhatsappController::class, 'verifyWebhook']);
Route::post('/webhook', [WhatsappController::class, 'handleIncomingMessage']);

// instagram webhooks
Route::get('/instagram-webhook', [InstagramController::class, 'verifyWebhook']);
Route::post('/instagram-webhook', [InstagramController::class, 'handleIncomingMessage']);
