@extends('layouts.adminmaster')

		@section('styles')

		<!-- INTERNAL Data table css -->
		<link href="{{asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
		<link href="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

		<!-- INTERNAL Sweet-Alert css -->
		<link href="{{asset('build/assets/plugins/sweet-alert/sweetalert.css')}}" rel="stylesheet" />

        <style>
            #hideAfterloading {
                position: absolute;
                top: 100px;
                left: 45%;
            }
        </style>

		@endsection

							@section('content')

							<!--Page header-->
							<div class="page-header d-xl-flex d-block">
								<div class="page-leftheader">
									<h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('IP List', 'menu')}}</span></h4>
								</div>
							</div>
							<!--End Page header-->

							<!-- IP List-->
							<div class="col-xl-12 col-lg-12 col-md-12">
								<div class="card ">
									<div class="card-header border-0 d-sm-max-flex">
										<h4 class="card-title">{{lang('IP List', 'menu')}}</h4>
										<div class="card-options mt-sm-max-2">
											@can('IpBlock Add')

											<a href="javascript:void(0)" class="btn btn-secondary me-3" id="create-new-ip">{{lang('Add IP Address')}}</a>
											@endcan

										</div>
									</div>
									<div class="card-body" style="min-height: 250px;">
										<div class="table-responsive">
											@can('IpBlock Delete')

											<button id="massdeletenotify" class="btn btn-outline-light btn-sm mb-4 data-table-btn" style="display: none;"><i class="fe fe-trash"></i> {{lang('Delete')}}</button>
											@endcan

											<table class="table table-bordered border-bottom text-nowrap ticketdeleterow w-100" id="support-articlelists">
												<thead>
													<tr>
														<th  width="10">{{lang('Sl.No')}}</th>
														@can('IpBlock Delete')

														<th width="10" >
															<input type="checkbox"  id="customCheckAll" class="form-check-input">
															<label  for="customCheckAll"></label>
														</th>
														@endcan
														@cannot('IpBlock Delete')

														<th width="10" >
															<input type="checkbox"  id="customCheckAll" class="form-check-input" disabled>
															<label  for="customCheckAll"></label>
														</th>
														@endcannot

														<th >{{lang('IP')}}</th>
														<th >{{lang('Country')}}</th>
														<th >{{lang('Entry')}}</th>
														<th >{{lang('Types')}}</th>
														<th >{{lang('Actions')}}</th>
													</tr>
												</thead>
												<div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                                                    <p>{{lang('loading.. Please Wait')}}</p>
                                                </div>
											</table>
										</div>
									</div>
								</div>
							</div>
							<!--End IP List-->
							@endsection

		@section('scripts')

		<!--INTERNAL Owl-carousel js -->
		<script src="{{asset('build/assets/plugins/owl-carousel/owl-carousel.js')}}?v=<?php echo time(); ?>"></script>

		<!-- INTERNAL Data tables -->
		<script src="{{asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/dataTables.responsive.min.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js')}}?v=<?php echo time(); ?>"></script>

		<!-- INTERNAL Index js-->
        @vite(['resources/assets/js/support/support-sidemenu.js'])

		<!-- INTERNAL Sweet-Alert js-->
		<script src="{{asset('build/assets/plugins/sweet-alert/sweetalert.min.js')}}?v=<?php echo time(); ?>"></script>

		<script type="text/javascript">
            "use strict";

            document.addEventListener("DOMContentLoaded", (event) => {

                let tableData = @json($iplists);

                let dateFormat = @json(setting('date_format'));
                let delPerm = @json(Auth::user()->can('IpBlock Delete'));
                let editPerm = @json(Auth::user()->can('IpBlock Edit'));

                var dataTable;
                var tableDropDown;

                loadTable(tableData);

                function truncateTitle(title) {
                    const maxLength = 40;
                    return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
                }

                function loadTable(tableData) {
                    document.getElementById('hideAfterloading')?.classList.remove('d-none');
                    document.getElementById('theadShow')?.classList.add('d-none');
                    if (tableDropDown)
                        tableDropDown.destroy();

                    if (dataTable)
                        dataTable.destroy();

                    if (document.getElementById('tableBody'))
                        document.getElementById('tableBody').remove();

                    let createTbody = document.createElement('tbody');
                    createTbody.setAttribute('id', "tableBody");
                    let rows = tableData.map((data, index) => {

                        return `
                            <tr>
                                <td>${index + 1}</td>

                                <td>
                                    ${delPerm ? `<input type="checkbox" name="spruko_checkbox[]" class="checkall form-check-input" value="${data.id}" />` : '~'}
                                </td>

                                <td>${data.ip ? data.ip : ''}</td>

                                <td>${data.country ? data.country : ''}</td>

                                <td>${data.entrytype ? data.entrytype : ''}</td>

                                <td>${data.types ? data.types : ''}</td>

                                <td>
                                    <div class = "d-flex">
                                        ${editPerm ? `<a href="javascript:void(0)" data-id="${data.id}" class="action-btns1 edit-iplist"><i class="feather feather-edit text-primary" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Edit')}}"></i></a>` : ''}

                                        ${delPerm ? `<a href="javascript:void(0)" data-id="${data.id}" class="action-btns1" id="delete-iplist" ><i class="feather feather-trash-2 text-danger" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Delete')}}"></i></a>` : ''}


                                        ${data.typestypes != 'Unlock' ? `<a href="javascript:void(0)" data-id="${data.id}" class="action-btns1" id="reset-iplist" ><i class="feather feather-rotate-ccw text-success" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Reset')}}"></i></a>` : ''}
                                    </div>

                                </td>

                            </tr>
                        `;
                    });

                    if (tableData.length == 0)
                        createTbody.innerHTML = ` `;
                    else
                        createTbody.innerHTML = rows.join('');


                    // Append the tbody to your table
                    // Replace 'your-table-id' with the actual ID of your table element
                    document.getElementById('support-articlelists').appendChild(createTbody);

                    document.getElementById('hideAfterloading')?.classList.add('d-none');
                    document.getElementById('theadShow')?.classList.remove('d-none');

                    $(document).ready(function() {

                        var SITEURL = '{{ url('') }}';

                        // Csrf field
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });

                        let prev = {!! json_encode(lang("Previous")) !!};
                        let next = {!! json_encode(lang("Next")) !!};
                        let nodata = {!! json_encode(lang("No data available in table")) !!};
                        let noentries = {!! json_encode(lang("No entries to show")) !!};
                        let showing = {!! json_encode(lang("showing page")) !!};
                        let ofval = {!! json_encode(lang("of")) !!};
                        let maxRecordfilter = {!! json_encode(lang("- filtered from ")) !!};
                        let maxRecords = {!! json_encode(lang("records")) !!};
                        let entries = {!! json_encode(lang("entries")) !!};
                        let show = {!! json_encode(lang("Show")) !!};
                        let search = {!! json_encode(lang("Search")) !!};
                        // Datatable
                        $('#support-articlelists').dataTable({
                            language: {
                                searchPlaceholder: search,
                                scrollX: "100%",
                                sSearch: '',
                                paginate: {
                                previous: prev,
                                next: next
                                },
                                emptyTable : nodata,
                                infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                                info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                                infoEmpty: noentries,
                                lengthMenu: `${show} _MENU_ ${entries} `,
                            },
                            order:[],
                            columnDefs: [
                                { "orderable": false, "targets":[ 0,1,4] }
                            ],
                        });

                        $('.form-select').select2({
                            minimumResultsForSearch: Infinity,
                            width: '100%'
                        });

                        $('.form-select').on('focus', function() {
                            $(this).attr('aria-hidden', 'false');
                        });
                    });


                    initializeTooltips();

                    function initializeTooltips() {
                        var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                        tooltipElements.forEach(function(element) {
                            new bootstrap.Tooltip(element);
                        });
                    }


                }

                $(function() {

                    (function($)  {

                        // Variables
                        var SITEURL = '{{url('')}}';

                        /*  When user click add ip button */
                        $('#create-new-ip').on('click', function () {
                            $('#btnsave').val("ipblock");
                            $('#IP_id').val('');
                            $('#IP_form').trigger("reset");
                            $('.modal-title').html("{{lang('Add New IP Address')}}");
                            $('#addIP').modal('show');
                        });

                        /* When click edit ip */
                        $('body').on('click', '.edit-iplist', function () {
                            var ip_id = $(this).data('id');
                            $.get('ipblocklist/' + ip_id , function (data) {
                                $('#nameError').html('');
                                $('#displayError').html('');
                                $('.modal-title').html("{{lang('Edit IP Address')}}");
                                $('#btnsave').val("edit-ip");
                                $('#addIP').modal('show');
                                $('#IP_id').val(data.id);
                                $('#ip').val(data.ip);
                                if (data.types == "Unlock")
                                {
                                    $('.iptype1').prop('checked', true);
                                }
                                if (data.types == "Locked")
                                {
                                    $('.iptype2').prop('checked', true);
                                }
                                if (data.types == "Blocked")
                                {
                                    $('.iptype3').prop('checked', true);
                                }

                            })
                        });

                        // submit ip list
                        $('body').on('submit', '#IP_form', function (e) {
                            e.preventDefault();
                            var actionType = $('#btnsave').val();
                            var fewSeconds = 2;
                            $('#btnipsave').html('Sending ... <i class="fa fa-spinner fa-spin"></i>');
                            $('#btnipsave').prop('disabled', true);
                                setTimeout(function(){
                                    $('#btnipsave').prop('disabled', false);
                                }, fewSeconds*1000);
                            var formData = new FormData(this);
                            $.ajax({
                                type:'POST',
                                url: SITEURL + "/admin/ipblocklist/create",
                                data: formData,
                                cache:false,
                                contentType: false,
                                processData: false,
                                success: (data) => {
                                    $('#nameError').html('');
                                    $('#displayError').html('');
                                    $('#IP_form').trigger("reset");
                                    $('#addIP').modal('hide');
                                    $('#btnipsave').html('{{lang('Save')}}');
                                    toastr.success(data.success);
                                    if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                        $('#support-articlelists').DataTable().clear().destroy();
                                    }
                                    tableData = data.iplists;
                                    loadTable(tableData);
                                },
                                error: function(data){
                                    $('#nameError').html('');
                                    $('#displayError').html('');
                                    $('#nameError').html(data.responseJSON.errors.ip);
                                    $('#displayError').html(data.responseJSON.errors.types);
                                    $('#btnipsave').html('{{lang('Save')}}');
                                }
                            });
                        });

                        // delete ip list
                        $('body').on('click', '#delete-iplist', function () {
                            let parent = $(this).closest('tr');
                            var _id = $(this).data("id");
                            swal({
                                title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                                text: "{{lang('This might erase your records permanently', 'alerts')}}",
                                icon: "warning",
                                buttons: true,
                                dangerMode: true,
                            })
                            .then((willDelete) => {
                                if (willDelete) {
                                    $.ajax({
                                        type: "delete",
                                        url: SITEURL + "/admin/ipblocklist/delete/"+_id,
                                        success: function (data) {
                                            toastr.success(data.success);
                                            $(parent[0]).addClass('fade-out');
                                            let newData = tableData.filter(item => item.id != parseInt(_id));
                                            tableData = newData;
                                            setTimeout(() => {
                                                parent[0].remove();
                                                if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                                    $('#support-articlelists').DataTable().clear().destroy();
                                                }
                                                loadTable(tableData);
                                            }, 1500);
                                        },
                                        error: function (data) {
                                            console.log('Error:', data);
                                        }
                                    });
                                }
                            });
                        });

                        // Mass delete ip list
                        $('body').on('click', '#massdeletenotify', function () {
                            var parent = [];
                            var id = [];
                            $('.checkall:checked').each(function(){
                                parent.push($(this).closest('tr'));
                                id.push($(this).val());
                            });
                            if(id.length > 0){
                                swal({
                                    title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                                    text: "{{lang('This might erase your records permanently', 'alerts')}}",
                                    icon: "warning",
                                    buttons: true,
                                    dangerMode: true,
                                })
                                .then((willDelete) => {
                                    if (willDelete) {
                                        $.ajax({
                                            url:"{{ route('ipblocklist.deleteall')}}",
                                            method:"post",
                                            data:{id:id},
                                            success:function(data)
                                            {
                                                toastr.success(data.success);
                                                parent.forEach(function(row) {
                                                    row.addClass('fade-out');
                                                });
                                                let newData = tableData.filter(item => !id.includes(String(item.id)));
                                                tableData = newData;
                                                setTimeout(() => {
                                                    parent.forEach(function(row) {
                                                        row.remove();
                                                    });
                                                    if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                                        $('#support-articlelists').DataTable().clear().destroy();
                                                    }
                                                    $('#customCheckAll').prop('checked', false);
                                                    loadTable(tableData);
                                                }, 1500);

                                            },
                                            error:function(data){
                                                console.log(data);
                                            }
                                        });
                                    }
                                });
                            }
                            else{
                                toastr.error('{{lang('Please select at least one check box.', 'alerts')}}');
                            }

                        });

                        // Reset ip js
                        $('body').on('click', '#reset-iplist', function(){
                            var reset_id = $(this).data("id");
                            swal({
                                title: `{{lang('Are you sure you want to reset this record?', 'alerts')}}`,
                                icon: "warning",
                                buttons: true,
                                dangerMode: true,
                            })
                            .then((willDelete) => {
                                if (willDelete) {
                                    $.ajax({
                                        type: "post",
                                        url: SITEURL + "/admin/ipblocklist/reset/"+reset_id,
                                        success: function (data) {
                                            toastr.success(data.success);
                                            if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                                $('#support-articlelists').DataTable().clear().destroy();
                                            }
                                            tableData = data.iplists;
                                            loadTable(tableData);
                                        },
                                        error: function (data) {
                                            console.log('Error:', data);
                                        }
                                    });
                                }
                            });
                        });

                        //checkbox script
                        $(document).ready(function() {

                            $(document).on('click', '#customCheckAll', function() {
                                $('.checkall').prop('checked', this.checked);
                                updateMassDeleteVisibility();
                            });

                            $(document).on('click', '.checkall', function() {
                                updateCustomCheckAll();
                                updateMassDeleteVisibility();
                            });


                            $(document).on('click', '.pagination a', function() {

                                setTimeout(function() {
                                    updateMassDeleteVisibility();
                                }, 100);
                            });


                            $('#customCheckAll').prop('checked', false);


                            function updateMassDeleteVisibility() {
                                if ($('.checkall:checked').length == 0) {
                                    $('#massdeletenotify').hide();
                                } else {
                                    $('#massdeletenotify').show();
                                }
                            }


                            function updateCustomCheckAll() {
                                var totalCheckboxes = $('.checkall').length;
                                var checkedCheckboxes = $('.checkall:checked').length;

                                if (checkedCheckboxes === totalCheckboxes) {
                                    $('#customCheckAll').prop('checked', true);
                                } else {
                                    $('#customCheckAll').prop('checked', false);
                                }
                            }
                        });
                    })(jQuery);
                });
            });

		</script>
		@endsection
		@section('modal')

    		@include('admin.securitysetting.ipblockmodel')

		@endsection
