
@extends('layouts.adminmaster')

		@section('styles')

		<!-- INTERNAL Data table css -->
		<link href="{{asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
		<link href="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

        <style>
            #hideAfterloading {
                position: absolute;
                top: 100px;
                left: 45%;
            }
        </style>

		@endsection

							@section('content')

							<!--Page header-->
							<div class="page-header d-xl-flex d-block">
								<div class="page-leftheader">
									<h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Role & Permissions', 'menu')}}</span></h4>
								</div>
							</div>
							<!--End Page header-->

							<!--Role List-->
							<div class="col-xl-12 col-lg-12 col-md-12">
								<div class="card ">
									<div class="card-header border-0 flex-wrap gap-2">
										<h4 class="card-title">{{lang('Roles List')}}</h4>
										<div class="card-options mt-sm-max-2">
											@can('Roles & Permission Create')

											<a href="{{url('admin/role/create')}}" class="btn btn-primary me-3" >{{lang('Add Role & Permissions')}}</a>
											@endcan

										</div>
									</div>
									<div class="card-body" style="min-height: 250px;">
										<div class="table-responsive role-table">
											<table class="table table-bordered border-bottom text-nowrap w-100" id="roleslist">
												<thead>
													<tr>
														<th  width="10">{{lang('Sl.No')}}</th>
														<th >{{lang('Role Name')}}</th>
														<th >{{lang('Employees Count')}}</th>
														<th >{{lang('Permissions Count')}}</th>
														<th >{{lang('Actions')}}</th>
													</tr>
												</thead>
                                                <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                                                    <p>{{lang('loading.. Please Wait')}}</p>
                                                </div>
												{{-- <tbody>
													@php $i = 1; @endphp
													@foreach ($roles as $role)
														<tr>
															<td>{{$i++}}</td>
															<td>{{Str::limit($role->name, '40')}}</td>
															<td>
																<span class="badge badge-primary">{{$role->users->count()}}</span>
															</td>
															<td>
																<span class="badge badge-success">{{$role->permissions->count()}}</span>
															</td>
															<td>
																<div class = "d-flex">
																@if(Auth::user()->can('Roles & Permission Edit'))

																	@if($role->name != 'superadmin')
																	<a href="{{url('/admin/role/edit/'.$role->id)}}" class="action-btns1"  data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Edit')}}"><i class="feather feather-edit text-primary"></i></a>
																	@endif
																@else

																	~
																@endif

																</div>
															</td>
														</tr>
													@endforeach
												</tbody> --}}
											</table>
										</div>
									</div>
									</div>
								</div>
							</div>
							<!--End Role List-->

							@endsection

		@section('scripts')

		<!-- INTERNAL Vertical-scroll js-->
		<script src="{{asset('build/assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js')}}?v=<?php echo time(); ?>"></script>

		<!-- INTERNAL Data tables -->
		<script src="{{asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/dataTables.responsive.min.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js')}}?v=<?php echo time(); ?>"></script>

		<!-- INTERNAL Index js-->
        @vite(['resources/assets/js/support/support-sidemenu.js'])
        @vite(['resources/assets/js/support/support-admindash.js'])

		<script type="text/javascript">
            "use strict";

            document.addEventListener("DOMContentLoaded", (event) => {

                let tableData = @json($roles);
                let editPerm = @json(Auth::user()->can('Roles & Permission Edit'));
                var SITEURL = '{{ url('') }}';

                var dataTable;
                var tableDropDown;

                loadTable(tableData);

                function truncateTitle(title) {
                    const maxLength = 40;
                    return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
                }

                function loadTable(tableData) {
                    document.getElementById('hideAfterloading')?.classList.remove('d-none');
                    document.getElementById('theadShow')?.classList.add('d-none');
                    if (tableDropDown)
                        tableDropDown.destroy();

                    if (dataTable)
                        dataTable.destroy();

                    if (document.getElementById('tableBody'))
                        document.getElementById('tableBody').remove();

                    let createTbody = document.createElement('tbody');
                    createTbody.setAttribute('id', "tableBody");
                    let rows = tableData.map((data, index) => {

                        return `
                            <tr>
                                <td>${index + 1}</td>

                                <td>${truncateTitle(data.name)}</td>

                                <td><span class="badge badge-primary">${data.users.length}</span></td>

                                <td><span class="badge badge-success">${data.permissions.length}</span></td>

                                <td>

                                    ${editPerm ? (data.name != 'superadmin' ? `<a href="${SITEURL}/admin/role/edit/${data.id}" class="action-btns1"  data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Edit')}}"><i class="feather feather-edit text-primary"></i></a>` : '' ) : '~'
                                    }

                                </td>

                            </tr>
                        `;
                    });

                    if (tableData.length == 0)
                        createTbody.innerHTML = ` `;
                    else
                        createTbody.innerHTML = rows.join('');


                    document.getElementById('roleslist').appendChild(createTbody);

                    document.getElementById('hideAfterloading')?.classList.add('d-none');
                    document.getElementById('theadShow')?.classList.remove('d-none');

                    $(document).ready(function() {

                        var SITEURL = '{{ url('') }}';

                        // Csrf field
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });

                        let prev = {!! json_encode(lang("Previous")) !!};
                        let next = {!! json_encode(lang("Next")) !!};
                        let nodata = {!! json_encode(lang("No data available in table")) !!};
                        let noentries = {!! json_encode(lang("No entries to show")) !!};
                        let showing = {!! json_encode(lang("showing page")) !!};
                        let ofval = {!! json_encode(lang("of")) !!};
                        let maxRecordfilter = {!! json_encode(lang("- filtered from ")) !!};
                        let maxRecords = {!! json_encode(lang("records")) !!};
                        let entries = {!! json_encode(lang("entries")) !!};
                        let show = {!! json_encode(lang("Show")) !!};
                        let search = {!! json_encode(lang("Search")) !!};
                        // Datatable
                        $('#roleslist').dataTable({
                            language: {
                                searchPlaceholder: search,
                                scrollX: "100%",
                                sSearch: '',
                                paginate: {
                                previous: prev,
                                next: next
                                },
                                emptyTable : nodata,
                                infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                                info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                                infoEmpty: noentries,
                                lengthMenu: `${show} _MENU_ ${entries} `,
                            },
                            order:[],
                            columnDefs: [
                                { "orderable": false, "targets":[ 0,1,4] }
                            ],
                        });

                        $('.form-select').select2({
                            minimumResultsForSearch: Infinity,
                            width: '100%'
                        });

                        $('.form-select').on('focus', function() {
                            $(this).attr('aria-hidden', 'false');
                        });
                    });


                    initializeTooltips();

                    function initializeTooltips() {
                        var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                        tooltipElements.forEach(function(element) {
                            new bootstrap.Tooltip(element);
                        });
                    }
                }

                $(function() {
                    (function($)  {
                        $('#customCheckAll').prop('checked', false);
                        $('.checkall').on('click', function(){
                            if($('.checkall:checked').length == $('.checkall').length){
                                $('#customCheckAll').prop('checked', true);
                            }else{
                                $('#customCheckAll').prop('checked', false);
                            }
                        });

                    })(jQuery);
                });
            });


		</script>

		@endsection
