@extends('layouts.adminmaster')
@section('styles')
    <style>
        .file-img {
            position: relative;
        }

        /* .list-unstyled{
            overflow:  hidden !important;
        } */

        .file-img button {
            position: absolute;
            inset-block-start: -4px;
            inset-inline-end: -4px;
            height: 20px;
            width: 20px;
            padding: 0px;
            border: 0;
        }

        .liveChatImageViewer {
            display: block;
            position: fixed;
            z-index: 9999999999;
            padding-top: 100px;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.9);
        }

        .liveChatImageClose {
            position: absolute;
            top: 15px;
            right: 35px;
            color: #f1f1f1;
            font-size: 40px;
            font-weight: bold;
            transition: 0.3s;
            border: 1px solid;
            padding: 0px 20px;
            border-radius: 50%;
            cursor: pointer;
        }

        .liveChatImageTag {
            margin: auto;
            display: block;
            /* width: 80vh; */
            height: 80vh;
            /* max-width: 403px; */
            border-radius: 10px;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            -webkit-box-pack: center;
            justify-content: center;
        }

        .editable-container {
            position: relative;
            width: 100%;
            height: auto;
        }

        .editable-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            padding: 8px;
            color: #aaa;
            pointer-events: none;
            user-select: none;
            transition: opacity 0.2s ease;
        }

        .editable-container div[contenteditable]:empty::before {
            content: 'Type message';
            opacity: 0.6;
        }

        .editable-container div[contenteditable]:not(:empty)::before {
            content: '';
        }

        .editable-container div[contenteditable] {
            padding: 8px;
            box-sizing: border-box;
        }

        .is-loading .agent-detail .font-weight-semibold,
        .is-loading .agent-detail .text-muted,
        .is-loading .agent-detail .avatar,
        .is-loading .agent-detail .name-email-container {
            background: linear-gradient(110deg, #ececec 8%, #f5f5f5 18%, #ececec 33%);
            border-radius: 5px;
            background-size: 200% 100%;
            /* Remove !important */
        }

        /* Adjust animation properties */
        @keyframes shine {
            to {
                background-position-x: 200%;
                /* Adjust direction */
            }
        }

        /* Apply animation to the elements */
        .is-loading .agent-detail .font-weight-semibold,
        .is-loading .agent-detail .text-muted,
        .is-loading .agent-detail .avatar,
        .is-loading .agent-detail .name-email-container {
            animation: shine 1.5s linear infinite;
        }


        .is-loading .agent-detail .avatar,
        .is-loading .agent-detail .name-email-container {
            background-image: linear-gradient(110deg, #ececec 8%, #f5f5f5 18%, #ececec 33%) !important;
            border-radius: 5px
        }

        .is-loading .agent-detail .onlineOfflineIndicator {
            display: none
        }

        .is-loading .agent-detail .font-weight-semibold,
        .is-loading .agent-detail .text-muted {
            opacity: 0;
        }

        .is-loading#main-chat-content .avatar,
        .is-loading#main-chat-content .operator-conversation-Info .flex-fill,
        .is-loading#main-chat-content .avatar,
        .is-loading#main-chat-content .chatnameperson,
        .is-loading#main-chat-content .chatting-user-info,
        .is-loading#main-chat-content .chat-day-label span,
        .is-loading#main-chat-content .chat-list-inner .main-chat-msg div {
            background-image: linear-gradient(110deg, #ececec 8%, #f5f5f5 18%, #ececec 33%) !important;
            border-radius: 5px;
            animation: shine 1.5s linear infinite;
            background: linear-gradient(110deg, #ececec 8%, #f5f5f5 18%, #ececec 33%);
            border-radius: 5px;
            background-size: 200% 100%;
        }

        .is-loading#main-chat-content .chat-day-label span {
            padding: 0.188rem 3.5rem !important
        }

        .is-loading#main-chat-content .chatnameperson,
        .is-loading#main-chat-content .chat-item-end .chatting-user-info {
            padding: 0.188rem 3.5rem;
            font-size: 0.7rem;
            background-color: rgba(51, 102, 255, 0.1);
            border-radius: 0.3rem;
            color: var(--primary);
        }

        .main-chat-msg p {
            word-wrap: break-word !important;
            word-break: break-word !important;
        }

        .dark-mode .main-chart-wrapper .chat-info {
            background-color: #191d43 !important
        }

        .dark-mode .chat-reply-area {
            background-color: #191d43 !important
        }

        .dark-mode .main-chart-wrapper .chat-info ul li.checkforactive {
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .dark-mode .checkforactive.active {
            background-color: rgba(255, 255, 255, 0.05);
        }

        .dark-mode .main-chart-wrapper .main-chat-area .chat-content .main-chat-msg div p {
            color: #f1f4fb;
        }

        .dark-mode .main-chart-wrapper .main-chat-area .chat-content .chat-item-start .main-chat-msg div,
        .dark-mode .main-chart-wrapper .main-chat-area .chat-content .chat-item-end .main-chat-msg div {
            background-color: rgb(37 38 74);
        }

        .tickets-chat-head {
            position: relative;
        }
        .tickets-chat-head .data-table-btn1 {
            position: absolute;
            right: 55px;
        }
        .tickets-chat-head .data-table-btn3 {
            position: absolute;
            right: 15px;
        }
        .main-chart-wrapper .chat-info ul li.checkforactive:hover .ticket-select-check{
            display: block
        }
        .ticket-select-check {
            position: absolute;
            inset-inline-start: 22px;
            inset-block-start: 22px;
            display: none;
            z-index: 100;
        }

        ul.show-checks li.checkforactive .ticket-select-check {
            display: block;
        }
        .chat-users-tab li {
            position: relative;
        }

        .is-loading ul{
                background-image: url(https://laravelui.spruko.com/dayone/assets/images/svgs/loader.svg);
                display: block !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
                padding: 2.5rem !important;
                background-size: auto !important;
                background-attachment: inherit !important;
        }

        .is-loading ul li{
            display: none !important;
        }

        .is-loading #operator-conversation-Info, .is-loading .chat-footer{
            display: none !important;
        }

        /* spell check and suggestion */
        #auto-expand {
            position: relative;
            border: 1px solid #ccc;
            padding: 10px;
            min-height: 40px;
            width: 100%;
            font-size: 16px;
            /* height: 100% !important; */
        }

        #suggestionText {
            padding: 4px 8px;
            font-size: 14px;
            color: #333;
            pointer-events: none;
            opacity: 0.5;
            z-index: 999;
            white-space: nowrap;
        }

        .misspelled {
            text-decoration: underline wavy red;
            cursor: pointer;
            position: relative;
        }

        .correctedtooltip {
            padding: 5px 10px;
            border-radius: 5px;
            color: #333;
            font-size: 12px;
            white-space: nowrap;
            z-index: 100000;
            cursor: pointer;
        }

        /* start text to speach */
        .msg-send-dropdown{
            display: none;
            position: absolute;
            position: absolute;
            inset-inline-end: 17px;
            inset-block-start: 9px;
        }
        .chat-list-inner{
            position: relative;
            /* padding: 1rem; */
            border-radius: 0.35rem;
            width:100%;
        }
        /* .chat-list-inner:hover{
            background-color: #f1f4fb;
        } */
        .chat-list-inner:hover .msg-send-dropdown {
            display: block
        }
        .chatting-user-info{
            margin-inline-end: 1.5rem;
        }
        .main-chart-wrapper .dropdown-menu li{
            margin-block-end:0px !important;
        }
        /* end text to speach */

    </style>

    <!-- INTERNAL Sweet-Alert css -->
    <link href="{{ asset('build/assets/plugins/sweet-alert/sweetalert.css') }}?v=<?php echo time(); ?>" rel="stylesheet" />
@endsection

@section('content')
    <!--Page header-->
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Operators Chat','menu')}}</span></h4>
        </div>
    </div>
    <!--End Page header-->
    <div class="main-chart-wrapper">
        <div class="row">
            <div class="col-xxl-3 col-xl-4 col-lg-5">
                <div class="chat-info border card">
                    <div class="p-4 ps-4  tickets-chat-head border-bottom">
                        <h5 class="fw-semibold mb-0">{{ lang('All Operators') }}</h5>
                        <button id="massdelete" class="btn btn-outline-light btn-sm btn-icon data-table-btn1" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Delete" style="display: none;"><i class="fe fe-trash"></i> </button>
                        <span class="ms-6" id="selectallbutton" style="display: none;">
                            <input aria-label="anchor" class="form-check-input" type="checkbox" id="customCheckAll" class="form-check-input">
                            <label for="customCheckAll" class="mb-0"></label>
                        </span>
                    </div>
                    <div>
                        <ul class="list-unstyled mb-0 mt-2 px-2 chat-users-tab overflow-auto" id="chat-msg-scroll">
                            @php
                                $emptyConversation = true;
                            @endphp
                            @foreach ($allconver as $conversation)
                                @php
                                    $conver = collect($conversation)->sortByDesc('created_at')->first();
                                    $markasUnread = false;

                                    foreach ($conversation as $markAsUnreadarray) {
                                        if (
                                            is_array(json_decode($markAsUnreadarray['mark_as_unread'])) &&
                                            in_array(auth()->id(), json_decode($markAsUnreadarray['mark_as_unread']))
                                        ) {
                                            $markasUnread = true;
                                            break;
                                        }
                                    }
                                @endphp
                                @if ((json_decode($conver['delete_status']) && !in_array(Auth::id(), json_decode($conver['delete_status']))) ||
                                        json_decode($conver['delete_status']) == null)
                                    {{ $emptyConversation = false }}
                                    @if ($conver != null)
                                        @if (isset($conver['created_user_id']))
                                            <li class="checkforactive" data-group-uniq="{{ $conver['unique_id'] }}">
                                        @else
                                            <li class="checkforactive"
                                                data-id="@if ($conver['sender_user_id'] != Auth::id()){{ $conver['sender_user_id'] }}@else{{ $conver['receiver_user_id'] }}@endif">
                                        @endif
                                        <div class="d-flex align-items-center">
                                            <div class="me-2 lh-1">
                                                @if ($conver['sender_user_id'] != Auth::id() && !isset($conver['created_user_id']))
                                                    @php
                                                        $senderimagedata = \App\Models\User::find($conver['sender_user_id']);
                                                    @endphp
                                                    @if($senderimagedata != null)
                                                        <span class="avatar brround" style="background-image: url({{ userprofileimage($senderimagedata) }})">
                                                            <span class="avatar-status onlineOfflineIndicator"></span>
                                                        </span>
                                                    @else
                                                        <span class="avatar brround" style="background-image: url(../uploads/profile/user-profile.png)">
                                                            <span class="avatar-status onlineOfflineIndicator"></span>
                                                        </span>
                                                    @endif
                                                @else
                                                    @if (!isset($conver['created_user_id']))
                                                        @php
                                                            $receiverimagedata = \App\Models\User::find($conver['receiver_user_id']);
                                                        @endphp
                                                        @if($receiverimagedata != null)
                                                            <span class="avatar brround"
                                                                style="background-image: url({{ userprofileimage($receiverimagedata) }})">
                                                                <span class="avatar-status onlineOfflineIndicator"></span>
                                                            </span>
                                                        @else
                                                            <span class="avatar brround"
                                                                style="background-image: url(../uploads/profile/user-profile.png)">
                                                                <span class="avatar-status onlineOfflineIndicator"></span>
                                                            </span>
                                                        @endif
                                                    @endif
                                                @endif

                                                {{-- For the Group Icon --}}
                                                @if (isset($conver['created_user_id']))
                                                    @php
                                                        $groupiconimagedata = \App\Models\User::find($conver['created_user_id']);
                                                    @endphp
                                                    @if($groupiconimagedata != null)
                                                        <span class="avatar brround"
                                                            style="background-image: url({{ userprofileimage($groupiconimagedata) }})">
                                                        </span>
                                                    @else
                                                        <span class="avatar brround"
                                                            style="background-image: url(../uploads/profile/user-profile.png)">
                                                        </span>
                                                    @endif
                                                @endif
                                                <input aria-label="anchor" data-id="{{ isset($conver['created_user_id']) ? 'group' : 'agent' }}" aria-expanded="false" type="checkbox" name="customer_checkbox[]" class="checkall ticket-select-check live-chat-checkbox form-check-input" value="{{ encrypt($conver['unique_id']) }}"/>
                                            </div>

                                            <div class="flex-fill">
                                                <div class="mb-0 d-flex align-items-center justify-content-between">
                                                    <div class="font-weight-semibold">
                                                        {{-- For the group Name --}}
                                                        @if (isset($conver['created_user_id']))
                                                            @php
                                                                $groupnamedata = \App\Models\User::find($conver['created_user_id']);
                                                            @endphp
                                                            <a href="javascript:void(0);">{{ $groupnamedata != null ? $groupnamedata->name : lang('New Group') }}</a>
                                                        @else
                                                            <a href="javascript:void(0);">
                                                                @if ($conver['sender_user_id'] != Auth::id())
                                                                    {{ isset($conver['sender_username']) ? $conver['sender_username'] : '' }}
                                                                @else
                                                                    {{ isset($conver['reciever_username']) ? $conver['reciever_username'] : '' }}
                                                                @endif
                                                            </a>
                                                        @endif
                                                    </div>
                                                    <div class="float-end text-muted fw-normal fs-12 chat-time" data-initial-24time='{{ \Carbon\Carbon::parse($conver['created_at'])->timezone(setting('default_timezone')) }}'>
                                                        {{ \Carbon\Carbon::parse($conver['created_at'])->diffForHumans() ?? '' }}
                                                    </div>
                                                    <div class="dropdown chat-actions lh-1">
                                                        <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown"
                                                            aria-expanded="false">
                                                            <i class="fe fe-more-vertical fs-18"></i>
                                                        </a>
                                                        <ul class="dropdown-menu">
                                                            <li>
                                                                <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="slectTicket(event, {{ $conver['id'] }})" data-id="{{ $conver['id'] }}">
                                                                    <i class="ri-mail-check-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Select') }}
                                                                </a>
                                                            </li>
                                                            @if (
                                                                $markasUnread &&
                                                                    $conver['sender_user_id'] != Auth::id() &&
                                                                    !isset($conver['created_user_id']) &&
                                                                    collect($conversation)->where('message_status', 'delivered')->count() < 1)
                                                                <li><a class="dropdown-item markAsUnreadBtn"
                                                                        href="{{ route('admin.markasread', $conver['unique_id']) }}"
                                                                        href="javascript:void(0);"><i
                                                                            class="ri-chat-check-line align-middle me-2 fs-18"></i>{{ lang('Mark As Read') }}</a></li>
                                                            @else
                                                                @if (
                                                                    $conver['sender_user_id'] != Auth::id() &&
                                                                        collect($conversation)->where('message_status', 'delivered')->count() < 1 &&
                                                                        !isset($conver['created_user_id']))
                                                                    <li><a class="dropdown-item markAsUnreadBtn"
                                                                            href="{{ route('admin.markasunread', $conver['unique_id']) }}"
                                                                            href="javascript:void(0);"><i
                                                                                class="ri-chat-check-line align-middle me-2 fs-18"></i>{{ lang('Mark As Unread') }}</a></li>
                                                                @endif
                                                            @endif
                                                            @if (isset($conver['created_user_id']))
                                                                <li>
                                                                    <a class="dropdown-item dropdown-item-delete gg" href="javascript:void(0);" onclick="confirmFunction('{{ route('admin.groupconversiondelete', $conver['unique_id']) }}','{{ $conver['unique_id'] }}')"><i class="ri-delete-bin-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Delete') }}</a>
                                                                </li>
                                                            @else
                                                                <li><a class="dropdown-item dropdown-item-delete" href="javascript:void(0);" onclick="confirmFunction('{{ route('admin.conversationdelete', $conver['unique_id']) }}','{{ $conver['receiver_user_id'] }}')"><i class="ri-delete-bin-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Delete') }}</a>
                                                                </li>
                                                            @endif
                                                        </ul>
                                                    </div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    @php
                                                        $groupIncludeUsers = json_decode($conver['receiver_user_id']);
                                                    @endphp

                                                    @if ($conver['sender_user_id'] == Auth::id())
                                                        <span
                                                            class="chat-msg text-truncate fs-13 text-default">{{ $conver['message'] ?? '' }}</span>
                                                        @if ($conver['message_status'] == 'delivered')
                                                            <span class="chat-read-icon d-inline-flex align-middle ms-auto me-2">
                                                                <i class="ri-check-double-fill"></i>
                                                            </span>
                                                        @endif
                                                        @if ($conver['message_status'] == 'seen')
                                                            <span class="chat-read-mark d-inline-flex align-middle ms-auto me-2">
                                                                <i class="ri-check-double-fill"></i>
                                                            </span>
                                                        @endif
                                                        @if ($conver['message_status'] == 'sent')
                                                            <span class="chat-read-icon d-inline-flex align-middle ms-auto me-2">
                                                                <i class="ri-check-fill"></i>
                                                            </span>
                                                        @endif
                                                    @else
                                                        {{-- Group Last message status --}}
                                                        @if (isset($conver['created_user_id']))
                                                            @if (json_decode($conver['mark_as_unread']) &&
                                                                    in_array(Auth::id(), json_decode($conver['mark_as_unread'])) &&
                                                                    $conver['sender_user_id'] != Auth::id())
                                                                <span
                                                                    class="chat-msg text-truncate fs-13 text-default">{{ $conver['message'] ?? '' }}</span>
                                                            @else
                                                                <span
                                                                    class="chat-msg text-truncate fs-13 text-default font-weight-bold">{{ $conver['message'] ?? '' }}</span>
                                                                @php
                                                                    $messageCount = collect($conversation)
                                                                        ->filter(function ($message) {
                                                                            $markAsUnreadArray = json_decode(
                                                                                $message['mark_as_unread'],
                                                                            );
                                                                            return !in_array(Auth::id(), $markAsUnreadArray);
                                                                        })
                                                                        ->count();
                                                                @endphp
                                                                @if (!str_contains($conver['message'], 'Group created by'))
                                                                    <span
                                                                        class="badge bg-success-transparent rounded-circle float-end unReadIndexNumber me-1 ms-auto">{{ $messageCount ?? '' }}</span>
                                                                @endif
                                                            @endif
                                                            {{-- Agent Last message status --}}
                                                        @else
                                                            @if ($conver['message_status'] != 'seen')
                                                                <span
                                                                    class="chat-msg text-truncate fs-13 text-default font-weight-bold">{{ $conver['message'] ?? '' }}</span>
                                                                <span
                                                                    class="badge bg-success-transparent rounded-circle float-end unReadIndexNumber">{{ collect($conversation)->where('message_status', 'delivered')->count() }}</span>
                                                            @else
                                                                @if ($markasUnread)
                                                                    <span
                                                                        class="chat-msg text-truncate fs-13 text-default font-weight-bold">{{ $conver['message'] ?? '' }}</span>
                                                                    <span
                                                                        class="badge bg-success-transparent rounded-circle float-end unReadIndexNumber"></span>
                                                                @else
                                                                    <span
                                                                        class="chat-msg text-truncate fs-13 text-default">{{ $conver['message'] ?? '' }}</span>
                                                                @endif
                                                            @endif
                                                        @endif
                                                    @endif

                                                    {{-- For the Group include People Icons --}}
                                                    @php
                                                        $conversationIncludeUsers = '';
                                                    @endphp
                                                    @if (isset($conver['created_user_id']))
                                                        <div class="avatar-list avatar-list-stacked me-3">
                                                            @foreach ($groupIncludeUsers as $index => $IncludeuserId)
                                                                @php
                                                                    $groupincludemembers = \App\Models\User::find($IncludeuserId);
                                                                @endphp
                                                                @if($groupincludemembers != null)
                                                                    @if ($index >= 2)
                                                                        {{ $conversationIncludeUsers = $conversationIncludeUsers . $groupincludemembers->name . ', ' }}
                                                                    @endif
                                                                    @if ($index < 2)
                                                                        <span class="avatar avatar-sm brround" style="background-image: url({{ userprofileimage($groupincludemembers) }})" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title={{ $groupincludemembers->name }} data-bs-original-title="" title=""></span>
                                                                    @endif
                                                                @endif
                                                            @endforeach

                                                            @if (count($groupIncludeUsers) > 2)
                                                                <span class="avatar avatar-sm brround bg-light text-dark"
                                                                    data-bs-toggle="tooltip" data-bs-placement="top"
                                                                    data-bs-title='{{ $conversationIncludeUsers }}'>+{{ count($groupIncludeUsers) - 2 }}</span>
                                                            @endif
                                                        </div>
                                                    @endif


                                                </div>
                                            </div>
                                        </div>
                                        </li>
                                    @endif
                                @endif
                            @endforeach

                            {{-- @dump($emptyConversation) --}}
                            @if ($emptyConversation)
                                <div class="text-center mt-5 px-2 py-4 bg-warning-transparent text-default mx-auto w-90 rounded-2 noDiscussionsProgress" style="margin-top: 20rem;">
                                    <span>{{ lang('As of now, there are no chat discussions in progress') }}</span>
                                </div>
                            @endif

                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-xxl-6 col-xl-8 col-lg-7">
                <div class="main-chat-area main-chat-area-new bg-white card border">
                    <div id="main-chat-content">
                        <div class="card no-articles d-none shadow-none" style="height: calc(100vh - 8rem);background-color: transparent;">
                            <div class="card-body p-8">
                                <div class="main-content text-center">
                                    <div class="notification-icon-container p-4">
                                        <img src="{{ asset('build/assets/images/noarticle.png') }}" alt="">
                                    </div>
                                    <h4 class="mb-1">{{ lang('Currently, no active chat discussions at the moment') }}</h4>
                                    <p class="text-muted">{{ lang('There are currently no ongoing chat discussions at this time.') }}</p>
                                </div>
                            </div>
                        </div>


                        <div class="align-items-center py-2 px-3 rounded border-bottom bg-white mb-3 mainchat-skeleton-loader d-none"
                            id="operator-conversation-Info">
                            <div class="me-2 lh-1">
                                <span class="avatar avatar-md brround">
                                </span>
                            </div>
                            <div class="flex-fill">
                                <p class="mb-0 fw-semibold fs-14">
                                    <a href="javascript:void(0);" class="chatnameperson">
                                    </a>
                                </p>
                                <p class="text-muted mb-0 chatpersonstatus">
                                </p>
                            </div>
                        </div>
                        <ul class="list-unstyled chat-content overflow-auto mainchat-skeleton-loader d-none"
                            id="operator-conversation" operator-id="1">
                            <li class="chat-day-label">
                                <span></span>
                            </li>
                            <li class="chat-item-start ">
                                <div class="chat-list-inner">
                                    <div class="chat-user-profile">
                                        <span class="avatar avatar-md brround"
                                            style="background-image: url(../uploads/profile/user-profile.png)">
                                        </span>
                                    </div>
                                    <div class="ms-3">
                                        <span class="chatting-user-info">
                                            <span class="chatnameperson"></span> <span class="msg-sent-time"></span>
                                        </span>
                                        <div class="main-chat-msg">
                                            <div
                                                style="
                                    padding-right: 250px;
                                ">
                                                <p class="mb-0"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="chat-item-start mt-2">
                                <div class="chat-list-inner">
                                    <div class="chat-user-profile">
                                        <span class="avatar avatar-md brround"
                                            style="background-image: url(../uploads/profile/1699439294.jpg)">
                                        </span>
                                    </div>
                                    <div class="ms-3">
                                        <span class="chatting-user-info">
                                            <span class="msg-sent-time">
                                            </span>
                                        </span>
                                        <div class="main-chat-msg">
                                            <div style="padding-left: 250px;">
                                                <p class="mb-0"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="chat-item-start mt-2">
                                <div class="chat-list-inner">
                                    <div class="chat-user-profile">
                                        <span class="avatar avatar-md brround"
                                            style="background-image: url(../uploads/profile/1699439294.jpg)">
                                        </span>
                                    </div>
                                    <div class="ms-3">
                                        <span class="chatting-user-info">
                                            <span class="msg-sent-time">
                                            </span>
                                        </span>
                                        <div class="main-chat-msg">
                                            <div style="padding-left: 250px;">
                                                <p class="mb-0"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="chat-item-start ">
                                <div class="chat-list-inner">
                                    <div class="chat-user-profile">
                                        <span class="avatar avatar-md brround"
                                            style="background-image: url(../uploads/profile/user-profile.png)">
                                        </span>
                                    </div>
                                    <div class="ms-3">
                                        <span class="chatting-user-info">
                                            <span class="chatnameperson"></span> <span class="msg-sent-time"></span>
                                        </span>
                                        <div class="main-chat-msg">
                                            <div style="padding-right: 250px;">
                                                <p class="mb-0"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="chat-item-start mt-2">
                                <div class="chat-list-inner">
                                    <div class="chat-user-profile">
                                        <span class="avatar avatar-md brround"
                                            style="background-image: url(../uploads/profile/1699439294.jpg)">
                                        </span>
                                    </div>
                                    <div class="ms-3">
                                        <span class="chatting-user-info">
                                            <span class="msg-sent-time">
                                            </span>
                                        </span>
                                        <div class="main-chat-msg">
                                            <div style="padding-left: 250px;">
                                                <p class="mb-0"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="chat-item-start ">
                                <div class="chat-list-inner">
                                    <div class="chat-user-profile">
                                        <span class="avatar avatar-md brround"
                                            style="background-image: url(../uploads/profile/user-profile.png)">
                                        </span>
                                    </div>
                                    <div class="ms-3">
                                        <span class="chatting-user-info">
                                            <span class="chatnameperson"></span> <span class="msg-sent-time"></span>
                                        </span>
                                        <div class="main-chat-msg">
                                            <div
                                                style="
                                    padding-right: 250px;
                                ">
                                                <p class="mb-0"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="chat-item-start mt-2">
                                <div class="chat-list-inner">
                                    <div class="chat-user-profile">
                                        <span class="avatar avatar-md brround"
                                            style="background-image: url(../uploads/profile/user-profile.png)">
                                        </span>
                                    </div>
                                    <div class="ms-3">
                                        <span class="chatting-user-info">
                                            <span class="chatnameperson"></span> <span class="msg-sent-time"></span>
                                        </span>
                                        <div class="main-chat-msg">
                                            <div
                                                style="
                                    padding-right: 250px;
                                ">
                                                <p class="mb-0"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="chat-item-start mt-2">
                                <div class="chat-list-inner">
                                    <div class="chat-user-profile">
                                        <span class="avatar avatar-md brround"
                                            style="background-image: url(../uploads/profile/1699439294.jpg)">
                                        </span>
                                    </div>
                                    <div class="ms-3">
                                        <span class="chatting-user-info">
                                            <span class="msg-sent-time">
                                            </span>
                                        </span>
                                        <div class="main-chat-msg">
                                            <div style="padding-left: 250px;">
                                                <p class="mb-0"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>




                    </div>
                    <div class="chat-footer bg-transparent shadow-none d-none border-top">
                        <div class="chat-reply-area chat-replyoptions flex-fill">
                            <div class="editable-container">
                                <div contenteditable="true" id="auto-expand" name="message" class="form-control textarea-chatoptions my-2 border-0"></div>
                            </div>
                            <div class="image-uploaded d-flex gap-2 flex-wrap">

                            </div>
                            <div class="d-flex align-items-center justify-content-between px-2">
                                <div data-bs-toggle="tooltip" onclick="handleClick(event);" data-bs-placement="top"
                                    data-bs-title="Canned responses" data-bs-original-title="" title="">
                                    <a aria-label="anchor" onclick="handleClick(event);" class="btn-emoji" href=""
                                        data-bs-target="#canned-responses" data-bs-toggle="modal">
                                        <i class="ri-message-line" onclick="handleClick(event);"></i>
                                    </a>
                                </div>
                                <div class="d-flex align-items-center gap-2">
                                    @if (setting('employeeVoiceChat') == 'on')
                                        <a aria-label="anchor" class="voiceRecorderButton" href="javascript:void(0);">
                                            <i class="ri-mic-line"></i>
                                        </a>
                                    @endif
                                    <a aria-label="anchor" class="btn-emoji allEmojisBtn dropdown" data-bs-toggle="dropdown"
                                        href="javascript:void(0)" data-bs-toggle="tooltip" data-bs-placement="top"
                                        data-bs-title="Emojis" data-bs-original-title="" title="">
                                        <i class="ri-emotion-line"></i>
                                    </a>
                                    <ul class="dropdown-menu" id="emojiGrid" style="height: 200px; overflow-y: scroll;"></ul>

                                    <a aria-label="anchor" class="{{ setting('liveChatAgentFileUpload') == '1' ? '' : 'd-none' }}" id="agentToCustFileSetUpdate" type="file" onclick="{document.querySelector('#chat-file-upload').click()}" href="javascript:void(0)" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Upload"><i class="ri-attachment-line"></i>
                                    </a>
                                    <input type="file" id="chat-file-upload" class="d-none" name="chat-file-upload" />
                                    <button aria-label="anchor" disabled="true" id="agentSendMessage"
                                        class="btn-reply border rounded-3 btn-outline-primary agent-send-message disabled" href="javascript:void(0)">
                                        <i class="ri-send-plane-2-fill fs-20"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 main-chat-user-details">
                <div class="chat-user-details bg-transparent p-0" id="chat-user-details">
                    <div class="card overflow-hidden border">
                        <a aria-label="button" type="button" href="javascript:void(0);" class="responsive-chat-close2 available-operators-close">
                            <i class="ri-close-line"></i>
                        </a>
                        <div class="card-header border-0 pb-0 flex-wrap gap-2">
                            <h4 class="card-title">{{ lang('Available Operators') }}<span class="text-default ms-1 fs-14 fw-medium AvailableOperatorsIndex">(0)</span></h4>
                            <button class="btn btn-primary btn-sm btn-icon mb-1 chatRoomBtn d-flex align-items-center ms-auto"
                                onclick="$('#chatRoom').modal('show');" data-toggle="modal" data-target="#chatRoom"><i
                                    class="feather feather-users"></i></button>
                        </div>

                        <div class="card-body">
                            <div class="mb-5"><input class="form-control" id="availableAgentsSearchInput"
                                    placeholder="Search For Operator" type="text"></div>
                            <div class="noUser" id="noUserMessage" style="display: none;">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="d-flex gap-3">
                                        <p> {{ lang('No user found') }} </p>
                                    </div>
                                </div>
                            </div>
                            <ul class="list-unstyled agents-list overflow-y-scroll" id="agents-list">

                                @foreach ($user as $users)
                                    <li class="agent-detail" data-id="{{ $users->id }}">
                                        <a href="javascript:void(0);" class="streched-link">
                                            <div class="d-flex gap-3 align-items-center text-break">
                                                <div>
                                                    <span class="avatar brround"
                                                        style="background-image: url({{ userprofileimage($users) }})">
                                                        <span class="avatar-status onlineOfflineIndicator"></span>
                                                    </span>
                                                </div>
                                                <div class="name-email-container">
                                                    <span class="font-weight-semibold">{{ $users->name }}</span>
                                                    <span class="d-block text-muted fs-12">{{ $users->email }}</span>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="card">

                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Chat Room Model --}}
    <div class="modal fade" id="chatRoom" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">{{ lang('Select Group Operators') }}</h5>
                    <button type="button" onclick="$('#chatRoom').modal('hide')" class="close" data-dismiss="modal"
                        aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" id="onlineUsersChatRoom">
                    <ul class="list-group" id="onlineUlChatroom">
                        <li class="list-group-item">
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <input type="checkbox" class="form-check-input position-relative" name="example-checkbox1" allchecked="true"
                                            value="option1">
                                    </div>
                                    <div>
                                        <span class="font-weight-semibold">{{ lang('All Operators') }}</span>
                                    </div>
                                </div>
                            </div>
                        </li>
                        @foreach ($user as $users)
                            <li class="list-group-item" data-id="{{ $users->id }}">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="d-flex gap-3 align-items-center">
                                        <div>
                                            <input type="checkbox" class="form-check-input position-relative" name="chatRoom-checkbox" value="option1">
                                        </div>
                                        <div class="d-flex align-items-center gap-3">
                                            <span class="avatar brround"
                                                style="background-image: url({{ userprofileimage($users) }})">
                                                <span class="avatar-status onlineOfflineIndicator"></span>
                                            </span>
                                            <div>
                                                <span class="font-weight-semibold">{{ $users->name }}</span>
                                                <span class="d-block text-muted fs-12">{{ $users->email }}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"
                        onclick="$('#chatRoom').modal('hide')">{{ lang('Close') }}</button>
                    <button type="button" class="btn btn-primary savebutton" data-dismiss="modal" disabled>{{ lang('Create
                        Room') }}</button>
                </div>
            </div>
        </div>
    </div>

    {{-- Canned Responses --}}
    <div class="modal fade" id="canned-responses" data-bs-backdrop="static" style="display: none;" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content tx-size-sm">
                <div class="modal-body p-4">
                    <div class="form-group">
                        <label class="form-label">{{ lang('Canned Responses') }}<a href=""
                                data-bs-target="#canned-add-responses" data-bs-toggle="modal"
                                class="fw-semibold font-weight-semibold text-primary text-decoration-underline float-end"></a>
                                <button  class="close" data-bs-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">×</span>
                                </button>
                            </label>
                        <select name="livechatPosition" id="cannedResponses"
                            class="form-control select2 select2-show-search" required>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- image Viewer --}}
    <div class="liveChatImageViewer d-none">
        <span class="liveChatImageClose">×</span>
        <img class="liveChatImageTag" src="">
    </div>

    @include('admin.superadmindashboard.texttospeachpopup')
    @include('admin.superadmindashboard.texttranslationpopup')

@endsection

@section('scripts')
    <!-- INTERNAL Web Socket -->
    <script domainName='{{ url('') }}' wsPort="{{ setting('liveChatPort') }}"
        src="{{ asset('build/assets/plugins/livechat/web-socket.js') }}"></script>

    <!-- INTERNAL Sweet-Alert js-->
    <script src="{{ asset('build/assets/plugins/sweet-alert/sweetalert.min.js') }}?v=<?php echo time(); ?>"></script>


    <script src="{{ asset('build/assets/plugins/typomaster/typojs.min.js') }}"></script>

    @vite(['resources/assets/js/select2.js'])

    <script>
        // Function to update the state of the "Select All" checkbox
        function updateCustomCheckAll() {
            var totalCheckboxes = $('.checkall').length;
            var checkedCheckboxes = $('.checkall:checked').length;
            let chatUserTabList = document.querySelector('.chat-user-tab-list');

            if (checkedCheckboxes == 0) {
                $('#selectallbutton').hide();
                chatUserTabList?.classList?.remove('show-checks');
            } else {
                $('#selectallbutton').show();
            }
            if (checkedCheckboxes === totalCheckboxes) {
                $('#customCheckAll').prop('checked', true);
            } else {
                $('#customCheckAll').prop('checked', false);
            }
        }

        // Live Time Update
        document.addEventListener('DOMContentLoaded', () => {
            function updateTime() {
                const timeElements = document.querySelectorAll('.chat-time');

                timeElements.forEach(element => {
                    const initialTime = element.getAttribute('data-initial-24time');
                    const initialDate = new Date(initialTime);
                    const now = new Date();

                    const diffInMinutes = Math.floor((now - initialDate) / 60000);
                    let timeText;

                    if (diffInMinutes < 1) {
                        timeText = 'Just now';
                    } else if (diffInMinutes < 60) {
                        timeText = `${diffInMinutes} minute${diffInMinutes > 1 ? 's' : ''} ago`;
                    } else {
                        const diffInHours = Math.floor(diffInMinutes / 60);
                        if (diffInHours < 24) {
                            timeText = `${diffInHours} hour${diffInHours > 1 ? 's' : ''} ago`;
                        } else {
                            const diffInDays = Math.floor(diffInHours / 24);
                            timeText = `${diffInDays} day${diffInDays > 1 ? 's' : ''} ago`;
                        }
                    }

                    element.textContent = timeText;
                });
            }

            // Update time every minute
            updateTime();
            setInterval(updateTime, 60000);
        });
    </script>

    <script type="text/javascript">
        "use strict";


        // to rest the cretae group chat model

        document.querySelector(".chatRoomBtn").addEventListener("click",()=>{
            document.querySelectorAll("#onlineUlChatroom [type='checkbox']").forEach((ele)=>{
                ele.checked = false
            })
        })

        let elementToToggle = null;


        let audioBlob;

        function startRecording() {
            const voiceRecorderButton = document.querySelector('.voiceRecorderButton');

            // Detach any existing onclick handlers to avoid duplicating handlers
            voiceRecorderButton.onclick = null;

            voiceRecorderButton.onclick = (e) => {
                navigator.mediaDevices.getUserMedia({ audio: true })
                .then(function (stream) {
                    voiceRecorderButton.classList.toggle('btn-active')
                    let audioChunks = [];
                    let mediaRecorder = new MediaRecorder(stream, { mimeType: 'audio/webm; codecs=opus' });
                    mediaRecorder.start();

                    mediaRecorder.ondataavailable = function (event) {
                        audioChunks.push(event.data);
                    };

                    // Setup stop handling once inside the recording session
                    voiceRecorderButton.onclick = () => {
                        if (mediaRecorder && mediaRecorder.state !== "inactive") {
                            mediaRecorder.stop(); // stop recording
                        }
                    };

                    mediaRecorder.onstop = function () {
                        voiceRecorderButton.classList.toggle('btn-active')
                        audioBlob = new Blob(audioChunks, { type: 'audio/webm; codecs=opus' }); // Specify codec in Blob
                        const audioUrl = URL.createObjectURL(audioBlob);
                        let audioElement = document.createElement('div');
                        audioElement.className = 'audio-container'
                        audioElement.innerHTML = `
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash text-danger cursor-pointer" viewBox="0 0 16 16">
                                <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z"/>
                                <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z"/>
                            </svg>
                            <audio id="audio-player" controls="" src="${audioUrl}"></audio>
                        `;

                        // Ensure all tracks are stopped
                        stream.getTracks().forEach(track => track.stop());

                        const existingAudioPlayer = document.querySelector('#audio-player');
                        if (existingAudioPlayer) {
                            existingAudioPlayer.parentNode.replaceChild(audioElement, existingAudioPlayer);
                            document.querySelector('.text-danger.cursor-pointer').remove();
                        } else {
                            document.querySelector('.chat-reply-area.chat-replyoptions').insertBefore(audioElement, document.querySelector('.chat-reply-area.chat-replyoptions .d-flex.align-items-center.px-2'));
                        }
                        document.querySelector('.cursor-pointer.text-danger').onclick = () => {
                            audioElement.remove();
                            if (document.querySelector("#auto-expand").textContent.trim()) {
                                document.querySelector("#agentSendMessage").classList.remove('disabled')
                                document.querySelector("#agentSendMessage").disabled = false;
                            } else {
                                document.querySelector("#agentSendMessage").classList.add('disabled')
                                document.querySelector("#agentSendMessage").disabled = true;
                            }
                        }

                        document.querySelector("#agentSendMessage").classList.remove('disabled')
                        document.querySelector("#agentSendMessage").disabled = false;
                        // Re-attach the handler for a new recording
                        startRecording();
                    };

                    // Optionally update a UI element to indicate that recording has started
                    // document.getElementById('recording-status').innerText = "Recording...";
                })
                .catch(function (error) {
                    alert("Error accessing microphone. Please connect a microphone");
                    console.error("Error accessing microphone", error);
                    // Optionally update a UI element to indicate that the microphone is unavailable
                    // document.getElementById('recording-status').innerText = "Microphone access denied or unavailable.";
                });
            };
        }

        @if (setting('employeeVoiceChat') == 'on')
            startRecording()
        @endif


        function handleClick(event) {
            event.preventDefault();
            elementToToggle = event.target;
            // Remove focus from the anchor
            event.target.blur();

            // Set focus to another element (body) to ensure focus is removed
            document.body.focus();
        }

        $('#canned-responses .modalclosecanned').on('click', function() {
            elementToToggle.checked = !elementToToggle.checked;
        })

        // to show the skeleton loader in the mainchat
        if (localStorage.activeOperators) {

            const matchingElement = document.querySelector(`li.checkforactive[data-id="${localStorage.activeOperators}"], li.checkforactive[data-group-uniq="${localStorage.activeOperators}"]`);
            if(!matchingElement){
                localStorage.setItem('activeOperators',document.querySelector("#chat-msg-scroll li")?.getAttribute("data-id") ?? document.querySelector("#chat-msg-scroll li")?.getAttribute("data-group-uniq"))

            }
            if('{{$emptyConversation}}'){
                document.querySelector(".no-articles").classList.remove("d-none");
            }else{
                document.querySelector(".no-articles").classList.add("d-none")
                document.querySelectorAll(".mainchat-skeleton-loader").forEach((ele) => {
                    ele.classList.remove("d-none")
                })
                document.querySelector("#main-chat-content").classList.add("is-loading")
            }
        }
        else {
            if('{{$emptyConversation}}'){
                localStorage.setItem('activeOperators',document.querySelector("#chat-msg-scroll li")?.getAttribute("data-id") ?? document.querySelector("#chat-msg-scroll li")?.getAttribute("data-group-uniq"))
            }
        }

        // Online users adding in the Chat Room model

        // For Check All
        document.querySelector('[name="example-checkbox1"]').onclick = (event) => {
            if (event.target.getAttribute('allchecked') == 'true') {
                document.querySelectorAll('#onlineUlChatroom input[type="checkbox"]').forEach((ele) => {
                    ele.checked = true
                })
                event.target.setAttribute('allchecked', false)
            } else {
                document.querySelectorAll('#onlineUlChatroom input[type="checkbox"]').forEach((ele) => {
                    ele.checked = false
                })
                event.target.setAttribute('allchecked', true)
            }
            if (document.querySelector("[name='chatRoom-checkbox']:checked")) {
                document.querySelector(".savebutton").disabled = false
            } else {
                document.querySelector(".savebutton").disabled = true
            }
        }

        // Check That all is checked are not
        document.querySelectorAll("#onlineUlChatroom .list-group-item[data-id] [name='chatRoom-checkbox']").forEach((
        ele) => {
            ele.onclick = () => {
                const checkboxes = document.querySelectorAll(
                    "#onlineUlChatroom .list-group-item[data-id] [name='chatRoom-checkbox']");
                const allChecked = Array.from(checkboxes).every(checkbox => checkbox.checked);
                if (allChecked) {
                    document.querySelector('[name="example-checkbox1"]').checked = true
                } else {
                    document.querySelector('[name="example-checkbox1"]').checked = false
                }
                if (document.querySelector("[name='chatRoom-checkbox']:checked")) {
                    document.querySelector(".savebutton").disabled = false
                } else {
                    document.querySelector(".savebutton").disabled = true
                }
            }
        })

        // confirmation Function
        function confirmFunction(deleteUrl,custId) {
            swal({
                title: `{{ lang('Are you sure you want to continue?', 'alerts') }}`,
                text: "{{ lang('This might erase your records permanently', 'alerts') }}",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            })
            .then((willDelete) => {
                if (willDelete) {
                    // localStorage.removeItem("activeOperators")
                    // window.location.href = deleteUrl;

                    $.ajax({
                        url: deleteUrl,
                        method: "get",
                        success: function(data) {
                            localStorage.removeItem("activeOperators");
                            toastr.success(data.success);

                            var activecustId = document.querySelector(`.checkforactive.active`)?.getAttribute("data-id") ?? document.querySelector(`.checkforactive.active`)?.getAttribute("data-group-uniq");
                            document.querySelector(`.checkforactive[data-id="${custId}"]`)?.remove() ?? document.querySelector(`.checkforactive[data-group-uniq="${custId}"]`)?.remove();
                            if(activecustId == custId){
                                document.querySelector(`#operator-conversation-Info[data-id="${custId}"]`)?.remove()
                                document.querySelector(`#operator-conversation[operator-id="${custId}"]`)?.remove()
                                document.querySelector(".engageConversation")?.classList.add("d-none")
                                document.querySelector(".chat-footer")?.classList.add("d-none")
                                var lielementexists = document.querySelector("#chat-msg-scroll li")?.getAttribute("data-id") ?? document.querySelector("#chat-msg-scroll li")?.getAttribute('data-group-uniq');
                                if(lielementexists){
                                    sideMenuOpenClickFunction(document.querySelector(`.checkforactive[data-id="${lielementexists}"]`) ?? document.querySelector(`.checkforactive[data-group-uniq="${lielementexists}"]`));
                                }else{
                                    let emptyconver = document.createElement("div");
                                    emptyconver.className = "text-center mt-5 px-2 py-4 bg-warning-transparent text-default mx-auto w-90 rounded-2 noDiscussionsProgress";
                                    emptyconver.style.marginTop = "20rem";
                                    emptyconver.innerHTML = `<span>{{ lang('As of now, there are no chat discussions in progress') }}</span>`;
                                    document.querySelector("#chat-msg-scroll").append(emptyconver);
                                    if(document.querySelector(".no-articles")){
                                        document.querySelector(".no-articles").classList.remove("d-none");
                                    }else{
                                        let newarticleempty = document.querySelector('.main-chat-area');
                                        newarticleempty.innerHTML = `<div class="card no-articles shadow-none" style="height: calc(100vh - 8rem);background-color: transparent;">
                                            <div class="card-body p-8">
                                                <div class="main-content text-center">
                                                    <div class="notification-icon-container p-4">
                                                        <img src="{{ asset('build/assets/images/noarticle.png') }}" alt="">
                                                    </div>
                                                    <h4 class="mb-1">{{ lang('Currently, no active chat discussions at the moment') }}</h4>
                                                    <p class="text-muted">{{ lang('There are currently no ongoing chat discussions at this time.') }}</p>
                                                </div>
                                            </div>
                                        </div>`;
                                    }
                                }
                            }
                        },
                        error: function(data) {
                            if(data?.error){
                                toastr.error(data.error);
                            }
                        }
                    });
                }
            })
        }

        // store the range
        let storedRange;
        function storeRange() {
            let message = document.querySelector('#auto-expand');
            const selection = document.getSelection();
            if (selection?.rangeCount) {
                let selected = selection.getRangeAt(0).commonAncestorContainer;
                if (message.contains(selected)) {
                    // Storing the range
                    storedRange = selection.getRangeAt(0);
                } else {
                    let newRng = document.createRange();
                    newRng.setStart(message, message.childNodes.length); // Start at the end of the content
                    newRng.setEnd(message, message.childNodes.length);
                    selection.removeAllRanges();
                    selection.addRange(newRng);
                    storedRange = selection.getRangeAt(0);
                }
            } else {
                let newRng = document.createRange();
                newRng.setStart(message, message.childNodes.length); // Start at the end of the content
                newRng.setEnd(message, message.childNodes.length);
                selection.removeAllRanges();
                selection.addRange(newRng);
                storedRange = selection.getRangeAt(0);
            }
        }

        function retrieveRange() {
            // Used to retrive the stored range value
            if (storedRange) {
                return storedRange;
            }
        }
        let newVal = "";
        // Get the Emojis Values
        function insertEmoji(emoji) {
            if (!storedRange) return;

            const textNode = document.createTextNode(emoji);
            storedRange.insertNode(textNode);

            // Move the caret after the inserted emoji
            let selection = document.getSelection();
            let newRng = document.createRange();
            newRng.setStartAfter(textNode);
            newRng.setEndAfter(textNode);
            selection.removeAllRanges();
            selection.addRange(newRng);

            // Update the stored range to the new position
            storedRange = newRng;
            document.getElementById("emojiGrid").classList.toggle('d-block');
        }

        // for adding the emojis
        document.addEventListener("DOMContentLoaded", function() {
            let allEmojisBtn = document.querySelector('.allEmojisBtn');
            allEmojisBtn.addEventListener('click', ()=>{
                storeRange();
            })
            const emojiGrid = document.getElementById("emojiGrid");

            // Emojis data
            const emojisData = ['😀', '😃', '😄', '😁', '😆', '😅', '😂', '🤣', '😊', '😇', '🙂', '🙃', '😉', '😌',
                '😍', '🥰', '😘', '😗', '😙', '😚', '😋', '😛', '😜', '🤪', '😝', '🤑', '🤗', '🤭', '🤫', '🤔',
                '🤐', '🤨', '😐', '😑', '😶', '😏', '😒', '🙄', '😬', '😮', '😯', '😦', '😧', '😨', '😰', '😱',
                '😳', '😵', '😡', '😠', '😤', '😖', '😆', '😋', '😷', '😎', '🤓', '🤠', '😸', '😺', '😻', '😼',
                '😽', '🙀', '😿', '😾', '👐', '🙌', '👏', '🤝', '👍', '👎', '👊', '✊', '🤛', '🤜', '🤞', '✌️',
                '🤘', '👌', '👈', '👉', '👆', '👇', '✋', '🤚', '🖐', '🖖', '👋', '🤙', '💪', '🖕', '✍️', '🙏',
                '🦶', '🦵', '💍', '💔', '❤️', '💙', '💚', '💛', '💜', '🧡', '💔', '❤️', '💕', '💞', '💓', '💗',
                '💖', '💘', '💝', '💟', '💤', '💢', '💣', '💥', '💫', '💦', '💨', '🕳️', '💧', '💩', '🙈', '🙉',
                '🙊', '💪', '👈', '👉', '👆', '👇', '🖕', '🤘', '🤞', '🤟', '🤙', '👊', '👋', '👏', '👐', '✋',
                '🤚', '🤝', '🙏', '💍', '💔', '❤️', '💕', '💞', '💓', '💗', '💖', '💘', '💝', '💟', '💤', '💢',
                '💣', '💥', '💫', '💦', '💨', '🕳️', '💧', '💩', '🙈', '🙉', '🙊', '💪', '👈', '👉', '👆', '👇',
                '🖕', '🤘', '🤞', '🤟', '🤙', '👊', '👋', '👏', '👐', '✋', '🤚', '🤝', '🙏', '💍', '💔', '❤️',
                '💕', '💞', '💓', '💗', '💖', '💘', '💝', '💟', '💤', '💢', '💣', '💥', '💫', '💦', '💨', '🕳️',
                '💧', '💩', '🙈', '🙉', '🙊', '💪', '👈', '👉', '👆', '👇', '🖕', '🤘', '🤞', '🤟', '🤙', '👊',
                '👋', '👏', '👐', '✋', '🤚', '🤝', '🙏', '💍', '💔', '❤️', '💕', '💞', '💓', '💗', '💖', '💘',
                '💝', '💟', '💤', '💢', '💣', '💥', '💫', '💦', '💨', '🕳️', '💧', '💩', '🙈', '🙉', '🙊', '💪',
                '👈', '👉', '👆', '👇', '🖕', '🤘', '🤞', '🤟', '🤙', '👊', '👋', '👏', '👐', '✋', '🤚', '🤝',
                '🙏', '💍', '💔', '❤️', '💕', '💞', '💓', '💗', '💖', '💘', '💝', '💟', '💤', '💢', '💣', '💥',
                '💫', '💦', '💨', '🕳️', '💧', '💩', '🙈', '🙉', '🙊', '💪', '👈', '👉', '👆', '👇', '🖕', '🤘',
                '🤞', '🤟', '🤙', '👊', '👋', '👏', '👐', '✋', '🤚', '🤝', '🙏', '💍', '💔', '❤️', '💕', '💞',
                '💓', '💗', '💖', '💘', '💝', '💟', '💤', '💢', '💣', '💥', '💫', '💦', '💨', '🕳️', '💧', '💩',
                '🙈', '🙉', '🙊', '💪', '👈', '👉', '👆', '👇', '🖕', '🤘', '🤞', '🤟', '🤙', '👊', '👋', '👏',
                '👐', '✋', '🤚', '🤝', '🙏', '💍', '💔', '❤️', '💕', '💞', '💓', '💗', '💖', '💘', '💝', '💟',
                '💤', '💢', '💣', '💥', '💫', '💦', '💨', '🕳️', '💧', '💩', '🙈', '🙉', '🙊', '💪', '👈', '👉',
                '👆', '👇', '🖕', '🤘', '🤞', '🤟', '🤙', '👊', '👋', '👏', '👐', '✋', '🤚', '🤝', '🙏', '💍',
                '💔', '❤️', '💕', '💞', '💓', '💗', '💖', '💘', '💝', '💟', '💤', '💢', '💣', '💥', '💫', '💦',
                '💨', '🕳️', '💧', '💩', '🙈', '🙉', '🙊', '💪', '👈', '👉', '👆', '👇', '🖕', '🤘', '🤞', '🤟',
                '🤙', '👊', '👋', '👏', '👐', '✋', '🤚', '🤝', '🙏', '💍', '💔', '❤️', '💕', '💞', '💓', '💗',
                '💖', '💘', '💝', '💟', '💤', '💢', '💣', '💥', '💫', '💦', '💨', '🕳️', '💧', '💩', '🙈', '🙉',
                '🙊', '💪', '👈', '👉', '👆', '👇', '🖕', '🤘', '🤞', '🤟', '🤙', '👊', '👋', '👏', '👐', '✋',
                '🤚', '🤝', '🙏', '💍', '💔', '❤️', '💕', '💞', '💓', '💗', '💖', '💘', '💝', '💟', '💤', '💢',
                '💣', '💥', '💫', '💦', '💨', '🕳️', '💧', '💩', '🙈', '🙉', '🙊', '💪', '👈', '👉', '👆', '👇',
                '🖕', '🤘', '🤞', '🤟', '🤙', '👊', '👋', '👏', '👐', '✋', '🤚', '🤝', '🙏', '💍', '💔', '❤️',
                '💕', '💞', '💓', '💗', '💖', '💘', '💝', '💟', '💤', '💢', '💣', '💥', '💫', '💦', '💨', '🕳️',
                '💧', '💩', '🙈', '🙉', '🙊', '💪', '👈', '👉', '👆', '👇', '🖕', '🤘', '🤞', '🤟', '🤙', '👊',
                '👋', '👏', '👐', '✋', '🤚', '🤝', '🙏', '💍', '💔', '❤️', '💕', '💞', '💓', '💗', '💖', '💘',
                '💝', '💟', '💤', '💢', '💣', '💥', '💫', '💦', '💨', '🕳️', '💧', '💩', '🙈', '🙉', '🙊', '💪',
                '👈', '👉', '👆', '👇', '🖕', '🤘', '🤞', '🤟', '🤙', '👊', '👋', '👏', '👐', '✋', '🤚', '🤝',
                '🙏', '💍', '💔', '❤️', '💕', '💞', '💓', '💗', '💖', '💘', '💝', '💟', '💤', '💢', '💣', '💥',
                '💫', '💦', '💨', '🕳️', '💧', '💩', '🙈'
            ];

            let emojis = [...new Set(emojisData)]

            // Number of emojis per row
            const emojisPerRow = 8;

            // Generate emoji grid
            for (let i = 0; i < emojis.length; i++) {
                if (i % emojisPerRow === 0) {
                    // Start a new row
                    const newRow = document.createElement("li");
                    newRow.className = "d-flex";
                    emojiGrid.appendChild(newRow);
                }

                // Create emoji element
                const col = document.createElement("span");
                col.style.padding = "0.5rem"
                col.classList.add("dropdown-item", ); // Adjust the grid layout as needed
                col.onclick = () => {
                    insertEmoji(emojis[i])
                }
                col.innerHTML = `${emojis[i]}`;

                // Append emoji to the current row
                const currentRow = emojiGrid.lastElementChild;
                currentRow.appendChild(col);
            }
        })

        // To add option the Cannedmessages to model
        $.ajax({
            type: "get",
            url: '{{ route('admin.getCannedmessages') }}',
            success: function(data) {
                if (data.success == true) {

                    var selectElement = document.getElementById('cannedResponses');
                    selectElement.innerHTML = `<option></option>`

                    data.message.cannedmessages.forEach(function(option) {
                        var optionElement = document.createElement('option');
                        optionElement.value = option.messages;
                        optionElement.textContent = option.title;
                        selectElement.appendChild(optionElement);
                    });

                    $(document).ready(function() {
                        $('#cannedResponses').select2({
                            placeholder: "Canned Responses",
                            dropdownParent: $('#canned-responses'),
                            // allowClear: true,
                        });
                    });
                }
            },
            error: function(data) {
                console.log('Error:', data);
            }
        });

        // To add value in the text area
        document.getElementById('cannedResponses').onchange = (ele => {
            document.querySelector("#auto-expand").innerHTML = document.querySelector("#auto-expand").innerHTML + ele.target.value
            // to remove the disabled from the Message send btn
            document.querySelector("#agentSendMessage").removeAttribute('disabled')
            document.querySelector("#agentSendMessage").classList.remove('disabled')

            // To Close the Model
            $('#canned-responses').modal('toggle');

            const divcontent = document.querySelector("#auto-expand");

            divcontent.style.height = "auto";
            divcontent.style.height = Math.min(divcontent.scrollHeight, 200) + "px";
            divcontent.scrollTop = 0;

            divcontent.focus();
            let selection = window.getSelection();
            let rng = selection.getRangeAt(0);
            let newRng = document.createRange();
            newRng.setStartAfter(divcontent.lastChild)
            newRng.setEndAfter(divcontent.lastChild)
            selection.removeAllRanges();
            selection.addRange(newRng);
        })

        const textarea = document.getElementById("auto-expand");
        textarea.addEventListener("input", () => {
            textarea.style.height = "auto";
            textarea.style.height = Math.min(textarea.scrollHeight, 200) + "px";
            textarea.scrollTop = 0;
        });

        let spellCheckEnabled = @json(setting('spellCheck'));
        let suggestionsEnabled = @json(setting('wordSuggestion'));

        if (spellCheckEnabled != 'off' || suggestionsEnabled != 'off') {

            let previousContent = "";
            let debounceTime;
            let latestInput = "";
            let userText;

            // Input event to process the text
            textarea.addEventListener("input", function () {
                if(document.getElementById('suggestionText')){
                    document.getElementById('suggestionText').remove()
                }
                userText = textarea.innerText.trim();
                const currentSelection = window.getSelection();
                const cursorAtEnd = currentSelection.rangeCount > 0 && currentSelection.getRangeAt(0).endOffset > 0 && textarea.innerText.length > 0;

                // Fetch only when cursor is at the end and content has changed
                if (cursorAtEnd && userText !== previousContent) {
                    previousContent = userText;
                    clearTimeout(debounceTime);

                    debounceTime = setTimeout(() => {
                        if (userText.length > 0) {
                            fetchCombinedRequest(userText);
                        }
                    }, 1000);
                } else {
                    if(document.getElementById('suggestionText')){
                        document.getElementById('suggestionText').innerText = "";
                    }
                }
            });

            async function fetchCombinedRequest(userInput) {
                try {
                    let url = '{{ route('geminiGet') }}';
                    const response = await fetch(url, {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json",
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify({ value: userInput }),
                    });

                    if (!response.ok) throw new Error("Failed to fetch");

                    const data = await response.json();

                    handleCombinedResponse(data.generated_text);
                } catch (error) {
                    console.error("Error fetching data:", error);
                }
            }

            // Function to handle combined response
            function handleCombinedResponse(responseText) {
                if (spellCheckEnabled == 'on' && suggestionsEnabled == 'on') {
                    const spellCheckResponse = parseApiResponse(responseText); // Parse spell check response
                    const suggestionsResponse = responseText.match(/suggestion:\s*([a-zA-Z\s]+)/)?.[1];
                    if (spellCheckResponse) {
                        applyCorrections(spellCheckResponse);
                        placeCaretAtEnd();
                    }

                    // Display suggestions
                    if (suggestionsResponse) {
                        displaySuggestion(suggestionsResponse);
                    }
                } else if (spellCheckEnabled == 'on' && suggestionsEnabled == 'off') {
                    const correctedText = parseApiResponse(responseText);
                    applyCorrections(correctedText);
                    placeCaretAtEnd();
                } else if (suggestionsEnabled == 'on') {
                    displaySuggestion(responseText.trim());
                }
            }

            function parseApiResponse(responseText) {
                const corrections = {};
                let formattedResponse = responseText.replace(/['"]+/g, "");
                formattedResponse = formattedResponse.replace(/\n/g, ",");
                const pairs = formattedResponse.split(",");
                pairs.forEach(pair => {
                    const [misspelled, corrected] = pair.split(":").map(s => s.trim());
                    if (misspelled && corrected && misspelled != corrected) {
                        corrections[misspelled] = corrected;
                    }
                });
                return corrections;
            }

            function applyCorrections(corrections) {
                let htmlContent = textarea.innerHTML;
                Object.entries(corrections).forEach(([misspelled, corrected]) => {
                    const regex = new RegExp(`\\b${escapeRegExp(misspelled)}\\b`, 'gi');
                    htmlContent = htmlContent.replace(regex,
                        `<span class="misspelled" data-corrected="${corrected}">${misspelled}</span>`
                    );
                });
                textarea.innerHTML = htmlContent;
                placeCaretAtEnd();
            }

            function displaySuggestion(responseApi) {
                if(document.getElementById('suggestionText')){
                    document.getElementById('suggestionText').remove();
                }

                var suggestionTextData = document.createElement('span');
                suggestionTextData.setAttribute('id','suggestionText');
                suggestionTextData.innerHTML = responseApi.trim();

                const selection = window.getSelection();
                if (!selection || !selection.rangeCount) {
                    return;
                }
                if (userText == textarea.innerText.trim()) {
                    document.getElementById('auto-expand').append(suggestionTextData)
                }
            }
            textarea.addEventListener('keydown', function (e) {
                if (e.key === "Tab") {
                    e.preventDefault();

                    const suggestionTextData = document.getElementById('suggestionText');
                    if (suggestionTextData && suggestionTextData.innerText.trim().length > 0) {
                        let userInput = textarea.innerText.trim();
                        let suggestion = suggestionTextData.innerText.trim();
                        if (userInput.endsWith(suggestion)) {
                            userInput = userInput.slice(0, -suggestion.length).trim();
                        }
                        textarea.innerText = `${userInput} ${suggestion}`;
                        suggestionTextData.innerText = '';
                        if (suggestionTextData) {
                            suggestionTextData.remove();
                        }
                        placeCaretAtEnd();
                    }
                }
            });

            function escapeRegExp(string) {
                return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
            }

            document.body.addEventListener('mouseover', function (event) {
                const element = event.target;
                if (element.classList.contains('misspelled')) {
                    showTooltip(event, element);
                }
            });

            document.body.addEventListener('mouseout', function (event) {
                const element = event.target;
                const relatedTarget = event.relatedTarget;

                if (element.classList.contains('misspelled')) {
                    if (relatedTarget && relatedTarget.classList.contains('correctedtooltip')) {
                        return;
                    }
                    hideTooltip();
                } else if (element.classList.contains('correctedtooltip')) {
                    if (relatedTarget && relatedTarget.classList.contains('misspelled')) {
                        return;
                    }
                    hideTooltip();
                }
            });

            function showTooltip(event, element) {
                const correctedWord = element.getAttribute('data-corrected');
                hideTooltip();

                const tooltip = document.createElement('span');
                tooltip.className = 'correctedtooltip';
                tooltip.textContent = correctedWord;

                // Styling
                tooltip.style.backgroundColor = '#fff';
                tooltip.style.border = '1px solid #ccc';
                tooltip.style.padding = '5px';
                tooltip.style.zIndex = '1000';
                tooltip.style.boxShadow = '0px 2px 8px rgba(0, 0, 0, 0.2)';
                tooltip.style.borderRadius = '4px';

                element.parentNode.insertBefore(tooltip, element.nextSibling);

                tooltip.onclick = (e) => {
                    e.stopPropagation();
                    replaceWord(element, correctedWord);
                };

                element.tooltip = tooltip;
            }

            function hideTooltip() {
                const existingTooltip = document.querySelector('.correctedtooltip');
                if (existingTooltip) {
                    existingTooltip.remove();
                }
            }

            function replaceWord(element, correctedWord) {
                const parent = element.parentElement;
                if(parent.classList.contains('misspelled')){
                    parent.classList.remove('misspelled');
                }
                parent.innerHTML = parent.innerHTML.replace(
                    new RegExp(`<span[^>]*>${element.textContent}</span>`, 'gi'),
                    correctedWord
                );
                hideTooltip();
                placeCaretAtEnd()
            }

            function placeCaretAtEnd() {
                setTimeout(() => {
                    textarea.focus();
                    const range = document.createRange();
                    const selection = window.getSelection();
                    range.selectNodeContents(textarea);
                    range.collapse(false);
                    selection.removeAllRanges();
                    selection.addRange(range);
                }, 1);
            }
        }

        // Function to update the visibility of the mass delete button
        function updateMassDeleteVisibility() {
            if ($('.checkall:checked').length == 0) {
                $('#massdelete').hide();
            } else {
                $('#massdelete').show();
            }
        }

        // Handle checkbox clicks
        document.querySelectorAll(".checkall").forEach((checkbox) => {
            checkbox.addEventListener('click', function(event) {
                event.stopPropagation();
                updateCustomCheckAll();
                updateMassDeleteVisibility();

                let target = event.target;
                let li = target.closest('li.checkforactive');
                let input = li.querySelector(".chat-actions .dropdown-item");
                let chatUserTabList = document.querySelector('.chat-users-tab');
                var checkedCheckboxes = $('.checkall:checked').length;
                let customCheckAll = document.querySelector('#customCheckAll');
                if(input){
                    if(target.checked){
                        chatUserTabList.classList.add('show-checks');
                        input.lastChild.textContent = "Deselect";
                        customCheckAll.nextElementSibling.textContent = checkedCheckboxes + ' '  + "Selected"
                    }else{
                        chatUserTabList.classList.remove('show-checks');
                        input.lastChild.textContent = "Select";
                        if(checkedCheckboxes == 0){
                            customCheckAll.nextElementSibling.textContent = ""
                        }else{
                            customCheckAll.nextElementSibling.textContent = checkedCheckboxes + ' '  + "Selected"
                        }
                    }
                }
            });
        });

        $(document).ready(function() {

            $(document).on('click', '#customCheckAll', function() {
                $('.checkall').prop('checked', this.checked);
                let chatUserTabList = document.querySelector('.chat-users-tab');
                let inputs = document.querySelectorAll(".checkforactive .chat-actions ul");
                var checkedCheckboxes = $('.checkall:checked').length;
                let customCheckAll = document.querySelector('#customCheckAll');
                inputs.forEach(ele =>{
                    let input = ele.querySelector('.dropdown-item');
                    if(input){
                        if(this.checked){
                        customCheckAll.nextElementSibling.textContent = checkedCheckboxes + ' ' + "Selected"
                        chatUserTabList.classList.add('show-checks');
                        input.lastChild.textContent = "Deselect";
                    }else{
                            if(checkedCheckboxes == 0){
                                customCheckAll.nextElementSibling.textContent = ""
                            }else{
                                customCheckAll.nextElementSibling.textContent = checkedCheckboxes + ' '  + "Selected"
                            }
                            chatUserTabList?.classList?.remove('show-checks');
                            input.lastChild.textContent = "Select";
                        }
                    }
                })
                updateMassDeleteVisibility();
            });


            // Handle pagination controls
            $(document).on('click', '.pagination a', function() {
                // Assuming '.pagination a' is the selector for your pagination controls
                setTimeout(function() {
                    updateMassDeleteVisibility();
                }, 100);
            });

            // Initialize the "Select All" checkbox to unchecked
            $('#customCheckAll').prop('checked', false);

        });

        $('body').on('click', '#massdelete', function() {
            var id = [];
            var custIds = [];
            $('.checkall:checked').each(function() {
                id.push({
                    value: $(this).val(),
                    dataId: $(this).data('id')
                });
                if($(this).data('id') == 'group'){
                    custIds.push($(this).closest('li.checkforactive').data('group-uniq'));
                }else{
                    custIds.push($(this).closest('li.checkforactive').data('id'));
                }
            });

            if (id.length > 0) {
                swal({
                    title: `{{ lang('Are you sure you want to continue?', 'alerts') }}`,
                    text: "{{ lang('This might erase your records permanently', 'alerts') }}",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                })
                .then((willDelete) => {
                    if (willDelete) {
                        $.ajax({
                            url: "{{ route('admin.chatmassdelete')}}",
                            method: "post",
                            data: {
                                id: id
                            },
                            success: function(data) {
                                localStorage.removeItem("activeOperators");
                                toastr.success(data.success);

                                $('#selectallbutton').hide();
                                $('#massdelete').hide();

                                custIds.map((custId)=>{
                                    var activecustId = document.querySelector(`.checkforactive.active`)?.getAttribute("data-id") ?? document.querySelector(`.checkforactive.active`)?.getAttribute("data-group-uniq");
                                    document.querySelector(`.checkforactive[data-id="${custId}"]`)?.remove() ?? document.querySelector(`.checkforactive[data-group-uniq="${custId}"]`)?.remove();
                                    if(activecustId == custId){
                                        document.querySelector(`#operator-conversation-Info[data-id="${custId}"]`)?.remove()
                                        document.querySelector(`#operator-conversation[operator-id="${custId}"]`)?.remove()
                                        document.querySelector(".engageConversation")?.classList.add("d-none")
                                        document.querySelector(".chat-footer")?.classList.add("d-none")
                                        var lielementexists = document.querySelector("#chat-msg-scroll li")?.getAttribute("data-id") ?? document.querySelector("#chat-msg-scroll li")?.getAttribute('data-group-uniq');
                                        if(lielementexists){
                                            sideMenuOpenClickFunction(document.querySelector(`.checkforactive[data-id="${lielementexists}"]`) ?? document.querySelector(`.checkforactive[data-group-uniq="${lielementexists}"]`));
                                        }else{

                                            let emptyconver = document.createElement("div");
                                            emptyconver.className = "text-center mt-5 px-2 py-4 bg-warning-transparent text-default mx-auto w-90 rounded-2 noDiscussionsProgress";
                                            emptyconver.style.marginTop = "20rem";
                                            emptyconver.innerHTML = `<span>{{ lang('As of now, there are no chat discussions in progress') }}</span>`;
                                            document.querySelector("#chat-msg-scroll").append(emptyconver);
                                            document.querySelector(".no-articles").classList.remove("d-none");
                                        }
                                    }
                                })
                            },
                            error: function(data) {
                                if(data?.error){
                                    toastr.error(data.error);
                                }
                            }
                        });
                    }
                });
            } else {
                toastr.error('{{ lang('Please select at least one check box.', 'alerts') }}');
            }
        });
    </script>

    <script type="text/javascript">
        "use strict";
        // Variables
        var SITEURL = '{{ url('') }}';
        const autoUserInfo = JSON.parse('{!! addslashes(json_encode(Auth::user())) !!}');

        var texttospeachenabled = '{{ setting('CHAT_TEXT_TO_SPEACH_ENABLE') }}';
        var texttranslateenabled = '{{ setting('CHAT_TEXT_TRANSLATE_ENABLE') }}';
        function texttospeachbtn() {
            if(event.target.closest('.ms-3').querySelector('.main-chat-msg p')){
                $('.select2_texttospeach').select2({
                    dropdownParent: ".texttospeachmodal",
                    minimumResultsForSearch: '',
                    placeholder: "Search",
                    width: '100%'
                });
                $('#texttospeachcontent').val(event.target.closest('.ms-3').querySelector('.main-chat-msg p').textContent);
                $('#texttospeachmodal').modal('show');
            }else{
                toastr.error('{{ lang('There is no text to speach.', 'alerts') }}');
            }
        }

        function langtranslatebtn() {
            var targetElement = event.target.closest('.ms-3').querySelector('.main-chat-msg p');
            if(targetElement){
                $('.select2_texttranslation').select2({
                    dropdownParent: ".texttranslationmodal",
                    minimumResultsForSearch: '',
                    placeholder: "Search",
                    width: '100%'
                });
                $('#texttranslationmodal').modal('show');

                document.querySelector('#translateButtonSave').onclick = async () =>{
                    document.querySelector('#translateButtonSave').innerHTML = "{{ lang('Translating') }} ... <i class='fa fa-spinner fa-spin'></i>";
                    const textInput = targetElement.innerText;
                    const selectedLang = document.getElementById('translate-lang').value;

                    try {
                        const translatedText = await translateText(textInput, selectedLang);
                        targetElement.innerHTML = translatedText;
                        document.querySelector('#translateButtonSave').innerHTML = "{{ lang('Translate') }}";
                        $('#texttranslationmodal').modal('hide');
                    } catch (error) {
                        console.error('Error:', error);
                    }
                }
            }else{
                toastr.error('{{ lang('There is no text to translate.', 'alerts') }}');
            }
        }

        function formatTime(inputTime) {
            const jsDate = new Date(inputTime);
            let timeFormat = @json(setting('time_format'));
            let formattedTime;
            switch (timeFormat) {
                case 'H:i:s': // 24-hour format with seconds
                    formattedTime = jsDate.toLocaleTimeString('en-GB', {
                        hour: '2-digit',
                        minute: '2-digit',
                        second: '2-digit',
                        hour12: false
                    });
                    break;
                case 'h:i A': // 12-hour format with AM/PM
                    formattedTime = jsDate.toLocaleTimeString('en-US', {
                        hour: '2-digit',
                        minute: '2-digit',
                        hour12: true
                    });
                    break;
                case 'H:i': // 24-hour format without seconds
                    formattedTime = jsDate.toLocaleTimeString('en-GB', {
                        hour: '2-digit',
                        minute: '2-digit',
                        hour12: false
                    });
                    break;
                default:
                    formattedTime = jsDate.toLocaleTimeString(); // Default format
            }

            return `${formattedTime}`;
        }

        let senderMessage = (data, img) => {

            let custLi = document.createElement("li");
            custLi.className = `chat-item-start ${data.message == `{{ lang('Group created by') }} ${data.sender_username}` ? 'd-none' : ''}`
            custLi.innerHTML = `
                    <div class="chat-list-inner">
                        <div class="chat-user-profile">
                            <span class="avatar avatar-md brround" style="background-image: url(${img})">
                            </span>
                        </div>
                        <div class="ms-3">
                            <span class="chatting-user-info">
                                <span class="chatnameperson">${data.sender_username == autoUserInfo.name ? autoUserInfo.name+' '+'{{ lang('(You)') }}' : data.sender_username}</span> <span class="msg-sent-time">${formatTime(data.created_at)}</span>
                                ${(texttospeachenabled == 'on' || texttranslateenabled == 'on') && (data.message_type != "image" && data.message_type != "audio") ?
                                    `<a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class='float-end msg-send-dropdown'>
                                        <i class="fe fe-more-vertical fs-18"></i>
                                    </a>
                                    <ul class="dropdown-menu">
                                        ${texttospeachenabled == 'on' ?
                                            `<li>
                                                <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="texttospeachbtn()">
                                                    <i class="ri-volume-up-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Text To Speach') }}
                                                </a>
                                            </li>` : ''}
                                        ${texttranslateenabled == 'on' ?
                                            `<li>
                                                <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="langtranslatebtn()">
                                                    <i class="ri-volume-up-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Language Translate') }}
                                                </a>
                                            </li>` : ''}
                                    </ul>`
                                    : ''
                                }
                            </span>
                            <div class="main-chat-msg">
                                ${data.message_type == "image" ? `<div onclick="AllFileViewer(this)" imageSrc="${data.message}" class="mt-2 ${data.message.toLowerCase().endsWith(".jpg") || data.message.toLowerCase().endsWith(".png") ? 'imageMessageLiveChat' : ''}" style="
                                            background-image: url('${data.message.toLowerCase().endsWith(".jpg") || data.message.toLowerCase().endsWith(".png") ? data.message : `${SITEURL}/build/assets/images/svgs/file.svg`}');
                                            background-size: cover;
                                            width: ${data.message.toLowerCase().endsWith(".jpg") || data.message.toLowerCase().endsWith(".png") ?'10rem' :'8rem'};
                                            aspect-ratio: 1;
                                            background-repeat: no-repeat;
                                            background-color: transparent;
                                            background-position: center;
                                        ">
                                        </div>
                                        ` : data.message_type == "audio" ? `<audio controls="" src="${data.message}"></audio>` : `<div style="white-space: pre-line;"><p class="mb-0" >${data.message}</p></div>`
                                }
                            </div>
                        </div>
                    </div>
            `
            return custLi
        }

        let receiverMessage = (data, img) => {

            let agentLi = document.createElement("li");
            agentLi.className = `chat-item-start ${data.message == `{{ lang('Group created by') }} ${data.sender_username}` ? 'd-none' : ''}`
            agentLi.innerHTML = `
                <div class="chat-list-inner">
                    <div class="chat-user-profile">
                        <span class="avatar avatar-md brround" style="background-image: url(${img})">
                        </span>
                    </div>
                    <div class="ms-3">
                        <span class="chatting-user-info">
                            ${data.sender_username == autoUserInfo.name ? autoUserInfo.name+' '+'({{ lang('You') }})' : data.sender_username}
                            <span class="msg-sent-time">
                                ${formatTime(data.created_at)}
                                ${
                                    data.message_status == 'seen' ?
                                    `<span class="chat-read-mark d-inline-flex align-middle">
                                            <i class="ri-check-double-fill"></i>
                                        </span>` :
                                    data.message_status == 'delivered' ?
                                    `<span class="chat-read-icon d-inline-flex align-middle">
                                            <i class="ri-check-double-fill"></i>
                                        </span>` : data.message_status == 'sent' ?
                                    `<span class="chat-read-icon d-inline-flex align-middle">
                                            <i class="ri-check-fill"></i>
                                        </span>` : ``
                                }
                            </span>
                            ${(texttospeachenabled == 'on' || texttranslateenabled == 'on') && (data.message_type != "image" && data.message_type != "audio") ?
                                `<a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class='float-end msg-send-dropdown'>
                                    <i class="fe fe-more-vertical fs-18"></i>
                                </a>
                                <ul class="dropdown-menu">
                                    ${texttospeachenabled == 'on' ?
                                        `<li>
                                            <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="texttospeachbtn()">
                                                <i class="ri-volume-up-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Text To Speach') }}
                                            </a>
                                        </li>` : ''}
                                    ${texttranslateenabled == 'on' ?
                                        `<li>
                                            <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="langtranslatebtn()">
                                                <i class="ri-volume-up-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Language Translate') }}
                                            </a>
                                        </li>` : ''}
                                </ul>`
                                : ''
                            }
                        </span>
                        <div class="main-chat-msg">
                            ${data.message_type == "image" ? `<div onclick="AllFileViewer(this)" imageSrc="${data.message}" class="mt-2 ${data.message.toLowerCase().endsWith(".jpg") || data.message.toLowerCase().endsWith(".png") ? 'imageMessageLiveChat' : ''}" style="
                                        background-image: url('${data.message.toLowerCase().endsWith(".jpg") || data.message.toLowerCase().endsWith(".png") ? data.message : `${SITEURL}/build/assets/images/svgs/file.svg`}');
                                        background-size: cover;
                                        width: ${data.message.toLowerCase().endsWith(".jpg") || data.message.toLowerCase().endsWith(".png") ?'10rem' :'8rem'};
                                        aspect-ratio: 1;
                                        background-repeat: no-repeat;
                                        background-color: transparent;
                                        background-position: center;
                                    ">
                                    </div>
                                ` : data.message_type == "audio" ? `<audio controls="" src="${data.message}"></audio>` : `<div style="white-space: pre-line;"><p class="mb-0" >${data.message}</p></div>`
                            }
                        </div>
                    </div>
                </div>
            `

            return agentLi
        }

        // To viewe the Pdf Files
        let AllFileViewer = (ele) => {
            if (!ele.classList.contains("imageMessageLiveChat")) {
                window.open(ele.getAttribute("imagesrc"))
            }
        }

        // conversation Image Upload
        let liveChatFileUpload = "{{ setting('liveChatFileUpload') }}"
        let livechatMaxFileUpload = "{{setting('AgentlivechatMaxFileUpload')}}"
        let livechatFileUploadMax = "{{setting('AgentlivechatFileUploadMax')}}"
        let livechatFileUploadTypes = "{{setting('AgentlivechatFileUploadTypes')}}"

        // Chat Image Upload
        if (document.querySelector("#chat-file-upload")) {
            document.querySelector("#chat-file-upload").addEventListener('change', () => {
                var fileInput = document.querySelector("#chat-file-upload");
                var file = fileInput.files[0];
                fileInput.value = ""
                var ThereIsError = false

                // For check the File Upload permissions
                if (livechatMaxFileUpload <= document.querySelectorAll(".image-uploaded .file-img").length) {
                    ThereIsError = {
                        errorMessage: "{{ lang('The maximum file upload limit has been exceeded.') }}"
                    };
                } else if (file.size > parseInt(livechatFileUploadMax) * 1024 * 1024) {
                    ThereIsError = {
                        errorMessage: `{{ lang('File size exceeds') }} ${livechatFileUploadMax} {{ lang('MB. Please choose a smaller file.') }}`
                    };
                } else if (livechatFileUploadTypes && !livechatFileUploadTypes.split(',').some(ext => file.name.toLowerCase().toLowerCase().endsWith(ext.toLowerCase().trim()))) {
                    ThereIsError = {
                        errorMessage: `{{ lang('Invalid file extension. Please choose a file with') }} ${livechatFileUploadTypes} {{ lang('extension(s).') }}`
                    };
                } else {
                    ThereIsError = false
                }

                // For add the Upload indication
                let uploadingIndication = document.createElement("p")
                uploadingIndication.className = "fw-lighter ms-4"
                uploadingIndication.id = "uploadingIndication"
                uploadingIndication.innerHTML = `uploading`

                // Upload The File
                if (file && !ThereIsError) {
                    // Adding the Uploding indication
                    document.querySelector(".image-uploaded").appendChild(uploadingIndication)

                    var formData = new FormData();
                    formData.append('chatFileUpload', file);

                    fetch('{{ route('admin.liveChatImageUpload') }}', {
                            method: 'POST',
                            body: formData,
                            headers: {
                                'X-CSRF-TOKEN': '{{ csrf_token() }}', // Include CSRF token
                            },
                        })
                        .then(response => response.json())
                        .then(data => {
                            let uploadedFileName = data.uploadedfilename;
                            const imageDiv = document.createElement("div");
                            imageDiv.classList.add("file-img")

                            imageDiv.innerHTML = `
                                <img imageSrc="${data.imageurl}" src="${uploadedFileName.toLowerCase().endsWith(".jpg") || uploadedFileName.toLowerCase().endsWith(".png") ? `${data.imageurl}` : `${SITEURL}/build/assets/images/svgs/file.svg`}"
                                    style="
                                    width: 100%;
                                    max-height: 55px;
                                    border-radius: 5px;
                                    ${uploadedFileName.toLowerCase().endsWith(".jpg") || uploadedFileName.toLowerCase().endsWith(".png") ? '' : 'height: 65px;'}"
                                >
                                <button class="btn-danger rounded-circle imageRemoveClick">
                                    <i class="fe fe-x fs-12"></i>
                                </button>
                            `
                            // For the Image Remove Click
                            imageDiv.querySelector(".imageRemoveClick").onclick = (ele) => {
                                let fileImgElement = ele.currentTarget.closest(".file-img");
                                let data = {
                                    filename: uploadedFileName,
                                }

                                $.ajax({
                                    type: "post",
                                    url: '{{ route('admin.removeChatImage') }}',
                                    data: data,
                                    success: function(data) {
                                        // To remove the Image
                                        if (fileImgElement) {
                                            fileImgElement.remove();
                                        }
                                    },
                                    error: function(data) {
                                        console.log('Error:', data);
                                    }
                                });
                            }
                            // To remove the uploading indication
                            document.querySelector("#uploadingIndication").remove()
                            document.querySelector(".image-uploaded").appendChild(imageDiv)
                            document.querySelector("#agentSendMessage").classList.remove('disabled')
                            document.querySelector("#agentSendMessage").removeAttribute('disabled')
                            document.querySelector("#auto-expand").focus()
                        })
                        .catch(error => {
                            console.error('Error uploading file:', error);
                        });
                } else {
                    toastr.error(ThereIsError.errorMessage)
                }

            })
        }

        const autoID2 = '{{ Auth::user()->id }}'

        // Create Room button
        document.querySelector("#chatRoom .savebutton").onclick = () => {
            var checkboxes = document.querySelectorAll('#onlineUlChatroom input[type="checkbox"]');
            let selectedUsersArray = []
            let selectedUsersNmaesArray = []
            selectedUsersArray.push(autoID2)
            checkboxes.forEach(function(checkbox, index) {
                if (checkbox.checked) {
                    var dataId = checkbox.closest('li').getAttribute('data-id');
                    var usersName = checkbox.closest('li').querySelector('.font-weight-semibold').innerText;
                    if (dataId) {
                        selectedUsersArray.push(dataId)
                    }
                    if (index > 0) {
                        selectedUsersNmaesArray.push(usersName)
                    }
                }
            });
            $('#chatRoom').modal('hide')
            let data = {
                usersId: `[${String(selectedUsersArray)}]`,
                recieverUsersNames: selectedUsersNmaesArray.map(item => `'${item}'`).join(', '),
            }

            $.ajax({
                type: "post",
                url: SITEURL + "/admin/operators/groupbroadcastoperator",
                data: data,
                success: function(data) {
                    localStorage.setItem("activeOperators", data.group.unique_id)

                },
                error: function(data) {
                    console.log('Error:', data);
                }
            });
        }

        // Available Agents search logic
        document.addEventListener("DOMContentLoaded", function() {
            const searchInput = document.getElementById("availableAgentsSearchInput");
            const agentList = document.querySelector(".agents-list");
            const noUserMessage = document.getElementById("noUserMessage"); // Assuming you have an element with the id "noUserMessage" for displaying the message

            // Clone the list items for resetting the order later
            const originalOrder = Array.from(agentList.children);

            searchInput.addEventListener("input", function() {
                const searchTerm = searchInput.value.trim().toLowerCase();

                // Filter the list based on the search term
                const filteredList = originalOrder.filter((li) => {
                    const name = li.querySelector(".font-weight-semibold").textContent
                .toLowerCase();
                    const email = li.querySelector(".text-muted").textContent.toLowerCase();
                    return name.includes(searchTerm) || email.includes(searchTerm);
                });

                // Clear the current list
                while (agentList.firstChild) {
                    agentList.removeChild(agentList.firstChild);
                }

                // Append the filtered list items back to the list
                if (filteredList.length > 0) {
                    filteredList.forEach((li) => {
                        agentList.appendChild(li);
                    });
                    noUserMessage.style.display = "none"; // Hide the message if there are users present
                } else {
                    noUserMessage.style.display = "block"; // Show the message if no user is present
                }

                // If the search input is empty, reset the order to the original
                if (searchTerm === "") {
                    originalOrder.forEach((li) => {
                        agentList.appendChild(li);
                    });
                    noUserMessage.style.display = "none"; // Hide the message if the search term is empty
                }
            });
        });

        let pauseAudios = () => {
            setTimeout(() => {
                const audios = document.querySelectorAll('audio');

                audios.forEach(audio => {
                    audio.addEventListener('play', () => {
                        audios.forEach(otherAudio => {
                            if (otherAudio !== audio) {
                                otherAudio.pause();
                                otherAudio.currentTime = 0;
                            }
                        });
                    });
                });
            }, 500);
        }

        // SideBar and Online operators loop click
        function sideMenuOpenClickFunction(ele) {

            document.querySelector(".chat-footer").classList.add('d-none');
            // To add the skeleton loader
            document.querySelector("#main-chat-content").classList.add('is-loading')
            document.querySelector("#main-chat-content").innerHTML = `<div class="d-flex align-items-center py-2 px-3 rounded border-bottom bg-white mb-3 mainchat-skeleton-loader" id="operator-conversation-Info">
                <div class="me-2 lh-1">
                    <span class="avatar avatar-md brround">
                    </span>
                </div>
                <div class="flex-fill">
                    <p class="mb-0 fw-semibold fs-14">
                        <a href="javascript:void(0);" class="chatnameperson">
                        </a>
                    </p>
                    <p class="text-muted mb-0 chatpersonstatus">
                    </p>
                </div>
                </div>
                <ul class="list-unstyled chat-content overflow-auto mainchat-skeleton-loader" id="operator-conversation" operator-id="1">
                    <li class="chat-day-label">
                        <span></span>
                    </li>
                    <li class="chat-item-start ">
                        <div class="chat-list-inner">
                            <div class="chat-user-profile">
                                <span class="avatar avatar-md brround" style="background-image: url(../uploads/profile/user-profile.png)">
                                </span>
                            </div>
                            <div class="ms-3">
                                <span class="chatting-user-info">
                                <span class="chatnameperson"></span> <span class="msg-sent-time"></span>
                                </span>
                                <div class="main-chat-msg">
                                <div style="
                                    padding-right: 250px;
                                    ">
                                    <p class="mb-0"></p>
                                </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="chat-item-start mt-2">
                        <div class="chat-list-inner">
                            <div class="chat-user-profile">
                                <span class="avatar avatar-md brround" style="background-image: url(../uploads/profile/1699439294.jpg)">
                                </span>
                            </div>
                            <div class="ms-3">
                                <span class="chatting-user-info">
                                <span class="msg-sent-time">
                                </span>
                                </span>
                                <div class="main-chat-msg">
                                <div style="
                                    padding-left: 250px;
                                    ">
                                    <p class="mb-0"></p>
                                </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="chat-item-start mt-2">
                        <div class="chat-list-inner">
                            <div class="chat-user-profile">
                                <span class="avatar avatar-md brround" style="background-image: url(../uploads/profile/1699439294.jpg)">
                                </span>
                            </div>
                            <div class="ms-3">
                                <span class="chatting-user-info">
                                <span class="msg-sent-time">
                                </span>
                                </span>
                                <div class="main-chat-msg">
                                <div style="
                                    padding-left: 250px;
                                    ">
                                    <p class="mb-0"></p>
                                </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="chat-item-start ">
                        <div class="chat-list-inner">
                            <div class="chat-user-profile">
                                <span class="avatar avatar-md brround" style="background-image: url(../uploads/profile/user-profile.png)">
                                </span>
                            </div>
                            <div class="ms-3">
                                <span class="chatting-user-info">
                                <span class="chatnameperson"></span> <span class="msg-sent-time"></span>
                                </span>
                                <div class="main-chat-msg">
                                <div style="
                                    padding-right: 250px;
                                    ">
                                    <p class="mb-0"></p>
                                </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="chat-item-start mt-2">
                        <div class="chat-list-inner">
                            <div class="chat-user-profile">
                                <span class="avatar avatar-md brround" style="background-image: url(../uploads/profile/1699439294.jpg)">
                                </span>
                            </div>
                            <div class="ms-3">
                                <span class="chatting-user-info">
                                <span class="msg-sent-time">
                                </span>
                                </span>
                                <div class="main-chat-msg">
                                <div style="
                                    padding-left: 250px;
                                    ">
                                    <p class="mb-0"></p>
                                </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="chat-item-start ">
                        <div class="chat-list-inner">
                            <div class="chat-user-profile">
                                <span class="avatar avatar-md brround" style="background-image: url(../uploads/profile/user-profile.png)">
                                </span>
                            </div>
                            <div class="ms-3">
                                <span class="chatting-user-info">
                                <span class="chatnameperson"></span> <span class="msg-sent-time"></span>
                                </span>
                                <div class="main-chat-msg">
                                <div style="
                                    padding-right: 250px;
                                    ">
                                    <p class="mb-0"></p>
                                </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="chat-item-start mt-2">
                        <div class="chat-list-inner">
                            <div class="chat-user-profile">
                                <span class="avatar avatar-md brround" style="background-image: url(../uploads/profile/user-profile.png)">
                                </span>
                            </div>
                            <div class="ms-3">
                                <span class="chatting-user-info">
                                <span class="chatnameperson"></span> <span class="msg-sent-time"></span>
                                </span>
                                <div class="main-chat-msg">
                                <div style="
                                    padding-right: 250px;
                                    ">
                                    <p class="mb-0"></p>
                                </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="chat-item-start mt-2">
                        <div class="chat-list-inner">
                            <div class="chat-user-profile">
                                <span class="avatar avatar-md brround" style="background-image: url(../uploads/profile/1699439294.jpg)">
                                </span>
                            </div>
                            <div class="ms-3">
                                <span class="chatting-user-info">
                                <span class="msg-sent-time">
                                </span>
                                </span>
                                <div class="main-chat-msg">
                                <div style="
                                    padding-left: 250px;
                                    ">
                                    <p class="mb-0"></p>
                                </div>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>
            `

            // operators Click
            if (!ele.getAttribute("data-group-uniq")) {
                $.ajax({
                    type: "get",
                    url: SITEURL + `/admin/operators/singleoperator/${ele.getAttribute("data-id")}`,
                    success: function(data) {
                        let userconversation = data.userconversation
                        if (ele.querySelector(".chat-msg") && ele.querySelector(".unReadIndexNumber")) {
                            ele.querySelector(".chat-msg").classList.remove("font-weight-bold")
                        }
                        if (ele.querySelector(".unReadIndexNumber")) {
                            ele.querySelector(".unReadIndexNumber").remove()
                            // To Change the Make as read to Mark as unread
                            if (ele.querySelector(".markAsUnreadBtn") && ele.querySelector(".markAsUnreadBtn")
                                .innerText == 'Mark As Read') {
                                ele.querySelector('.markAsUnreadBtn').href = ele.querySelector(
                                    '.markAsUnreadBtn').href.replace("markasread", "markasunread")
                                ele.querySelector('.markAsUnreadBtn').innerHTML =
                                    `<i class="ri-chat-check-line align-middle me-2 fs-18"></i> Mark As Unread`
                            }
                        }

                        // Message conversation logic
                        let chatFooter = document.querySelector(".chat-footer")
                        chatFooter.classList.remove("d-none")

                        let mainChatContent = document.querySelector("#main-chat-content")
                        mainChatContent.classList.remove("d-none")
                        document.querySelector("#main-chat-content .no-articles")?.classList.add('d-none')
                        if (document.querySelector("#operator-conversation")) {
                            document.querySelector("#operator-conversation").remove()
                        }
                        if (document.querySelector("#operator-conversation-Info")) {
                            document.querySelector("#operator-conversation-Info").remove()
                        }

                        // For thr messages conversation
                        let conversation = document.createElement("ul");
                        conversation.className = "list-unstyled chat-content overflow-auto"
                        conversation.id = "operator-conversation"


                        // For the Chat data
                        function formatDateString(inputDateStr) {
                            const jsDate = new Date(inputDateStr);

                            let format = @json(setting('date_format'));
                            switch (format) {
                                case 'd M, Y':
                                    return jsDate.toLocaleDateString('en-GB', {
                                        day: '2-digit',
                                        month: 'short',
                                        year: 'numeric'
                                    });
                                case 'm.d.y':
                                    return jsDate.toLocaleDateString('en-US', {
                                        day: '2-digit',
                                        month: '2-digit',
                                        year: '2-digit'
                                    }).replace(/\//g, '.');
                                case 'Y-m-d':
                                    return jsDate.toISOString().split('T')[0];
                                case 'd-m-Y':
                                    return jsDate.toLocaleDateString('en-GB').replace(/\//g, '-');
                                case 'd/m/Y':
                                    return jsDate.toLocaleDateString('en-GB');
                                case 'Y/m/d':
                                    return jsDate.toISOString().split('T')[0].replace(/-/g, '/');
                                default:
                                    return jsDate.toLocaleDateString(); // Default format
                            }
                        }
                        conversation.setAttribute('operator-id', ele.getAttribute("data-id"))
                        if (userconversation) {
                            let currentDate = null;
                            userconversation.map((chatdata) => {
                                const messageDate = formatDateString(chatdata.updated_at);
                                if (messageDate !== currentDate) {
                                    conversation.innerHTML += `
                                            <li class="chat-day-label">
                                                <span>${messageDate}</span>
                                            </li>
                                        `;
                                    currentDate = messageDate;
                                }
                                if (chatdata.sender_user_id != ele.getAttribute("data-id")) {
                                    conversation.appendChild(receiverMessage(chatdata, data.senderdata.image_url))
                                } else {
                                    conversation.appendChild(senderMessage(chatdata, data.receiverdata.image_url))
                                }
                            })
                        }

                        // For the receiver Info
                        let receiverInfo = document.createElement("div");
                        receiverInfo.className =
                            "d-flex align-items-center flex-wrap gap-3 py-2 px-3 rounded border-bottom bg-white mb-3"
                        receiverInfo.id = "operator-conversation-Info"
                        receiverInfo.setAttribute('data-id', ele.getAttribute("data-id"))
                        receiverInfo.innerHTML = `
                            <div class="me-2 lh-1">
                                <span class="avatar avatar-md brround" style="background-image: url(${data.receiverdata.image_url ? data.receiverdata.image_url : '../uploads/profile/user-profile.png'})">
                                <span class="avatar-status ${Object.keys(agentMessageChannel.subscription.members.members).includes(ele.getAttribute("data-id")) ? 'bg-green' : 'bg-gray'} onlineOfflineIndicator "></span>
                                </span>
                                </div>
                                <div class="flex-fill">
                                <p class="mb-0 fw-semibold fs-14">
                                <a href="javascript:void(0);" class="chatnameperson">${data.receiverdata.name}</a>
                                </p>
                                <p class="text-muted mb-0 chatpersonstatus">${Object.keys(agentMessageChannel.subscription.members.members).includes(ele.getAttribute("data-id")) ? 'online' : 'offline'}</p>
                                </div>
                                <div class="d-flex flex-wrap rightIcons">
                                <div class="dropdown ms-2">
                                <button aria-label="button" class="btn btn-icon btn-outline-light my-1 btn-wave waves-light waves-effect waves-light" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="ri-more-2-fill"></i>
                                </button>
                                <ul class="dropdown-menu">
                                <li>
                                    <a class="dropdown-item" onclick="${document.querySelector(`.checkforactive[data-id='${ele.getAttribute("data-id")}'] .dropdown-item-delete`)?.getAttribute('onclick')}" >
                                        Delete Chat
                                    </a>
                                </li>
                                </ul>
                                </div>

                                <button aria-label="button" class="btn btn-outline-light my-1 btn-wave waves-light waves-effect waves-light responsive-userinfo-open ms-2" type="button" aria-expanded="false">
                                    ${data.receiverdata.name}
                                </button>
                                <button aria-label="button" type="button" class="btn btn-icon btn-outline-light my-1 ms-2 responsive-chat-close"> <i class="ri-close-line"></i> </button>
                            </div>
                        `

                        mainChatContent.appendChild(receiverInfo)
                        mainChatContent.appendChild(conversation)
                        // to remove the skeleton loader
                        document.querySelector("#main-chat-content").classList.remove("is-loading")


                        pauseAudios();
                        // To add the Image Viewer
                        if (document.querySelector(".imageMessageLiveChat")) {
                            // To Open the Image Viewer
                            document.querySelectorAll(".imageMessageLiveChat").forEach((element) => {
                                element.onclick = (ele) => {
                                    document.querySelector(".liveChatImageViewer").classList.remove(
                                        "d-none")
                                    document.querySelector(".liveChatImageViewer img").src = ele
                                        .target.getAttribute("imagesrc")
                                    document.querySelector(
                                            ".liveChatImageViewer .liveChatImageClose").onclick =
                                    () => {
                                            // To Close the Image Viewer
                                            document.querySelector(".liveChatImageViewer").classList
                                                .add("d-none")
                                        }
                                }
                            })
                        }

                        // To Scroll Down the Conversation
                        document.querySelector("#operator-conversation").scrollBy(0, document.querySelector(
                            "#operator-conversation").scrollHeight)

                        // Set the sidebar active
                        localStorage.setItem("activeOperators", ele.getAttribute("data-id"))
                        document.querySelectorAll(".checkforactive").forEach((lielement) => {
                            lielement.classList.remove("active")
                            if (lielement.getAttribute("data-id") == ele.getAttribute("data-id")) {
                                lielement.classList.add("active")
                            }
                        })

                        responsivechat();
                    },
                    error: function(data) {
                        console.log('Error:', data);
                    }
                })
            }

            // Group Click
            if (ele.getAttribute("data-group-uniq")) {
                $.ajax({
                    type: "get",
                    url: SITEURL + `/admin/operators/groupconversion/${ele.getAttribute("data-group-uniq")}`,
                    success: function(data) {
                        if (ele.querySelector(".chat-msg") && (ele.querySelector(".unReadIndexNumber") && ele
                                .querySelector(".unReadIndexNumber").innerText)) {
                            ele.querySelector(".chat-msg").classList.remove("font-weight-bold")
                        }
                        if (ele.querySelector(".unReadIndexNumber") && ele.querySelector(".unReadIndexNumber")
                            .innerText) {
                            ele.querySelector(".unReadIndexNumber").remove()
                        }

                        let userconversation = data.groupconversion
                        // Message conversation logic
                        let chatFooter = document.querySelector(".chat-footer")
                        chatFooter.classList.remove("d-none")

                        let mainChatContent = document.querySelector("#main-chat-content")
                        mainChatContent.classList.remove("d-none")
                        document.querySelector("#main-chat-content .no-articles")?.classList.add('d-none')

                        // To remove the messsage conversations
                        if (document.querySelector("#operator-conversation")) {
                            document.querySelector("#operator-conversation").remove()
                        }
                        // To remove the receiver Info
                        if (document.querySelector("#operator-conversation-Info")) {
                            document.querySelector("#operator-conversation-Info").remove()
                        }

                        // To make the include uses names in the correct way
                        function formatString(inputString) {
                            // Remove single quotes and split the string by commas
                            var parts = inputString.replace(/'/g, '').split(',');

                            // Trim each part and join them with a comma and space
                            var result = parts.map(function(part) {
                                return part.trim();
                            }).join(', ');

                            return result;
                        }

                        // For thr messages conversation
                        let conversation = document.createElement("ul");
                        conversation.className = "list-unstyled chat-content overflow-auto"
                        conversation.id = "operator-conversation"
                        conversation.setAttribute('group-id', ele.getAttribute("data-group-uniq"))
                        conversation.setAttribute('group-recievers_names', userconversation[userconversation
                            .length - 1].reciever_username)
                        conversation.setAttribute('group-recievers_id', userconversation[userconversation
                            .length - 1].receiver_user_id)

                        // For the Chat data
                        function formatDateString(inputDateStr) {
                            const jsDate = new Date(inputDateStr);

                            let format = @json(setting('date_format'));
                            switch (format) {
                                case 'd M, Y':
                                    return jsDate.toLocaleDateString('en-GB', {
                                        day: '2-digit',
                                        month: 'short',
                                        year: 'numeric'
                                    });
                                case 'm.d.y':
                                    return jsDate.toLocaleDateString('en-US', {
                                        day: '2-digit',
                                        month: '2-digit',
                                        year: '2-digit'
                                    }).replace(/\//g, '.');
                                case 'Y-m-d':
                                    return jsDate.toISOString().split('T')[0];
                                case 'd-m-Y':
                                    return jsDate.toLocaleDateString('en-GB').replace(/\//g, '-');
                                case 'd/m/Y':
                                    return jsDate.toLocaleDateString('en-GB');
                                case 'Y/m/d':
                                    return jsDate.toISOString().split('T')[0].replace(/-/g, '/');
                                default:
                                    return jsDate.toLocaleDateString(); // Default format
                            }
                        }

                        if (userconversation) {
                            let currentDate = null;
                            let ChatNotification = false
                            userconversation.map((chatdata) => {
                                const messageDate = formatDateString(chatdata.updated_at);
                                if (messageDate !== currentDate) {
                                    conversation.innerHTML += `
                                        <li class="chat-day-label">
                                            <span>${messageDate}</span>
                                        </li>
                                    `;
                                    currentDate = messageDate;
                                    // For the ChatNotifications
                                    if (!ChatNotification) {
                                        // Created User Span
                                        const chatJoinNotify = document.createElement("li");
                                        chatJoinNotify.className = 'chat-join-notify'
                                        chatJoinNotify.innerHTML = `
                                        <span><b class="fw-bold">${chatdata.created_user_id == autoID ? chatdata.sender_username+' '+'({{ lang('You') }})' : chatdata.sender_username}</b> created the group At ${formatTime(chatdata.created_at)}</span>
                                        `
                                        conversation.appendChild(chatJoinNotify)

                                        // Include Users Span
                                        chatdata.reciever_username.split(', ').map(name => name.replace(
                                            /'/g, '')).map((recieverUser => {
                                            let SpanElementJoinNotify = document
                                                .createElement("li")
                                            let AuthUserName = document.querySelector(
                                                '.user-info .mb-2').innerText
                                            SpanElementJoinNotify.className =
                                                'chat-join-notify'
                                            SpanElementJoinNotify.innerHTML =
                                                `<span><b class="fw-bold">${recieverUser == AuthUserName ? recieverUser+' '+'({{ lang('You') }})' : recieverUser}</b> has joined the conversation in the group</span>`
                                            conversation.appendChild(SpanElementJoinNotify)
                                        }))

                                        ChatNotification = true
                                    }
                                }
                                if (chatdata.sender_user_id == '{{ Auth::user()->id }}') {
                                    conversation.appendChild(receiverMessage(chatdata,chatdata
                                        .senderimage_url))
                                } else {
                                    conversation.appendChild(senderMessage(chatdata, chatdata
                                        .senderimage_url))
                                }
                            })
                        }


                        // For the receiver Info
                        let receiverInfo = document.createElement("div");
                        receiverInfo.className =
                            "d-flex align-items-center py-2 px-3 rounded border-bottom bg-white mb-3 flex-wrap gap-3"
                        receiverInfo.id = "operator-conversation-Info"
                        receiverInfo.setAttribute('data-id', ele.getAttribute("data-group-uniq"))
                        receiverInfo.innerHTML = `
                                <div class="avatar-list avatar-list-stacked me-3 d-flex">
                                <span class="avatar avatar-md brround" style="background-image: url(../uploads/profile/user-profile.png})">
                                </span>
                                </div>
                                <div class="flex-fill ms-3">
                                <p class="mb-0 fw-semibold fs-14">
                                <a href="javascript:void(0);" class="chatnameperson responsive-userinfo-open text-truncate" style="width: 502px;display: block;">${formatString(data.receiverUsersInfo)}</a>
                                </p>
                                </div>
                                <div class="d-flex flex-wrap rightIcons">
                                <div class="dropdown ms-2">
                                <button aria-label="button" class="btn btn-icon btn-outline-light my-1 btn-wave waves-light waves-effect waves-light" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="ri-more-2-fill"></i>
                                </button>
                                <ul class="dropdown-menu">
                                <li><a class="dropdown-item" onclick="confirmFunction('operators/groupconversiondelete/${ele.getAttribute("data-group-uniq")}','${ele.getAttribute("data-group-uniq")}')">Delete Chat</a></li>
                                </ul>
                                </div>

                                <button aria-label="button" class="btn btn-outline-light my-1 btn-wave waves-light waves-effect waves-light responsive-userinfo-open ms-2" type="button" aria-expanded="false">
                                    Available Operators
                                </button>
                                <button aria-label="button" type="button" class="btn btn-icon btn-outline-light my-1 ms-2 responsive-chat-close"> <i class="ri-close-line"></i> </button>
                                </div>
                        `

                        let iconElements = Array.from(ele.querySelector('.avatar-list-stacked')
                            .querySelectorAll(".avatar-sm"));
                        let modifiedHTMLArray = [];
                        iconElements.forEach((iconEle) => {
                            iconEle.classList.add('avatar');
                            iconEle.classList.remove('avatar-sm');
                            modifiedHTMLArray.push(iconEle.outerHTML);
                            iconEle.classList.add('avatar');
                            iconEle.classList.add('avatar-sm');
                        });

                        receiverInfo.querySelector('.avatar-list-stacked').innerHTML = modifiedHTMLArray.join(
                            '\n')

                        mainChatContent.appendChild(receiverInfo)
                        mainChatContent.appendChild(conversation)

                        // to remove the skeleton loader
                        document.querySelector("#main-chat-content").classList.remove("is-loading")

                        pauseAudios();
                        // To add the Image Viewer
                        if (document.querySelector(".imageMessageLiveChat")) {
                            // To Open the Image Viewer
                            document.querySelectorAll(".imageMessageLiveChat").forEach((element) => {
                                element.onclick = (ele) => {
                                    document.querySelector(".liveChatImageViewer").classList.remove(
                                        "d-none")
                                    document.querySelector(".liveChatImageViewer img").src = ele
                                        .target.getAttribute("imagesrc")
                                    document.querySelector(
                                            ".liveChatImageViewer .liveChatImageClose").onclick =
                                    () => {
                                            // To Close the Image Viewer
                                            document.querySelector(".liveChatImageViewer").classList
                                                .add("d-none")
                                        }
                                }
                            })
                        }

                        // To Scroll Down the Conversation
                        document.querySelector("#operator-conversation").scrollBy(0, document.querySelector(
                            "#operator-conversation").scrollHeight)

                        // Set the sidebar active
                        localStorage.setItem("activeOperators", ele.getAttribute("data-group-uniq"))
                        document.querySelectorAll(".checkforactive").forEach((lielement) => {
                            lielement.classList.remove("active")
                            if (lielement.getAttribute("data-group-uniq") == ele.getAttribute(
                                    "data-group-uniq")) {
                                lielement.classList.add("active")
                            }
                        })

                        responsivechat();
                    },
                    error: function(data) {
                        console.log('Error:', data);
                    }
                });
            }
        }

        // For the Side Bar Click
        function slectTicket(event, id) {
            let target = event.currentTarget;
            if(target){
                let li = target.closest('li.checkforactive');
                let input = li.querySelector("[name='customer_checkbox[]']");
                let chatUserTabList = document.querySelector('.chat-users-tab');
                event.stopPropagation();
                if(input){
                    if(input.checked){
                        input.checked = false;
                        target.lastChild.textContent = "Select";
                    }else{
                        input.checked = true;
                        target.lastChild.textContent = "Deselect";
                    }

                    var checkedCheckboxes = $('.checkall:checked').length;
                    let customCheckAll = document.querySelector('#customCheckAll');
                    if ($('.checkall:checked').length === 0) {
                        customCheckAll.nextElementSibling.textContent = ""
                        chatUserTabList?.classList?.remove('show-checks');
                        $('#massdelete').hide();
                        $('#selectallbutton').hide();
                    } else {
                        customCheckAll.nextElementSibling.textContent = checkedCheckboxes + ' '  + "Selected"
                        chatUserTabList.classList.add('show-checks');
                        $('#massdelete').show();
                        $('#selectallbutton').show();
                    }
                }
            }
            updateCustomCheckAll();
        }

        document.querySelectorAll(".agent-detail,.checkforactive").forEach((ele) => {
            ele.onclick = () => {
                sideMenuOpenClickFunction(ele)
            }
        })

        // Prevent the li loop click from the dropdown
        document.querySelectorAll('#chat-msg-scroll .chat-actions').forEach((ele) => {
            ele.addEventListener('click', function(event) {
                event.stopPropagation();
            })

            // markAsUnreadBtn
            if (ele.querySelector('.markAsUnreadBtn')) {
                ele.querySelector('.markAsUnreadBtn').addEventListener('click', function(event) {
                    event.stopPropagation();
                    if (localStorage.activeOperators == ele.closest('.checkforactive').getAttribute(
                            'data-group-uniq') || localStorage.activeOperators == ele.closest(
                            '.checkforactive').getAttribute('data-id')) {
                        localStorage.removeItem('activeOperators')
                    }
                })
            }

            // Delete Btn
            if (ele.querySelector('[href*="conversationdelete"]')) {
                ele.querySelector('[href*="conversationdelete"]').addEventListener('click', function(event) {
                    event.stopPropagation();
                    if (localStorage.activeOperators == ele.closest('.checkforactive').getAttribute(
                            'data-group-uniq') || localStorage.activeOperators == ele.closest(
                            '.checkforactive').getAttribute('data-id')) {
                        localStorage.removeItem('activeOperators')
                    }
                })
            }
        })

        const autoUser = '{{ Auth::user()->name }}'
        const autoID = '{{ Auth::user()->id }}'
        let chatOpenAgent = []

        function sanitizeHTML(input) {
            const map = {
                '&': '&amp;',
                '<': '&lt;',
                '>': '&gt;',
                '"': '&quot;',
                "'": '&#039;',
                '/': '&#x2F;',  // For forward slash
                '`': '&#x60;',  // Backtick
                '=': '&#x3D;'   // Equals
            };

            return input.replace(/[&<>"'/`=]/g, function (char) {
                return map[char];
            });
        }

        // Send Message button
        document.querySelector("#agentSendMessage").onclick = () => {
            let operatorConversation = document.querySelector("#operator-conversation")

            // Agent Message Send
            if (!operatorConversation.getAttribute('group-id')) {

                // To remove the no chat discussion message
                document.querySelector("#chat-msg-scroll .noDiscussionsProgress")?.remove()

                if (document.querySelector("#auto-expand").querySelector("#suggestionText")) {
                    document.querySelector("#auto-expand").querySelector("#suggestionText").remove();
                }

                if (document.querySelector("#auto-expand").querySelector(".misspelled")) {
                    document.querySelector("#auto-expand").querySelectorAll(".misspelled").forEach((element) => {
                        // Create a text node with the innerText of the current element
                        const textNode = document.createTextNode(element.innerText);
                        // Replace the misspelled element with the text node
                        element.parentNode.replaceChild(textNode, element);
                    });
                }

                let PresentTimeFormatted = `${((new Date().getHours() + 11) % 12) + 1}:${new Date().getMinutes()}${new Date().getHours() >= 12 ? "PM" : "AM"}`;
                let data = {
                    message: sanitizeHTML(document.querySelector("#auto-expand").textContent),
                    receiverId: document.querySelector("#operator-conversation").getAttribute('operator-id'),
                    messageStatus: Object.keys(agentMessageChannel.subscription.members.members).includes(
                            operatorConversation.getAttribute('operator-id')) ?
                        chatOpenAgent.includes(parseInt(operatorConversation.getAttribute('operator-id'))) ?
                        `seen` : `delivered` : `sent`,
                }

                const messageDeliveryStatus = Object.keys(agentMessageChannel.subscription.members.members).includes(
                        operatorConversation.getAttribute('operator-id')) ?
                    chatOpenAgent.includes(parseInt(operatorConversation.getAttribute('operator-id'))) ? `
                    <span class="chat-read-mark d-inline-flex align-middle">
                        <i class="ri-check-double-fill"></i>
                    </span>
                    ` :
                        `<span class="chat-read-icon d-inline-flex align-middle">
                        <i class="ri-check-double-fill"></i>
                    </span>
                    ` :
                        `<span class="chat-read-icon d-inline-flex align-middle">
                            <i class="ri-check-fill"></i>
                    </span>`
                ;


                let senderMessage = document.createElement("li");
                senderMessage.className = "chat-item-start"
                senderMessage.innerHTML = `
                    <div class="chat-list-inner">
                        <div class="chat-user-profile">
                            <span class="avatar avatar-md brround" style="background-image: url(${document.querySelector(".leading-none img").src})">
                            </span>
                        </div>
                        <div class="ms-3">
                            <span class="chatting-user-info">
                                ${autoUser} ({{ lang('You') }})
                                <span class="msg-sent-time">
                                    ${PresentTimeFormatted}
                                    ${messageDeliveryStatus}
                                </span>
                                ${texttospeachenabled == 'on' || texttranslateenabled == 'on' ?
                                    `<a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class='float-end msg-send-dropdown'>
                                        <i class="fe fe-more-vertical fs-18"></i>
                                    </a>
                                    <ul class="dropdown-menu">
                                        ${texttospeachenabled == 'on' ?
                                            `<li>
                                                <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="texttospeachbtn()">
                                                    <i class="ri-volume-up-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Text To Speach') }}
                                                </a>
                                            </li>` : ''}
                                        ${texttranslateenabled == 'on' ?
                                            `<li>
                                                <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="langtranslatebtn()">
                                                    <i class="ri-volume-up-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Language Translate') }}
                                                </a>
                                            </li>` : ''}
                                    </ul>`
                                    : ''
                                }
                            </span>
                            <div class="main-chat-msg">
                                <div style="white-space: pre-line;">
                                    <p class="mb-0">${data.message}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                `

                if (document.querySelector("#auto-expand").textContent.trim()) {
                    if (operatorConversation.lastElementChild && operatorConversation.lastElementChild.id === "agentTyping") {
                        operatorConversation.insertBefore(senderMessage, operatorConversation.lastElementChild);
                    } else {
                        operatorConversation.appendChild(senderMessage);
                    }

                    // After message sent show the message in the top
                    document.querySelectorAll("#chat-msg-scroll > li").forEach((operatorsChat) => {
                        if (operatorsChat.getAttribute('data-id') == document.querySelector(
                                "#operator-conversation").getAttribute('operator-id')) {
                            operatorsChat.querySelector(".chat-msg").classList.remove("font-weight-bold")
                            operatorsChat.querySelector(".chat-msg").innerHTML = data.message.replace(/\n/g,
                                ' ')
                            operatorsChat.querySelector(".chat-time").setAttribute("data-initial-24time", new Date().toLocaleString());

                            operatorsChat.querySelector(".chat-time").innerText = new Date()
                            .toLocaleTimeString()
                            if (operatorsChat.querySelector(".chat-msg").parentNode.querySelector(
                                    '.d-inline-flex')) {
                                operatorsChat.querySelector(".chat-msg").parentNode.querySelector(
                                    '.d-inline-flex').remove()
                            }
                            if (document.querySelector("#messageStatusDiv")) {
                                document.querySelector("#messageStatusDiv").remove()
                            }
                            // To remove the Make as unread button
                            if (operatorsChat.querySelector(".markAsUnreadBtn")) {
                                operatorsChat.querySelector(".markAsUnreadBtn").parentNode.remove()
                            }
                            const messageStatus = document.createElement("div");
                            messageStatus.id = "messageStatusDiv"
                            messageStatus.innerHTML = messageDeliveryStatus
                            operatorsChat.querySelector(".chat-msg").parentNode.appendChild(messageStatus)
                            document.querySelector("#chat-msg-scroll").insertBefore(operatorsChat, document
                                .querySelector("#chat-msg-scroll > li"));
                        }
                    })

                    // To Scroll Down the Conversation
                    operatorConversation.scrollBy(0, operatorConversation.scrollHeight)

                    textarea.style.height = '49px'

                    // Message Send ajax request
                    $.ajax({
                        type: "post",
                        url: SITEURL + "/admin/operators/broadcastoperator",
                        data: data,
                        success: function(data) {
                            $('#cannedResponses').select2('destroy');
                            document.querySelector("#cannedResponses").selectedIndex = null
                            $('#cannedResponses').select2({
                                placeholder: {
                                    id: '',
                                    text: 'Canned Responses'
                                },
                                // allowClear: true
                            });
                            // New Message will add to sidebar
                            const existingLi = Array.from(document.querySelectorAll("#chat-msg-scroll>li"))
                                .find(li => li.getAttribute('data-id') == document.querySelector("#operator-conversation").getAttribute('operator-id'));
                            if (!existingLi) {
                                let deleteRouteUrl = "{{ route('admin.conversationdelete', ':unique_id') }}";
                                const newMessageLiElement = document.createElement("li");
                                newMessageLiElement.className = "checkforactive active"
                                newMessageLiElement.setAttribute("data-id", document.querySelector("#operator-conversation").getAttribute('operator-id'))
                                newMessageLiElement.innerHTML = `
                                    <div class="d-flex align-items-center">
                                        <div class="me-2 lh-1">
                                            <span class="avatar brround" style="${document.querySelector("#operator-conversation-Info .avatar-md").style.cssText.replace('"',"")}">
                                                <span class="avatar-status ${Object.keys(agentMessageChannel.subscription.members.members).includes(document.querySelector("#operator-conversation").getAttribute('operator-id')) ? 'bg-green' : 'bg-gray'} onlineOfflineIndicator"></span>
                                            </span>
                                            <input aria-label="anchor" data-id="agent" aria-expanded="false" type="checkbox" name="customer_checkbox[]" class="checkall ticket-select-check live-chat-checkbox form-check-input" value="${data.MessageSent.encrypted_unique_id}"/>
                                        </div>
                                        <div class="flex-fill">
                                            <div class="mb-0 d-flex align-items-center justify-content-between">
                                                <div class="font-weight-semibold">
                                                    <a href="javascript:void(0);">${document.querySelector("#main-chat-content .responsive-userinfo-open").innerText}</a>

                                                </div>
                                                <div class="float-end text-muted fw-normal fs-12 chat-time" data-initial-24time="${new Date().toLocaleString()}">${new Date().toLocaleTimeString()}</div>
                                                <div class="dropdown chat-actions lh-1">
                                                    <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <i class="fe fe-more-vertical fs-18"></i>
                                                    </a>
                                                    <ul class="dropdown-menu">
                                                        <li>
                                                            <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="slectTicket(event, ${data.MessageSent.id})" data-id="${data.MessageSent.id}">
                                                                <i class="ri-mail-check-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>
                                                                {{ lang('Select') }}
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item dropdown-item-delete" href="javascript:void(0);" onclick="confirmFunction('${deleteRouteUrl.replace(':unique_id', data.MessageSent.unique_id)}','${data.MessageSent.receiver_user_id}')">
                                                                <i class="ri-delete-bin-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>
                                                                {{ lang('Delete') }}
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <span class="chat-msg text-truncate fs-13 text-default">${data.MessageSent.message}</span>
                                                ${messageDeliveryStatus}
                                            </div>
                                        </div>
                                    </div>
                                `
                                newMessageLiElement.onclick = () => {
                                    if(event.target.classList.contains('fe-more-vertical') || event.target.classList.contains('dropdown-item') || event.target.classList.contains('ticket-select-check')){
                                        event.stopPropagation();
                                        updateCustomCheckAll();
                                        updateMassDeleteVisibility();
                                    }else{
                                        sideMenuOpenClickFunction(newMessageLiElement);
                                    }
                                }

                                document.querySelector("#chat-msg-scroll").insertBefore(newMessageLiElement,document.querySelector("#chat-msg-scroll > li"));


                            }
                        },
                        error: function(error) {
                            if (error.responseJSON) {
                                // toastr.error("The message field cannot be null")
                            }
                        }
                    });
                }

                if (document.querySelector("#audio-player")) {

                    var formData = new FormData();
                    formData.append('chatFileUpload', audioBlob, 'recording.webm');

                    fetch(SITEURL+`/livechat/live-chat-image-upload`, {
                        method: 'POST',
                        body: formData,
                        headers: {
                            'X-CSRF-Token': '{{ csrf_token() }}',
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json, text/javascript, */*; q=0.01',
                        },
                    })
                    .then(response => {
                        return response.json()
                    })
                    .then(resdata => {

                        let data ={
                            message : `${resdata.imageurl}`,
                            receiverId: document.querySelector("#operator-conversation")
                                .getAttribute('operator-id'),
                            messageStatus: Object.keys(agentMessageChannel.subscription.members
                                    .members).includes(operatorConversation.getAttribute(
                                    'operator-id')) ?
                                chatOpenAgent.includes(parseInt(operatorConversation
                                    .getAttribute('operator-id'))) ? `seen` : `delivered` :
                                `sent`,
                            messageType: "audio",
                        }

                        let audioMessage = document.createElement("li");
                        audioMessage.className = "chat-item-start"
                        audioMessage.innerHTML = `
                            <div class="chat-list-inner">
                                <div class="chat-user-profile">
                                    <span class="avatar avatar-md brround" style="background-image: url(${document.querySelector(".leading-none img").src})">
                                    </span>
                                </div>
                                <div class="ms-3">
                                    <span class="chatting-user-info">
                                        ${autoUser} ({{ lang('You') }})
                                        <span class="msg-sent-time">
                                            ${PresentTimeFormatted}
                                            ${messageDeliveryStatus}
                                        </span>
                                    </span>
                                    <div class="main-chat-msg">
                                        <audio controls src="${data.message}"></audio>
                                    </div>
                                </div>
                            </div>
                        `

                        // To add The audio In the Chat
                        if(operatorConversation.lastElementChild && operatorConversation.lastElementChild.id === "agentTyping") {
                            operatorConversation.insertBefore(audioMessage, operatorConversation.lastElementChild);
                        } else {
                            operatorConversation.appendChild(audioMessage);
                        }

                        // To Scroll Down the Conversation
                        document.querySelector("#operator-conversation").scrollBy(0, document.querySelector("#operator-conversation").scrollHeight)
                        document.querySelector("#audio-player").parentElement.remove()

                        $.ajax({
                            type: "post",
                            url: SITEURL + "/admin/operators/broadcastoperator",
                            data: data,
                            success: function (data) {
                                // New Message will add to sidebar
                                const existingLi = Array.from(document.querySelectorAll("#chat-msg-scroll>li"))
                                .find(li => li.getAttribute('data-id') == document.querySelector("#operator-conversation").getAttribute('operator-id'));
                                if (!existingLi) {
                                    let deleteRouteUrl = "{{ route('admin.conversationdelete', ':unique_id') }}";
                                    const newMessageLiElement = document.createElement("li");
                                    newMessageLiElement.className = "checkforactive active"
                                    newMessageLiElement.setAttribute("data-id", document.querySelector("#operator-conversation").getAttribute('operator-id'))
                                    newMessageLiElement.innerHTML = `
                                        <div class="d-flex align-items-center">
                                            <div class="me-2 lh-1">
                                                <span class="avatar brround" style="${document.querySelector("#operator-conversation-Info .avatar-md").style.cssText.replace('"',"")}">
                                                    <span class="avatar-status ${Object.keys(agentMessageChannel.subscription.members.members).includes(document.querySelector("#operator-conversation").getAttribute('operator-id')) ? 'bg-green' : 'bg-gray'} onlineOfflineIndicator"></span>
                                                </span>
                                                <input aria-label="anchor" data-id="agent" aria-expanded="false" type="checkbox" name="customer_checkbox[]" class="checkall ticket-select-check live-chat-checkbox form-check-input" value="${data.MessageSent.encrypted_unique_id}"/>
                                            </div>
                                            <div class="flex-fill">
                                                <div class="mb-0 d-flex align-items-center justify-content-between">
                                                    <div class="font-weight-semibold">
                                                        <a href="javascript:void(0);">${document.querySelector("#main-chat-content .responsive-userinfo-open").innerText}</a>

                                                    </div>
                                                    <div class="float-end text-muted fw-normal fs-12 chat-time" data-initial-24time="${new Date().toLocaleString()}">${new Date().toLocaleTimeString()}</div>
                                                    <div class="dropdown chat-actions lh-1">
                                                        <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fe fe-more-vertical fs-18"></i>
                                                        </a>
                                                        <ul class="dropdown-menu">
                                                            <li>
                                                                <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="slectTicket(event, ${data.MessageSent.id})" data-id="${data.MessageSent.id}">
                                                                    <i class="ri-mail-check-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>
                                                                    {{ lang('Select') }}
                                                                </a>
                                                            </li>
                                                            <li>
                                                                <a class="dropdown-item dropdown-item-delete" href="javascript:void(0);" onclick="confirmFunction('${deleteRouteUrl.replace(':unique_id', data.MessageSent.unique_id)}','${data.MessageSent.receiver_user_id}')">
                                                                    <i class="ri-delete-bin-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>
                                                                    {{ lang('Delete') }}
                                                                </a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <span class="chat-msg text-truncate fs-13 text-default">${data.MessageSent.message}</span>
                                                    ${messageDeliveryStatus}
                                                </div>
                                            </div>
                                        </div>
                                    `
                                    newMessageLiElement.onclick = () => {
                                        if(event.target.classList.contains('fe-more-vertical') || event.target.classList.contains('dropdown-item') || event.target.classList.contains('ticket-select-check')){
                                            event.stopPropagation();
                                            updateCustomCheckAll();
                                            updateMassDeleteVisibility();
                                        }else{
                                            sideMenuOpenClickFunction(newMessageLiElement);
                                        }
                                    }

                                    document.querySelector("#chat-msg-scroll").insertBefore(newMessageLiElement,document.querySelector("#chat-msg-scroll > li"));


                                }
                            },
                            error: function (data) {
                                console.log('Error:', data);
                            }
                        });

                    })
                    .catch(error => {
                        console.error('Error:', error);
                    });
                }

                // to show the Image Upload Message
                let imageUploadTimeout = document.querySelector("#auto-expand").textContent ? 1000 : 0
                setTimeout(() => {
                    // For the Image Upload
                    if (document.querySelectorAll(".image-uploaded .file-img").length) {
                        document.querySelectorAll(".image-uploaded .file-img img").forEach((ele) => {
                            let data = {
                                message: ele.getAttribute('imageSrc'),
                                receiverId: document.querySelector("#operator-conversation")
                                    .getAttribute('operator-id'),
                                messageStatus: Object.keys(agentMessageChannel.subscription.members
                                        .members).includes(operatorConversation.getAttribute(
                                        'operator-id')) ?
                                    chatOpenAgent.includes(parseInt(operatorConversation
                                        .getAttribute('operator-id'))) ? `seen` : `delivered` :
                                    `sent`,
                                messageType: "image"
                            }

                            let imageMessage = document.createElement("li");
                            imageMessage.className = "chat-item-start"
                            imageMessage.innerHTML = `
                            <div class="chat-list-inner">
                                <div class="chat-user-profile">
                                    <span class="avatar avatar-md brround" style="background-image: url(${document.querySelector(".leading-none img").src})">
                                    </span>
                                </div>
                                <div class="ms-3">
                                    <span class="chatting-user-info">
                                        ${autoUser} ({{ lang('You') }})
                                        <span class="msg-sent-time">
                                            ${PresentTimeFormatted}
                                            ${messageDeliveryStatus}
                                        </span>
                                    </span>
                                    <div class="main-chat-msg">
                                        <div onclick="AllFileViewer(this)" imagesrc="${data.message}" class="mt-2 ${data.message.toLowerCase().endsWith(".jpg") || data.message.toLowerCase().endsWith(".png") ? 'imageMessageLiveChat' : ''}" style="
                                                background-image: url('${data.message.toLowerCase().endsWith(".jpg") || data.message.toLowerCase().endsWith(".png") ? data.message : `${SITEURL}/build/assets/images/svgs/file.svg`}');
                                                background-size: cover;
                                                width: ${data.message.toLowerCase().endsWith(".jpg") || data.message.toLowerCase().endsWith(".png") ?'10rem' :'8rem'};
                                                aspect-ratio: 1;
                                                background-repeat: no-repeat;
                                                background-color: transparent;
                                                background-position: center; ">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            `

                            // To add the image Preview Onclick
                            if (imageMessage.querySelector(".imageMessageLiveChat")) {
                                // To Open the Image Viewer
                                imageMessage.querySelector(".imageMessageLiveChat").onclick = (ele) => {
                                    document.querySelector(".liveChatImageViewer").classList.remove(
                                        "d-none")
                                    document.querySelector(".liveChatImageViewer img").src = ele
                                        .target.getAttribute("imagesrc")
                                    document.querySelector(
                                            ".liveChatImageViewer .liveChatImageClose").onclick =
                                    () => {
                                            // To Close the Image Viewer
                                            document.querySelector(".liveChatImageViewer").classList
                                                .add("d-none")
                                        }
                                }
                            }

                            // To add The Image In the Chat
                            if (operatorConversation.lastElementChild && operatorConversation
                                .lastElementChild.id === "agentTyping") {
                                operatorConversation.insertBefore(imageMessage, operatorConversation
                                    .lastElementChild);
                            } else {
                                operatorConversation.appendChild(imageMessage);
                            }

                            // To Scroll Down the Conversation
                            document.querySelector("#operator-conversation").scrollBy(0, document
                                .querySelector("#operator-conversation").scrollHeight)
                            document.querySelector('.image-uploaded').innerHTML = ""

                            $.ajax({
                                type: "post",
                                url: SITEURL + "/admin/operators/broadcastoperator",
                                data: data,
                                success: function(data) {
                                    // To remove the Added Images

                                },
                                error: function(data) {
                                    console.log('Error:', data);
                                }
                            });
                        })
                    }
                }, imageUploadTimeout);

                document.querySelector("#auto-expand").textContent = ''

            }

            // Group Message send
            if (operatorConversation.getAttribute('group-id')) {

                // message status
                // delivered Status Logic
                const onlineUsersarray = Object.keys(agentMessageChannel.subscription.members.members);
                const valuesToCheck = JSON.parse(document.querySelector("#operator-conversation").getAttribute('group-recievers_id'));
                const allValuesIncluded = valuesToCheck.every(value => onlineUsersarray.includes(String(value)));

                // To add the seen users id in the DB
                const seenUsersIds = [...new Set(chatOpenAgent.find(obj => obj[operatorConversation.getAttribute('group-id')])[operatorConversation.getAttribute('group-id')])]

                // Seen Status Logic
                const allAreinOpenstate = chatOpenAgent.find(obj => obj.hasOwnProperty(document.querySelector("#operator-conversation").getAttribute('group-id')))
                const seenStatusvalue = valuesToCheck.every(value => allAreinOpenstate[document.querySelector("#operator-conversation").getAttribute('group-id')].includes(value))

                if (document.querySelector("#auto-expand").querySelector("#suggestionText")) {
                    document.querySelector("#auto-expand").querySelector("#suggestionText").remove();
                }

                if (document.querySelector("#auto-expand").querySelector(".misspelled")) {
                    document.querySelector("#auto-expand").querySelectorAll(".misspelled").forEach((element) => {
                        // Create a text node with the innerText of the current element
                        const textNode = document.createTextNode(element.innerText);
                        // Replace the misspelled element with the text node
                        element.parentNode.replaceChild(textNode, element);
                    });
                }

                let PresentTimeFormatted = `${((new Date().getHours() + 11) % 12) + 1}:${new Date().getMinutes()}${new Date().getHours() >= 12 ? "PM" : "AM"}`;
                let data = {
                    message: sanitizeHTML(document.querySelector("#auto-expand").textContent),
                    recieverUsersNames: document.querySelector("#operator-conversation").getAttribute(
                        'group-recievers_names'),
                    usersId: document.querySelector("#operator-conversation").getAttribute('group-recievers_id'),
                    messageStatus: seenStatusvalue ? 'seen' : allValuesIncluded ? 'delivered' : 'sent',
                    seenUserIds: `[${seenUsersIds}]`
                }

                const messageDeliveryStatus = data.messageStatus == 'seen' ? `
                <span class="chat-read-mark d-inline-flex align-middle">
                    <i class="ri-check-double-fill"></i>
                </span>
                ` : data.messageStatus == 'delivered' ?
                    `<span class="chat-read-icon d-inline-flex align-middle">
                    <i class="ri-check-double-fill"></i>
                </span>
                ` :
                    `<span class="chat-read-icon d-inline-flex align-middle">
                        <i class="ri-check-fill"></i>
                </span>`;


                let senderMessage = document.createElement("li");
                senderMessage.className = "chat-item-start"
                senderMessage.innerHTML = `
                    <div class="chat-list-inner">
                        <div class="chat-user-profile">
                            <span class="avatar avatar-md brround" style="background-image: url(${document.querySelector(".leading-none img").src})">
                            </span>
                        </div>
                        <div class="ms-3">
                            <span class="chatting-user-info">
                                ${autoUser} ({{ lang('You') }})
                                <span class="msg-sent-time">
                                    ${PresentTimeFormatted}
                                    ${messageDeliveryStatus}
                                </span>
                                ${texttospeachenabled == 'on' || texttranslateenabled == 'on' ?
                                    `<a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class='float-end msg-send-dropdown'>
                                        <i class="fe fe-more-vertical fs-18"></i>
                                    </a>
                                    <ul class="dropdown-menu">
                                        ${texttospeachenabled == 'on' ?
                                            `<li>
                                                <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="texttospeachbtn()">
                                                    <i class="ri-volume-up-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Text To Speach') }}
                                                </a>
                                            </li>` : ''}
                                        ${texttranslateenabled == 'on' ?
                                            `<li>
                                                <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="langtranslatebtn()">
                                                    <i class="ri-volume-up-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Language Translate') }}
                                                </a>
                                            </li>` : ''}
                                    </ul>`
                                    : ''
                                }
                            </span>
                            <div class="main-chat-msg">
                                <div style="white-space: pre-line;">
                                    <p class="mb-0">${data.message}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                `

                if (document.querySelector("#auto-expand").textContent.trim()) {
                    if (operatorConversation.lastElementChild && operatorConversation.lastElementChild.id ===
                        "agentTyping") {
                        operatorConversation.insertBefore(senderMessage, operatorConversation.lastElementChild);
                    } else {
                        operatorConversation.appendChild(senderMessage);
                    }

                    // To Scroll Down the Conversation
                    operatorConversation.scrollBy(0, operatorConversation.scrollHeight)

                    // After message sent show the message in the top
                    document.querySelectorAll("#chat-msg-scroll > li").forEach((operatorsChat) => {
                        if (operatorsChat.getAttribute('data-group-uniq') == document.querySelector(
                                "#operator-conversation").getAttribute('group-id')) {
                            operatorsChat.querySelector(".chat-msg").classList.remove("font-weight-bold")
                            operatorsChat.querySelector(".chat-msg").innerHTML = data.message.replace(/\n/g,
                                ' ')
                            operatorsChat.querySelector(".chat-time").setAttribute("data-initial-24time", new Date().toLocaleString());
                            operatorsChat.querySelector(".chat-time").innerText = new Date()
                            .toLocaleTimeString()

                            if (operatorsChat.querySelector(".chat-msg").parentNode.querySelector(
                                    '.d-inline-flex')) {
                                operatorsChat.querySelector(".chat-msg").parentNode.querySelector(
                                    '.d-inline-flex').remove()
                            }
                            if (document.querySelector("#messageStatusDiv")) {
                                document.querySelector("#messageStatusDiv").remove()
                            }
                            // To remove the Make as unread button
                            if (operatorsChat.querySelector(".markAsUnreadBtn")) {
                                operatorsChat.querySelector(".markAsUnreadBtn").parentNode.remove()
                            }
                            const messageStatus = document.createElement("div");
                            messageStatus.className = "ms-auto me-2"
                            messageStatus.id = "messageStatusDiv"
                            messageStatus.innerHTML = messageDeliveryStatus
                            // operatorsChat.querySelector(".chat-msg").parentNode.appendChild(messageStatus)
                            operatorsChat.querySelector(".chat-msg").parentNode.insertBefore(messageStatus,
                                operatorsChat.querySelector(".chat-msg").parentNode.querySelector(
                                    '.avatar-list'))
                            document.querySelector("#chat-msg-scroll").insertBefore(operatorsChat, document
                                .querySelector("#chat-msg-scroll > li"));
                        }
                    })

                    $.ajax({
                        type: "post",
                        url: SITEURL +
                            `/admin/operators/groupconversionstore/${operatorConversation.getAttribute('group-id')}`,
                        data: data,
                        success: function(data) {

                        },
                        error: function(data) {
                            console.log('Error:', data);
                        }
                    });
                }

                if (document.querySelector("#audio-player")) {

                    var formData = new FormData();
                    formData.append('chatFileUpload', audioBlob, 'recording.webm');

                    fetch(SITEURL+`/livechat/live-chat-image-upload`, {
                        method: 'POST',
                        body: formData,
                        headers: {
                            'X-CSRF-Token': '{{ csrf_token() }}',
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json, text/javascript, */*; q=0.01',
                        },
                    })
                    .then(response => {
                        return response.json()
                    })
                    .then(resdata => {

                        let data ={
                            message : `${resdata.imageurl}`,
                            recieverUsersNames: document.querySelector("#operator-conversation")
                                .getAttribute('group-recievers_names'),
                            usersId: document.querySelector("#operator-conversation")
                                .getAttribute('group-recievers_id'),
                            messageStatus: seenStatusvalue ? 'seen' : allValuesIncluded ?
                                'delivered' : 'sent',
                            seenUserIds: `[${seenUsersIds}]`,
                            messageType: "audio"
                        }

                        let audioMessage = document.createElement("li");
                        audioMessage.className = "chat-item-start"
                        audioMessage.innerHTML = `
                            <div class="chat-list-inner">
                                <div class="chat-user-profile">
                                    <span class="avatar avatar-md brround" style="background-image: url(${document.querySelector(".leading-none img").src})">
                                    </span>
                                </div>
                                <div class="ms-3">
                                    <span class="chatting-user-info">
                                        ${autoUser} ({{ lang('You') }})
                                        <span class="msg-sent-time">
                                            ${PresentTimeFormatted}
                                            ${messageDeliveryStatus}
                                        </span>
                                    </span>
                                    <div class="main-chat-msg">
                                        <audio controls src="${data.message}"></audio>
                                    </div>
                                </div>
                            </div>
                        `

                        // To add The audio In the Chat
                        if(operatorConversation.lastElementChild && operatorConversation.lastElementChild.id === "agentTyping") {
                            operatorConversation.insertBefore(audioMessage, operatorConversation.lastElementChild);
                        } else {
                            operatorConversation.appendChild(audioMessage);
                        }

                        // To Scroll Down the Conversation
                        document.querySelector("#operator-conversation").scrollBy(0, document.querySelector("#operator-conversation").scrollHeight)
                        document.querySelector("#audio-player").parentElement.remove()

                        $.ajax({
                            type: "post",
                            url: SITEURL + `/admin/operators/groupconversionstore/${operatorConversation.getAttribute('group-id')}`,
                            data: data,
                            success: function (data) {
                                // To remove the Added Images
                            },
                            error: function (data) {
                                console.log('Error:', data);
                            }
                        });

                    })
                    .catch(error => {
                        console.error('Error:', error);
                    });
                }

                // to slow the Image Upload Message
                let imageUploadTimeout = document.querySelector("#auto-expand").textContent ? 1000 : 0
                setTimeout(() => {
                    // For the Image Upload
                    if (document.querySelectorAll(".image-uploaded .file-img").length) {
                        document.querySelectorAll(".image-uploaded .file-img img").forEach((ele) => {
                            let data = {
                                message: ele.getAttribute('imageSrc'),
                                recieverUsersNames: document.querySelector("#operator-conversation")
                                    .getAttribute('group-recievers_names'),
                                usersId: document.querySelector("#operator-conversation")
                                    .getAttribute('group-recievers_id'),
                                messageStatus: seenStatusvalue ? 'seen' : allValuesIncluded ?
                                    'delivered' : 'sent',
                                seenUserIds: `[${seenUsersIds}]`,
                                messageType: "image"
                            }

                            let imageMessage = document.createElement("li");
                            imageMessage.className = "chat-item-start"
                            imageMessage.innerHTML = `
                            <div class="chat-list-inner">
                                <div class="chat-user-profile">
                                    <span class="avatar avatar-md brround" style="background-image: url(${document.querySelector(".leading-none img").src})">
                                    </span>
                                </div>
                                <div class="ms-3">
                                    <span class="chatting-user-info">
                                        ${autoUser} ({{ lang('You') }})
                                        <span class="msg-sent-time">
                                            ${PresentTimeFormatted}
                                            ${messageDeliveryStatus}
                                        </span>
                                    </span>
                                    <div class="main-chat-msg">
                                        <div onclick="AllFileViewer(this)" imagesrc="${data.message}" class="mt-2 ${data.message.toLowerCase().endsWith(".jpg") || data.message.toLowerCase().endsWith(".png") ? 'imageMessageLiveChat' : ''}" style="
                                                background-image: url('${data.message.toLowerCase().endsWith(".jpg") || data.message.toLowerCase().endsWith(".png") ? data.message : `${SITEURL}/build/assets/images/svgs/file.svg`}');
                                                background-size: cover;
                                                width: ${data.message.toLowerCase().endsWith(".jpg") || data.message.toLowerCase().endsWith(".png") ?'10rem' :'8rem'};
                                                aspect-ratio: 1;
                                                background-repeat: no-repeat;
                                                background-color: transparent;
                                                background-position: center;
                                                ">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            `

                            // To add the image Preview Onclick
                            if (imageMessage.querySelector(".imageMessageLiveChat")) {
                                // To Open the Image Viewer
                                imageMessage.querySelector(".imageMessageLiveChat").onclick = (ele) => {
                                    document.querySelector(".liveChatImageViewer").classList.remove(
                                        "d-none")
                                    document.querySelector(".liveChatImageViewer img").src = ele
                                        .target.getAttribute("imagesrc")
                                    document.querySelector(
                                            ".liveChatImageViewer .liveChatImageClose").onclick =
                                    () => {
                                            // To Close the Image Viewer
                                            document.querySelector(".liveChatImageViewer").classList
                                                .add("d-none")
                                        }
                                }
                            }

                            // To add The Image In the Chat
                            if (operatorConversation.lastElementChild && operatorConversation
                                .lastElementChild.id === "agentTyping") {
                                operatorConversation.insertBefore(imageMessage, operatorConversation
                                    .lastElementChild);
                            } else {
                                operatorConversation.appendChild(imageMessage);
                            }

                            // To Scroll Down the Conversation
                            document.querySelector("#operator-conversation").scrollBy(0, document
                                .querySelector("#operator-conversation").scrollHeight)

                            // To remove the Added Images
                            document.querySelector('.image-uploaded').innerHTML = ""

                            $.ajax({
                                type: "post",
                                url: SITEURL + `/admin/operators/groupconversionstore/${operatorConversation.getAttribute('group-id')}`,
                                data: data,
                                success: function(data) {


                                },
                                error: function(data) {
                                    console.log('Error:', data);
                                }
                            });
                        })
                    }
                }, imageUploadTimeout);

                document.querySelector("#auto-expand").textContent = ''
            }
            pauseAudios();

        }

        // Sending Typing
        var debounceTimeout;
        var debounceTimeout2;
        var debounceTimeout3;

        document.querySelector("#auto-expand").oninput = (ele) => {
            let agentSendMessageBtn = document.querySelector("#agentSendMessage")

            // For the message Send Btn Disabled and Enabled
            if (ele.target.textContent) {
                agentSendMessageBtn.disabled = false
                agentSendMessageBtn.classList.remove('disabled')
            } else {
                agentSendMessageBtn.disabled = true
                agentSendMessageBtn.classList.add('disabled')
            }

            clearTimeout(debounceTimeout);
            debounceTimeout = setTimeout(function() {
                let data = {
                    message: null,
                    receiverId: document.querySelector("#operator-conversation").getAttribute(
                        'operator-id') ? document.querySelector("#operator-conversation").getAttribute(
                            'operator-id') : document.querySelector("#operator-conversation").getAttribute(
                            'group-id'),
                    typingMessage: ele.target.textContent
                }

                $.ajax({
                    type: "post",
                    url: SITEURL + "/admin/operators/agentbroadcastmessagetyping",
                    data: data,
                    success: function(data) {

                    },
                    error: function(data) {
                        console.log('Error:', data);
                    }
                });
            }, 500);
        }

        // Enter Message Send Function
        document.getElementById('auto-expand').addEventListener('keydown', function(event) {
            if (event.key === 'Enter' && !event.shiftKey) {
                event.preventDefault();
                document.getElementById('agentSendMessage').click();
            }
        });

        // Last Message For the Side bar
        let pastMessage = ""
        let SidebarPastUserId
        let sibeBarTypingAllowVar = true


        // Active operators induction with localStorage
        if (localStorage.activeOperators) {
            let activeOperators = localStorage.activeOperators
            document.querySelectorAll("#chat-msg-scroll>li").forEach((element) => {
                // Agent Loop
                if (element.getAttribute("data-id") == activeOperators) {
                    element.classList.add("active")
                    $.ajax({
                        type: "get",
                        url: SITEURL + `/admin/operators/singleoperator/${activeOperators}`,
                        success: function(data) {
                            let userconversation = data.userconversation

                            if (element.querySelector(".chat-msg") && (element
                                    .querySelector(".unReadIndexNumber") && element
                                    .querySelector(".unReadIndexNumber").innerText)) {
                                element.querySelector(".chat-msg").classList.remove(
                                    "font-weight-bold")
                            }
                            if (element.querySelector(".unReadIndexNumber") && element
                                .querySelector(".unReadIndexNumber").innerText) {
                                element.querySelector(".unReadIndexNumber").remove()
                            }

                            // Message conversation logic
                            let chatFooter = document.querySelector(".chat-footer")
                            chatFooter.classList.remove("d-none")

                            let mainChatContent = document.querySelector(
                                "#main-chat-content")
                            mainChatContent.classList.remove("d-none")
                            document.querySelector("#main-chat-content .no-articles")
                                ?.classList.add('d-none')
                            if (document.querySelector("#operator-conversation")) {
                                document.querySelector("#operator-conversation").remove()
                            }
                            if (document.querySelector("#operator-conversation-Info")) {
                                document.querySelector("#operator-conversation-Info")
                                    .remove()
                            }

                            // For thr messages conversation
                            let conversation = document.createElement("ul");
                            conversation.className =
                                "list-unstyled chat-content overflow-auto"
                            conversation.id = "operator-conversation"


                            // For the Chat data
                            function formatDateString(inputDateStr) {
                                const jsDate = new Date(inputDateStr);

                                let format = @json(setting('date_format'));
                                switch (format) {
                                    case 'd M, Y':
                                        return jsDate.toLocaleDateString('en-GB', {
                                            day: '2-digit',
                                            month: 'short',
                                            year: 'numeric'
                                        });
                                    case 'm.d.y':
                                        return jsDate.toLocaleDateString('en-US', {
                                            day: '2-digit',
                                            month: '2-digit',
                                            year: '2-digit'
                                        }).replace(/\//g, '.');
                                    case 'Y-m-d':
                                        return jsDate.toISOString().split('T')[0];
                                    case 'd-m-Y':
                                        return jsDate.toLocaleDateString('en-GB').replace(/\//g, '-');
                                    case 'd/m/Y':
                                        return jsDate.toLocaleDateString('en-GB');
                                    case 'Y/m/d':
                                        return jsDate.toISOString().split('T')[0].replace(/-/g, '/');
                                    default:
                                        return jsDate.toLocaleDateString(); // Default format
                                }
                            }
                            conversation.setAttribute('operator-id', activeOperators)
                            if (userconversation) {
                                let currentDate = null;
                                userconversation.map((chatdata) => {
                                    const messageDate = formatDateString(chatdata
                                        .updated_at);
                                    if (messageDate !== currentDate) {
                                        conversation.innerHTML += `
                                                <li class="chat-day-label">
                                                    <span>${messageDate}</span>
                                                </li>
                                            `;
                                        currentDate = messageDate;
                                    }
                                    if (chatdata.sender_user_id !=
                                        activeOperators) {
                                        conversation.appendChild(receiverMessage(chatdata, data.senderdata.image_url))
                                    } else {
                                        conversation.appendChild(senderMessage(chatdata, data.receiverdata.image_url))
                                    }
                                })
                            }
                            // For the receiver Info
                            let receiverInfo = document.createElement("div");
                            receiverInfo.className =
                                "d-flex align-items-center py-2 px-3 rounded border-bottom bg-white mb-3 flex-wrap gap-3"
                            receiverInfo.id = "operator-conversation-Info"
                            receiverInfo.setAttribute('data-id', activeOperators)
                            receiverInfo.innerHTML = `
                                    <div class="me-2 lh-1">
                                                    <span class="avatar avatar-md brround" style="background-image: url(${data.receiverdata.image_url ? data.receiverdata.image_url : '../uploads/profile/user-profile.png'})">
                                                    <span class="avatar-status ${Object.keys(agentMessageChannel.subscription.members.members).includes(activeOperators) ? 'bg-green' : 'bg-gray'} onlineOfflineIndicator "></span>
                                                    </span>
                                                    </div>
                                                    <div class="flex-fill">
                                                    <p class="mb-0 fw-semibold fs-14">
                                                    <a href="javascript:void(0);" class="chatnameperson">${data.receiverdata.name}</a>
                                                    </p>
                                                    <p class="text-muted mb-0 chatpersonstatus">${Object.keys(agentMessageChannel.subscription.members.members).includes(activeOperators) ? 'online' : 'offline'}</p>
                                                    </div>
                                                    <div class="d-flex flex-wrap rightIcons">
                                                    <div class="dropdown ms-2 ">
                                                    <button aria-label="button" class="btn btn-icon btn-outline-light my-1 btn-wave waves-light waves-effect waves-light" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <i class="ri-more-2-fill"></i>
                                                    </button>
                                                    <ul class="dropdown-menu">
                                                    <li>
                                                        <a class="dropdown-item" href="javascript:void(0);" onclick="${document.querySelector(`.checkforactive[data-id='${activeOperators}'] .dropdown-item-delete`).getAttribute('onclick')}">Delete Chat</a>
                                                    </li>
                                                    </ul>
                                                    </div>

                                                    <button aria-label="button" class="btn btn-outline-light my-1 btn-wave waves-light waves-effect waves-light responsive-userinfo-open ms-2" type="button" aria-expanded="false">
                                                        ${data.receiverdata.name}
                                                    </button>
                                                    <button aria-label="button" type="button" class="btn btn-icon btn-outline-light my-1 ms-2 responsive-chat-close"> <i class="ri-close-line"></i> </button>
                                                    </div>
                                `
                            mainChatContent.appendChild(receiverInfo)
                            mainChatContent.appendChild(conversation)

                            // to remove the skeleton loader
                            document.querySelector("#main-chat-content").classList.remove(
                                "is-loading")

                            // To add the Image Viewer
                            if (document.querySelector(".imageMessageLiveChat")) {
                                // To Open the Image Viewer
                                document.querySelectorAll(".imageMessageLiveChat").forEach((
                                    element) => {
                                    element.onclick = (ele) => {
                                        document.querySelector(
                                                ".liveChatImageViewer")
                                            .classList.remove("d-none")
                                        document.querySelector(
                                                ".liveChatImageViewer img")
                                            .src = ele.target.getAttribute(
                                                "imagesrc")
                                        document.querySelector(
                                            ".liveChatImageViewer .liveChatImageClose"
                                            ).onclick = () => {
                                            // To Close the Image Viewer
                                            document.querySelector(
                                                    ".liveChatImageViewer")
                                                .classList.add("d-none")
                                        }
                                    }
                                })
                            }

                            // To Scroll Down the Conversation
                            document.querySelector("#operator-conversation").scrollBy(0,
                                document.querySelector("#operator-conversation")
                                .scrollHeight)

                        responsivechat();
                        },
                        error: function(data) {
                            console.log('Error:', data);
                        }
                    })
                }

                // Group Loop
                if (element.getAttribute("data-group-uniq") == activeOperators) {
                    element.classList.add("active")
                    $.ajax({
                        type: "get",
                        url: SITEURL +
                            `/admin/operators/groupconversion/${element.getAttribute("data-group-uniq")}`,
                        success: function(data) {
                            if (element.querySelector(".chat-msg") && (element
                                    .querySelector(".unReadIndexNumber") && element
                                    .querySelector(".unReadIndexNumber").innerText)) {
                                element.querySelector(".chat-msg").classList.remove(
                                    "font-weight-bold")
                            }
                            if (element.querySelector(".unReadIndexNumber") && element
                                .querySelector(".unReadIndexNumber").innerText) {
                                element.querySelector(".unReadIndexNumber").remove()
                            }

                            let userconversation = data.groupconversion

                            // Message conversation logic
                            let chatFooter = document.querySelector(".chat-footer")
                            chatFooter.classList.remove("d-none")

                            let mainChatContent = document.querySelector(
                                "#main-chat-content")
                            mainChatContent.classList.remove("d-none")
                            document.querySelector("#main-chat-content .no-articles")
                                ?.classList.add('d-none')

                            // To remove the messsage conversations
                            if (document.querySelector("#operator-conversation")) {
                                document.querySelector("#operator-conversation").remove()
                            }
                            // To remove the receiver Info
                            if (document.querySelector("#operator-conversation-Info")) {
                                document.querySelector("#operator-conversation-Info")
                                    .remove()
                            }

                            // To make the include uses names in the correct way
                            function formatString(inputString) {
                                // Remove single quotes and split the string by commas
                                var parts = inputString.replace(/'/g, '').split(',');

                                // Trim each part and join them with a comma and space
                                var result = parts.map(function(part) {
                                    return part.trim();
                                }).join(', ');

                                return result;
                            }

                            // For thr messages conversation
                            let conversation = document.createElement("ul");
                            conversation.className =
                                "list-unstyled chat-content overflow-auto"
                            conversation.id = "operator-conversation"
                            conversation.setAttribute('group-id', element.getAttribute(
                                "data-group-uniq"))
                            conversation.setAttribute('group-recievers_names',
                                userconversation[userconversation.length - 1]
                                .reciever_username)
                            conversation.setAttribute('group-recievers_id',
                                userconversation[userconversation.length - 1]
                                .receiver_user_id)

                            // For the Chat data
                            function formatDateString(inputDateStr) {
                                const jsDate = new Date(inputDateStr);

                                let format = @json(setting('date_format'));
                                switch (format) {
                                    case 'd M, Y':
                                        return jsDate.toLocaleDateString('en-GB', {
                                            day: '2-digit',
                                            month: 'short',
                                            year: 'numeric'
                                        });
                                    case 'm.d.y':
                                        return jsDate.toLocaleDateString('en-US', {
                                            day: '2-digit',
                                            month: '2-digit',
                                            year: '2-digit'
                                        }).replace(/\//g, '.');
                                    case 'Y-m-d':
                                        return jsDate.toISOString().split('T')[0];
                                    case 'd-m-Y':
                                        return jsDate.toLocaleDateString('en-GB').replace(/\//g, '-');
                                    case 'd/m/Y':
                                        return jsDate.toLocaleDateString('en-GB');
                                    case 'Y/m/d':
                                        return jsDate.toISOString().split('T')[0].replace(/-/g, '/');
                                    default:
                                        return jsDate.toLocaleDateString(); // Default format
                                }
                            }

                            if (userconversation) {
                                let currentDate = null;
                                let ChatNotification = false
                                userconversation.map((chatdata) => {
                                    const messageDate = formatDateString(chatdata
                                        .updated_at);
                                    if (messageDate !== currentDate) {
                                        conversation.innerHTML += `
                                        <li class="chat-day-label">
                                            <span>${messageDate}</span>
                                        </li>
                                    `;
                                        currentDate = messageDate;
                                        // For the ChatNotifications
                                        if (!ChatNotification) {
                                            // Created User Span
                                            const chatJoinNotify = document
                                                .createElement("li");
                                            chatJoinNotify.className =
                                                'chat-join-notify'
                                            chatJoinNotify.innerHTML = `
                                        <span><b class="fw-bold">${chatdata.created_user_id == autoID ? chatdata.sender_username+' '+'({{ lang('You') }})' : chatdata.sender_username}</b> created the group At ${formatTime(chatdata.created_at)}</span>
                                        `
                                            conversation.appendChild(chatJoinNotify)

                                            // Include Users Span
                                            chatdata.reciever_username.split(', ')
                                                .map(name => name.replace(/'/g, ''))
                                                .map((recieverUser => {
                                                    let SpanElementJoinNotify =
                                                        document
                                                        .createElement("li")
                                                    let AuthUserName =
                                                        document
                                                        .querySelector(
                                                            '.user-info .mb-2'
                                                            ).innerText
                                                    SpanElementJoinNotify
                                                        .className =
                                                        'chat-join-notify'
                                                    SpanElementJoinNotify
                                                        .innerHTML =
                                                        `<span><b class="fw-bold">${recieverUser == AuthUserName ? recieverUser+' '+'({{ lang('You') }})' : recieverUser}</b> has joined the conversation in the group</span>`
                                                    conversation
                                                        .appendChild(
                                                            SpanElementJoinNotify
                                                            )
                                                }))

                                            ChatNotification = true
                                        }
                                    }
                                    if (chatdata.sender_user_id ==
                                        '{{ Auth::user()->id }}') {
                                        conversation.appendChild(receiverMessage(chatdata,chatdata.senderimage_url))
                                    } else {
                                        conversation.appendChild(senderMessage(chatdata, chatdata.senderimage_url))
                                    }
                                })
                            }

                            // For the receiver Info
                            let receiverInfo = document.createElement("div");
                            receiverInfo.className =
                                "d-flex align-items-center py-2 px-3 rounded border-bottom bg-white mb-3 flex-wrap gap-3"
                            receiverInfo.id = "operator-conversation-Info"
                            receiverInfo.setAttribute('data-id', element.getAttribute(
                                "data-group-uniq"))
                            receiverInfo.innerHTML = `
                                    <div class="avatar-list avatar-list-stacked me-3 d-flex">
                                    <span class="avatar avatar-md brround" style="background-image: url(../uploads/profile/user-profile.png})">
                                    </span>
                                    </div>
                                    <div class="flex-fill ms-3">
                                    <p class="mb-0 fw-semibold fs-14">
                                    <a href="javascript:void(0);" class="chatnameperson responsive-userinfo-open text-truncate" style="width: 502px;display: block;">${formatString(data.receiverUsersInfo)}</a>
                                    </p>
                                    </div>
                                    <div class="d-flex flex-wrap rightIcons">
                                    <div class="dropdown ms-2">
                                    <button aria-label="button" class="btn btn-icon btn-outline-light my-1 btn-wave waves-light waves-effect waves-light" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="ri-more-2-fill"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" onclick="confirmFunction('operators/groupconversiondelete/${element.getAttribute("data-group-uniq")}','${element.getAttribute("data-group-uniq")}')">Delete Chat</a></li>
                                    </ul>
                                    </div>

                                    <button aria-label="button" class="btn btn-outline-light my-1 btn-wave waves-light waves-effect waves-light responsive-userinfo-open ms-2" type="button" aria-expanded="false">
                                        Available Operators
                                    </button>
                                    <button aria-label="button" type="button" class="btn btn-icon btn-outline-light my-1 ms-2 responsive-chat-close"> <i class="ri-close-line"></i> </button>
                                    </div>
                            `

                            let iconElements = Array.from(element.querySelector(
                                '.avatar-list-stacked').querySelectorAll(
                                ".avatar-sm"));
                            let modifiedHTMLArray = [];
                            iconElements.forEach((iconEle) => {
                                iconEle.classList.add('avatar');
                                iconEle.classList.remove('avatar-sm');
                                modifiedHTMLArray.push(iconEle.outerHTML);
                                iconEle.classList.add('avatar');
                                iconEle.classList.add('avatar-sm');
                            });

                            receiverInfo.querySelector('.avatar-list-stacked').innerHTML =
                                modifiedHTMLArray.join('\n')

                            mainChatContent.appendChild(receiverInfo)
                            mainChatContent.appendChild(conversation)

                            // to remove the skeleton loader
                            document.querySelector("#main-chat-content").classList.remove(
                                "is-loading")

                            // To add the Image Viewer
                            if (document.querySelector(".imageMessageLiveChat")) {
                                // To Open the Image Viewer
                                document.querySelectorAll(".imageMessageLiveChat").forEach((
                                    element) => {
                                    element.onclick = (ele) => {
                                        document.querySelector(
                                                ".liveChatImageViewer")
                                            .classList.remove("d-none")
                                        document.querySelector(
                                                ".liveChatImageViewer img")
                                            .src = ele.target.getAttribute(
                                                "imagesrc")
                                        document.querySelector(
                                            ".liveChatImageViewer .liveChatImageClose"
                                            ).onclick = () => {
                                            // To Close the Image Viewer
                                            document.querySelector(
                                                    ".liveChatImageViewer")
                                                .classList.add("d-none")
                                        }
                                    }
                                })
                            }

                            // To Scroll Down the Conversation
                            document.querySelector("#operator-conversation").scrollBy(0,
                                document.querySelector("#operator-conversation")
                                .scrollHeight)


                            // To add the ID in Array
                            const existingEntryIndex = chatOpenAgent.findIndex(entry =>
                                Object.keys(entry)[0] == activeOperators);
                            if (existingEntryIndex != -1) {
                                const existingArray = chatOpenAgent[existingEntryIndex][
                                    activeOperators
                                ];
                                existingArray.push(parseInt(autoID));
                            } else {
                                chatOpenAgent.push({
                                    [activeOperators]: [parseInt(autoID)]
                                });
                            }

                        responsivechat();
                        },
                        error: function(data) {
                            console.log('Error:', data);
                        }
                    });
                }
            })
        }else{
            if(document.querySelector(".checkforactive")){
                document.querySelector(".checkforactive").click()
            }else{
                document.querySelector(".no-articles").classList.remove("d-none");
            }
        }


        const agentMessageChannel = Echo.join('agentMessaging')
        agentMessageChannel.listen('AgentMessagingEvent', (socket) => {

            if(socket?.groupdata?.texttospeachsettingUpdateddata && socket?.groupdata?.texttospeachsettingUpdateddata == 'texttospeachsettingUpdated'){
                if(socket.groupdata.texttospeachsettingUpdatedvalue == 'on' || socket.groupdata.texttranslatesettingUpdatedvalue == 'on'){
                    document.querySelectorAll('.msg-sent-time').forEach((element) => {
                        const nextAnchor = element.nextElementSibling;
                        const nextDropdown = nextAnchor?.nextElementSibling;

                        if(nextAnchor?.classList.contains('msg-send-dropdown') && nextDropdown?.classList.contains('dropdown-menu')){
                            nextAnchor.remove();
                            nextDropdown.remove();
                        }

                        const dropdownHTML = `
                        <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class='float-end msg-send-dropdown'>
                            <i class="fe fe-more-vertical fs-18"></i>
                        </a>
                        <ul class="dropdown-menu">
                            ${socket.groupdata.texttospeachsettingUpdatedvalue == 'on' == 'on' ?
                                `<li>
                                    <a class="dropdown-item" onclick="texttospeachbtn()">
                                        <i class="ri-volume-up-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Text To Speach') }}
                                    </a>
                                </li>` : ''
                            }
                            ${socket.groupdata.texttranslatesettingUpdatedvalue == 'on' ?
                                `<li>
                                    <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="langtranslatebtn()">
                                        <i class="ri-volume-up-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Language Translate') }}
                                    </a>
                                </li>` : ''
                            }
                        </ul>
                        `;

                        element.insertAdjacentHTML('afterend', dropdownHTML);
                    });
                }else{
                    document.querySelectorAll('.msg-send-dropdown').forEach((element)=>{
                        element.nextElementSibling.remove();
                        element.remove();
                    })
                }
            }

            if(socket?.groupdata?.agenttoagentfilesettingupdateddata && socket?.groupdata?.agenttoagentfilesettingupdateddata == 'agentToagentFilesettingUpdated'){
                if(socket.groupdata.agenttoagentfilesettingupdatedvalue == 'on'){
                    document.getElementById('agentToCustFileSetUpdate').classList.remove('d-none')
                }else{
                    document.getElementById('agentToCustFileSetUpdate').classList.add('d-none')
                }
            }

            let groupIncludeDB = socket.groupInclude ? JSON.parse(socket.groupInclude) : []

            // Conversation Messages
            let operatorConversation = document.querySelector("#operator-conversation")
            if (
                (autoID == socket.receiverId && operatorConversation?.getAttribute("operator-id") == socket
                    .senderId && socket.message != null) || // Agent Conversation Messages
                (socket.receiverId == operatorConversation?.getAttribute("group-id") && socket.message != null &&
                    socket.senderId != autoID && groupIncludeDB.includes(parseInt(autoID))
                    ) // Group Conversation Messages
            ) {
                // For the current Time
                const now = new Date();
                const hours = now.getHours();
                const minutes = now.getMinutes();
                const period = hours >= 12 ? "PM" : "AM";

                const formattedTime = `${((hours + 11) % 12) + 1}:${minutes}${period}`;

                let operatorMessage = document.createElement("li");
                operatorMessage.className = "chat-item-start"
                operatorMessage.innerHTML = `
                    <div class="chat-list-inner">
                        <div class="chat-user-profile">
                            <span class="avatar avatar-md brround" style="background-image: url(${socket.senderImage})">
                            </span>
                        </div>
                        <div class="ms-3">
                            <span class="chatting-user-info">
                                <span class="chatnameperson">${socket.senderName}</span> <span class="msg-sent-time">${formattedTime}</span>
                                ${(texttospeachenabled == 'on' || texttranslateenabled == 'on') && (socket.messageType != "image" && socket.messageType != "audio") ?
                                    `<a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class='float-end msg-send-dropdown'>
                                        <i class="fe fe-more-vertical fs-18"></i>
                                    </a>
                                    <ul class="dropdown-menu">
                                        ${texttospeachenabled == 'on' ?
                                            `<li>
                                                <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="texttospeachbtn()">
                                                    <i class="ri-volume-up-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Text To Speach') }}
                                                </a>
                                            </li>` : ''}
                                        ${texttranslateenabled == 'on' ?
                                            `<li>
                                                <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="langtranslatebtn()">
                                                    <i class="ri-volume-up-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>{{ lang('Language Translate') }}
                                                </a>
                                            </li>` : ''}
                                    </ul>`
                                    : ''
                                }
                            </span>
                            <div class="main-chat-msg">
                                ${socket.messageType == "image" ? `
                                                    <div onclick="AllFileViewer(this)"imageSrc="${socket.message}" class="mt-2 ${socket.message.toLowerCase().endsWith(".jpg") || socket.message.toLowerCase().endsWith(".png") ? 'imageMessageLiveChat' : ''}" style="
                                                        background-image: url('${socket.message.toLowerCase().endsWith(".jpg") || socket.message.toLowerCase().endsWith(".png") ? socket.message : `${SITEURL}/build/assets/images/svgs/file.svg`}');
                                                        background-size: cover;
                                                        width: ${socket.message.toLowerCase().endsWith(".jpg") || socket.message.toLowerCase().endsWith(".png") ?'10rem' :'8rem'};
                                                        aspect-ratio: 1;
                                                        background-repeat: no-repeat;
                                                        background-color: transparent;
                                                        background-position: center;
                                                    ">
                                                    </div>
                                                ` : socket.messageType == "audio" ? `<audio controls="" src="${socket.message}"></audio>` : `<div style="white-space: pre-line;"><p class="mb-0" >${socket.message}</p></div>`
                                }
                            </div>
                        </div>
                    </div>
                `

                if (document.querySelector("#agentTyping")) {
                    document.querySelector("#agentTyping").remove()
                }
                operatorConversation.appendChild(operatorMessage)

                // To get the seen indaction
                $.ajax({
                    type: "get",
                    url: SITEURL +
                        `/admin/operators/singleoperator/${document.querySelector("#operator-conversation-Info").getAttribute("data-id")}`,
                    success: function(data) {},
                    error: function(data) {},
                })

                // To Scroll Down the Conversation
                document.querySelector("#operator-conversation").scrollBy(0, document.querySelector(
                    "#operator-conversation").scrollHeight)
            }

            //Typing induction in Conversation
            if (
                (autoID == socket.receiverId && operatorConversation?.getAttribute("operator-id") == socket
                    .senderId && socket.typingMessage != null && socket.senderId != autoID) ||
                // Agent Typing Condition
                (socket.receiverId == operatorConversation?.getAttribute("group-id") && socket.typingMessage !=
                    null && socket.senderId != autoID && groupIncludeDB.includes(parseInt(autoID))
                    ) // Group Typing Condition
            ) {
                if (document.querySelector("#agentTyping")) {
                    document.querySelector("#agentTyping").remove()
                }

                let operatorMessage = document.createElement("li");
                operatorMessage.className = "chat-item-start"
                operatorMessage.id = "agentTyping"
                operatorMessage.innerHTML = `
                        <div class="chat-list-inner">
                            <div class="chat-user-profile">
                                <span class="avatar avatar-md brround" style="background-image: url(${socket.senderImage})">
                                </span>
                            </div>
                            <div class="ms-3">
                                <span class="chatting-user-info">
                                    <span class="chatnameperson">${socket.senderName}</span>
                                </span>
                                <div class="main-chat-msg">
                                    <div class="d-flex">
                                        <b class="ms-3">{{ lang('Typing') }}...</b>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `

                operatorConversation.appendChild(operatorMessage)

                // To Scroll Down the Conversation
                document.querySelector("#operator-conversation").scrollBy(0, document.querySelector(
                    "#operator-conversation").scrollHeight)

                clearTimeout(debounceTimeout3);

                debounceTimeout3 = setTimeout(function() {
                    if (document.querySelector("#agentTyping")) {
                        document.querySelector("#agentTyping").remove()
                    }
                }, 5000)
            }

            // Typing induction in Sidebar
            let groupLiElementExisting = document.querySelector(`#chat-msg-scroll>li[data-group-uniq='${socket.receiverId}']`)

            // Chat Open induction
            if (
                (socket.openedUser && !socket.message) || // Agent Condition
                (document.querySelector(`.checkforactive[data-group-uniq='${socket.openedUser}']`) && !socket
                    .message) // Group Condition
            ) {

                // To add the old message to the side bar
                if (document.querySelector(`.checkforactive[data-group-uniq='${SidebarPastUserId}']`)) {
                    document.querySelector(`.checkforactive[data-group-uniq='${SidebarPastUserId}']`).querySelector(
                        '.chat-msg').innerText = pastMessage
                }
                if (document.querySelector(`.checkforactive[data-id='${SidebarPastUserId}']`)) {
                    document.querySelector(`.checkforactive[data-id='${SidebarPastUserId}']`).querySelector(
                        '.chat-msg').innerText = pastMessage
                }

                if (socket.openedUser == autoID) {
                    if (!chatOpenAgent.includes(socket.senderId)) {
                        // Agent Array add
                        chatOpenAgent.push(socket.senderId)
                    }
                    if (chatOpenAgent.includes(parseInt(operatorConversation?.getAttribute("operator-id")))) {
                        document.querySelectorAll("#operator-conversation .chat-read-icon").forEach((ele) => {
                            // To add the Message view induction in chat
                            ele.classList.remove("chat-read-icon")
                            ele.classList.add("chat-read-mark")
                            ele.querySelector('i').className = "ri-check-double-fill"

                            // To add the Message view induction in sidebar
                            let SideBarProfile = document.querySelector(
                                `.checkforactive[data-id='${parseInt(operatorConversation?.getAttribute("operator-id"))}']`
                                ).querySelector(".chat-read-icon")
                            if (SideBarProfile) {
                                SideBarProfile.classList.add('chat-read-mark')
                                SideBarProfile.querySelector('i').className = "ri-check-double-fill"
                                SideBarProfile.classList.remove('chat-read-icon')
                            }
                        })
                    }
                } else {
                    const valueToRemove = socket.senderId;
                    chatOpenAgent = chatOpenAgent.filter(item => item !== valueToRemove);
                }


                // Group Array Add logic
                if (document.querySelector(`.checkforactive[data-group-uniq='${socket.openedUser}']`)) {
                    // Group Array Add
                    const existingEntryIndex = chatOpenAgent.findIndex(entry => Object.keys(entry)[0] === socket
                        .openedUser);
                    if (existingEntryIndex !== -1) {
                        const existingArray = chatOpenAgent[existingEntryIndex][socket.openedUser];
                        if (!existingArray.includes(socket.senderId)) {
                            existingArray.push(socket.senderId);

                            // Remove sender ID from other entries
                            chatOpenAgent.forEach((entry, index) => {
                                const key = Object.keys(entry)[0];
                                const existingArray = entry[key];

                                if (index !== existingEntryIndex) {
                                    const indexOfNumber = existingArray.indexOf(socket.senderId);
                                    if (indexOfNumber !== -1) {
                                        existingArray.splice(indexOfNumber, 1);
                                    }
                                }
                            });
                        }
                    } else {
                        // To remove the user id from old data
                        chatOpenAgent.forEach(entry => {
                            const key = Object.keys(entry)[0];
                            const existingArray = entry[key];

                            const indexOfNumber = existingArray.indexOf(socket.senderId);
                            if (indexOfNumber !== -1) {
                                existingArray.splice(indexOfNumber, 1);
                            }
                        });

                        chatOpenAgent.push({
                            [socket.openedUser]: [socket.senderId]
                        });
                    }

                    // To add the Message view induction in chat
                    if (document.querySelector("#operator-conversation")) {
                        const valuesToCheck = JSON.parse(document.querySelector("#operator-conversation")
                            .getAttribute('group-recievers_id'));
                        const existingEntryIndex = chatOpenAgent.find(obj => obj.hasOwnProperty(document
                            .querySelector("#operator-conversation").getAttribute('group-id')))
                        const allValuesIncluded = valuesToCheck ? valuesToCheck.every(value => existingEntryIndex[
                                document.querySelector("#operator-conversation").getAttribute('group-id')]
                            .includes(value)) : false;

                        if (document.querySelector(`#operator-conversation[group-id='${socket.openedUser}']`) &&
                            allValuesIncluded) {
                            // For the Side bar induction
                            let SideBarElement = document.querySelector(
                                `.checkforactive[data-group-uniq='${document.querySelector("#operator-conversation").getAttribute('group-id')}']`
                                )
                            if (SideBarElement.querySelector('.chat-read-icon')) {
                                SideBarElement.querySelector('.chat-read-icon').classList.add('chat-read-mark')
                                SideBarElement.querySelector('.chat-read-icon').classList.remove('chat-read-icon')
                            }


                            // For the conversation message status induction
                            document.querySelectorAll("#operator-conversation .chat-read-icon").forEach((ele) => {
                                ele.classList.remove("chat-read-icon")
                                ele.classList.add("chat-read-mark")
                                ele.querySelector('i').className = "ri-check-double-fill"
                            })
                        }
                    }

                }

                // To remove the user from group
                let isIdFound = false;

                function isNumberPresent() {
                    if (chatOpenAgent.includes(socket.senderId) || !document.querySelector(
                            `.checkforactive[data-group-uniq='${socket.openedUser}']`)) {
                        for (const openusers of chatOpenAgent) {
                            if (typeof openusers == "object") {
                                if (openusers[Object.keys(openusers)[0]].includes(socket.senderId)) {
                                    isIdFound = true
                                    break
                                }
                            }
                        }
                    }

                }
                isNumberPresent()
                if (isIdFound) {
                    // To remove the group
                    for (const openusers of chatOpenAgent) {
                        if (typeof openusers == "object") {
                            if (openusers[Object.keys(openusers)[0]].includes(socket.senderId)) {
                                openusers[Object.keys(openusers)[0]] = openusers[Object.keys(openusers)[0]].filter(
                                    item => item != socket.senderId)
                            }
                        }
                    }
                }
            }

            // Sidebar adding message top
            if (
                (autoID == socket.receiverId && socket.message != null) || // Agent
                (groupIncludeDB.includes(parseInt(autoID)) && socket.message != null) // Group
            ) {
                const existingLi = Array.from(document.querySelectorAll("#chat-msg-scroll>li")).find(li => li.getAttribute('data-id') == socket.senderId);

                if (!existingLi && !socket.groupInclude) {
                    if(document.querySelector('.text-center.mt-5.p-1.bg-warning-transparent.text-default')){
                        document.querySelector('.text-center.mt-5.p-1.bg-warning-transparent.text-default').remove();
                    }

                    let deleteRouteUrl = "{{ route('admin.conversationdelete', ':unique_id') }}";
                    let agentElement = document.createElement("li")
                    agentElement.className = "checkforactive"
                    agentElement.setAttribute("data-id", "2")
                    agentElement.innerHTML = `
                            <div class="d-flex align-items-center">
                                <div class="me-2 lh-1">
                                    <span class="avatar brround" style="
                                        background-image: url(${document.querySelector(`.agents-list [data-id='${socket.senderId}'] .avatar `).style.backgroundImage.match(/url\("?(.+?)"?\)/)[1]})
                                    ">
                                    <span class="avatar-status onlineOfflineIndicator bg-green"></span>
                                    </span>
                                    <input aria-label="anchor" data-id="agent" aria-expanded="false" type="checkbox" name="customer_checkbox[]" class="checkall ticket-select-check live-chat-checkbox form-check-input" value="${socket.groupdata.encrypted_unique_id}"/>
                                </div>
                                <div class="flex-fill">
                                    <div class="mb-0 d-flex align-items-center justify-content-between">
                                        <div class="font-weight-semibold">
                                        <a href="javascript:void(0);">${document.querySelector(`.agents-list [data-id='${socket.senderId}'] .font-weight-semibold`).innerHTML}</a>
                                        </div>
                                        <div class="float-end text-muted fw-normal fs-12 chat-time" data-initial-24time="${new Date().toLocaleString()}">${new Date().toLocaleTimeString()}</div>
                                        <div class="dropdown chat-actions lh-1">
                                            <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i class="fe fe-more-vertical fs-18"></i>
                                            </a>
                                            <ul class="dropdown-menu">
                                                <li>
                                                    <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="slectTicket(event, ${socket.groupdata.id})" data-id="${socket.groupdata.id}">
                                                        <i class="ri-mail-check-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>
                                                        {{ lang('Select') }}
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item dropdown-item-delete" href="javascript:void(0);" onclick="confirmFunction('${deleteRouteUrl.replace(':unique_id', socket.groupdata.unique_id)}','${socket.groupdata.id}')">
                                                        <i class="ri-delete-bin-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>
                                                        {{ lang('Delete') }}
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-between">
                                        <span class="chat-msg text-truncate fs-13 text-default font-weight-bold">${socket.message}</span>
                                        <span class="badge bg-success-transparent rounded-circle float-end unReadIndexNumber">1</span>
                                    </div>
                                </div>
                            </div>
                        `
                    agentElement.onclick = () => {
                        if(event.target.classList.contains('fe-more-vertical') || event.target.classList.contains('dropdown-item') || event.target.classList.contains('ticket-select-check')){
                            event.stopPropagation();
                            updateCustomCheckAll();
                            updateMassDeleteVisibility();
                        }else{
                            sideMenuOpenClickFunction(agentElement);
                        }
                    }
                    document.querySelector("#chat-msg-scroll").insertBefore(agentElement, document.querySelector(
                        "#chat-msg-scroll > li"));

                } else {
                    document.querySelectorAll("#chat-msg-scroll>li").forEach((ele) => {
                        if (
                            (ele.getAttribute("data-id") == socket.senderId && autoID == socket
                                .receiverId && operatorConversation?.getAttribute("operator-id") != socket
                                .senderId) || // Agent Sidebar adding message top Condition
                            (ele.getAttribute("data-group-uniq") == socket.receiverId && groupIncludeDB
                                .includes(parseInt(autoID)) && socket.senderId != autoID
                                ) // Group Sidebar adding message top Condition
                        ) {
                            // To add the message to the sidebar
                            ele.querySelector(".chat-msg").innerText = socket.message
                            // To add the time to the sidebar

                            ele.querySelector(".chat-time").setAttribute("data-initial-24time", new Date().toLocaleString());
                            ele.querySelector('.chat-time').innerText = new Date().toLocaleTimeString()

                            if (ele.querySelector(".unReadIndexNumber")) {
                                ele.querySelector(".unReadIndexNumber").innerText = ele.querySelector(
                                    ".unReadIndexNumber").innerText ? parseInt(ele.querySelector(
                                    ".unReadIndexNumber").innerText) + 1 : 1
                            } else {
                                // To stop the Unread Index Number for the Open chat
                                if (operatorConversation?.getAttribute("group-id") != socket.receiverId) {
                                    let unReadIndexNumber = document.createElement('span')
                                    unReadIndexNumber.className =
                                        "badge bg-success-transparent rounded-circle float-end unReadIndexNumber me-1 ms-auto"
                                    unReadIndexNumber.innerText = 1
                                    if (ele.querySelector(".chat-msg").parentNode.querySelector(
                                            '.avatar-list')) {
                                        // To inset the group number top of the span
                                        ele.querySelector(".chat-msg").parentNode.insertBefore(
                                            unReadIndexNumber, ele.querySelector(".chat-msg").parentNode
                                            .querySelector('.avatar-list'))
                                    } else {
                                        ele.querySelector(".chat-msg").parentNode.appendChild(
                                            unReadIndexNumber)
                                    }
                                }
                            }
                            // To stop the bold Text to the Open chat
                            if (operatorConversation?.getAttribute("group-id") != socket.receiverId) {
                                ele.querySelector(".chat-msg").classList.add("font-weight-bold")
                            }
                            if (ele.parentNode.querySelector(".d-inline-flex")) {
                                ele.parentNode.querySelector(".d-inline-flex").remove()
                            }
                            // To add the recent Customer to top
                            ele.parentNode.insertBefore(ele, document.querySelector("#chat-msg-scroll>li"))
                            clearTimeout(debounceTimeout2);
                            // To add the message in the side bar when the user was tying speed
                            sibeBarTypingAllowVar = false
                            setInterval(() => {
                                sibeBarTypingAllowVar = true
                            }, 500);
                        }

                        // To Add the Agent Message in the SideBar
                        if (ele.getAttribute("data-id") == socket.senderId && autoID == socket.receiverId) {
                            // To add the message to the sidebar
                            ele.querySelector(".chat-msg").innerHTML = socket.message
                            // To add the time to the sidebar

                            ele.querySelector(".chat-time").setAttribute("data-initial-24time", new Date().toLocaleString());
                            ele.querySelector('.chat-time').innerText = new Date().toLocaleTimeString()
                            if (ele.querySelector("#messageStatusDiv")) {
                                ele.querySelector("#messageStatusDiv").remove()
                            }
                        }
                    })
                }
            }

            //Group created the SideBar Update Logic
            if (!document.querySelector(`.checkforactive[data-group-uniq='${socket.receiverId}']`) && socket.message && socket.groupInclude && JSON.parse(socket.groupInclude).includes(parseInt(autoID))) {

                if(document.querySelector('.text-center.mt-5.p-1.bg-warning-transparent.text-default')){
                    document.querySelector('.text-center.mt-5.p-1.bg-warning-transparent.text-default').remove();
                }

                let deleteRouteUrl = "{{ route('admin.groupconversiondelete', ':unique_id') }}";
                let agentElement = document.createElement("li")
                agentElement.className = "checkforactive"
                agentElement.setAttribute("data-group-uniq", socket.receiverId)
                agentElement.innerHTML = `
                        <div class="d-flex align-items-center">
                            <div class="me-2 lh-1">
                                <span class="avatar brround" style="background-image: url(${socket.senderImage})">
                                    <span class="avatar-status onlineOfflineIndicator bg-green"></span>
                                </span>
                                <input aria-label="anchor" data-id="group" aria-expanded="false" type="checkbox" name="customer_checkbox[]" class="checkall ticket-select-check live-chat-checkbox form-check-input" value="${socket.groupdata.encrypted_unique_id}"/>
                            </div>
                            <div class="flex-fill">
                                <div class="mb-0 d-flex align-items-center justify-content-between">
                                    <div class="font-weight-semibold">
                                        <a href="javascript:void(0);">${socket.senderName}</a>
                                    </div>
                                    <div class="float-end text-muted fw-normal fs-12 chat-time" data-initial-24time="${new Date().toLocaleString()}">${new Date().toLocaleTimeString()}</div>
                                    <div class="dropdown chat-actions lh-1">
                                        <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="fe fe-more-vertical fs-18"></i>
                                        </a>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <a aria-label="anchor" class="dropdown-item" href="javascript:void(0);" onclick="slectTicket(event, ${socket.groupdata.id})" data-id="${socket.groupdata.id}">
                                                    <i class="ri-mail-check-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>
                                                    {{ lang('Select') }}
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item dropdown-item-delete gg" href="javascript:void(0);" onclick="confirmFunction('${deleteRouteUrl.replace(':unique_id', socket.receiverId)}','${socket.receiverId}')">
                                                    <i class="ri-delete-bin-fill align-middle me-2 fs-17 text-muted chat-info-optionicon d-inline-block"></i>
                                                    {{ lang('Delete') }}
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center justify-content-between">
                                    <span class="chat-msg text-truncate fs-13 text-default font-weight-bold">${socket.message}</span>
                                    <span class="badge bg-success-transparent rounded-circle float-end unReadIndexNumber">1</span>

                                    <div class="avatar-list avatar-list-stacked me-3">
                                        ${socket.groupdata.groupincludeusersdata}
                                    </div>
                                </div>
                            </div>
                        </div>
                    `
                agentElement.onclick = () => {
                    if(event.target.classList.contains('fe-more-vertical') || event.target.classList.contains('dropdown-item') || event.target.classList.contains('ticket-select-check')){
                        event.stopPropagation();
                        updateCustomCheckAll();
                        updateMassDeleteVisibility();
                    }else{
                        sideMenuOpenClickFunction(agentElement);
                    }
                }
                $('[data-bs-toggle="tooltip"]').tooltip();
                document.querySelector("#chat-msg-scroll").insertBefore(agentElement, document.querySelector("#chat-msg-scroll > li"));
            }
            pauseAudios();
        })
        agentMessageChannel.here((users) => {

            // For the Active chat online status
            setTimeout(() => {
                users.map((user)=>{
                    let activeChatEle = document.querySelector("#operator-conversation-Info")
                    if(activeChatEle){
                        if(activeChatEle.getAttribute('data-id') && user.id == activeChatEle.getAttribute('data-id').trim()){
                            activeChatEle.querySelector(".chatpersonstatus").innerText = "online"
                            activeChatEle.querySelector(".onlineOfflineIndicator ").classList.add("bg-green")
                            activeChatEle.querySelector(".onlineOfflineIndicator ").classList.remove("bg-gray")
                        }
                    }
                })
            }, 5000);

            // To remove the skeleton loader
            document.querySelector("#agents-list")?.classList.remove("is-loading")

            let availableAgents = document.querySelector("#chat-user-details")

            // index of Online Agents
            if(availableAgents.querySelector(".card-header .AvailableOperatorsIndex")){
                availableAgents.querySelector(".card-header .AvailableOperatorsIndex").innerText = `(${parseInt(users.length) - 1})`
            }

            // Online Agents
            document.querySelectorAll("#chat-msg-scroll li.checkforactive,#agents-list li.agent-detail,#onlineUlChatroom li[data-id]")
                .forEach((ele) => {
                    let dataId = ele.getAttribute("data-id");
                    if (dataId) {
                        let id = parseInt(dataId);
                        if (users.some(item => item.id === id)) {
                            let onlineOfflineIndicator = ele.querySelector(".onlineOfflineIndicator")
                            onlineOfflineIndicator.classList.remove('bg-gray')
                            onlineOfflineIndicator.classList.add('bg-green')
                            if (ele.classList.contains("agent-detail")) {
                                document.querySelector(".agent-detail").parentNode.insertBefore(
                                    onlineOfflineIndicator.closest(".agent-detail"), document.querySelector(
                                        ".agent-detail"))
                            }
                            // For The Chart Room Online
                            if (ele.classList.contains("list-group-item")) {
                                document.querySelector("#onlineUlChatroom").insertBefore(ele, document
                                    .querySelector("#onlineUlChatroom .list-group-item[data-id]"))
                            }
                        } else {
                            let onlineOfflineIndicator = ele.querySelector(".onlineOfflineIndicator")
                            if (onlineOfflineIndicator) {
                                onlineOfflineIndicator.classList.add('bg-gray')
                                onlineOfflineIndicator.classList.remove('bg-green')
                            }
                        }
                    }
                })

        })
        agentMessageChannel.joining((user) => {

            // without reload the joining Agent will show reload

            let availableAgents = document.querySelector("#chat-user-details")

            // Online Agents
            document.querySelectorAll(
                "#chat-msg-scroll li.checkforactive,#agents-list li.agent-detail,#operator-conversation-Info,#onlineUlChatroom li[data-id]"
                ).forEach((ele) => {
                let dataId = ele.getAttribute("data-id");
                if (dataId) {
                    let id = parseInt(dataId);
                    if (user.id === id) {
                        let onlineOfflineIndicator = ele.querySelector(".onlineOfflineIndicator")
                        if (onlineOfflineIndicator) {
                            onlineOfflineIndicator.classList.remove('bg-gray')
                            onlineOfflineIndicator.classList.add('bg-green')
                        }
                        if (ele.classList.contains("agent-detail") && ele.id !=
                            'operator-conversation-Info') {
                            document.querySelector(".agent-detail").parentNode.insertBefore(
                                onlineOfflineIndicator.closest(".agent-detail"), document.querySelector(
                                    ".agent-detail"))
                            // index of Online Agents
                            availableAgents.querySelector(".card-header .AvailableOperatorsIndex").innerText = `(${parseInt(availableAgents.querySelector(".card-header .AvailableOperatorsIndex").innerText.match(/\d+/)[0]) + 1})`
                        }
                        // For the Chartroom online add
                        if (ele.classList.contains("list-group-item")) {
                            document.querySelector("#onlineUlChatroom").insertBefore(ele, document
                                .querySelector("#onlineUlChatroom .list-group-item[data-id]"))
                        }

                        // For the online info
                        if (ele.id == 'operator-conversation-Info') {
                            ele.querySelector(".chatpersonstatus").innerText = "online"
                        }
                    }
                }
            })

        })
        agentMessageChannel.leaving((user) => {
            // without reload the leaving Agent will show reload
            let availableAgents = document.querySelector("#chat-user-details")

            // Online Agents
            document.querySelectorAll(
                "#chat-msg-scroll li.checkforactive,#agents-list li.agent-detail,#operator-conversation-Info,#onlineUlChatroom li[data-id]"
                ).forEach((ele) => {
                let dataId = ele.getAttribute("data-id");
                if (dataId) {
                    let id = parseInt(dataId);
                    if (user.id === id) {
                        let onlineOfflineIndicator = ele.querySelector(".onlineOfflineIndicator")
                        if (onlineOfflineIndicator) {
                            onlineOfflineIndicator.classList.add('bg-gray')
                            onlineOfflineIndicator.classList.remove('bg-green')
                        }

                        if (ele.classList.contains("agent-detail") && ele.id !=
                            'operator-conversation-Info') {
                            // index of Online Agents
                            availableAgents.querySelector(".card-header .AvailableOperatorsIndex").innerText = `(${parseInt(availableAgents.querySelector(".card-header .AvailableOperatorsIndex").innerText.match(/\d+/)[0]) - 1})`
                        }

                        // For the Offline info
                        if (ele.id == 'operator-conversation-Info') {
                            ele.querySelector(".chatpersonstatus").innerText = "offline"
                        }
                    }
                }
            })

            // To remove the user Form the chat Apen Array
            chatOpenAgent = chatOpenAgent.filter(item => item !== user.id);
        })
    </script>
    <script type="text/javascript">
        function responsivechat() {

            /* NEW JS FOR LIVE CHAT RESPONSIVE */
            document.querySelectorAll(".checkforactive").forEach((ele) => {
                ele.addEventListener("click", () => {
                    document.querySelector(".main-chart-wrapper").classList.add("responsive-chat-open")
                })
            })

            document.querySelectorAll(".responsive-userinfo-open").forEach((ele) => {
                ele.addEventListener("click", () => {
                    document.querySelector(".main-chat-user-details").classList.add("open");
                });
            });

            document.querySelector(".responsive-chat-close")?.addEventListener("click", () => {
                document.querySelector(".main-chart-wrapper").classList.remove("responsive-chat-open")
            })

            document.querySelector(".responsive-chat-close2")?.addEventListener("click",() =>{
                document.querySelector(".main-chat-user-details").classList.remove("open")
            })

            document.querySelector(".chat-info")?.addEventListener("click", () => {
                document.querySelector(".main-chat-user-details").classList.remove("open")
            })
            document.querySelector(".chat-content")?.addEventListener("click", () => {
                document.querySelector(".main-chat-user-details").classList.remove("open")
            })
            /* NEW JS FOR LIVE CHAT RESPONSIVE */
        }
    </script>

    <script>
        let voices = [];
        let arabicVoice = null;
        let defaultVoice = null;

        function loadVoices() {
            voices = speechSynthesis.getVoices();
        }

        async function translateText(text, targetLang) {
            const response = await fetch('{{ route('texttospeech.lang.translate.back') }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    text: text,
                    target_lang: targetLang
                })
            });

            if (!response.ok) {
                throw new Error('Translation failed');
            }

            const data = await response.json();
            return data.translatedText;
        }

        async function speakText() {
            const textInput = document.getElementById('texttospeachcontent').value;
            const selectedLang = document.getElementById('lang-select').value;
            try {
                const translatedText = await translateText(textInput, selectedLang);
                const utterance = new SpeechSynthesisUtterance(translatedText);
                const matchingVoice = voices.find(voice => voice.lang.startsWith(selectedLang));

                if (matchingVoice) {
                    utterance.voice = matchingVoice;
                    utterance.lang = selectedLang;
                } else {
                    alert(`No voice is available for the selected language: ${selectedLang}. The browser will use a default voice.`);
                }

                speechSynthesis.cancel();
                speechSynthesis.speak(utterance);
            } catch (error) {
                console.error('Error:', error);
            }
        }

        function stop() {
            speechSynthesis.cancel();
        }

        function pause() {
            speechSynthesis.pause();
        }

        function resume() {
            speechSynthesis.resume();
        }

        window.addEventListener('load', () => {
            loadVoices();
            speechSynthesis.onvoiceschanged = loadVoices;
        });
        window.addEventListener('beforeunload', () => {
            if (speechSynthesis.speaking) {
                stop();
            }
        });
    </script>

@endsection
