@extends('layouts.adminmaster')
@section('styles')

<style>

    .rtl .notify-sound {
    padding-left: 1.5rem !important;
    padding-right: 1.5rem !important;
    }
    .theme-colors .switcher-style {
    padding: 0;
    }
    .switch-select.form-check {
    margin-block-end: 0;
    min-height: auto;
    }
    .theme-colors .switcher-style {
    padding: 0;
    }
    .theme-colors .switch-select .color-input {
    width: 2rem;
    height: 2rem;
    border-radius: 50px;
    }
    .theme-colors .switch-select .color-input.form-check-input:checked {
    border: 1px solid var(--input-border);
    position: relative;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.03);
    }
    .theme-colors .switch-select .color-input.form-check-input:checked:before {
    position: absolute;
    content: "\eb7b";
    font-family: remixicon !important;
    color: #00ff00;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.35rem;
    font-weight: 600;
    }
    .theme-colors .switch-select .color-input.color-white {
    background-color: #fff;
    }
    .theme-colors .switch-select .color-input.color-dark {
    background-color: #000;
    }
    .theme-colors .switch-select .color-input.color-primary {
    background-color: var(--primary);
    }
    .theme-colors .switch-select .color-input.color-primary-1 {
    background-color: rgb(30, 144, 255);
    }
    .theme-colors .switch-select .color-input.color-primary-2 {
    background-color: rgb(255, 99, 71);
    }
    .theme-colors .switch-select .color-input.color-primary-3 {
    background-color: rgb(67, 160, 71);
    }
    .theme-colors .switch-select .color-input.color-primary-4 {
    background-color: rgb(0, 172, 193);
    }
    .theme-colors .switch-select .color-input.color-primary-5 {
    background-color: rgb(109, 40, 217);
    }
    .theme-colors .switch-select .form-check-input:checked[type="radio"] {
    background-image: none;
    }
    .theme-colors .switch-select .form-check-input {
    border: 0;
    }
    .theme-colors .switch-select .form-check-input:focus {
    box-shadow: none;
    }
    .theme-colors .switch-select .form-check-input:active {
    filter: brightness(100%);
    }
    .chat-appearance-content .chat-message-popup {
    background-color: var(--default-background);
    border: 0px;
    height: 560px;
    width: auto;
    bottom: inherit;
    inset-inline-end: inherit;
    position: relative;
    z-index: 99;
    box-shadow: 0px 16px 18px rgba(6, 10, 48, 0.1);
    overflow: hidden;
    transition: none;
    }
    #text-area {
    padding: 1.25rem 0.75rem 1rem;
    line-height: 1.375rem;
    resize: none;
    overflow-y: auto;
    }
    .form-check.switch-select .form-check-input {
    position: relative;
    }
    .theme-container-background button,
    .theme-container-primary button {
    display: none;
    }
    .pickr-container-background .pickr .pcr-button,
    .pickr-container-primary .pickr .pcr-button {
    width: 2rem;
    height: 2rem;
    overflow: hidden;
    border-radius: 50%;
    border: 1px solid #e6ebf1;
    box-shadow: none;
    }
    .pickr-container-background .pickr .pcr-button::after,
    .pickr-container-primary .pickr .pcr-button::after {
    content: "\efc5";
    font-family: remixicon !important;
    color: rgba(255, 255, 255, 0.7);
    line-height: 1.5;
    font-size: 1.25rem;
    }

    .pickr .pcr-button::after {
    position: absolute;
    content: "";
    top: 0;
    left: 0;
    height: 100%;
    width: 100%;
    transition: background 0.3s;
    background: var(--pcr-color);
    border-radius: 50%;
    }
    .service-card1 {
    margin: 15px;
    margin: 0 auto;
    background-color: rgba(235, 239, 244, 0.25);
    }

    .service-card {
    margin: 15px;
    margin: 0 auto;
    }

    .service-card.form-check-input {
        width: 100%;
        height: 100%;
        border-radius: 6px;
        border: 1px solid #e7edf3;
        background: transparent;
        inset-block-start: 0rem;
        margin: 0px !important;
        z-index: 1;
    }

    .service-card.form-check-input:checked {
        width: 100%;
        height: 100%;
        border: 1px solid var(--primary);
        background: var(--primary01);
        border-radius: 6px;
        margin: 0px;
        z-index: 0;
    }

    .service-card-style {
        border-radius: 5px;
        font-size: 25px;
    }

    .service-card1 {
        margin: 15px;
        margin: 0 auto;
        background-color: rgba(235, 239, 244, 0.25);
    }

    .service-card {
        margin: 15px;
        margin: 0 auto;
    }
    .service-card-container {
        position: relative;
    }
    .service-card-container {
        position: relative;
        padding: 1.5rem;
        border-radius: 6px;
    }
    .service-card.form-check-input:checked {
        width: 100%;
        height: 100%;
        border: 1px solid var(--primary);
        background: var(--primary01);
        border-radius: 6px;
        margin: 0px;
        z-index: 0;
    }
    .service-card.form-check-input {
        width: 100%;
        height: 100%;
        border-radius: 6px;
        border: 1px solid #e7edf3;
        background: transparent;
        inset-block-start: 0rem;
        margin: 0px !important;
        z-index: 1;
    }
    .service-card-container .form-check-input {
        position: absolute;
        inset-inline-end: 0;
        inset-block-start: -0.3rem;
    }
    .check-active {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 30px;
        position: absolute;
        height: 30px;
        right: -0.7rem;
        top: -0.7rem;
        background: var(--primary);
        border-radius: 50px;
        color: var(--primary);
        padding: 5px;
        z-index: 9;
        font-size: 15px !important;
        border: 1px solid var(--primary);
    }
    .service-card-container .avatar {
        position: inherit;
        display: flex;
        justify-content: center;
        flex-direction: column;
        margin: 0 auto;
    }

    .service-card1 {
        margin: 15px;
        margin: 0 auto;
        background-color: rgba(235, 239, 244, 0.25);
    }

    .service-card {
        margin: 15px;
        margin: 0 auto;
    }

    .service-card.form-check-input {
        width: 100%;
        height: 100%;
        border-radius: 6px;
        border: 1px solid #e7edf3;
        background: transparent;
        inset-block-start: 0rem;
        margin: 0px !important;
        z-index: 1;
    }

    .service-card.form-check-input:checked {
        width: 100%;
        height: 100%;
        border: 1px solid var(--primary);
        background: var(--primary01);
        border-radius: 6px;
        margin: 0px;
        z-index: 0;
    }
    .service-card-style {
        border-radius: 5px;
        font-size: 25px;
    }
    .service-card1 {
        margin: 15px;
        margin: 0 auto;
        background-color: rgba(235, 239, 244, 0.25);
    }
    .service-card {
        margin: 15px;
        margin: 0 auto;
    }
    .check-active {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 30px;
        position: absolute;
        height: 30px;
        right: -0.7rem;
        top: -0.7rem;
        background: #fff;
        border-radius: 50px;
        color: var(--primary);
        padding: 5px;
        z-index: 9;
        font-size: 15px;
        border: 1px solid var(--primary);
    }
    .service-card1 {
        margin: 0;
        background-color: #fff;
        border-radius:6px;
        position:relative;
    }
    .service-card1 img {
        border-radius:6px;
    }
    .service-card1 .del-btn {
        position: absolute;
        top: -12px;
        z-index: 10;
        left: auto;
        cursor: pointer;
        right: -11px;
        display: flex;
        align-items: center;
        margin: 0 auto;
    }
    .service-card1 .del-btn i {
        margin: 0 auto;
    }
    .service-card1.active .del-btn {
        display: none;
    }
    .service-card1 #my-dropzone {
        border-radius: 6px;
        border: 1px solid #e7edf3 !important;
        background: transparent;
        inset-block-start: 0rem;
        margin: 0px !important;
        z-index: 1;
        min-height: auto !important;
    }
    #my-dropzone .dz-image {
        width: 4rem;
        height: 4rem;
        line-height: 4rem;
        font-size: 1.25rem;
    }
    #my-dropzone .dz-details {
        display: none;
    }
    .dropzone#my-dropzone .dz-preview.dz-file-preview .dz-image {
        border-radius: 6px !important;
    }
    #my-dropzone .dz-button {
        display: none;
    }
    .dropzone#my-dropzone .dz-preview {
        min-height: auto;
    }
    .upload-img {
        display: flex !important;
        position: absolute;
        /* background: var(--black-7); */
        border-radius: 5px;
        width: 100%;
        height: 100%;
        /* padding: 25%; */
        color: #fff;
        font-size: 20px;
        align-items: center;
    }
    .upload-img i {
        margin: 0 auto;
    }
    .dropzone .dz-preview {
        margin: 0 !important;
    }
    .dropzone .dz-preview .dz-image {
        border-radius: 5px !important;
    }
    .imageshowdiv{
        position: relative;
    }
    .imageshowdiv .delete-image{

        position: absolute;
        top: -12px;
        z-index: 10;
        left: auto;
        cursor: pointer;
        right: -11px;
        display: flex;
        align-items: center;
        margin: 0 auto;
    }
    .chat-footer-icons .btn-list a:hover i {
        color: rgb(var(--primary)) !important;
    }

</style>

    <!-- INTERNAl color css -->
    <link rel="stylesheet" href="{{ asset('build/assets/plugins/colorpickr/themes/nano.min.css') }}?v=<?php echo time(); ?>">

    <!-- Select2 css -->
    <link href="{{ asset('build/assets/plugins/livechat/livechat.css') }}" rel="stylesheet" />

    <!-- INTERNAl Tag css -->
    <link href="{{ asset('build/assets/plugins/taginput/bootstrap-tagsinput.css') }}?v=<?php echo time(); ?>"
        rel="stylesheet" />
    <!-- INTERNAL Sweet-Alert css -->
    <link href="{{ asset('build/assets/plugins/sweet-alert/sweetalert.css') }}?v=<?php echo time(); ?>" rel="stylesheet" />

    <!-- INTERNAl dropzone css -->
    <link href="{{asset('build/assets/plugins/dropzone1/dropzone.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
@endsection
@section('content')
    @php
        $domainname = url('/');
    @endphp
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span
                    class="font-weight-normal text-muted ms-2">{{ lang('Livechat Appearance', 'setting') }}</span></h4>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-9">
            <form action="{{ route('livechat.appearancestore') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <h4 class="card-title">{{ lang('Livechat Appearance', 'setting') }}</h4>
                        </div>
                    </div>
                    <div class="card-body theme-colors p-0">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item">
                                <div class="row">
                                    <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12">
                                        <span class="fs-14 fw-semibold mb-0">{{ lang('Header Background Image', 'setting') }} :</span>
                                    </div>
                                    <div class="col-xl-9 col-lg-9 col-md-9 col-sm-12">
                                        <div class="d-flex align-items-center gap-4 flex-wrap">
                                            <div class="d-flex align-items-center gap-4 flex-wrap" id="image-div">
                                                <input type="hidden" id="chat_header_bg_image_selected" name="chat_header_bg_image_selected">
                                                {{-- <div class="service-card1">
                                                    <div class="form-check service-card-container mb-0 lh-1 p-1">
                                                        <input id="service-maincard1" name="service-maincard" type="radio" class="service-card form-check-input">
                                                        <i class="ti ti-check check-active d-none"></i>
                                                        <img src="{{ asset('uploads/livechatbgimages/bg1.jpg') }}" data-id="bg1.jpg" class="avatar avatar-xl" alt="img">
                                                    </div>
                                                </div>
                                                <div class="service-card1">
                                                    <div class="form-check service-card-container mb-0 lh-1 p-1">
                                                        <input id="service-maincard2" name="service-maincard" type="radio" class="service-card form-check-input">
                                                        <i class="ti ti-check check-active d-none"></i>
                                                        <img src="{{ asset('uploads/livechatbgimages/bg2.jpg') }}" data-id="bg2.jpg" class="avatar avatar-xl" alt="img">
                                                    </div>
                                                </div>
                                                <div class="service-card1">
                                                    <div class="form-check service-card-container mb-0 lh-1 p-1">
                                                        <input id="service-maincard3" name="service-maincard" type="radio" class="service-card form-check-input">
                                                        <i class="ti ti-check check-active d-none"></i>
                                                        <img src="{{ asset('uploads/livechatbgimages/bg3.jpg') }}" data-id="bg3.jpg" class="avatar avatar-xl" alt="img">
                                                    </div>
                                                </div> --}}
                                                @if(setting('chat_header_bg_image') != null)
                                                    @php
                                                        $bgimages = explode(',',setting('chat_header_bg_image'));
                                                    @endphp
                                                    @foreach($bgimages as $key => $value)
                                                        <div class="service-card1">
                                                            <div class="form-check service-card-container mb-0 lh-1 p-1">
                                                                <span class="del-btn btn btn-sm btn-icon btn-danger rounded-circle lh-sm">
                                                                    <i class="ri-delete-bin-line fs-14"></i>
                                                                </span>
                                                                <input id="service-maincard{{ $key+5 }}" name="service-maincard" type="radio" class="service-card form-check-input">
                                                                <i class="ti ti-check check-active d-none"></i>
                                                                <img src="{{ asset('uploads/livechatbgimages/'.$value) }}" data-id="{{ $value }}" class="avatar avatar-xl" alt="img">
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                @endif
                                            </div>
                                            <div class="service-card1 avatar avatar-xl">
                                                <div class="form-check service-card-container mb-0 lh-1 p-0">
                                                    <span class="upload-img bg-white"><i class="ti ti-plus text-muted"></i></span>
                                                    <div data-single="true" method="post" action="https://httpbin.org/post" class="dropzone p-0 avatar avatar-xl"  id="my-dropzone"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item">
                                <div class="row gy-3 d-sm-flex align-items-center">
                                    <div class="col-xl-3">
                                        <span class="fs-14 fw-semibold mb-0">{{ lang('Chat Icon Image', 'setting') }} :</span>
                                    </div>
                                    <div class="col-xl-9">
                                        <div class="d-flex align-items-center gap-3">
                                            <input class="form-control " type="file" id="chaticonimgfetchfromjs" name="chat_icon_bg_image" accept="image/png, image/jpeg,image/jpg">

                                            @if(setting('chat_icon_bg_image') != null)
                                                <div class="file-image-1 imageshowdiv avatar avatar-xl m-0 rounded-circle">
                                                    <img src="{{route('getImage.url', ['imagePath' =>'uploads*livechatbgimages*iconimage*'.setting('chat_icon_bg_image'),'storage_disk'=>setting('chat_icon_bg_image_storage_disk') ?? 'public'])}}" alt="{{ setting('chat_icon_bg_image') }}">
                                                    <a href="javascript:void(0);" class="btn btn-sm btn-icon btn-danger rounded-circle lh-sm delete-image" data-id="{{ setting('chat_icon_bg_image') }}"><i class="ri-delete-bin-line fs-14"></i></a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item">
                                <div class="row">
                                    <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12">
                                        <span class="fs-14 fw-semibold mb-0">{{ lang('Theme Color', 'setting') }} :</span>
                                    </div>
                                    <div class="col-xl-9 col-lg-9 col-md-9 col-sm-12">
                                        <div class="d-flex flex-wrap align-items-center switcher-style">
                                            <div class="form-check switch-select me-3">
                                                <input class="form-check-input color-input color-primary-1" type="radio" name="chat_theme_primary" id="switcher-primary" @if (setting('livechatthemecolor') == '30, 144, 255') checked="" @endif value="30, 144, 255">
                                            </div>
                                            <div class="form-check switch-select me-3">
                                                <input class="form-check-input color-input color-primary-2" type="radio" name="chat_theme_primary" id="switcher-primary1" @if (setting('livechatthemecolor') == '255, 99, 71') checked="" @endif value="255, 99, 71">
                                            </div>
                                            <div class="form-check switch-select me-3">
                                                <input class="form-check-input color-input color-primary-3" type="radio" name="chat_theme_primary" id="switcher-primary2" @if (setting('livechatthemecolor') == '67, 160, 71') checked="" @endif value="67, 160, 71">
                                            </div>
                                            <div class="form-check switch-select me-3">
                                                <input class="form-check-input color-input color-primary-4" type="radio" name="chat_theme_primary" id="switcher-primary3" @if (setting('livechatthemecolor') == '0, 172, 193') checked="" @endif value="0, 172, 193">
                                            </div>
                                            <div class="form-check switch-select me-3">
                                                <input class="form-check-input color-input color-primary-5" type="radio" name="chat_theme_primary" id="switcher-primary4" @if (setting('livechatthemecolor') == '109, 40, 217') checked="" @endif value="109, 40, 217">
                                            </div>
                                            <div class="form-check switch-select ps-0 mt-1 color-primary-light">
                                                <input type="hidden" name="chat_theme_primary" id="switcher-primary-custom">
                                                <div class="theme-container-primary"></div>
                                                <div class="pickr-container-primary"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item">
                                <div class="row gy-2 d-sm-flex align-items-center">
                                    <div class="col-xl-3">
                                        <span class="fs-14 fw-semibold mb-0">{{ lang('Chat Position', 'setting') }} <span class="text-red">*</span> :</span>
                                    </div>
                                    <div class="col-xl-9">
                                        <div class="d-flex align-items-center gap-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" value="left" name="livechatPosition" id="chat-left" @if(setting('livechatPosition') == 'left') checked="" @endif>
                                                <label class="form-check-label" for="chat-left">{{ lang('Left', 'setting') }}</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" value="right" name="livechatPosition" id="chat-right" @if(setting('livechatPosition') == 'right') checked="" @endif>
                                                <label class="form-check-label" for="chat-right">{{ lang('Right', 'setting') }}</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item">
                                <div class="row gy-3 d-sm-flex align-items-center">
                                    <div class="col-xl-3">
                                        <span class="fs-14 fw-semibold mb-0">{{ lang('Chat Icon Size', 'setting') }} <span class="text-red">*</span> :</span>
                                    </div>
                                    <div class="col-xl-9">
                                        <div class="d-flex align-items-center gap-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" value="small" name="livechatIconSize" id="size-small" @if(setting('livechatIconSize') == 'small') checked="" @endif>
                                                <label class="form-check-label" for="size-small">{{ lang('Small', 'setting') }}</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" value="large" name="livechatIconSize" id="size-large" @if(setting('livechatIconSize') == 'large') checked="" @endif>
                                                <label class="form-check-label" for="size-large">{{ lang('Large', 'setting') }}</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item">
                                <div class="row gy-2 d-sm-flex align-items-center">
                                    <div class="col-xl-3">
                                        <span class="fs-14 fw-semibold mb-0">{{ lang('Multiple Operators Title', 'setting') }} :</span>
                                        <small class="text-muted ps-2 ps-md-max-0"><i>({{lang('When there are multiple livechat operators, customers in the livechat window will see the text provided in the input field below.', 'setting')}})</i></small>
                                    </div>
                                    <div class="col-xl-6">
                                        <input type="text" class="form-control @error('LivechatCustWelcomeMsg') is-invalid @enderror" placeholder="Enter Multiple Operators Title" name="LivechatCustWelcomeMsg" value="{{ setting('LivechatCustWelcomeMsg') }}" id="LivechatCustWelcomeMsg" autocomplete="off">

                                        @error('LivechatCustWelcomeMsg')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ lang($message) }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item">
                                <div class="row gy-2 d-sm-flex align-items-center">
                                    <div class="col-xl-3">
                                        <span class="fs-14 fw-semibold mb-0">{{ lang('Icon Label Title', 'setting') }} :</span>
                                        <small class="text-muted ps-2 ps-md-max-0"><i>({{lang('Display a brief message beside the closed chat icon.', 'setting')}})</i></small>
                                    </div>
                                    <div class="col-xl-6">
                                        <input type="text" class="form-control @error('STATIC_NAME_FOR_ICON') is-invalid @enderror" placeholder="Enter Icon Label Title"
                                            name="STATIC_NAME_FOR_ICON" value="{{ setting('STATIC_NAME_FOR_ICON') }}"
                                            id="STATIC_NAME_FOR_ICON" autocomplete="off">

                                        @error('STATIC_NAME_FOR_ICON')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ lang($message) }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item">
                                <div class="row gy-2 d-sm-flex align-items-center">
                                    <div class="col-xl-3">
                                        <span class="fs-14 fw-semibold mb-0">{{ lang('Livechat Title', 'setting') }} :</span>
                                        <small class="text-muted ps-2 ps-md-max-0"><i>({{lang('This text will be shown as the livechat title', 'setting')}})</i></small>
                                    </div>
                                    <div class="col-xl-6">
                                        <input type="text" class="form-control @error('LIVECHAT_POPUP_TITLE') is-invalid @enderror" placeholder="Enter Livechat Title"
                                            name="LIVECHAT_POPUP_TITLE" value="{{ setting('LIVECHAT_POPUP_TITLE') }}"
                                            id="LIVECHAT_POPUP_TITLE" autocomplete="off">

                                        @error('LIVECHAT_POPUP_TITLE')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ lang($message) }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item">
                                <div class="row gy-2 d-sm-flex align-items-center">
                                    <div class="col-xl-3">
                                        <span class="fs-14 fw-semibold mb-0">{{ lang('Livechat Sub-Title', 'setting') }} :</span>
                                        <small class="text-muted ps-2 ps-md-max-0"><i>({{lang('This text will be shown as the livechat sub-title.', 'setting')}})</i></small>
                                    </div>
                                    <div class="col-xl-6">
                                        <input type="text" class="form-control @error('LIVECHAT_POPUP_SUB_TITLE') is-invalid @enderror" placeholder="Enter Livechat Sub-Title" name="LIVECHAT_POPUP_SUB_TITLE" value="{{ setting('LIVECHAT_POPUP_SUB_TITLE') }}" id="LIVECHAT_POPUP_SUB_TITLE" autocomplete="off">

                                        @error('LIVECHAT_POPUP_SUB_TITLE')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ lang($message) }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </li>
                            <li class="list-group-item">
                                <div class="row gy-2 d-sm-flex align-items-center">
                                    <div class="col-xl-3">
                                        <span class="fs-14 fw-semibold mb-0">{{ lang('Livechat Icon Dragable', 'setting') }} :</span>
                                        <small class="text-muted ps-2 ps-md-max-0"><i>({{lang('If you enable this switch you can draggable chaticon.', 'setting')}})</i></small>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="switch_section my-0">
                                            <div class="switch-toggle d-flex d-md-max-block mt-4 ms-0">
                                                <a class="onoffswitch2">
                                                    <input type="checkbox" name="livechat_icon_draggable" id="livechat_icon_draggable" class=" toggle-class onoffswitch2-checkbox" @if(setting('livechat_icon_draggable') == 'on') checked="" @endif>
                                                    <label for="livechat_icon_draggable" class="toggle-class onoffswitch2-label" ></label>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-12 card-footer ">
                        <div class="form-group float-end ">
                            <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-xl-3">
            <div class="card chat-appearance-content">
                <div class="card-body">
                    <div class="chat-message-popup card mb-4 chat-message-pop-default">
                        <div class="popup-head">
                            <div class="row">
                                <div class="col-7">
                                    <h4 class="mb-3">{{ setting('LIVECHAT_POPUP_TITLE') }}</h4>
                                    <span class="d-block fs-13">
                                        {{ setting('LIVECHAT_POPUP_SUB_TITLE') }}
                                    </span>
                                </div>
                                <div class="col-5">
                                    <div class="d-flex align-items-center gap-4 justify-content-end mb-4">
                                        <div class="dropdown">
                                            <a><i class="fe fe-chevron-down text-white"></i></a>
                                        </div>
                                        <div class="d-flex align-items-center gap-2">
                                            <a class="popup-minimize-normal" href="javascript:void(0);"><i class="fe fe-x text-white"></i></a>
                                            <a class="popup-minimize" href="javascript:void(0);"><i class="fe fe-x text-white"></i></a>
                                            <a class="popup-minimize-fullscreen" href="javascript:void(0);"><i class="fe fe-x text-white"></i></a>
                                        </div>
                                    </div>
                                    <div class="avatar-list avatar-list-stacked text-end">
                                        <span class="avatar avatar-sm brround" style="background-image: url('{{ asset('build/assets/images/sampleusers/10.jpg') }}')" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="David"></span>
                                        <span class="avatar avatar-sm brround" style="background-image: url('{{ asset('build/assets/images/sampleusers/1.jpg') }}')" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Amanda"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="p-2 fs-12 online-status-indicator online">
                            <span class="text-success"><i class="fa fa-circle me-2"></i></span>{{ setting('OnlineStatusMessage') }}
                        </div>
                        <div class="popup-chat-main-body">
                            <div class="popup-messages pt-0 chat-body-style">
                                <div class="direct-chat-messages">
                                </div>
                            </div>
                            <div class="popup-messages-footer border-top p-0">
                                <div class="expand-textarea p-0">
                                    <textarea class="form-control border-0" id="text-area" rows="1" placeholder=""></textarea>
                                </div>
                                <div class="chat-footer-icons d-flex align-items-center justify-content-between border-top border-block-start-dashed">
                                    <div class="btn-list">
                                        <a class="btn btn-lg border-0 rounded-circle me-0" href="javascript:void(0);">
                                            <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><path d="M0 0h24v24H0V0z" fill="none"></path><path d="M16.5 6v11.5c0 2.21-1.79 4-4 4s-4-1.79-4-4V5c0-1.38 1.12-2.5 2.5-2.5s2.5 1.12 2.5 2.5v10.5c0 .55-.45 1-1 1s-1-.45-1-1V6H10v9.5c0 1.38 1.12 2.5 2.5 2.5s2.5-1.12 2.5-2.5V5c0-2.21-1.79-4-4-4S7 2.79 7 5v12.5c0 3.04 2.46 5.5 5.5 5.5s5.5-2.46 5.5-5.5V6h-1.5z"></path></svg>
                                        </a>
                                        <a class="btn btn-lg border-0 rounded-circle me-0" href="javascript:void(0);">
                                            <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><path d="M0 0h24v24H0V0z" fill="none"></path><circle cx="15.5" cy="9.5" r="1.5"></circle><circle cx="8.5" cy="9.5" r="1.5"></circle><path d="M12 16c-1.48 0-2.75-.81-3.45-2H6.88c.8 2.05 2.79 3.5 5.12 3.5s4.32-1.45 5.12-3.5h-1.67c-.69 1.19-1.97 2-3.45 2zm-.01-14C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"></path></svg>
                                        </a>
                                        <a class="btn btn-lg border-0 rounded-circle me-0" href="javascript:void(0);">
                                            <i class="ri-mic-line fs-18"></i>
                                        </a>
                                    </div>
                                    <div>
                                        <a class="btn btn-lg btn-icon btn-primary border rounded-circle send-icon" href="javascript:void(0);">
                                            <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><path d="M0 0h24v24H0V0z" fill="none"></path><path d="M4.01 6.03l7.51 3.22-7.52-1 .01-2.22m7.5 8.72L4 17.97v-2.22l7.51-1M2.01 3L2 10l15 2-15 2 .01 7L23 12 2.01 3z"></path></svg></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="popup-end-chat-main-body">
                            <div class="p-4">
                                <div class="section-end-chat text-center chat-content">
                                    <h2 class="fw-bold">End Chat?</h2>
                                    <p>All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as
                                        necessary</p>
                                    <div class="mt-6">
                                        <a class="btn btn-primary end-chat-button px-5" href="javascript:void(0);">Conform
                                            End Chat</a>
                                    </div>
                                    <div class="mt-3">
                                        <a class="btn btn-link text-primary goback-chat btn-sm"
                                            href="javascript:void(0);"><i class="fe fe-arrow-left"></i> Go Back</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="rating-chat-main-body">
                            <div class="p-4">
                                <div class="text-start">
                                    <h5 class="fw-semibold">Thank you for Contacting Us</h5>
                                    <p class="text-muted mb-2">Please rate our supportive team in the following areas </p>
                                    <form class="mt-3">
                                        <div class="mt-0">
                                            <label class="mb-1">What is your best reason for your score</label>
                                            <div id="rater-basic" class="star-rating"
                                                style="width: 7.5rem; height: 1.0625rem; background-size: 1.0625rem;"
                                                title="1/5">
                                                <div class="star-value" style="background-size: 1.0625rem; width: 0%;">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mt-3">
                                            <label class="mb-1">What is your best reason for your score</label>
                                            <textarea class="form-control" rows="5" cols="50"></textarea>
                                        </div>
                                        <div class="d-grid">
                                            <a class="btn btn-success px-5 mt-4 btn-chat-close" href="javascript:void(0);">Submit your Review</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    @vite(['resources/assets/js/select2.js'])

    <!-- INTERNAL Sweet-Alert js-->
    <script src="{{ asset('build/assets/plugins/sweet-alert/sweetalert.min.js') }}?v=<?php echo time(); ?>"></script>

    <!-- INTERNAL TAG js-->
    <script src="{{ asset('build/assets/plugins/taginput/bootstrap-tagsinput.js') }}?v=<?php echo time(); ?>"></script>

    <!-- INTERNAL color pickr -->
    <script src="{{ asset('build/assets/plugins/colorpickr/pickr.min.js') }}?v=<?php echo time(); ?>"></script>

    <!-- INTERNAL dropzone js-->
    <script src="{{ asset('build/assets/plugins/dropzone1/dropzone-min.js') }}?v=<?php echo time(); ?>"></script>
    <script>

    document.addEventListener('DOMContentLoaded', function() {

        var mainradios = document.querySelectorAll('input[name="service-maincard"]');
        mainradios.forEach(function(radio) {
            var imagetagdata = radio.closest('.service-card-container').querySelector('img');
            var checkIcon = radio.closest('.service-card-container').querySelector('.check-active');
            if ('{{ setting('chat_header_bg_image_selected') }}' == imagetagdata.getAttribute('data-id')) {
                checkIcon.classList.remove('d-none');
                radio.closest(".service-card1").classList.add('active');
                document.querySelector('.popup-head').style.backgroundImage  = `url(${imagetagdata.src})`;
                document.querySelector('#chat_header_bg_image_selected').value  = imagetagdata.getAttribute('data-id');
            } else {
                checkIcon.classList.add('d-none');
                radio.closest(".service-card1").classList.remove('active');
            }
        });

        // Event delegation for radio buttons
        document.getElementById('image-div').addEventListener('change', function(event) {
            if (event.target.name === 'service-maincard') {
                var radios = document.querySelectorAll('input[name="service-maincard"]');
                radios.forEach(function(radio) {
                    var checkIcon = radio.parentElement.querySelector('.check-active');
                    var checkIcon2 = document.querySelector('.del-btn');
                    if (radio.checked) {
                        checkIcon.classList.remove('d-none');
                        radio.closest(".service-card1").classList.add('active');
                        var imagetagdata = event.target.closest('.service-card-container').querySelector('img');
                        document.querySelector('.popup-head').style.backgroundImage  = `url(${imagetagdata.src})`;
                        document.querySelector('#chat_header_bg_image_selected').value  = imagetagdata.getAttribute('data-id');
                    } else {
                        checkIcon.classList.add('d-none');
                        radio.closest(".service-card1").classList.remove('active');
                    }
                });
            }
        });

        document.getElementById('image-div').addEventListener('click', function(event) {
            if (event.target.closest('.del-btn')) {
                var imagetagdata = event.target.closest('.service-card-container').querySelector('img');
                if(imagetagdata){
                    let _token   = $('meta[name="csrf-token"]').attr('content');
                    swal({
                        title: `{{ lang('Are you sure you want to continue?', 'alerts') }}`,
                        text: "{{ lang('This might erase your records permanently', 'alerts') }}",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            $.ajax({
                                type: "DELETE",
                                url: `{{ route('livechat.appearanceMediadelete') }}`,
                                data: {_token: _token,imgurl: imagetagdata.src,imgname: imagetagdata.getAttribute('data-id')},
                                success: function (data) {
                                    toastr.success(data.success);
                                    let delboard = event.target.closest(".service-card1");
                                    if (delboard) {
                                        delboard.remove();
                                    }
                                },
                                error: function (data) {
                                    console.log('Error:', data);
                                }
                            });
                        }
                    });
                }
            }
        });

        if (!Dropzone.instances.some(dz => dz.element.id === "my-dropzone")) {
            $("#my-dropzone").dropzone({
                url: '{{route('livechat.appearanceMedia')}}',
                maxFiles: 1,
                addRemoveLinks: false,
                dictRemoveFile: "<span class='btn btn-sm btn-icon btn-danger rounded-circle lh-sm'><i class='ri-delete-bin-line fs-14'></i></span>",
                dictCancelUpload: "",
                headers: {
                    'X-CSRF-TOKEN': "{{ csrf_token() }}"
                },
                success: function (file, response) {

                    var $imgDiv = $('#image-div');
                    if ($imgDiv.length > 0) {
                        var $serviceCardDiv = $("<div>", { "class": "service-card1" });
                        // var deleteButtonHTML = '<span class="del-btn btn btn-sm btn-icon btn-danger rounded-circle lh-sm"><i class="ri-delete-bin-line fs-14"></i></span>';
                        // $serviceCardDiv.append(deleteButtonHTML);

                        var $formCheckDiv = $("<div>", { "class": "form-check service-card-container mb-0 lh-1 p-1" });
                        // Calculate the new ID based on the number of children in #image-div
                        var elementCount = $imgDiv.children().length + 1;
                        var uniqueId = "service-maincard" + elementCount; // Increment the ID based on child count

                        var $deleteButtonHTML = '<span class="del-btn btn btn-sm btn-icon btn-danger rounded-circle lh-sm"><i class="ri-delete-bin-line fs-14"></i></span>';

                        var $radioInput = $("<input>", {
                            id: uniqueId,
                            name: "service-maincard",
                            type: "radio",
                            "class": "service-card form-check-input"
                        });

                        var $checkIcon = $("<i>", { "class": "ti ti-check check-active d-none" });

                        var $imgElement = $("<img>", {
                            "class": "avatar avatar-xl",
                            alt: file.name
                        });

                        // Instead of using `URL.createObjectURL(file)`, get the URL from the response object
                        if (response.files) {
                            $imgElement.attr("src", response.files); // Adjust the response path to match your server
                        } else {
                            $imgElement.attr("src", URL.createObjectURL(file)); // Fallback to local file URL if response doesn't include a URL
                        }

                        $formCheckDiv.append($deleteButtonHTML).append($radioInput).append($checkIcon).append($imgElement);
                        $serviceCardDiv.append($formCheckDiv);
                        $imgDiv.append($serviceCardDiv);

                        // Ensure to remove the file after it's successfully processed
                        this.removeFile(file);
                    } else {
                        console.error('image-div element not found!');
                    }
                },
                init: function () {
                    var dropzoneInstance = this; // Save reference to Dropzone instance

                    this.on("addedfile", function (file) {

                    });
                    this.on("removedfile", function (file) {

                    });
                }
            });
        }

        // Delete icon image
        $('body').on('click', '.delete-image', function () {
            var iconId = $(this).data("id");
            swal({
                title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                text: "{{lang('This might erase your records permanently', 'alerts')}}",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            })
            .then((willDelete) => {
                if (willDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: `{{ route('livechat.appearanceicondelete') }}`,
                        success: function (data) {
                            toastr.success(data.success);
                            $('.imageshowdiv').hide();
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });
        });

    });
    </script>

    <script type="text/javascript">
    "use strict";

       //switcher color pickers
        const pickrContainerPrimary = document.querySelector(
        ".pickr-container-primary"
        );
        const themeContainerPrimary = document.querySelector(
        ".theme-container-primary"
        );
        /* for theme primary */
        const nanoThemes = [
        [
            "nano",
            {
            defaultRepresentation: "RGB",
            components: {
                preview: true,
                opacity: false,
                hue: true,

                interaction: {
                hex: false,
                rgba: true,
                hsva: false,
                input: true,
                clear: false,
                save: false,
                },
            },
            },
        ],
        ];
        const nanoButtons = [];
        let nanoPickr = null;
        for (const [theme, config] of nanoThemes) {
        const button = document.createElement("button");
        button.innerHTML = theme;
        button.type = "button";
        nanoButtons.push(button);

        button.addEventListener("click", () => {
            const el = document.createElement("p");
            pickrContainerPrimary.appendChild(el);

            /* Delete previous instance */
            if (nanoPickr) {
            nanoPickr.destroyAndRemove();
            }



            /* Apply active class */
            for (const btn of nanoButtons) {
            btn.classList[btn === button ? "add" : "remove"]("active");
            }

            let themecolor = '{{ setting('livechatthemecolor') }}';
            let splittedcolor = themecolor.split(', ');
            let rgbvalue = null;
            if (splittedcolor.length !== 3) {
                rgbvalue = "rgb('51 ,102 ,255')";
            }else{
                rgbvalue = `rgb(${splittedcolor[0]}, ${splittedcolor[1]}, ${splittedcolor[2]})`;
            }
            /* Create fresh instance */
            nanoPickr = new Pickr(
                Object.assign(
                    {
                        el,
                        theme,
                        default: rgbvalue,
                    },
                    config
                )
            );

            let initialColor = rgbvalue.match(/\d+/g);
            let html = document.querySelector(".chat-message-popup");
            html.style.setProperty("--primary", `${initialColor[0]}, ${initialColor[1]}, ${initialColor[2]}`);

            /* Set events */
            nanoPickr.on("changestop", (source, instance) => {
                let color = instance.getColor().toRGBA();
                let html = document.querySelector(".chat-message-popup");
                document.querySelector("#switcher-primary-custom").value = `${Math.floor(color[0])}, ${Math.floor(color[1])}, ${Math.floor(color[2])}`;
                html.style.setProperty("--primary", `${Math.floor(color[0])}, ${Math.floor(color[1])}, ${Math.floor(color[2])}`);
                /* theme color picker */
                localStorage.setItem("primary", `${Math.floor(color[0])}, ${Math.floor(color[1])}, ${Math.floor(color[2])}`);
            });
        });

        themeContainerPrimary.appendChild(button);
        }
        nanoButtons[0].click();
        /* for theme primary */

        switcherClick()
        function switcherClick() {
            let
                primaryDefaultColor1Btn,
                primaryDefaultColor2Btn,
                primaryDefaultColor3Btn,
                primaryDefaultColor4Btn,
                primaryDefaultColor5Btn;
            let html = document.querySelector(".chat-message-popup");
            primaryDefaultColor1Btn = document.querySelector("#switcher-primary");
            primaryDefaultColor2Btn = document.querySelector("#switcher-primary1");
            primaryDefaultColor3Btn = document.querySelector("#switcher-primary2");
            primaryDefaultColor4Btn = document.querySelector("#switcher-primary3");
            primaryDefaultColor5Btn = document.querySelector("#switcher-primary4");

            // primary theme
            let primaryColor1Var = primaryDefaultColor1Btn.addEventListener(
                "click",
                () => {
                localStorage.setItem("primary", "30, 144, 255");
                html.style.setProperty("--primary", `30, 144, 255`);
                }
            );
            let primaryColor2Var = primaryDefaultColor2Btn.addEventListener(
                "click",
                () => {
                localStorage.setItem("primary", "255, 99, 71");
                html.style.setProperty("--primary", `255, 99, 71`);
                }
            );
            let primaryColor3Var = primaryDefaultColor3Btn.addEventListener(
                "click",
                () => {
                localStorage.setItem("primary", "67, 160, 71");
                html.style.setProperty("--primary", `67, 160, 71`);
                }
            );
            let primaryColor4Var = primaryDefaultColor4Btn.addEventListener(
                "click",
                () => {
                localStorage.setItem("primary", "0, 172, 193");
                html.style.setProperty("--primary", `0, 172, 193`);
                }
            );
            let primaryColor5Var = primaryDefaultColor5Btn.addEventListener(
                "click",
                () => {
                localStorage.setItem("primary", "109, 40, 217");
                html.style.setProperty("--primary", `109, 40, 217`);
                }
            );

        }

        document.querySelectorAll('.form-check-input.color-input').forEach( (ele) =>{
            ele.onclick = () =>{
                document.getElementById('switcher-primary-custom').value = ele.value;
            }
        })
        /* for theme primary */
    </script>
@endsection
