@extends('layouts.adminmaster')

@section('content')

    <!--Page header-->
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{ lang('Integrations', 'menu') }}</span></h4>
        </div>
    </div>
    <!--End Page header-->


    <div class="row">
        {{-- whatsapp start --}}
        <div class="col-xl-6">
            <div class="card custom-card">
                <form action="{{ route('whatsapp.setting.store') }}" method="post" autocomplete="off">
                    @csrf
                    <div class="card-header border-0">
                        <div class="card-title flex-grow-1">
                            {{ lang('WhatsApp') }}
                        </div>
                        {{-- <div class="form-check form-switch form-check">
                            <input class="form-check-input" id="enableWhatsapp" name="enableWhatsapp" value="on" type="checkbox" @if (setting('enableWhatsapp') == 'on') checked="" @endif>
                            <label class="form-check-label" for="enableWhatsapp">{{ lang('Enable Whatsapp', 'setting') }}</label>
                        </div> --}}
                        <div class="form-group mb-0 d-flex ms-auto">
                            <div class="switch_section my-0">
                                <div class="switch-toggle d-flex m-0">
                                    <a class="onoffswitch2">
                                        <label class="custom-switch m-0">
                                            <input type="checkbox" name="enableWhatsapp" @if (setting('enableWhatsapp') == 'on') checked="" @endif class="custom-switch-input">
                                            <span class="custom-switch-indicator"></span>
                                        </label>
                                    </a>

                                    <div class="ps-3">
                                        <label class="form-label">{{ lang('Enable WhatsApp', 'setting') }}</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('WhatsApp Phone Number Used For Registration') }} <span class="text-danger">*</span></label>
                                <input name="whatsappNumber" type="text" class="form-control {{ $errors->has('whatsappNumber') ? ' is-invalid' : '' }}" placeholder="{{ lang('Mobile Number with Country Code and without +. Eg: 919876543210') }}" value="{{ old('whatsappNumber', setting('whatsappNumber')) }}">
                                @if ($errors->has('whatsappNumber'))
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $errors->first('whatsappNumber') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('Graph API Version') }} <span class="text-danger">*</span></label>
                                <input name="whatsAppGraphAPIVersion" type="text" class="form-control {{ $errors->has('whatsAppGraphAPIVersion') ? ' is-invalid' : '' }}" placeholder="{{ lang('v21.0') }}" value="{{ old('whatsAppGraphAPIVersion', setting('whatsAppGraphAPIVersion')) }}">
                                @if ($errors->has('whatsAppGraphAPIVersion'))
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $errors->first('whatsAppGraphAPIVersion') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('Permanent Access Token') }} <span class="text-danger">*</span></label>
                                <input name="whatsappToken" type="text" class="form-control {{ $errors->has('whatsappToken') ? ' is-invalid' : '' }}" placeholder="{{ lang('Permanent Access Token') }}" value="{{ old('whatsappToken', setting('whatsappToken')) }}">
                                @if ($errors->has('whatsappToken'))
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $errors->first('whatsappToken') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('WhatsApp Phone Number ID') }} <span class="text-danger">*</span></label>
                                <input name="whatsPhoneNumberId" type="text" class="form-control {{ $errors->has('whatsPhoneNumberId') ? ' is-invalid' : '' }}" placeholder="{{ lang('WhatsApp Phone Number ID') }}" value="{{ old('whatsPhoneNumberId', setting('whatsPhoneNumberId')) }}">
                                @if ($errors->has('whatsPhoneNumberId'))
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $errors->first('whatsPhoneNumberId') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('WhatsApp Business Account ID') }} <span class="text-danger">*</span></label>
                                <input name="businessAccId" type="text" class="form-control {{ $errors->has('businessAccId') ? ' is-invalid' : '' }}" placeholder="{{ lang('WhatsApp Business Account ID') }}" value="{{ old('businessAccId', setting('businessAccId')) }}">
                                @if ($errors->has('businessAccId'))
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $errors->first('businessAccId') }}</strong>
                                    </span>
                                @endif

                            </div>
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('WhatsApp Webhook Verify token') }} <span class="text-danger">*</span></label>
                                <input name="whatsappVerifyToken" type="text" class="form-control {{ $errors->has('whatsappVerifyToken') ? ' is-invalid' : '' }}" placeholder="{{ lang('WhatsApp Webhook Verify token') }}" value="{{ old('whatsappVerifyToken', setting('whatsappVerifyToken')) }}">
                                @if ($errors->has('whatsappVerifyToken'))
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $errors->first('whatsappVerifyToken') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('Callback Url For Webhook') }} <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" placeholder="{{ lang('Callback Url For Webhook') }}" value="{{ url('/api/webhook') }}" disabled readonly>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="float-end mb-3">
                            <button type="submit" class="btn btn-primary" onclick="this.disabled=true;this.innerHTML=`{{ lang('Sending') }} ... <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{ lang('Submit') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        {{-- whatsapp end --}}
        {{-- instagram start --}}
        <div class="col-xl-6">
            <div class="card custom-card">
                <form action="{{ route('instagram.setting.store') }}" method="post" autocomplete="off">
                    @csrf
                    <div class="card-header border-0">
                        <div class="card-title flex-grow-1">
                            {{ lang('Instagram') }}
                        </div>
                        {{-- <div class="form-check form-switch form-check">
                            <input class="form-check-input" id="enableInstagram" name="enableInstagram" value="on" type="checkbox" @if (setting('enableInstagram') == 'on') checked="" @endif>
                            <label class="form-check-label" for="enableInstagram">{{ lang('Enable Instagram', 'setting') }}</label>
                        </div> --}}
                        <div class="form-group mb-0 d-flex ms-auto">
                            <div class="switch_section my-0">
                                <div class="switch-toggle d-flex m-0">
                                    <a class="onoffswitch2">
                                        <label class="custom-switch m-0">
                                            <input type="checkbox" name="enableInstagram" @if (setting('enableInstagram') == 'on') checked="" @endif class="custom-switch-input">
                                            <span class="custom-switch-indicator"></span>
                                        </label>
                                    </a>
                                    <div class="ps-3">
                                        <label class="form-label">{{ lang('Enable Instagram', 'setting') }}</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('Instagram Account ID') }} <span class="text-danger">*</span></label>
                                <input name="instagramAccountId" type="text" class="form-control {{ $errors->has('instagramAccountId') ? ' is-invalid' : '' }}" placeholder="{{ lang('Instagram Account ID') }}" value="{{ old('instagramAccountId', setting('instagramAccountId')) }}">
                                @if ($errors->has('instagramAccountId'))
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $errors->first('instagramAccountId') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('Instagram Account Username') }} <span class="text-danger">*</span></label>
                                <input name="instagramUsername" type="text" class="form-control {{ $errors->has('instagramUsername') ? ' is-invalid' : '' }}" placeholder="{{ lang('Instagram Account Username') }}" value="{{ old('instagramUsername', setting('instagramUsername')) }}">
                                @if ($errors->has('instagramUsername'))
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $errors->first('instagramUsername') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('Instagram Permanent Access Token') }} <span class="text-danger">*</span></label>
                                <input name="InstagramAccessToken" type="text" class="form-control {{ $errors->has('InstagramAccessToken') ? ' is-invalid' : '' }}" placeholder="{{ lang('Instagram Permanent Access Token') }}" value="{{ old('InstagramAccessToken', setting('InstagramAccessToken')) }}">
                                @if ($errors->has('InstagramAccessToken'))
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $errors->first('InstagramAccessToken') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('Facebook Page Access Token') }} <span class="text-danger">*</span></label>
                                <input name="fbPageAccessToken" type="text" class="form-control {{ $errors->has('fbPageAccessToken') ? ' is-invalid' : '' }}" placeholder="{{ lang('fbPage Permanent Access Token') }}" value="{{ old('fbPageAccessToken', setting('fbPageAccessToken')) }}">
                                @if ($errors->has('fbPageAccessToken'))
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $errors->first('fbPageAccessToken') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('Graph API Version') }} <span class="text-danger">*</span></label>
                                <input name="instagramGraphAPIVersion" type="text" class="form-control {{ $errors->has('instagramGraphAPIVersion') ? ' is-invalid' : '' }}" placeholder="{{ lang('v21.0') }}" value="{{ old('instagramGraphAPIVersion', setting('instagramGraphAPIVersion')) }}">
                                @if ($errors->has('instagramGraphAPIVersion'))
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $errors->first('instagramGraphAPIVersion') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('Instagram Webhook Verify token') }} <span class="text-danger">*</span></label>
                                <input name="InstagramVerifyToken" type="text" class="form-control {{ $errors->has('InstagramVerifyToken') ? ' is-invalid' : '' }}" placeholder="{{ lang('Instagram Webhook Verify token') }}" value="{{ old('InstagramVerifyToken', setting('InstagramVerifyToken')) }}">
                                @if ($errors->has('InstagramVerifyToken'))
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $errors->first('InstagramVerifyToken') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('Instagram Callback Url For Webhook') }} <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" placeholder="{{ lang('Instagram Callback Url For Webhook') }}" value="{{ url('/api/instagram-webhook') }}" disabled readonly>
                            </div>
                            {{-- <div class="col-xl-12">
                                <label class="form-label">{{ lang('Instagram Deauthorize Url For Webhook') }} <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" placeholder="{{ lang('Instagram Callback Url For Webhook') }}" value="{{ url('/api/instagram-deauthorize') }}" disabled readonly>
                            </div>
                            <div class="col-xl-12">
                                <label class="form-label">{{ lang('Instagram Deletion Url For Webhook') }} <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" placeholder="{{ lang('Instagram Callback Url For Webhook') }}" value="{{ url('/api/instagram-deletionurl') }}" disabled readonly>
                            </div> --}}
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="float-end mb-3">
                            <button type="submit" class="btn btn-primary" onclick="this.disabled=true;this.innerHTML=`{{ lang('Sending') }} ... <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{ lang('Submit') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        {{-- instagram end --}}
        {{-- <div class="col-xl-6">
            <div class="card custom-card">
                <form action="{{ route('settings.paypal.store') }}" method="post" autocomplete="off">
                    @csrf
                    <div class="card-header">
                        <div class="card-title flex-grow-1">
                            {{ lang('Paypal Settings') }}
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" role="switch" id="paypal" name="enablePaypal" @if(setting('enablePaypal') == 'on') checked @endif>
                            <label class="form-check-label" for="paypal">{{ lang('Paypal Settings') }}</label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <div class="col-xl-12">
                                <label for="paypal-id" class="form-label">{{ lang('Paypal Key') }}</label>
                                <input name="paypalKey" type="text" class="form-control @error('paypalKey') is-invalid @enderror" id="paypal-id" placeholder="{{ lang('Paypal Settings') }}" value="{{ setting('paypalKey') }}">
                            </div>
                            @error('paypalKey')
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ lang($message) }}</strong>
                                </span>
                            @enderror
                            <div class="col-xl-12">
                                <label for="paypal-secret" class="form-label">{{ lang('Paypal Secret') }}</label>
                                <input name="paypalSecret" type="text" class="form-control @error('paypalSecret') is-invalid @enderror" id="paypal-secret" placeholder="{{ lang('Paypal Settings') }}" value="{{ setting('paypalSecret') }}">
                            </div>
                            @error('paypalSecret')
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ lang($message) }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="float-end mb-3">
                            <button class="btn btn-primary" onclick="this.disabled=true;this.innerHTML=`Loading.. <i class='ri-loader-line'></i>`;this.form.submit();">{{ lang('Submit') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div> --}}
    </div>
@endsection
