@extends('layouts.adminmaster')

@section('styles')

    <!-- INTERNAL Data table css -->
    <link href="{{asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
    <link href="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

    <!-- INTERNAL Sweet-Alert css -->
    <link href="{{asset('build/assets/plugins/sweet-alert/sweetalert.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

    <style>
        #hideAfterloading {
            position: absolute;
            top: 100px;
            left: 45%;
        }
    </style>

@endsection

@section('content')

    <!--Page header-->
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Language List')}}</span></h4>
        </div>
    </div>
    <!--End Page header-->


    <div class="col-xl-12 col-lg-12 col-md-12">
        <div class="card">
            <div class="card-header border-0">
                <h4 class="card-title">{{lang('Language List')}}</h4>
                <div class="card-options">
                    @can('Languages Create')
                    <a href="{{route('admin.languages.create')}}" class="btn btn-secondary mt-sm-0 mt-2 me-3" >
                        <i class="feather feather-plus"></i> {{lang('Add Languages')}}
                    </a>
                    @endcan
                </div>
            </div>
            <div class="card-body" style="min-height: 250px;">
                <div class="table-responsive spruko-delete">
                    <table id="support-articlelists" class="table table-bordered border-bottom text-nowrap ticketdeleterow w-100">
                        <thead>
                            <tr>
                                <th class="tb-w-3x">{{ lang('Sl.No') }}</th>
                                <th class="tb-w-10x">{{ lang('Language Name') }}</th>
                                <th class="tb-w-3x">{{ lang('Language Code') }}</th>
                                <th class="tb-w-3x">{{ lang('Translation status') }}</th>
                                <th class="tb-w-7x">{{ lang('Create date') }}</th>
                                <th class="tb-w-7x">{{ lang('Actions') }}</th>
                            </tr>
                        </thead>
                        <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                            <p>{{lang('loading.. Please Wait')}}</p>
                        </div>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')

		<!-- INTERNAL Vertical-scroll js-->
		<script src="{{asset('build/assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js')}}?v=<?php echo time(); ?>"></script>

		<!-- INTERNAL Data tables -->
		<script src="{{asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/dataTables.responsive.min.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/datatablebutton.min.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/buttonbootstrap.min.js')}}?v=<?php echo time(); ?>"></script>

		<!-- INTERNAL Index js-->
        @vite(['resources/assets/js/support/support-sidemenu.js'])

		<!-- INTERNAL Sweet-Alert js-->
		<script src="{{asset('build/assets/plugins/sweet-alert/sweetalert.min.js')}}?v=<?php echo time(); ?>"></script>

        <script type="text/javascript">
            "use strict";

            document.addEventListener("DOMContentLoaded", (event) => {

                let tableData = @json($languages);

                let dateFormat = @json(setting('date_format'));
                let delPerm = @json(Auth::user()->can('Languages Delete'));
                let editPerm = @json(Auth::user()->can('Languages Edit'));
                let translatePerm = @json(Auth::user()->can('Languages Translate'));

                var dataTable;
                var tableDropDown;

                loadTable(tableData);

                function truncateTitle(title) {
                    const maxLength = 40;
                    return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
                }

                function dateTime(createdTime) {

                    const jsDate = new Date(createdTime);

                    let format = @json(setting('date_format'));
                    switch (format) {
                        case 'd M, Y':
                            return jsDate.toLocaleDateString('en-GB', {
                                day: '2-digit',
                                month: 'short',
                                year: 'numeric'
                            });
                        case 'm.d.y':
                            return jsDate.toLocaleDateString('en-US', {
                                day: '2-digit',
                                month: '2-digit',
                                year: '2-digit'
                            }).replace(/\//g, '.');
                        case 'Y-m-d':
                            return jsDate.toISOString().split('T')[0];
                        case 'd-m-Y':
                            return jsDate.toLocaleDateString('en-GB').replace(/\//g, '-');
                        case 'd/m/Y':
                            return jsDate.toLocaleDateString('en-GB');
                        case 'Y/m/d':
                            return jsDate.toISOString().split('T')[0].replace(/-/g, '/');
                        default:
                            return jsDate.toLocaleDateString(); // Default format
                    }

                }

                function loadTable(tableData) {
                    document.getElementById('hideAfterloading')?.classList.remove('d-none');
                    document.getElementById('theadShow')?.classList.add('d-none');
                    if (tableDropDown)
                        tableDropDown.destroy();

                    if (dataTable)
                        dataTable.destroy();

                    if (document.getElementById('tableBody'))
                        document.getElementById('tableBody').remove();

                    let createTbody = document.createElement('tbody');
                    createTbody.setAttribute('id', "tableBody");
                    let rows = tableData.map((data, index) => {
                        var trnaslateRouteUrl = "{{ route('admin.languages.translate', ['code' => ':id']) }}".replace(':id', data.languagecode);
                        var editRouteUrl = "{{ route('admin.languages.edit', ['id' => ':id']) }}".replace(':id', data.id);

                        return `
                            <tr>
                                <td>${index + 1}</td>

                                <td>
                                    ${data.languagename+' - '+data.languagenativename} ${'{{ setting('default_lang') }}' == data.languagecode ? "({{ lang('Default') }})" : ''}
                                </td>

                                <td><a href="${trnaslateRouteUrl}">${data.languagecode}</a></td>

                                <td>
                                    ${data.translates_count != 0 ?
                                        `<span class="badge bg-yellow text-dark">${data.translates_count} {{ lang('Translations are missing') }}</span>`
                                        :
                                        `<span class="badge bg-success">{{ lang('Translate are completed') }}</span>`
                                    }
                                </td>

                                <td>${dateTime(data.created_at)}</td>

                                <td>
                                    <div class = "d-flex">
                                        ${editPerm ? `<a href="${editRouteUrl}"  class="action-btns1"><i class="feather feather-edit text-primary" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Edit')}}"></i></a>` : ''}

                                        ${translatePerm ? `<a href="${trnaslateRouteUrl}"  class="action-btns1"><i class="feather feather-repeat text-primary" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Translate')}}"></i></a>` : ''}

                                        ${delPerm && "{{ setting('default_lang') }}" != data.languagecode ? `<a href="javascript:void(0)" data-id="${data.id}" class="action-btns1" id="delete-language" ><i class="feather feather-trash-2 text-danger" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Delete')}}"></i></a>` : ''}
                                    </div>

                                </td>

                            </tr>
                        `;
                    });

                    if (tableData.length == 0)
                        createTbody.innerHTML = ` `;
                    else
                        createTbody.innerHTML = rows.join('');


                    // Append the tbody to your table
                    // Replace 'your-table-id' with the actual ID of your table element
                    document.getElementById('support-articlelists').appendChild(createTbody);

                    document.getElementById('hideAfterloading')?.classList.add('d-none');
                    document.getElementById('theadShow')?.classList.remove('d-none');

                    $(document).ready(function() {

                        var SITEURL = '{{ url('') }}';

                        // Csrf field
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });

                        let prev = {!! json_encode(lang("Previous")) !!};
                        let next = {!! json_encode(lang("Next")) !!};
                        let nodata = {!! json_encode(lang("No data available in table")) !!};
                        let noentries = {!! json_encode(lang("No entries to show")) !!};
                        let showing = {!! json_encode(lang("showing page")) !!};
                        let ofval = {!! json_encode(lang("of")) !!};
                        let maxRecordfilter = {!! json_encode(lang("- filtered from ")) !!};
                        let maxRecords = {!! json_encode(lang("records")) !!};
                        let entries = {!! json_encode(lang("entries")) !!};
                        let show = {!! json_encode(lang("Show")) !!};
                        let search = {!! json_encode(lang("Search")) !!};
                        // Datatable
                        $('#support-articlelists').dataTable({
                            language: {
                                searchPlaceholder: search,
                                scrollX: "100%",
                                sSearch: '',
                                paginate: {
                                previous: prev,
                                next: next
                                },
                                emptyTable : nodata,
                                infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                                info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                                infoEmpty: noentries,
                                lengthMenu: `${show} _MENU_ ${entries} `,
                            },
                            order:[],
                            columnDefs: [
                                { "orderable": false, "targets":[ 0,1,4] }
                            ],
                        });

                        $('.form-select').select2({
                            minimumResultsForSearch: Infinity,
                            width: '100%'
                        });

                        $('.form-select').on('focus', function() {
                            $(this).attr('aria-hidden', 'false');
                        });
                    });


                    initializeTooltips();

                    function initializeTooltips() {
                        var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                        tooltipElements.forEach(function(element) {
                            new bootstrap.Tooltip(element);
                        });
                    }


                }

                $(function() {

                    (function($)  {

                        // Variables
                        var SITEURL = '{{url('')}}';

                    });

                    // Variables
                    var SITEURL = '{{url('')}}';

                    // Delete Language
                    $('body').on('click', '#delete-language', function () {
                        let parent = $(this).closest('tr');
                        var _id = $(this).data("id");
                        swal({
                            title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                            text: "{{lang('This might erase your records permanently', 'alerts')}}",
                            icon: "warning",
                            buttons: true,
                            dangerMode: true,
                        })
                        .then((willDelete) => {
                            if (willDelete) {
                                $.ajax({
                                    type: "post",
                                    url: SITEURL + "/admin/languages/destroy/"+_id,
                                    success: function (data) {
                                        toastr.success(data.success);
                                        $(parent[0]).addClass('fade-out');
                                        let newData = tableData.filter(item => item.id != parseInt(_id));
                                        tableData = newData;
                                        setTimeout(() => {
                                            parent[0].remove();
                                            if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                                $('#support-articlelists').DataTable().clear().destroy();
                                            }
                                            loadTable(tableData);
                                        }, 1500);
                                    },
                                    error: function (data) {
                                        console.log('Error:', data);
                                    }
                                });
                            }
                        });
                    });
                })
            });

        </script>

@endsection
