@extends('layouts.adminmaster')

@section('styles')
    <!-- INTERNAl Summernote css -->
    <link rel="stylesheet" href="{{ asset('build/assets/plugins/summernote/summernote.css') }}?v=<?php echo time(); ?>">

    <!-- INTERNAl color css -->
    <link rel="stylesheet" href="{{ asset('build/assets/plugins/colorpickr/themes/nano.min.css') }}?v=<?php echo time(); ?>">

    <!-- INTERNAL Sweet-Alert css -->
    <link href="{{ asset('build/assets/plugins/sweet-alert/sweetalert.css') }}?v=<?php echo time(); ?>" rel="stylesheet" />
@endsection

@section('content')


    <!--Page header-->
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span
                    class="font-weight-normal text-muted ms-2">{{ lang('General Setting', 'menu') }}</span></h4>
        </div>
    </div>
    <!--End Page header-->

    <div class="row">
        <!-- Cron command -->
        <div class="col-xl-12 col-lg-12 col-md-12">
            <div class="card ">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ lang('Cron Job Setup Command', 'setting') }}</h4>
                </div>
                <div class="card-body pt-0">
                    <label><small><i>({{ $croncommanddata == 'php artisan schedule:work' ? lang('Copy the provided command, paste this command in your terminal and enter, it will automatically run the commands.') : lang('Copy the provided command, log in to your cPanel server, look for "Cron Jobs," and click on it. You will see "Common Settings" selection dropdown then you select "Once Per Minute(* * * * *)" and also you see an input field for entering commands; paste the command there and click on Add New Cron Job.') }})</i></small></label>
                    <div class="form-group mb-0">
                        <div class="input-group">
                            <input type="text" class="form-control cronCommandLink" name="cronjobcommand" readonly id="cronjobcommand" value="{{ $croncommanddata }}" autocomplete="off">
                            <button class="btn btn-primary p-2 cronCommandLinkCopyBtn">
                                <i class="fa fa-clone" data-bs-toggle="tooltip" title="" data-bs-original-title="{{ lang('Copy') }}" aria-label="fa fa-clone"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Cron command -->

        <!-- App Title & Logos -->
        <div class="col-xl-12 col-lg-12 col-md-12">
            <div class="card ">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ lang('App Title & Logos', 'setting') }}</h4>
                </div>
                <form method="POST" action="{{ url('/admin/general') }}" enctype="multipart/form-data">
                    <div class="card-body">
                        @csrf

                        @honeypot
                        <input type="hidden" class="form-control" name="id" Value="{{ $basic->id }}">
                        <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <div class="form-group">
                                    <label class="form-label">{{ lang('Title') }} <span class="text-red">*</span></label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror"
                                        name="title" Value="{{ $basic->title }}">
                                    @error('title')
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong>{{ lang($message) }}</strong>
                                        </span>
                                    @enderror

                                </div>
                            </div>

                            <div class="col-xl-4 col-sm-12 col-lg-12">
                                <div class="spfileupload">
                                    <div class="row">
                                        <div class="col-xl-7 col-lg-9 col-md-8 col-sm-9">
                                            <div class="form-group">
                                                <div class="@error('image') is-invalid @enderror ">
                                                    <label
                                                        class="form-label fs-16">{{ lang('Upload Light-Logo', 'setting') }}</label>
                                                    <div class="input-group file-browser">
                                                        <input class="form-control " name="image" type="file">

                                                    </div>
                                                    <small
                                                        class="text-muted"><i>{{ lang('The file size should not be more than 5MB', 'filesetting') }}</i></small>
                                                </div>
                                                @error('image')
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong>{{ lang($message) }}</strong>
                                                    </span>
                                                @enderror

                                            </div>
                                        </div>
                                        <div class="col-xl-5 col-lg-3 col-md-4 col-sm-3">
                                            <div class="file-image-1 ms-sm-auto sprukologoss ms-sm-auto">
                                                <div class="product-image sprukologoimages">
                                                    @if ($title->image == null)
                                                        <img src="{{ asset('uploads/logo/logo/logo-white.png') }}"
                                                            class="br-5" alt="logo">
                                                    @else
                                                        <button
                                                            class="btn ticketnotedelete text-gray logosdelete"
                                                            value="logo1" data-id="{{ $title->id }}">
                                                            <i class="feather feather-x"></i>
                                                        </button>
                                                        <img src="{{ route('getImage.url', ['imagePath' => 'uploads*logo*logo*'.$title->image, 'storage_disk' => $title->image_storage_disk ?? 'public']) }}" class="br-5" alt="">
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-sm-12 col-lg-12">
                                <div class="spfileupload">
                                    <div class="row">
                                        <div class="col-xl-7 col-lg-9 col-md-8 col-sm-9">
                                            <div class="form-group">
                                                <div class="@error('image1') is-invalid @enderror">
                                                    <label
                                                        class="form-label fs-16">{{ lang('Upload Dark-Logo', 'setting') }}</label>
                                                    <div class="input-group file-browser">
                                                        <input class="form-control " name="image1" type="file">
                                                    </div>
                                                    <small
                                                        class="text-muted"><i>{{ lang('The file size should not be more than 5MB', 'filesetting') }}</i></small>
                                                </div>
                                                @error('image1')
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong>{{ lang($message) }}</strong>
                                                    </span>
                                                @enderror

                                            </div>
                                        </div>
                                        <div class="col-xl-5 col-lg-3 col-md-4 col-sm-3">
                                            <div class="file-image-1 ms-sm-auto">
                                                <div class="product-image sprukologoimages">
                                                    @if ($title->image1 == null)
                                                        <img src="{{ asset('uploads/logo/darklogo/logo.png') }}"
                                                            class="br-5" alt="logo">
                                                    @else
                                                        <button
                                                            class="btn ticketnotedelete text-gray logosdelete"
                                                            value="logo2" data-id="{{ $title->id }}">
                                                            <i class="feather feather-x"></i>
                                                        </button>
                                                        <img src="{{ route('getImage.url', ['imagePath' => 'uploads*logo*darklogo*'.$title->image1, 'storage_disk' => $title->image1_storage_disk ?? 'public']) }}"
                                                            class="br-5" alt="">
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-sm-12 col-lg-12">
                                <div class="spfileupload">
                                    <div class="row">
                                        <div class="col-xl-7 col-lg-9 col-md-8 col-sm-9">
                                            <div class="form-group">
                                                <div class="@error('image2') is-invalid @enderror">
                                                    <label
                                                        class="form-label fs-16">{{ lang('Upload Dark-Icon', 'setting') }}</label>
                                                    <div class="input-group file-browser">
                                                        <input class="form-control " name="image2" type="file">
                                                    </div>
                                                    <small
                                                        class="text-muted"><i>{{ lang('The file size should not be more than 5MB', 'filesetting') }}</i></small>
                                                </div>
                                                @error('image2')
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong>{{ lang($message) }}</strong>
                                                    </span>
                                                @enderror

                                            </div>
                                        </div>
                                        <div class="col-xl-5 col-lg-3 col-md-4 col-sm-3">
                                            <div class="file-image-1 ms-sm-auto">
                                                <div class="product-image sprukologoimages">
                                                    @if ($title->image2 == null)
                                                        <img src="{{ asset('uploads/logo/icon/icon.png') }}"
                                                            class="br-5" alt="logo">
                                                    @else
                                                        <button
                                                            class="btn ticketnotedelete text-gray logosdelete"
                                                            value="logo3" data-id="{{ $title->id }}">
                                                            <i class="feather feather-x"></i>
                                                        </button>
                                                        <img src="{{ route('getImage.url', ['imagePath' => 'uploads*logo*icon*'.$title->image2, 'storage_disk' => $title->image2_storage_disk ?? 'public']) }}"
                                                            class="br-5" alt="">
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-sm-12 col-lg-12">
                                <div class="spfileupload">
                                    <div class="row">
                                        <div class="col-xl-7 col-lg-9 col-md-8 col-sm-9">
                                            <div class="form-group">
                                                <div class="@error('image3') is-invalid @enderror">
                                                    <label
                                                        class="form-label fs-16">{{ lang('Upload Light-Icon', 'setting') }}</label>
                                                    <div class="input-group file-browser">
                                                        <input class="form-control " name="image3" type="file">
                                                    </div>
                                                    <small
                                                        class="text-muted"><i>{{ lang('The file size should not be more than 5MB', 'filesetting') }}</i></small>
                                                </div>
                                                @error('image3')
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong>{{ lang($message) }}</strong>
                                                    </span>
                                                @enderror

                                            </div>
                                        </div>
                                        <div class="col-xl-5 col-lg-3 col-md-4 col-sm-3">
                                            <div class="file-image-1 ms-sm-auto">
                                                <div class="product-image sprukologoimages">
                                                    @if ($title->image3 == null)
                                                        <img src="{{ asset('uploads/logo/darkicon/icon-white.png') }}"
                                                            class="br-5" alt="logo">
                                                    @else
                                                        <button
                                                            class="btn ticketnotedelete text-gray logosdelete"
                                                            value="logo4" data-id="{{ $title->id }}">
                                                            <i class="feather feather-x"></i>
                                                        </button>
                                                        <img src="{{ route('getImage.url', ['imagePath' => 'uploads*logo*darkicon*'.$title->image3, 'storage_disk' => $title->image3_storage_disk ?? 'public']) }}"
                                                            class="br-5" alt="">
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-sm-12 col-lg-12">
                                <div class="spfileupload">
                                    <div class="row">
                                        <div class="col-xl-7 col-lg-9 col-md-8 col-sm-9">
                                            <div class="form-group">
                                                <div class="@error('image4') is-invalid @enderror">
                                                    <label
                                                        class="form-label fs-16">{{ lang('Upload Favicon', 'setting') }}</label>
                                                    <div class="input-group file-browser">
                                                        <input class="form-control " name="image4" type="file">
                                                    </div>
                                                    <small
                                                        class="text-muted"><i>{{ lang('The file size should not be more than 5MB', 'filesetting') }}</i></small>
                                                </div>
                                                @error('image4')
                                                    <span class="invalid-feedback d-block" role="alert">
                                                        <strong>{{ lang($message) }}</strong>
                                                    </span>
                                                @enderror

                                            </div>
                                        </div>
                                        <div class="col-xl-5 col-lg-3 col-md-4 col-sm-3">
                                            <div class="file-image-1 ms-sm-auto">
                                                <div class="product-image sprukologoimages">
                                                    @if ($title->image4 == null)
                                                        <img src="{{ asset('uploads/logo/favicons/favicon.ico') }}"
                                                            class="br-5" alt="logo">
                                                    @else
                                                        <button
                                                            class="btn ticketnotedelete text-gray logosdelete"
                                                            value="logo5" data-id="{{ $title->id }}">
                                                            <i class="feather feather-x"></i>
                                                        </button>
                                                        <img src="{{ route('getImage.url', ['imagePath' => 'uploads*logo*favicons*'.$title->image4, 'storage_disk' => $title->image4_storage_disk ?? 'public']) }}"
                                                            class="br-5" alt="">
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="col-md-12 card-footer ">
                        <div class="form-group float-end">
                            {{-- <input type="submit" class="btn btn-secondary" value="{{ lang('Save Changes') }}"
                                onclick="this.disabled=true;this.form.submit();"> --}}
                            <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- End App Title & Logos -->

        <!-- Color Setting -->
        <div class="col-xl-6 col-lg-6">
            <div class="card ">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ lang('Color Setting', 'setting') }}</h4>
                </div>
                <form action="{{ route('settings.color.colorsetting') }}" method="POST">
                    @csrf

                    <div class="card-body">
                        <div class="row">
                            <div class="col-xl-6 col-lg-6 col-md-6">
                                <div class="form-group ">
                                    <label for="" class="form-label">{{ lang('Primary Color', 'setting') }} <span
                                            class="text-red">*</span></label>
                                    <input class="form-control {{ $errors->has('theme_color') ? ' is-invalid' : '' }}"
                                        name="theme_color" type="text"
                                        value="{{ old('theme_color', setting('theme_color')) }}" id="theme_color-input">

                                    @if ($errors->has('theme_color'))
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong>{{ $errors->first('theme_color') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-6 col-md-6">
                                <div class="form-group ">
                                    <label for="" class="form-label">{{ lang('Secondary Color', 'setting') }}
                                        <span class="text-red">*</span></label>
                                    <input
                                        class="form-control {{ $errors->has('theme_color_dark') ? ' is-invalid' : '' }}"
                                        name="theme_color_dark" type="text"
                                        value="{{ old('theme_color_dark', setting('theme_color_dark')) }}"
                                        id="theme_color_dark-input">

                                    @if ($errors->has('theme_color_dark'))
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong>{{ $errors->first('theme_color_dark') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 card-footer ">
                        <div class="form-group float-end ">
                            <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- Color Setting -->

        <!-- Global Language Setting -->
        <div class="col-xl-6 col-lg-6">
            <div class="card ">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ lang('Global Language Setting', 'setting') }}</h4>
                </div>
                <form action="{{ route('settings.lang.store') }}" method="POST">
                    @csrf

                    <div class="card-body">
                        <div class="form-group mb-4">
                            <label class="form-label">{{ lang('Select Language', 'setting') }}</label>
                            <select name="default_lang" id="input-default_lang"
                                class="form-control select2 select2-show-search" required>
                                @foreach (getLanguageslist() as $key => $lang)
                                    <option value="{{ $lang->languagecode }}"
                                        {{ old('default_lang', setting('default_lang')) == $lang->languagecode ? 'selected' : '' }}>
                                        {{ Str::upper($lang->languagename) }}</option>
                                @endforeach

                            </select>
                        </div>
                    </div>
                    <div class="col-md-12 card-footer ">
                        <div class="form-group float-end ">
                            <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- Global Language Setting -->

        <!-- Date and Time Format -->
        <div class="col-xl-6 col-lg-6">
            <div class="card ">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ lang('Global Date & Time Format', 'setting') }}</h4>
                </div>
                <form action="{{ route('settings.timedateformat.store') }}" method="POST">
                    @csrf

                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-6 col-12">
                                <div class="form-group mb-4">
                                    <label class="form-label">{{ lang('Select Date Format', 'setting') }}</label>
                                    <select name="date_format" id="input-date_format"
                                        class="form-control select2 select2-show-search" required>

                                        <option value="d M, Y" {{ setting('date_format') == 'd M, Y' ? 'selected' : '' }}>
                                            d M, Y</option>
                                        <option value="m.d.y" {{ setting('date_format') == 'm.d.y' ? 'selected' : '' }}>
                                            m.d.y</option>
                                        <option value="Y-m-d" {{ setting('date_format') == 'Y-m-d' ? 'selected' : '' }}>
                                            Y-m-d</option>
                                        <option value="d-m-Y" {{ setting('date_format') == 'd-m-Y' ? 'selected' : '' }}>
                                            d-m-Y</option>
                                        <option value="d/m/Y" {{ setting('date_format') == 'd/m/Y' ? 'selected' : '' }}>
                                            d/m/Y</option>
                                        <option value="Y/m/d" {{ setting('date_format') == 'Y/m/d' ? 'selected' : '' }}>
                                            Y/m/d</option>

                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6 col-12">
                                <div class="form-group mb-4">
                                    <label class="form-label">{{ lang('Select Time Format', 'setting') }}</label>
                                    <select name="time_format" id="input-time_format"
                                        class="form-control select2 select2-show-search" required>

                                        <option value="h:i A" {{ setting('time_format') == 'h:i A' ? 'selected' : '' }}>
                                            03:00 PM</option>
                                        <option value="h:i:s A"
                                            {{ setting('time_format') == 'h:i:s A' ? 'selected' : '' }}>03:00:02 PM
                                        </option>
                                        <option value="H:i" {{ setting('time_format') == 'H:i' ? 'selected' : '' }}>
                                            15:00</option>
                                        <option value="H:i:s" {{ setting('time_format') == 'H:i:s' ? 'selected' : '' }}>
                                            15:00:02</option>

                                    </select>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="col-md-12 card-footer ">
                        <div class="form-group float-end ">
                            <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- Date and Time Format -->

        <!--- Start Week Days -->
        <div class="col-xl-6 col-lg-6">
            <div class="card ">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ lang('First Day of the Week', 'setting') }}</h4>
                </div>
                <form action="{{ route('settings.startweek.store') }}" method="POST">
                    @csrf

                    <div class="card-body">
                        <div class="form-group mb-4">
                            <label class="form-label">{{ lang('Select Day', 'setting') }}</label>
                            <select name="start_week" id="input-start_week"
                                class="form-control select2 select2-show-search" required>

                                <option value="0" {{ setting('start_week') == '0' ? 'selected' : '' }}>Sunday
                                </option>
                                <option value="1" {{ setting('start_week') == '1' ? 'selected' : '' }}>Monday
                                </option>
                                <option value="2" {{ setting('start_week') == '2' ? 'selected' : '' }}>Tuesday
                                </option>
                                <option value="3" {{ setting('start_week') == '3' ? 'selected' : '' }}>Wednesday
                                </option>
                                <option value="4" {{ setting('start_week') == '4' ? 'selected' : '' }}>Thursday
                                </option>
                                <option value="5" {{ setting('start_week') == '5' ? 'selected' : '' }}>Friday
                                </option>
                                <option value="6" {{ setting('start_week') == '6' ? 'selected' : '' }}>Saturday
                                </option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-12 card-footer ">
                        <div class="form-group float-end ">
                            <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!--- Start Week Days -->

        <!-- TimeZones -->
        <div class="col-xl-6 col-lg-6">
            <div class="card ">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ lang('Global Timezones', 'setting') }}</h4>
                </div>
                <form action="{{ route('settings.timezone.store') }}" method="POST">
                    @csrf

                    <div class="card-body">
                        <div class="form-group mb-4">
                            <label class="form-label">{{ lang('Select Global Timezones', 'setting') }}</label>
                            <select name="timezones" class="form-control select2 select2-show-search" id="">
                                @foreach ($timezones as $group => $timezoness)
                                    <option value="{{ $timezoness->timezone }}"
                                        {{ $timezoness->timezone == setting('default_timezone') ? 'selected' : '' }}>
                                        {{ $timezoness->timezone }} {{ $timezoness->utc }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-12 card-footer ">
                        <div class="form-group float-end ">
                            <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- End TimeZone -->

        <!-- Two Factor Authentication -->
        <div class="col-xl-12 col-lg-12 col-md-12">
            <div class="card">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ lang('Two Factor Authentication Settings', 'setting') }}</h4>
                </div>
                <form action="{{ route('admin.twofactauthsetting') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <div class="">
                            <div class="col-sm-12 col-md-12">
                                <div class="form-group">
                                    <div class="switch_section">
                                        <div class="switch-toggle d-flex mt-4">
                                            <a class="onoffswitch2">
                                                <input type="checkbox" id="emp_google_two_fact"
                                                    name="Employe_google_two_fact" value="on"
                                                    class=" toggle-class onoffswitch2-checkbox"
                                                    @if (setting('Employe_google_two_fact') == 'on') checked="" @endif>
                                                <label for="emp_google_two_fact"
                                                    class="toggle-class onoffswitch2-label"></label>
                                            </a>
                                            <div class="ps-3">
                                                <label
                                                    class="form-label">{{ lang('Enable Employee Google Two Factor Authentication', 'setting') }}<small
                                                        class="text-muted ">
                                                        <i>({{ lang('If you enable this setting, the application "employees" will be able to use "Google Two Factor Authentication" for login into our appliation.', 'setting') }})</i></small></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="switch_section">
                                        <div class="switch-toggle d-flex mt-4">
                                            <a class="onoffswitch2">
                                                <input type="checkbox" id="emp_email_two_fact"
                                                    name="Employe_email_two_fact" value="on"
                                                    class=" toggle-class onoffswitch2-checkbox"
                                                    @if (setting('Employe_email_two_fact') == 'on') checked="" @endif>
                                                <label for="emp_email_two_fact"
                                                    class="toggle-class onoffswitch2-label"></label>
                                            </a>
                                            <div class="ps-3">
                                                <label
                                                    class="form-label">{{ lang('Enable Employee Email Two Factor Authentication', 'setting') }}<small
                                                        class="text-muted ">
                                                        <i>({{ lang('If you enable this setting, the application "employees" will be able to use "Email Two Factor Authentication" for login into our appliation.', 'setting') }})</i></small></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="form-group float-end">
                            <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- Two Factor Authentication -->

        <!-- Spell check and next word suggestion using Google Gemini -->
        <div class="col-xl-12 col-lg-12 col-md-12">
            <div class="card">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ lang('SpellCheck And Next Word Suggestion Using Google Gemini AI', 'setting') }}</h4>
                </div>
                <form action="{{ route('admin.googleGemini') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <div class="">
                            <div class="col-sm-12 col-md-12">
                                <div class="form-group">
                                    <label class="form-label">{{ lang('Gemini API Key') }}</label>
                                    <input type="text" name="geminiApiKey" class="form-control @error('geminiApiKey') is-invalid @enderror" value="{{ setting('geminiApiKey') }}">
                                    @error('geminiApiKey')
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong>{{ lang($message) }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <div class="switch_section">
                                        <div class="switch-toggle d-flex mt-4">
                                            <a class="onoffswitch2">
                                                <input type="checkbox" id="spellCheck" name="spellCheck" value="on" class=" toggle-class onoffswitch2-checkbox" @if (setting('spellCheck') == 'on') checked="" @endif>
                                                <label for="spellCheck" class="toggle-class onoffswitch2-label"></label>
                                            </a>
                                            <div class="ps-3">
                                                <label class="form-label">{{ lang('Enable SpellCheck', 'setting') }}
                                                    <small class="text-muted ">
                                                        <i>({{ lang('If you enable this setting, the application "employees" will be able to use "Google Two Factor Authentication" for login into our appliation.', 'setting') }})</i>
                                                    </small>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="switch_section">
                                        <div class="switch-toggle d-flex mt-4">
                                            <a class="onoffswitch2">
                                                <input type="checkbox" id="wordSuggestion" name="wordSuggestion" value="on" class=" toggle-class onoffswitch2-checkbox" @if (setting('wordSuggestion') == 'on') checked="" @endif>
                                                <label for="wordSuggestion" class="toggle-class onoffswitch2-label"></label>
                                            </a>
                                            <div class="ps-3">
                                                <label class="form-label">{{ lang('Enable Next Word Suggestion', 'setting') }}
                                                    <small class="text-muted ">
                                                        <i>({{ lang('If you enable this setting, the application "employees" will be able to use "Email Two Factor Authentication" for login into our appliation.', 'setting') }})</i>
                                                    </small>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="form-group float-end">
                            <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- Spell check and next word suggestion using Google Gemini -->

        <!-- Security Controls -->
        <div class="col-xl-12 col-lg-12 col-md-12">
            <div class="card">
                <div class="card-header border-0">
                    <h4 class="card-title">{{lang('Security Controls', 'setting')}}</h4>
                </div>
                <form action="{{route('admin.securitySettings')}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <div class="">
                            <div class="col-sm-12 col-md-12">
                                <div class="form-group">
                                    <div class="switch_section">
                                        <div class="switch-toggle d-flex mt-4">
                                            <a class="onoffswitch2">
                                            <input type="checkbox" id="inspectDisable" name="inspectDisable" value="on"  class=" toggle-class onoffswitch2-checkbox"  @if(setting('inspectDisable') == 'on') checked="" @endif>
                                            <label for="inspectDisable" class="toggle-class onoffswitch2-label" ></label>
                                            </a>
                                            <div class="ps-3">
                                                <label class="form-label">{{lang('Right-Click Protection', 'setting')}}<small  class="text-muted "> <i>({{lang('This setting prevents users from accessing the right-click context menu on the application.', 'setting')}})</i></small></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="switch_section">
                                        <div class="switch-toggle d-flex mt-4">
                                            <a class="onoffswitch2">
                                            <input type="checkbox" id="selectDisabled" name="selectDisabled" value="on"  class=" toggle-class onoffswitch2-checkbox"  @if(setting('selectDisabled') == 'on') checked="" @endif>
                                            <label for="selectDisabled" class="toggle-class onoffswitch2-label" ></label>
                                            </a>
                                            <div class="ps-3">
                                                <label class="form-label">{{lang('Text Selection Prevention', 'setting')}}<small  class="text-muted "> <i>({{lang('This setting disables the ability for users to select and copy text from your application.', 'setting')}})</i></small></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="form-group float-end">
                        <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- Security Controls -->

        <!-- Inactive Customer Auto Logout -->
        <div class="col-xl-12 col-lg-12 col-md-12">
            <div class="card">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ lang('Session Timeout Settings', 'setting') }}</h4>
                </div>
                <form action="{{ route('admin.customerautologout') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <!---Customer Profile Delete Notify--->
                        <div class="">
                            <div class="col-sm-12 col-md-12">
                                <div
                                    class="form-group {{ $errors->has('admin_users_inactive_auto_logout') ? ' has-danger' : '' }}">
                                    <div class="switch_section">
                                        <div class="switch-toggle d-flex mt-4">
                                            <a class="onoffswitch2">
                                                <input type="checkbox" id="myonoffswitchadminautologout"
                                                    name="admin_users_inactive_auto_logout" value="on"
                                                    class=" toggle-class onoffswitch2-checkbox"
                                                    @if (setting('admin_users_inactive_auto_logout') == 'on') checked="" @endif>
                                                <label for="myonoffswitchadminautologout"
                                                    class="toggle-class onoffswitch2-label"></label>
                                            </a>
                                            <div class="ps-3">
                                                <label
                                                    class="form-label">{{ lang('Enable Admin Panel Users Session Timeout', 'setting') }}<small
                                                        class="text-muted ">
                                                        <i>({{ lang('If you enable this setting, admin panel users will be automatically logged out based on their session time (set in minutes) below. This feature helps enhance security and privacy for admin panel users.', 'setting') }})</i></small></label>

                                            </div>
                                        </div>
                                    </div>
                                    @if ($errors->has('admin_users_inactive_auto_logout'))
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong>{{ $errors->first('admin_users_inactive_auto_logout') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-12 ms-7 ps-3 ">
                                <div
                                    class="form-group d-flex d-md-max-block {{ $errors->has('admin_users_inactive_auto_logout_time') ? ' is-invalid' : '' }}">
                                    <input type="number" maxlength="2" class="form-control wd-5 w-lg-max-30 ms-2 "
                                        name="admin_users_inactive_auto_logout_time"
                                        value="{{ old('admin_users_inactive_auto_logout_time', setting('admin_users_inactive_auto_logout_time')) }}"  min="0" oninput="validity.valid||(value='');">
                                    <label
                                        class="form-label mt-2 ms-2">{{ lang('Session Timeout In Minutes', 'setting') }}</label>
                                </div>
                                @if ($errors->has('admin_users_inactive_auto_logout_time'))
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $errors->first('admin_users_inactive_auto_logout_time') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="form-group float-end">
                            <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- Inactive Customer Auto Logout -->

        <!-- Switches -->
        <div class="col-xl-12 col-lg-12 col-md-12">
            <div class="card ">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ lang('App Global Settings', 'setting') }}</h4>
                </div>
                <div class="card-body">
                    <div class="switch_section">
                        <div class="switch-toggle d-flex d-md-max-block mt-4">
                            <a class="onoffswitch2">
                                <input type="checkbox" name="checkbox" id="sprukoadminp"
                                    class=" toggle-class onoffswitch2-checkbox sprukoregister"
                                    @if (setting('SPRUKOADMIN_P') == 'on') checked="" @endif>
                                <label for="sprukoadminp" class="toggle-class onoffswitch2-label"></label>
                            </a>
                            <label
                                class="form-label ps-3 ps-md-max-0">{{ lang('Enable Dark Mode Switch For Admin Panel User’s', 'setting') }}</label>
                            <small
                                class="text-muted ps-2 ps-md-max-0"><i>({{ lang('If you disable this setting, the "Switch to Dark-Mode" option will disappear from the Admin panel user’s profile page.', 'setting') }})</i></small>
                        </div>
                    </div>

                    <div class="switch_section">
                        <div class="switch-toggle d-flex d-md-max-block mt-4">
                            <a class="onoffswitch2">
                                <input type="checkbox" name="checkbox" id="darkmode"
                                    class=" toggle-class onoffswitch2-checkbox sprukoregister"
                                    @if (setting('DARK_MODE') == '1') checked="" @endif>
                                <label for="darkmode" class="toggle-class onoffswitch2-label"></label>
                            </a>
                            <label
                                class="form-label ps-3 ps-md-max-0">{{ lang('Enable Dark-Mode Globally', 'setting') }}</label>
                            <small
                                class="text-muted ps-2 ps-md-max-0"><i>({{ lang('If you enable this setting, the whole application will convert to "Dark-Mode" except for the users that are permitted with "Personal Settings."', 'setting') }})</i></small>
                        </div>
                    </div>

                    <div class="switch_section">
                        <div class="switch-toggle d-flex d-md-max-block mt-4">
                            <a class="onoffswitch2">
                                <input type="checkbox" name="GOOGLEFONT_DISABLE" id="GOOGLEFONT_DISABLE"
                                    class=" toggle-class onoffswitch2-checkbox sprukoregister"
                                    @if (setting('GOOGLEFONT_DISABLE') == 'on') checked="" @endif>
                                <label for="GOOGLEFONT_DISABLE" class="toggle-class onoffswitch2-label"></label>
                            </a>
                            <label
                                class="form-label ps-3 ps-md-max-0">{{ lang('Disable Google Font', 'setting') }}</label>
                            <small
                                class="text-muted ps-2 ps-md-max-0"><i>({{ lang('If you enable this setting, "Google Font" will not apply to the whole application or site.', 'setting') }})</i></small>
                        </div>
                    </div>
                    <div class="switch_section">
                        <div class="switch-toggle d-flex d-md-max-block mt-4">
                            <a class="onoffswitch2">
                                <input type="checkbox" name="FORCE_SSL" id="FORCE_SSL"
                                    class=" toggle-class onoffswitch2-checkbox sprukoregister"
                                    @if (setting('FORCE_SSL') == 'on') checked="" @endif>
                                <label for="FORCE_SSL" class="toggle-class onoffswitch2-label"></label>
                            </a>
                            <label
                                class="form-label ps-3 ps-md-max-0">{{ lang('Enable Force SSL (https)', 'setting') }}</label>
                            <small
                                class="text-muted ps-2 ps-md-max-0"><i>({{ lang('If you enable this setting, it will make your web application secure using "force SSL" when it is not secure, even if your domain is certified with an SSL certificate.', 'setting') }})</i></small>
                        </div>
                    </div>

                    <div class="switch_section">
                        <div class="switch-toggle d-flex d-md-max-block mt-4">
                            <a class="onoffswitch2">
                                <input type="checkbox" name="KNOWLEDGE_ENABLE" id="myonoffswitch12"
                                    class=" toggle-class onoffswitch2-checkbox enablemenus" value="yes"
                                    @if (setting('KNOWLEDGE_ENABLE') == 'yes') checked="" @endif>
                                <label for="myonoffswitch12" class="toggle-class onoffswitch2-label"></label>
                            </a>
                            <label class="form-label ps-3 ps-md-max-0">{{ lang('Enable Knowledge', 'setting') }}</label>
                            <small
                                class="text-muted ps-2 ps-md-max-0"><i>({{ lang('If you disable this setting, the "Knowledge" option will disappear from the application’s header section.', 'setting') }})</i></small>
                        </div>
                    </div>
                    <div class="switch_section">
                        <div class="switch-toggle d-flex d-md-max-block mt-4">
                            <a class="onoffswitch2">
                                <input type="checkbox" name="FAQ_ENABLE" id="faqs"
                                    class=" toggle-class onoffswitch2-checkbox enablemenus" value="yes"
                                    @if (setting('FAQ_ENABLE') == 'yes') checked="" @endif>
                                <label for="faqs" class="toggle-class onoffswitch2-label"></label>
                            </a>
                            <label class="form-label ps-3 ps-md-max-0">{{ lang('Enable Faq', 'setting') }}</label>
                            <small
                                class="text-muted ps-2 ps-md-max-0"><i>({{ lang('If you disable this setting, the "faq" option will disappear from the application’s header section.', 'setting') }})</i></small>
                        </div>
                    </div>

                    <div class="switch_section">
                        <div class="switch-toggle d-flex d-md-max-block mt-4">

                            <a class="onoffswitch2">
                                <input type="checkbox" name="envato_on" id="envato_on"
                                    class=" toggle-class onoffswitch2-checkbox sprukoregister" value="yes"
                                    @if (setting('ENVATO_ON') == 'on') checked="" @endif>
                                <label for="envato_on" class="toggle-class onoffswitch2-label"></label>
                            </a>
                            <label class="form-label ps-3 ps-md-max-0">{{ lang('Envato On', 'setting') }}</label>
                            <small
                                class="text-muted ps-2 ps-md-max-0"><i>({{ lang('If you disable this Envato switch, the entire "Envato" option will disappear from the application', 'setting') }})</i></small>
                        </div>

                    </div>

                    <div class="switch_section">
                        <div class="switch-toggle d-flex d-md-max-block mt-4">
                            <a class="onoffswitch2">
                                <input type="checkbox" name="article_count" id="article_count"
                                    class=" toggle-class onoffswitch2-checkbox sprukoregister" value="yes"
                                    @if (setting('article_count') == 'on') checked="" @endif>
                                <label for="article_count" class="toggle-class onoffswitch2-label"></label>
                            </a>
                            <label
                                class="form-label ps-3 ps-md-max-0">{{ lang('Article Count Enable', 'setting') }}</label>
                            <small
                                class="text-muted ps-2 ps-md-max-0"><i>({{ lang('If you disable this setting, article views count will disappear in the "Article" view page.', 'setting') }})</i></small>
                        </div>
                    </div>

                    <div class="switch_section">
                        <div class="switch-toggle d-flex d-md-max-block mt-4">

                            <a class="onoffswitch2">
                                <input type="checkbox" name="sidemenu_icon_style" id="sidemenu_icon_style"
                                    class=" toggle-class onoffswitch2-checkbox sprukoregister" value="yes"
                                    @if (setting('sidemenu_icon_style') == 'on') checked="" @endif>
                                <label for="sidemenu_icon_style" class="toggle-class onoffswitch2-label"></label>
                            </a>
                            <label
                                class="form-label ps-3 ps-md-max-0">{{ lang('Sidemenu Icon Style', 'setting') }}</label>
                            <small
                                class="text-muted ps-2 ps-md-max-0"><i>({{ lang('If you "Enable" this setting, the whole application sidemenu will collapse into Icon Menu', 'setting') }})</i></small>
                        </div>
                    </div>

                    <!-- Under Maintanance Mode -->
                    {{-- @can('Maintenance Mode Access')
                    <div class="switch_section">
                        <div class="switch-toggle d-flex d-md-max-block mt-4">
                            <a class="onoffswitch2">
                                <input type="checkbox" name="maintanance_mode_enable" id="maintanance_mode_enable"
                                    class=" toggle-class onoffswitch2-checkbox sprukoregister" value="yes"
                                    @if (setting('MAINTENANCE_MODE') == 'on') checked @endif>
                                <label for="maintanance_mode_enable" class="toggle-class onoffswitch2-label"></label>
                            </a>
                            <label
                                class="form-label ps-3 ps-md-max-0">{{ lang('Enable Maintenance Mode', 'setting') }}</label>
                            <a href="{{ url('/admin/maintenancepage') }}" class="ps-1"><i
                                    class="feather feather-edit-2"></i></a>
                            <small
                                class="text-muted ps-2 ps-md-max-0"><i>({{ lang('If you "Enable" this setting, the application will go into maintenance mode. Only admin panel users can access the application.', 'setting') }})</i></small>
                        </div>
                    </div>
                    @endcan --}}
                    <!-- End Under Maintanance Mode -->
                </div>
            </div>
        </div>
        <!-- End switches-->

        <!-- Footer Copyright Text -->
        <div class="col-xl-12 col-lg-12 col-md-12">
            <div class="card ">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ lang('Footer Copyright Text', 'setting') }}</h4>
                </div>
                <form method="POST" action="{{ url('admin/footer/') }}" enctype="multipart/form-data">
                    @csrf

                    @honeypot
                    <input type="hidden" name="id" value="1">

                    <div class="card-body">
                        <textarea class="summernote d-none @error('copyright') is-invalid @enderror" name="copyright" aria-multiline="true">{{ $footertext->copyright }}</textarea>
                        @error('copyright')
                            <span class="invalid-feedback d-block" role="alert">
                                <strong>{{ lang($message) }}</strong>
                            </span>
                        @enderror

                    </div>

                    <div class="card-footer">
                        <div class="form-group float-end ">
                            <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- Footer Copyright Text -->
    </div>

@endsection

@section('scripts')
    <!-- INTERNAL Summernote js  -->
    <script src="{{ asset('build/assets/plugins/summernote/summernote.js') }}?v=<?php echo time(); ?>"></script>

    <!-- INTERNAL Index js-->
        @vite(['resources/assets/js/support/support-sidemenu.js'])
        @vite(['resources/assets/js/select2.js'])

    <!-- INTERNAL color pickr -->
    <script src="{{ asset('build/assets/plugins/colorpickr/pickr.min.js') }}?v=<?php echo time(); ?>"></script>

    <!-- INTERNAL Sweet-Alert js-->
    <script src="{{ asset('build/assets/plugins/sweet-alert/sweetalert.min.js') }}?v=<?php echo time(); ?>"></script>



    <script type="text/javascript">
        $(function() {
            "use strict";
            $('.summernote').summernote({
                placeholder: '',
                tabsize: 1,
                height: 200,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline',
                    'clear']],
                    ['fontname', ['fontname']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['view', ['fullscreen']],
                    ['help', ['help']]
                ],
            });

            (() => {

                //  color pickr code
                // Simple example, see optional options for more configuration.
                window.setColorPicker = (elem, defaultValue) => {
                    elem = document.querySelector(elem);
                    let pickr = Pickr.create({
                        el: elem,
                        default: defaultValue,
                        theme: 'nano', // or 'monolith', or 'nano'
                        useAsButton: true,
                        swatches: [
                            '#217ff3',
                            '#11cdef',
                            '#fb6340',
                            '#f5365c',
                            '#f7fafc',
                            '#212529',
                            '#2dce89'
                        ],
                        components: {
                            // Main components
                            preview: true,
                            opacity: true,
                            hue: true,
                            // Input / output Options
                            interaction: {
                                hex: true,
                                rgba: true,
                                // hsla: true,
                                // hsva: true,
                                // cmyk: true,
                                input: true,
                                clear: true,
                                silent: true,
                                preview: true,
                            }
                        }
                    });
                    pickr.on('init', pickr => {
                        elem.value = pickr.getSelectedColor().toRGBA().toString(0);
                    }).on('change', color => {
                        elem.value = color.toRGBA().toString(0);
                    });

                    return pickr;

                }

                // Color Pickr variables
                let themeColor = setColorPicker('#theme_color-input', document.querySelector('#theme_color-input').value);
                let themeColorDark = setColorPicker('#theme_color_dark-input', document.querySelector('#theme_color_dark-input').value);

                // Csrf Field
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                // summernote js
                $('.summernote').summernote({
                    placeholder: '',
                    tabsize: 1,
                    height: 200,
                });

                // Multiple switch changes
                $('.sprukoregister').on('change', function() {
                    var googledisable = $('#GOOGLEFONT_DISABLE').prop('checked') == true ? 'on' : 'off';
                    var forcessl = $('#FORCE_SSL').prop('checked') == true ? 'on' : 'off';
                    var darkmode = $('#darkmode').prop('checked') == true ? '1' : '0';
                    var sprukoadminp = $('#sprukoadminp').prop('checked') == true ? 'on' : 'off';
                    var envatoon = $('#envato_on').prop('checked') == true ? 'on' : 'off';
                    var purchasecodeon = $('#purchasecode_on').prop('checked') == true ? 'on' : 'off';
                    var articlecount = $('#article_count').prop('checked') == true ? 'on' : 'off';
                    var sidemenustyle = $('#sidemenu_icon_style').prop('checked') == true ? 'on' : 'off';
                    // var maintanancemode = $('#maintanance_mode_enable').prop('checked') == true ? 'on' : 'off';

                    $.ajax({
                        type: "GET",
                        dataType: "json",
                        url: '{{ url('/admin/general/register') }}',
                        data: {
                            'googledisable': googledisable,
                            'forcessl': forcessl,
                            'darkmode': darkmode,
                            'sprukoadminp': sprukoadminp,
                            'envatoon': envatoon,
                            'purchasecodeon': purchasecodeon,
                            'articlecount': articlecount,
                            'sidemenustyle': sidemenustyle,
                            // 'maintanancemode': maintanancemode,
                        },
                        success: function(data) {
                            toastr.success('{{ lang('Updated successfully', 'alerts') }}')
                            window.location.reload();
                        },
                        error: function(data) {
                            window.location.reload();
                        }
                    });
                });

                // Enable Menus
                $('.enablemenus').on('change', function() {
                    var status = $('#myonoffswitch12').prop('checked') == true ? 'yes' : 'no';
                    var status1 = $('#faqs').prop('checked') == true ? 'yes' : 'no';
                    $.ajax({
                        type: "post",
                        dataType: "json",
                        url: '{{ url('/admin/knowledge') }}',
                        data: {
                            'KNOWLEDGE_ENABLE': status,
                            'FAQ_ENABLE': status1,
                        },
                        success: function(data) {
                            if (toastr.success('{{ lang('Updated successfully', 'alerts') }}')) {
                                location.reload();
                            }
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                });

                // employye profile enable
                $('#myonoffswitch124').on('change', function() {
                    var status2 = $('#myonoffswitch124').prop('checked') == true ? 'yes' : 'no';
                    $.ajax({
                        type: "post",
                        dataType: "json",
                        url: '{{ url('/admin/profileagent') }}',
                        data: {
                            'PROFILE_AGENT_ENABLE': status2
                        },
                        success: function(data) {
                            if (toastr.success('{{ lang('Updated successfully', 'alerts') }}')) {
                                location.reload();
                            }
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                });

                // Logos Delete
                $('body').on('click', '.logosdelete', function(e) {
                    e.preventDefault();
                    let id = $(this).data('id');
                    let logo = $(this).val();
                    swal({
                            title: `{{ lang('Are you sure want to remove this logo?') }}`,
                            icon: "warning",
                            buttons: true,
                            dangerMode: true,
                        })
                        .then((willDelete) => {
                            if (willDelete) {
                                $.ajax({
                                    type: "post",
                                    url: "{{ route('admin.logodelete') }}",
                                    data: {
                                        'id': id,
                                        'logo': logo

                                    },
                                    success: function(data) {
                                        toastr.success(data.success);
                                        location.reload();
                                    },
                                    error: function(data) {
                                        console.log('Error:', data);
                                    }
                                });
                            }
                        });
                });

                //Login_Disable Content modelPopup
                $('body').on('click', '.sprukologindisable', function(e) {

                    e.preventDefault();
                    $('#name').html("");
                    $('#sprukologin').val("Save");
                    $('#logindisable_form').trigger("reset");
                    $('.modal-title').html("{{ lang('Login/Register Disable Statement') }}");
                    $('#addlogindisable').modal('show');
                    $('#name').val("{{ setting('login_disable_statement') }}");
                })

                $('body').on('submit', '#logindisable_form', function(e) {
                    e.preventDefault();
                    var actionType = $('#btnsave').val();
                    var fewSeconds = 2;
                    $('#btnsave').html('Loading');
                    $('#btnsave').prop('disabled', true);
                    setTimeout(function() {
                        $('#btnsave').prop('disabled', false);
                        $('#btnsave').html('Save');
                    }, fewSeconds * 1000);
                    var formData = new FormData(this);
                    $.ajax({
                        type: 'POST',
                        url: '{{ url('admin/general/logindisable') }}',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,

                        success: (data) => {
                            $('#nameError').html('');
                            $('#logindisable_form').trigger("reset");
                            $('#addlogindisable').modal('hide');
                            $('#btnsave').html('Save');
                            toastr.success(data.success);
                        },
                        error: function(data) {
                            $('#nameError').html('');
                            $('#nameError').html(data.responseJSON.errors.name);

                            $('#btnsave').html('Save');
                        }
                    });
                });



            })();
        });

        // To copy in the Click Bord
        document.querySelector(".cronCommandLinkCopyBtn").onclick = () => {
            var copyText = document.querySelector(".cronCommandLink");

            if (navigator.clipboard) {
                copyText.select();
                copyText.setSelectionRange(0, 99999);

                navigator.clipboard.writeText(copyText.value)
                    .then(() => {
                        console.log('Text successfully copied to clipboard');
                        toastr.success('{{ lang('Command successfully copied to clipboard') }}');
                    })
                    .catch(err => {
                        console.error('Unable to copy text to clipboard', err);
                    });
            } else {
                console.warn('Clipboard API not supported, copying to clipboard may not work.');
            }
        }
    </script>
@endsection

@section('modal')
    @include('admin.generalsetting.modalpopup.logindisablemodal')
@endsection
