
@extends('layouts.adminmaster')

@section('styles')

<!-- INTERNAL Data table css -->
<link href="{{asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
<link href="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

<!-- INTERNAL Sweet-Alert css -->
<link href="{{asset('build/assets/plugins/sweet-alert/sweetalert.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

<style>
    #hideAfterloading {
        position: absolute;
        top: 100px;
        left: 45%;
    }
</style>

@endsection

					@section('content')

					<!--Page header-->
					<div class="page-header d-xl-flex d-block">
						<div class="page-leftheader">
							<h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Feature Box', 'menu')}}</span></h4>
						</div>
					</div>
					<!--End Page header-->

					<!-- Feature Box Section -->
					<div class="col-xl-12 col-lg-12 col-md-12">
						<div class="card ">
							<form method="POST" action="{{url('/admin/feature-box/feature')}}" enctype="multipart/form-data">
								@csrf

								@honeypot

								<div class="card-header border-0 d-sm-max-flex">
									<h4 class="card-title">{{lang('Feature Box Section')}}</h4>
								</div>
								<div class="card-body" >
									<div class="row">
										<div class="col-sm-12 col-md-12">
											<input type="hidden" class="form-control " name="id" value="{{$basic->id}}">
											<div class="form-group">
												<label class="form-label">{{lang('Title')}} <span  class="text-red">*</span></label>
												<input type="text" class="form-control @error('featuretitle') is-invalid @enderror" name="featuretitle" value="{{$basic->featuretitle}}">
												@error('featuretitle')

													<span class="invalid-feedback d-block" role="alert">
														<strong>{{ lang($message) }}</strong>
													</span>
												@enderror

											</div>
										</div>
										<div class="col-sm-12 col-md-12">
											<div class="form-group">
												<label class="form-label">{{lang('Subtitle')}}</label>
												<input type="text" class="form-control @error('featuresub') is-invalid @enderror" name="featuresub" value="{{$basic->featuresub}}">
												@error('featuresub')

													<span class="invalid-feedback d-block" role="alert">
														<strong>{{ lang($message) }}</strong>
													</span>
												@enderror

											</div>
										</div>
									</div>
								</div>
								<div class="col-md-12 card-footer ">
									<div class="form-group float-end">
                                        <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
									</div>
								</div>
						</form>
						</div>
					</div>
					<!-- End Feature Box Section -->

					<!-- Feature Box List -->
					<div class="col-xl-12 col-lg-12 col-md-12">
						<div class="card">
							<div class="card-header border-0 d-sm-max-flex">
								<h4 class="card-title ">{{lang('Feature Box List')}}</h4>
								<div class="card-options  mt-sm-max-2">
									@can('Feature Box Create')

									<a href="javascript:void(0)" class="btn btn-secondary me-3" id="create-new-featurebox">{{lang('Add Feature')}}</a>
									@endcan

								</div>
							</div>
							<div class="card-body" style="min-height: 250px;">
								<div class="table-responsive spruko-delete">
									@can('Feature Box Delete')

									<button id="massdeletenotify" class="btn btn-outline-light btn-sm mb-4 data-table-btn" style="display: none;"><i class="fe fe-trash"></i> {{lang('Delete')}}</button>
									@endcan

									<table class="table table-bordered border-bottom text-nowrap ticketdeleterow w-100" id="featurebox">
										<thead>
											<tr>
												<th width="10" >{{lang('Sl.No')}}</th>
												@can('Feature Box Delete')

												<th width="10" >
													<input type="checkbox"  id="customCheckAll" class="form-check-input">
													<label  for="customCheckAll"></label>
												</th>
												@endcan
												@cannot('Feature Box Delete')

												<th width="10" >
													<input type="checkbox"  id="customCheckAll" class="form-check-input" disabled>
													<label  for="customCheckAll"></label>
												</th>
												@endcannot

												<th >{{lang('Title')}}</th>
												<th >{{lang('Subtitle')}}</th>
												<th >{{lang('Actions')}}</th>
											</tr>
										</thead>
                                        <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                                            <p>{{lang('loading.. Please Wait')}}</p>
                                        </div>
									</table>
								</div>
							</div>
						</div>
					</div>
					<!-- End Feature Box List -->
					@endsection

		@section('modal')

		   @include('admin.featurebox.model')

		@endsection

@section('scripts')

<!-- INTERNAL Vertical-scroll js-->
<script src="{{asset('build/assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js')}}?v=<?php echo time(); ?>"></script>


<!-- INTERNAL Index js-->
@vite(['resources/assets/js/support/support-sidemenu.js'])

<!-- INTERNAL Data tables -->
<script src="{{asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/dataTables.responsive.min.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js')}}?v=<?php echo time(); ?>"></script>

<!-- INTERNAL Sweet-Alert js-->
<script src="{{asset('build/assets/plugins/sweet-alert/sweetalert.min.js')}}?v=<?php echo time(); ?>"></script>

<script type="text/javascript">
    "use strict";

    document.addEventListener("DOMContentLoaded", (event) => {

        let tableData = @json($featureboxes);

        let dateFormat = @json(setting('date_format'));
        let delPerm = @json(Auth::user()->can('Feature Box Delete'));
        let editPerm = @json(Auth::user()->can('Feature Box Edit'));

        var dataTable;
        var tableDropDown;

        loadTable(tableData);

        function truncateTitle(title) {
            const maxLength = 40;
            return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
        }

        function loadTable(tableData) {
            document.getElementById('hideAfterloading')?.classList.remove('d-none');
            document.getElementById('theadShow')?.classList.add('d-none');
            if (tableDropDown)
                tableDropDown.destroy();

            if (dataTable)
                dataTable.destroy();

            if (document.getElementById('tableBody'))
                document.getElementById('tableBody').remove();

            let createTbody = document.createElement('tbody');
            createTbody.setAttribute('id', "tableBody");
            let rows = tableData.map((data, index) => {

                return `
                    <tr>
                        <td>${index + 1}</td>
                        <td class="text-center">
                            ${delPerm
                                ? `<input type="checkbox" name="spruko_checkbox[]" class="checkall form-check-input" value="${data.id}" />`
                                : '~'
                            }

                        </td>

                        <td>${data.title ? truncateTitle(data.title) : ''}</td>

                        <td>${ data.subtitle ? truncateTitle(data.subtitle) : ''}</td>

                        <td>
                            <div class = "d-flex">

                                ${editPerm ? `<a href="javascript:void(0)" data-id="${data.id}" class="action-btns1 edit-testimonial"><i class="feather feather-edit text-primary" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Edit')}}"></i></a>` : '~'
                                }
                                ${delPerm ? `<a href="javascript:void(0)" data-id="${data.id}" class="action-btns1" id="delete-testimonial" ><i class="feather feather-trash-2 text-danger" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Delete')}}"></i></a>` : '~'
                                }
                            </div>

                        </td>

                    </tr>
                `;
            });

            if (tableData.length == 0)
                createTbody.innerHTML = ` `;
            else
                createTbody.innerHTML = rows.join('');


            // Append the tbody to your table
            // Replace 'your-table-id' with the actual ID of your table element
            document.getElementById('featurebox').appendChild(createTbody);

            document.getElementById('hideAfterloading')?.classList.add('d-none');
            document.getElementById('theadShow')?.classList.remove('d-none');

            // var myTable = document.querySelector("#support-category");

            $(document).ready(function() {

                var SITEURL = '{{ url('') }}';

                // Csrf field
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                let prev = {!! json_encode(lang("Previous")) !!};
                let next = {!! json_encode(lang("Next")) !!};
                let nodata = {!! json_encode(lang("No data available in table")) !!};
                let noentries = {!! json_encode(lang("No entries to show")) !!};
                let showing = {!! json_encode(lang("showing page")) !!};
                let ofval = {!! json_encode(lang("of")) !!};
                let maxRecordfilter = {!! json_encode(lang("- filtered from ")) !!};
                let maxRecords = {!! json_encode(lang("records")) !!};
                let entries = {!! json_encode(lang("entries")) !!};
                let show = {!! json_encode(lang("Show")) !!};
                let search = {!! json_encode(lang("Search")) !!};
                // Datatable
                $('#featurebox').dataTable({
                    language: {
                        searchPlaceholder: search,
                        scrollX: "100%",
                        sSearch: '',
                        paginate: {
                        previous: prev,
                        next: next
                        },
                        emptyTable : nodata,
                        infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                        info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                        infoEmpty: noentries,
                        lengthMenu: `${show} _MENU_ ${entries} `,
                    },
                    order:[],
                    columnDefs: [
                        { "orderable": false, "targets":[ 0,1,4] }
                    ],
                });

                $('.form-select').select2({
                    minimumResultsForSearch: Infinity,
                    width: '100%'
                });

                $('.form-select').on('focus', function() {
                    $(this).attr('aria-hidden', 'false');
                });
            });


            initializeTooltips();

            function initializeTooltips() {
                var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                tooltipElements.forEach(function(element) {
                    new bootstrap.Tooltip(element);
                });
            }


        }


        $(function() {
            (function($)  {

                // Variables
                var SITEURL = '{{url('')}}';

                let elementToToggle = null;

                /*  When user click add featurebox button */
                $('#create-new-featurebox').on('click', function (event) {
                    elementToToggle = event.target;
                    $('#nameError').html('');
                    $('#descriptionError').html('');
                    $('#ImageError').html('');
                    $('#btnsave').html("create-feature");
                    $('#featurebox_id').val('');
                    $('#featurebox_form').trigger("reset");
                    $('.modal-title').html("{{lang('Add New Feature Box')}}");
                    $('.imageshowdiv').hide();
                    $('#addfeature').modal('show');
                });

                /* When click edit featurebox */
                $('body').on('click', '.edit-testimonial', function (event) {
                    elementToToggle = event.target;
                    var testimonial_id = $(this).data('id');
                    $.get('feature-box/' + testimonial_id , function (data) {
                        $('#featurebox_form').trigger("reset");
                        $('#nameError').html('');
                        $('#descriptionError').html('');
                        $('#ImageError').html('');
                        $('.modal-title').html("{{lang('Edit Feature Box')}}");
                        $('#btnsave').html("Update");
                        $('#addfeature').modal('show');
                        $('#featurebox_id').val(data.id);
                        $('#name').val(data.title);
                        $('#description').val(data.subtitle);
                        $('#featureboxurl').val(data.featureboxurl);
                        if(data.imageurl != null){
                            $('.imageshowdiv').show();
                            $('#featureImage').attr('src', data.imageurl);
                            $('.delete-image').attr('data-id', data.id);
                        }else{
                            $('.imageshowdiv').hide();
                        }

                        if (data.url_checkbox == "on")
                        {
                            $('#url_checkbox').prop('checked', true);
                        }else{
                            $('#url_checkbox').prop('checked', false);
                        }

                    })
                });

                $('#featurebox_form #btnsave').on('click', function() {
                    elementToToggle.checked = !elementToToggle.checked;
                })

                // Delete Featurebox Image
                $('body').on('click', '.delete-image', function () {
                    var featureId = $(this).data("id");
                    swal({
                        title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                        text: "{{lang('This might erase your records permanently', 'alerts')}}",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            $.ajax({
                                type: "post",
                                url: SITEURL + "/admin/feature-box/image/delete/" +featureId,
                                success: function (data) {
                                    toastr.success(data.success);
                                    $('.imageshowdiv').hide();
                                },
                                error: function (data) {
                                    console.log('Error:', data);
                                }
                            });
                        }
                    });
                });

                // Delete Featurebox function
                $('body').on('click', '#delete-testimonial', function () {
                    let parent = $(this).closest('tr');
                    var _id = $(this).data("id");
                    swal({
                        title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                        text: "{{lang('This might erase your records permanently', 'alerts')}}",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            $.ajax({
                                type: "get",
                                url: SITEURL + "/admin/feature-box/delete/"+_id,
                                success: function (data) {
                                    toastr.success(data.success);
                                    $(parent[0]).addClass('fade-out');
                                    let newData = tableData.filter(item => item.id != parseInt(_id));
                                    tableData = newData;
                                    setTimeout(() => {
                                        parent[0].remove();
                                        if ($.fn.DataTable.isDataTable('#featurebox')) {
                                            $('#featurebox').DataTable().clear().destroy();
                                        }
                                        loadTable(tableData);
                                    }, 1500);
                                },
                                error: function (data) {
                                    console.log('Error:', data);
                                }
                            });
                        }
                    });
                });

                // Feature Box Submit button
                $('body').on('submit', '#featurebox_form', function (e) {
                    e.preventDefault();
                    var actionType = $('#btnsave').val();
                    var fewSeconds = 2;
                    $('#btnsave').html('Sending... <i class="fa fa-spinner fa-spin"></i>');
                    $('#btnsave').prop('disabled', true);
                    setTimeout(function(){
                        $('#btnsave').prop('disabled', false);
                    }, fewSeconds*1000);
                    var formData = new FormData(this);
                    $.ajax({
                        type:'POST',
                        url: SITEURL + "/admin/feature-box/create",
                        data: formData,
                        cache:false,
                        contentType: false,
                        processData: false,
                        success: (data) => {
                            if(data.errors){
                                $('#nameError').html('');
                                $('#descriptionError').html('');
                                $('#ImageError').html('');
                                $('#nameError').html(data.errors.title);
                                $('#descriptionError').html(data.errors.subtitle);
                                $('#ImageError').html(data.errors.image);
                                $('#btnsave').html('{{lang('Save Changes')}}');
                            }
                            if(data.success){
                                $('#nameError').html('');
                                $('#descriptionError').html('');
                                $('#ImageError').html('');
                                $('#featurebox_form').trigger("reset");
                                $('#addfeature').modal('hide');
                                $('#btnsave').html('{{lang('Save Changes')}}');
                                toastr.success(data.success);
                                if ($.fn.DataTable.isDataTable('#featurebox')) {
                                    $('#featurebox').DataTable().clear().destroy();
                                }
                                tableData = data.featureboxes;
                                loadTable(tableData);
                            }
                        },
                        error: function(data){
                            $('#nameError').html('');
                            $('#descriptionError').html('');
                            $('#ImageError').html('');
                            console.log('Error:', data);
                            $('#btnsave').html('{{lang('Save Changes')}}');
                        }
                    });
                });
                // Mass Delete
                $('body').on('click', '#massdeletenotify', function () {
                    var parent = [];
                    var id = [];
                    $('.checkall:checked').each(function(){
                        parent.push($(this).closest('tr'));
                        id.push($(this).val());
                    });
                    if(id.length > 0){
                        swal({
                            title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                            text: "{{lang('This might erase your records permanently', 'alerts')}}",
                            icon: "warning",
                            buttons: true,
                            dangerMode: true,
                        })
                        .then((willDelete) => {
                            if (willDelete) {
                                $.ajax({
                                    url:"{{ route('featurebox.deleteall')}}",
                                    method:"post",
                                    data:{id:id},
                                    success:function(data)
                                    {
                                        toastr.success(data.success);
                                        parent.forEach(function(row) {
                                            row.addClass('fade-out');
                                        });
                                        let newData = tableData.filter(item => !id.includes(String(item.id)));
                                        tableData = newData;
                                        setTimeout(() => {
                                            parent.forEach(function(row) {
                                                row.remove();
                                            });
                                            if ($.fn.DataTable.isDataTable('#featurebox')) {
                                                $('#featurebox').DataTable().clear().destroy();
                                            }
                                            $('#customCheckAll').prop('checked', false);
                                            loadTable(tableData);
                                        }, 1500);

                                    },
                                    error:function(data){
                                    }
                                });
                            }
                        });
                    }else{
                        toastr.error('{{lang('Please select at least one check box.', 'alerts')}}');
                    }
                });

                //checkbox script
                $(document).ready(function() {

                    $(document).on('click', '#customCheckAll', function() {
                        $('.checkall').prop('checked', this.checked);
                        updateMassDeleteVisibility();
                    });

                    $(document).on('click', '.checkall', function() {
                        updateCustomCheckAll();
                        updateMassDeleteVisibility();
                    });


                    $(document).on('click', '.pagination a', function() {

                        setTimeout(function() {
                            updateMassDeleteVisibility();
                        }, 100);
                    });


                    $('#customCheckAll').prop('checked', false);


                    function updateMassDeleteVisibility() {
                        if ($('.checkall:checked').length == 0) {
                            $('#massdeletenotify').hide();
                        } else {
                            $('#massdeletenotify').show();
                        }
                    }


                    function updateCustomCheckAll() {
                        var totalCheckboxes = $('.checkall').length;
                        var checkedCheckboxes = $('.checkall:checked').length;

                        if (checkedCheckboxes === totalCheckboxes) {
                            $('#customCheckAll').prop('checked', true);
                        } else {
                            $('#customCheckAll').prop('checked', false);
                        }
                    }
                });

            })(jQuery);
        });
    });


</script>

@endsection
