@extends('layouts.adminmaster')

		@section('styles')

		<!-- INTERNAl Summernote css -->
		<link rel="stylesheet" href="{{asset('build/assets/plugins/summernote/summernote.css')}}?v=<?php echo time(); ?>">

		<!-- INTERNAL Data table css -->
		<link href="{{asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
		<link href="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

		<!-- INTERNAL Sweet-Alert css -->
		<link href="{{asset('build/assets/plugins/sweet-alert/sweetalert.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

        <style>
            .table-ans {
                max-width: 300px !important;
                width: 300px !important;
            }

            #support-articlelists tbody td{
                max-width: 300px !important;
                width: 300px !important;
                overflow: hidden;
                text-overflow: ellipsis;
                white-space: nowrap;
            }

            #hideAfterloading {
                position: absolute;
                top: 100px;
                left: 45%;
            }
        </style>
		@endsection

        @section('content')

            <!--Page header-->
            <div class="page-header d-xl-flex d-block">
                <div class="page-leftheader">
                    <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('FAQ’s', 'menu')}}</span></h4>
                </div>
            </div>
            <!--End Page header-->

            <div class="col-xl-12 col-lg-12 col-md-12">
                <div class="card ">
                    <form method="POST" action="{{url('/admin/faq')}}" enctype="multipart/form-data">
                        @csrf

                        @honeypot

                        <div class="card-header border-0 d-sm-max-flex">
                            <h4 class="card-title">{{lang('FAQ’s Section')}}</h4>
                            <div class="card-options card-header-styles mt-sm-max-2">
                                <small class="me-1 mt-1">{{lang('Show Section')}}</small>
                                <div class="float-end mt-0">
                                    <div class="switch-toggle">
                                        <a class="onoffswitch2">
                                            <input type="checkbox"  name="faqcheck" id="faqchecks" class=" toggle-class onoffswitch2-checkbox" value="on" @if($basic->faqcheck == 'on')  checked=""  @endif>
                                            <label for="faqchecks" class="toggle-class onoffswitch2-label" ></label>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body" >
                            <div class="row">
                                <div class="col-sm-12 col-md-12">
                                    <input type="hidden" class="form-control " id="testimonial_id" name="id" value="{{$basic->id}}">
                                    <div class="form-group">
                                        <label class="form-label">{{lang('Title')}} <span class="text-red">*</span></label>
                                        <input type="text" class="form-control @error('faqtitle') is-invalid @enderror" name="faqtitle" value="{{$basic->faqtitle}}">
                                        @error('faqtitle')

                                            <span class="invalid-feedback d-block" role="alert">
                                                <strong>{{ lang($message) }}</strong>
                                            </span>
                                        @enderror

                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-12">
                                    <div class="form-group">
                                        <label class="form-label">{{lang('Subtitle')}}</label>
                                        <input type="text" class="form-control @error('faqsub') is-invalid @enderror" name="faqsub" value="{{$basic->faqsub}}">
                                        @error('faqsub')

                                            <span class="invalid-feedback d-block" role="alert">
                                                <strong>{{ lang($message) }}</strong>
                                            </span>
                                        @enderror

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 card-footer ">
                            <div class="form-group float-end">
                                <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="col-xl-12 col-lg-12 col-md-12">
                <div class="card ">
                    <div class="card-header border-0 d-sm-max-flex">
                        <h4 class="card-title">{{lang('FAQ’s', 'menu')}}</h4>
                        <div class="card-options mt-sm-max-2">
                            @can('FAQs Create')
                                <a href="{{route('faq.create')}}" class="btn btn-secondary me-3" id="create-new-post">{{lang('Add FAQ')}}</a>
                            @endcan

                        </div>
                    </div>
                    <div class="card-body" style="min-height: 250px;">
                        <div class="table-responsive spruko-delete">
                            @can('FAQs Delete')

                            <button id="massdeletenotify" class="btn btn-outline-light btn-sm mb-4 data-table-btn" style="display: none;"><i class="fe fe-trash"></i> {{lang('Delete')}}</button>
                            @endcan

                            <table class="table table-bordered border-bottom text-nowrap ticketdeleterow w-100" id="support-articlelists">
                                <thead>
                                    <tr>
                                        <th  width="10">{{lang('Sl.No')}}</th>
                                        @can('FAQs Delete')

                                        <th width="10" >
                                            <input type="checkbox"  id="customCheckAll" class="form-check-input">
                                            <label  for="customCheckAll"></label>
                                        </th>
                                        @endcan
                                        @cannot('FAQs Delete')

                                        <th width="10" >
                                            <input type="checkbox"  id="customCheckAll" class="form-check-input" disabled>
                                            <label  for="customCheckAll"></label>
                                        </th>
                                        @endcannot

                                        <th >{{lang('Question')}}</th>
                                        <th class="table-ans">{{lang('Answer')}}</th>
                                        <th >{{lang('Faq Category', 'menu')}}</th>
                                        <th class="w-5">{{lang('Status')}}</th>
                                        <th class="w-5">{{lang('Actions')}}</th>
                                    </tr>
                                </thead>
                                <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                                    <p>{{lang('loading.. Please Wait')}}</p>
                                </div>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        @endsection
	@section('modal')

   	@include('admin.faq.model')

	@endsection

		@section('scripts')

		<!-- INTERNAL Vertical-scroll js-->
		<script src="{{asset('build/assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js')}}"></script>

		<!-- INTERNAL Summernote js  -->
		<script src="{{asset('build/assets/plugins/summernote/summernote.js')}}"></script>

		<!-- INTERNAL Data tables -->
		<script src="{{asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
		<script src="{{asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js')}}"></script>
		<script src="{{asset('build/assets/plugins/datatable/dataTables.responsive.min.js')}}"></script>
		<script src="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js')}}"></script>

		<!-- INTERNAL Index js-->
        @vite(['resources/assets/js/support/support-sidemenu.js'])
        @vite(['resources/assets/js/support/support-articles.js'])

		<!-- INTERNAL Sweet-Alert js-->
		<script src="{{asset('build/assets/plugins/sweet-alert/sweetalert.min.js')}}"></script>

		<script type="text/javascript">
            "use strict";

            document.addEventListener("DOMContentLoaded", (event) => {

                let tableData = @json($faqs);

                let dateFormat = @json(setting('date_format'));
                let delPerm = @json(Auth::user()->can('FAQs Delete'));
                let editPerm = @json(Auth::user()->can('FAQs Edit'));

                var dataTable;
                var tableDropDown;

                loadTable(tableData);

                function truncateTitle(title) {
                    const maxLength = 40;
                    return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
                }

                function processFAQAnswer(html, wordLimit) {
                    // Strip HTML tags
                    const stripTags = (html) => {
                        const div = document.createElement('div');
                        div.innerHTML = html;
                        return div.textContent || div.innerText || '';
                    };

                    // Limit words
                    const limitWords = (text, limit) => {
                        const words = text.split(' ');
                        return words.slice(0, limit).join(' ') + (words.length > limit ? '...' : '');
                    };

                    const strippedAnswer = stripTags(html);
                    return limitWords(strippedAnswer, wordLimit);
                };

                function loadTable(tableData) {
                    document.getElementById('hideAfterloading')?.classList.remove('d-none');
                    document.getElementById('theadShow')?.classList.add('d-none');
                    if (tableDropDown)
                        tableDropDown.destroy();

                    if (dataTable)
                        dataTable.destroy();

                    if (document.getElementById('tableBody'))
                        document.getElementById('tableBody').remove();

                    let createTbody = document.createElement('tbody');
                    createTbody.setAttribute('id', "tableBody");
                    let rows = tableData.map((data, index) => {
                        var routeUrl = "{{ route('faq.edit', ['id' => ':id']) }}".replace(':id', data.id);
                        return `
                            <tr>
                                <td>${index + 1}</td>
                                <td>
                                    ${delPerm
                                        ? `<input type="checkbox" name="spruko_checkbox[]" class="checkall form-check-input" value="${data.id}" />`
                                        : '~'
                                    }

                                </td>

                                <td>${data.question ? truncateTitle(data.question) : ''}</td>

                                <td>${data.answer ? processFAQAnswer(data.answer, 50) : ''}</td>

                                <td>${data.faqcat_id ? (data.faqcategory ? data.faqcategory.faqcategoryname : '~') : '~'}</td>

                                <td>
                                    ${editPerm ?
                                        (data.status == '1' ?
                                        `<label class="custom-switch form-switch mb-0">
                                            <input type="checkbox" name="status" data-id="${data.id}" id="myonoffswitch${data.id}" value="1" class="custom-switch-input tswitch" checked>
                                            <span class="custom-switch-indicator"></span>
                                        </label>`
                                        :
                                        `<label class="custom-switch form-switch mb-0">
                                            <input type="checkbox" name="status" data-id="${data.id}" id="myonoffswitch${data.id}" value="1" class="custom-switch-input tswitch">
                                            <span class="custom-switch-indicator"></span>
                                        </label>`
                                        )
                                    :
                                        '~'
                                    }
                                </td>

                                <td>
                                    <div class = "d-flex">

                                        ${editPerm ? `<a href="${routeUrl}" class="action-btns1"><i class="feather feather-edit text-primary" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Edit')}}"></i></a>` : '~'
                                        }
                                        ${delPerm ? `<a href="javascript:void(0)" data-id="${data.id}" class="action-btns1" id="show-delete"><i class="feather feather-trash-2 text-danger" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Delete')}}"></i></a>` : '~'
                                        }
                                    </div>

                                </td>

                            </tr>
                        `;
                    });

                    if (tableData.length == 0)
                        createTbody.innerHTML = ` `;
                    else
                        createTbody.innerHTML = rows.join('');


                    // Append the tbody to your table
                    // Replace 'your-table-id' with the actual ID of your table element
                    document.getElementById('support-articlelists').appendChild(createTbody);

                    document.getElementById('hideAfterloading')?.classList.add('d-none');
                    document.getElementById('theadShow')?.classList.remove('d-none');

                    // var myTable = document.querySelector("#support-category");

                    $(document).ready(function() {

                        var SITEURL = '{{ url('') }}';

                        // Csrf field
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });


                        let prev = {!! json_encode(lang("Previous")) !!};
                        let next = {!! json_encode(lang("Next")) !!};
                        let nodata = {!! json_encode(lang("No data available in table")) !!};
                        let noentries = {!! json_encode(lang("No entries to show")) !!};
                        let showing = {!! json_encode(lang("showing page")) !!};
                        let ofval = {!! json_encode(lang("of")) !!};
                        let maxRecordfilter = {!! json_encode(lang("- filtered from ")) !!};
                        let maxRecords = {!! json_encode(lang("records")) !!};
                        let entries = {!! json_encode(lang("entries")) !!};
                        let show = {!! json_encode(lang("Show")) !!};
                        let search = {!! json_encode(lang("Search")) !!};
                        // Datatable
                        $('#support-articlelists').dataTable({
                            language: {
                                searchPlaceholder: search,
                                scrollX: "100%",
                                sSearch: '',
                                paginate: {
                                previous: prev,
                                next: next
                                },
                                emptyTable : nodata,
                                infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                                info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                                infoEmpty: noentries,
                                lengthMenu: `${show} _MENU_ ${entries} `,
                            },
                            order:[],
                            columnDefs: [
                                { "orderable": false, "targets":[ 0,1,4] }
                            ],
                        });

                        $('.form-select').select2({
                            minimumResultsForSearch: Infinity,
                            width: '100%'
                        });

                        $('.form-select').on('focus', function() {
                            $(this).attr('aria-hidden', 'false');
                        });
                    });


                    initializeTooltips();

                    function initializeTooltips() {
                        var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                        tooltipElements.forEach(function(element) {
                            new bootstrap.Tooltip(element);
                        });
                    }


                }

                $(function() {

                    (function($)  {

                        // Variables
                        var SITEURL = '{{url('')}}';

                        //Mass Delete
                        $('body').on('click', '#massdeletenotify', function () {
                            var parent = [];
                            var id = [];
                            $('.checkall:checked').each(function(){
                                parent.push($(this).closest('tr'));
                                id.push($(this).val());
                            });
                            if(id.length > 0){
                                swal({
                                    title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                                    text: "{{lang('This might erase your records permanently', 'alerts')}}",
                                    icon: "warning",
                                    buttons: true,
                                    dangerMode: true,
                                })
                                .then((willDelete) => {
                                    if (willDelete) {
                                        $.ajax({
                                            url:"{{ route('faq.deleteall')}}",
                                            method:"post",
                                            data:{id:id},
                                            success:function(data)
                                            {
                                                toastr.success(data.success);
                                                parent.forEach(function(row) {
                                                    row.addClass('fade-out');
                                                });
                                                let newData = tableData.filter(item => !id.includes(String(item.id)));
                                                tableData = newData;
                                                setTimeout(() => {
                                                    parent.forEach(function(row) {
                                                        row.remove();
                                                    });
                                                    if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                                        $('#support-articlelists').DataTable().clear().destroy();
                                                    }
                                                    $('#customCheckAll').prop('checked', false);
                                                    loadTable(tableData);
                                                }, 1500);

                                            },
                                            error:function(data){
                                            }
                                        });
                                    }
                                });
                            }else{
                                toastr.error('{{lang('Please select at least one check box.', 'alerts')}}');
                            }

                        });
                        //Mass Delete

                        $('body').on('click', '#show-delete', function () {
                            let parent = $(this).closest('tr');
                            var _id = $(this).data("id");
                            swal({
                                title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                                text: "{{lang('This might erase your records permanently', 'alerts')}}",
                                icon: "warning",
                                buttons: true,
                                dangerMode: true,
                            })
                            .then((willDelete) => {
                                if (willDelete) {
                                    $.ajax({
                                        type: "delete",
                                        url: `{{url('/admin/faq/delete/${_id}')}}`,
                                        success: function (data) {
                                            toastr.success(data.success);
                                            $(parent[0]).addClass('fade-out');
                                            let newData = tableData.filter(item => item.id != parseInt(_id));
                                            tableData = newData;
                                            setTimeout(() => {
                                                parent[0].remove();
                                                if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                                    $('#support-articlelists').DataTable().clear().destroy();
                                                }
                                                loadTable(tableData);
                                            }, 1500);
                                        },
                                        error: function (data) {
                                            console.log('Error:', data);
                                        }
                                    });
                                }
                            });
                        });


                        //checkbox script
                        $(document).ready(function() {

                            $(document).on('click', '#customCheckAll', function() {
                                $('.checkall').prop('checked', this.checked);
                                updateMassDeleteVisibility();
                            });

                            $(document).on('click', '.checkall', function() {
                                updateCustomCheckAll();
                                updateMassDeleteVisibility();
                            });


                            $(document).on('click', '.pagination a', function() {

                                setTimeout(function() {
                                    updateMassDeleteVisibility();
                                }, 100);
                            });


                            $('#customCheckAll').prop('checked', false);


                            function updateMassDeleteVisibility() {
                                if ($('.checkall:checked').length == 0) {
                                    $('#massdeletenotify').hide();
                                } else {
                                    $('#massdeletenotify').show();
                                }
                            }


                            function updateCustomCheckAll() {
                                var totalCheckboxes = $('.checkall').length;
                                var checkedCheckboxes = $('.checkall:checked').length;

                                if (checkedCheckboxes === totalCheckboxes) {
                                    $('#customCheckAll').prop('checked', true);
                                } else {
                                    $('#customCheckAll').prop('checked', false);
                                }
                            }
                        });


                        // Status change faq
                        $('body').on('click', '.tswitch', function () {
                            var _id = $(this).data("id");
                            var status = $(this).prop('checked') == true ? '1' : '0';
                            $.ajax({
                                type: "post",
                                url: SITEURL + "/admin/faq/status"+_id,
                                data: {'status': status},
                                success: function (data) {
                                    toastr.success(data.success);
                                },
                                error: function (data) {
                                    console.log('Error:', data);
                                }
                            });
                        });

                    })(jQuery);

                    // Add faq
                    function addPost() {
                        $("#faq_id").val('');
                        $(".modal-title").text('{{lang('Add New FAQ')}}');
                        $('#faq_form').trigger("reset");
                        $('#answer').summernote({
                            callbacks: {
                                onPaste: function (e) {
                                    var bufferText = ((e.originalEvent || e).clipboardData || window.clipboardData).getData('Text');
                                    e.preventDefault();
                                    document.execCommand('insertText', false, bufferText);
                                }
                            },
                        disableDragAndDrop:true,
                        });
                        $('#answer').summernote('reset');
                        $('#faqcat_name').select2({
                            dropdownParent: ".sprukofaqcat",
                            minimumResultsForSearch: '',
                            placeholder: "Search",
                            width: '100%'
                        });
                        $.get('faqcategory/list', function(data){

                            $('#faqcat_name').html(data);
                        });
                        $('#addfaq').modal('show');
                    }

                    // edit faq
                    function editPost(event) {
                        var id  = $(event).data("id");
                        let _url = `{{url('/admin/faq/${id}')}}`;
                        $('#questionError').text('');
                        $('#answerError').text('');
                        $('#answer').summernote({
                            callbacks: {
                                onPaste: function (e) {
                                    var bufferText = ((e.originalEvent || e).clipboardData || window.clipboardData).getData('Text');
                                    e.preventDefault();
                                    document.execCommand('insertText', false, bufferText);
                                }
                            },
                        });
                        $('#faqcat_name').select2({
                            dropdownParent: ".sprukofaqcat",
                            minimumResultsForSearch: '',
                            placeholder: "Search",
                            width: '100%'
                        });
                        $.ajax({
                            url: _url,
                            type: "GET",
                            success: function(response) {
                                if(response) {
                                    $('#questionError').text('');
                                    $('#answerError').text('');
                                    $(".modal-title").text('{{lang('Edit FAQ')}}');
                                    $("#faq_id").val(response.post.id);
                                    $("#question").val(response.post.question);
                                    $("#answer").summernote('code',response.post.answer);
                                    $('#faqcat_name').html(response.faqcatlist);
                                    if (response.post.status == "1")
                                    {
                                        $('#status').prop('checked', true);
                                    }
                                    $('#addfaq').modal('show');
                                }
                            }
                        });
                    }

                    // create the faq
                    function createPost() {

                        $('#questionError').text('');
                        $('#answerError').text('');
                        var question = $('#question').val();
                        var answer = $('#answer').val();
                        var faqcatsname = $('#faqcat_name').val();
                        var status = $('#status').prop('checked') == true ? '1' : '0';
                        var id = $('#faq_id').val();
                        var actionType = $('#btnsave').val();
                        var fewSeconds = 2;
                        $('#btnsave').prop('disabled', true);
                            setTimeout(function(){
                                $('#btnsave').prop('disabled', false);
                            }, fewSeconds*1000);
                        let _url = `{{url('/admin/faq/create')}}`;
                        let _token   = $('meta[name="csrf-token"]').attr('content');
                        $.ajax({
                            url:_url,
                            type:"POST",
                            data:{
                                id: id,
                                question: question,
                                answer: answer,
                                status: status,
                                faqcatsname: faqcatsname,
                                _token: _token
                            },
                            success: function(response) {
                                if(response.code == 200) {
                                    $('#questionError').text('');
                                    $('#answerError').text('');
                                    $('#faq_form').trigger("reset");
                                    $('#answer').summernote('reset');
                                    $('#addfaq').modal('hide');
                                    toastr.success(response.success);
                                    location.reload();
                                }
                            },
                            error: function(response) {
                                $('#questionError').text('');
                                $('#answerError').text('');
                                $('#questionError').text(response.responseJSON.errors.question);
                                $('#answerError').text(response.responseJSON.errors.answer);
                                $('#faqcategoryError').text(response.responseJSON.errors.faqcatsname);
                            }
                        });

                    }

                    // cancel faq
                    function cancelPost() {
                        $('#faq_form').trigger("reset");
                        $('#answer').summernote('reset');
                    }
                });

            });

		</script>

		@endsection
