
@extends('layouts.adminmaster')

@section('styles')


<!-- INTERNAl Summernote css -->
<link rel="stylesheet" href="{{asset('build/assets/plugins/summernote/summernote.css')}}?v=<?php echo time(); ?>">

<!-- INTERNAl color css -->
<link rel="stylesheet" href="{{asset('build/assets/plugins/colorpickr/themes/nano.min.css')}}?v=<?php echo time(); ?>">

<!-- INTERNAL Sweet-Alert css -->
<link href="{{asset('build/assets/plugins/sweet-alert/sweetalert.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />


@endsection

@section('content')

    <!--Page header-->
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Envato Setting', 'menu')}}</span></h4>
        </div>
    </div>
    <!--End Page header-->

    <!-- Envato Expires follow this url -->
    <div class="col-xl-12">
        <div class="card ">
            <div class="card-header border-bottom">
                <h4 class="card-title">{{lang('Envato Setting', 'setting')}}</h4>
            </div>
            <form action="{{route('settings.expiredsupport')}}" method="POST">
                @csrf
                <div class="card-body pt-2 pb-2" >
                    <div class="row">

                        <!--- Enable purchase code to employees --->
                        <div class="border-bottom">
                            <div class="col-sm-12 col-md-12">
                                <div class="form-group {{ $errors->has('purchasecode_on') ? ' has-danger' : '' }}">
                                    <div class="switch_section">
                                        <div class="switch-toggle d-flex">
                                            <a class="onoffswitch2">
                                                <input type="checkbox" id="purchasecode_on" name="purchasecode_on" value="on"  class="toggle-class onoffswitch2-checkbox"  @if(setting('purchasecode_on') == 'on') checked="" @endif>
                                                <label for="purchasecode_on" class="toggle-class onoffswitch2-label" ></label>
                                            </a>
                                            <div class="ps-3">
                                                <label class="form-label d-inline">{{lang('Enable purchase code to employees', 'setting')}}</label>
                                                <small class="text-muted"><i>({{lang('If you enable this, employees can see the purchase code submitted by customer’s.', 'setting')}})</i></small>
                                            </div>
                                        </div>
                                    </div>
                                    @if ($errors->has('purchasecode_on'))

                                    <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ $errors->first('purchasecode_on') }}</strong>
                                    </span>
                                    @endif

                                </div>
                            </div>
                        </div>
                        <!--- END Enable purchase code to employees --->

                        <!--- Envato Expired On --->
                        <div class="border-bottom">
                            <div class="col-sm-12 col-md-12 pt-2">
                                <div class="form-group {{ $errors->has('ENVATO_EXPIRED_BLOCK') ? ' has-danger' : '' }}">
                                    <div class="switch_section">
                                        <div class="switch-toggle d-flex mt-4">
                                            <a class="onoffswitch2">
                                                <input type="checkbox" id="envato_expired_on" name="ENVATO_EXPIRED_BLOCK" value="on"  class="toggle-class onoffswitch2-checkbox"  @if(setting('ENVATO_EXPIRED_BLOCK') == 'on') checked="" @endif>
                                                <label for="envato_expired_on" class="toggle-class onoffswitch2-label" ></label>
                                            </a>
                                            <div class="ps-3">
                                                <label class="form-label d-inline">{{lang('Envato Expired On', 'setting')}}</label>
                                                <small class="text-muted"><i>({{lang('If you enable this Envato Expired switch, ticket does not create with an expired license.', 'setting')}})</i></small>
                                            </div>
                                        </div>
                                    </div>
                                    @if ($errors->has('ENVATO_EXPIRED_BLOCK'))

                                    <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ $errors->first('ENVATO_EXPIRED_BLOCK') }}</strong>
                                    </span>
                                    @endif

                                </div>
                            </div>
                        </div>
                        <!--- END Envato Expired On --->

                        <div class="col-xl-12 col-lg-12 col-md-12 mt-4 ps-6 ms-1">
                            <div class="form-group ">
                                <label for="" class="form-label d-inline">{{lang('Support policy URL', 'setting')}} <span class="text-red">*</span></label>
                                <small class="text-muted"><i>({{lang('When a customer tries to create a ticket with an expired license, an alert will be displayed to the customer with the below URL to redirect to your support policies page.', 'setting')}})</i></small>
                                <input class="form-control col-md-6 mt-3 pb-1 {{ $errors->has('SUPPORT_POLICY_URL') ? ' is-invalid' : '' }}" placeholder="{{lang('https://example.com')}}" name="SUPPORT_POLICY_URL" type="text" value="{{ old('SUPPORT_POLICY_URL', setting('SUPPORT_POLICY_URL')) }}" >

                                @if ($errors->has('SUPPORT_POLICY_URL'))

                                <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ $errors->first('SUPPORT_POLICY_URL') }}</strong>
                                </span>
                                @endif

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 card-footer ">
                    <div class="form-group float-end ">
                        <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- End Envato Expires follow this url  -->

@endsection

@section('scripts')


<!-- INTERNAL Summernote js  -->
<script src="{{asset('build/assets/plugins/summernote/summernote.js')}}?v=<?php echo time(); ?>"></script>

<!-- INTERNAL Index js-->
@vite(['resources/assets/js/support/support-sidemenu.js'])
@vite(['resources/assets/js/select2.js'])

<!-- INTERNAL color pickr -->
<script src="{{ asset('build/assets/plugins/colorpickr/pickr.min.js') }}?v=<?php echo time(); ?>"></script>

<!-- INTERNAL Sweet-Alert js-->
<script src="{{asset('build/assets/plugins/sweet-alert/sweetalert.min.js')}}?v=<?php echo time(); ?>"></script>



<script type="text/javascript">

    "use strict";


</script>

@endsection
