@extends('layouts.adminmaster')

@section('styles')

<!-- INTERNAL Data table css -->
<link href="{{asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
<link href="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

<!-- INTERNAL Sweet-Alert css -->
<link href="{{asset('build/assets/plugins/sweet-alert/sweetalert.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

<style>
    #hideAfterloading {
        position: absolute;
        top: 100px;
        left: 45%;
    }
</style>

@endsection

@section('content')

<!--Page header-->
<div class="page-header d-xl-flex d-block">
    <div class="page-leftheader">
        <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Sub-Category')}}</span></h4>
    </div>
</div>
<!--End Page header-->


<div class="col-xl-12 col-lg-12 col-md-12">
    <div class="card ">
        <div class="card-header border-0 d-sm-max-flex flex-wrap gap-2">
            <h4 class="card-title">{{lang('Subcategory List')}}</h4>
            <div class="card-options mt-sm-max-2">
                @can('Subcategory Create')

                    <a href="javascript:void(0)" class="btn btn-secondary me-3" id="create-new-subcategory">{{lang('Add SubCategory')}}</a>
                @endcan


            </div>
        </div>
        <div class="card-body" style="min-height: 250px;">
            <div class="table-responsive  spruko-delete">
                @can('Subcategory Delete')

                <button id="massdelete" class="btn btn-outline-light btn-sm mb-4 data-table-btn" style="display: none;"><i class="fe fe-trash"></i> {{lang('Delete')}}</button>
                @endcan
                <table class="table table-bordered border-bottom text-nowrap w-100" id="support-articlelists">
                    <thead>
                        <tr>
                            <th  width="10">{{lang('Sl.No')}}</th>
                            @can('Subcategory Delete')

                            <th width="10" >
                                <input type="checkbox"  id="customCheckAll" class="form-check-input">
                                <label  for="customCheckAll"></label>
                            </th>
                            @endcan
                            @cannot('Subcategory Delete')

                            <th width="10" >
                                <input type="checkbox"  id="customCheckAll" class="form-check-input" disabled>
                                <label  for="customCheckAll"></label>
                            </th>
                            @endcannot
                            <th >{{lang('Subcategory Name')}}</th>
                            <th >{{lang('Parent Category list')}}</th>
                            <th >{{lang('Status')}}</th>
                            <th >{{lang('Actions')}}</th>
                        </tr>
                    </thead>
                    <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                        <p>{{lang('loading.. Please Wait')}}</p>
                    </div>
                </table>
            </div>
        </div>
        </div>
    </div>
</div>

@endsection


@section('scripts')

<!-- INTERNAL Vertical-scroll js-->
<script src="{{asset('build/assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js')}}?v=<?php echo time(); ?>"></script>

<!-- INTERNAL Data tables -->
<script src="{{asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/dataTables.responsive.min.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js')}}?v=<?php echo time(); ?>"></script>

<!-- INTERNAL Index js-->
@vite(['resources/assets/js/support/support-sidemenu.js'])

<!-- INTERNAL Sweet-Alert js-->
<script src="{{asset('build/assets/plugins/sweet-alert/sweetalert.min.js')}}?v=<?php echo time(); ?>"></script>

<script type="text/javascript">
    "use strict";

    document.addEventListener("DOMContentLoaded", (event) => {

        let tableData = @json($subcategory);
        let delPerm = @json(Auth::user()->can('Subcategory Delete'));
        let editPerm = @json(Auth::user()->can('Subcategory Edit'));
        var SITEURL = '{{ url('') }}';

        var dataTable;
        var tableDropDown;

        loadTable(tableData);

        function truncateTitle(title) {
            const maxLength = 40;
            return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
        }

        function loadTable(tableData) {
            document.getElementById('hideAfterloading')?.classList.remove('d-none');
            document.getElementById('theadShow')?.classList.add('d-none');
            if (tableDropDown)
                tableDropDown.destroy();

            if (dataTable)
                dataTable.destroy();

            if (document.getElementById('tableBody'))
                document.getElementById('tableBody').remove();

            let createTbody = document.createElement('tbody');
            createTbody.setAttribute('id', "tableBody");
            let rows = tableData.map((data, index) => {

                var parentcategory = '';
                data.subcategorylist.map((data2, index2) => {
                    parentcategory += `<span class="badge badge-info-light me-1">${data2.subcatlistss.name}</span>`;
                });

                return `
                    <tr>
                        <td>${index + 1}</td>
                        <td>
                            ${delPerm ? `<input type="checkbox" name="subcategory_checkbox[]" class="checkall form-check-input" value="${data.id}" />` : '~'}
                        </td>

                        <td>${data.subcategoryname}</td>

                        <td>
                            ${parentcategory}
                        </td>

                        <td>
                            <label class="custom-switch form-switch mb-0">
                            ${editPerm ?
                                `<input type="checkbox" name="status" data-id="${data.id}" id="myonoffswitch${data.id}" value="1" class="custom-switch-input stswitch" ${data.status == 1 ? 'checked' : ''}>
								<span class="custom-switch-indicator"></span>`
                                : '~'
                            }
                            </label>
                        </td>

                        <td>
                            <div class="d-flex">
                                ${editPerm
                                    ?
                                    `
                                        <a href="javascript:void(0)" class="action-btns1 edit-subcategory" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Edit')}}"><i class="feather feather-edit text-primary"></i></a>
                                    `
                                    :
                                    '~'
                                }
                                ${delPerm
                                    ?
                                    `
                                        <a href="javascript:void(0)" class="action-btns1 delete-subcategory" data-id="${data.id}" id="show-delete" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Delete')}}"><i class="feather feather-trash-2 text-danger"></i></a>
                                    `
                                    :
                                    '~'
                                }
                            </div>
                        </td>
                    </tr>
                `;
            });

            if (tableData.length == 0)
                createTbody.innerHTML = ` `;
            else
                createTbody.innerHTML = rows.join('');

            document.getElementById('support-articlelists').appendChild(createTbody);

            document.getElementById('hideAfterloading')?.classList.add('d-none');
            document.getElementById('theadShow')?.classList.remove('d-none');

            $(document).ready(function() {

                var SITEURL = '{{ url('') }}';

                // Csrf field
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                let prev = {!! json_encode(lang("Previous")) !!};
                let next = {!! json_encode(lang("Next")) !!};
                let nodata = {!! json_encode(lang("No data available in table")) !!};
                let noentries = {!! json_encode(lang("No entries to show")) !!};
                let showing = {!! json_encode(lang("showing page")) !!};
                let ofval = {!! json_encode(lang("of")) !!};
                let maxRecordfilter = {!! json_encode(lang("- filtered from ")) !!};
                let maxRecords = {!! json_encode(lang("records")) !!};
                let entries = {!! json_encode(lang("entries")) !!};
                let show = {!! json_encode(lang("Show")) !!};
                let search = {!! json_encode(lang("Search")) !!};
                // Datatable
                $('#support-articlelists').dataTable({
                    language: {
                        searchPlaceholder: search,
                        scrollX: "100%",
                        sSearch: '',
                        paginate: {
                        previous: prev,
                        next: next
                        },
                        emptyTable : nodata,
                        infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                        info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                        infoEmpty: noentries,
                        lengthMenu: `${show} _MENU_ ${entries} `,
                    },
                    order:[],
                    columnDefs: [
                        { "orderable": false, "targets":[ 0,1,4] }
                    ],
                });

                $('.form-select').select2({
                    minimumResultsForSearch: Infinity,
                    width: '100%'
                });

                $('.form-select').on('focus', function() {
                    $(this).attr('aria-hidden', 'false');
                });
            });


            initializeTooltips();

            function initializeTooltips() {
                var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                tooltipElements.forEach(function(element) {
                    new bootstrap.Tooltip(element);
                });
            }
        }

        $(function() {
            (function($)  {

                // Variables
                var SITEURL = '{{url('')}}';

                /*  When user click add category button */
                $('#create-new-subcategory').on('click', function () {
                    $('#btnsave').val("create-product");
                    $('#subcategory_id').val('');
                    $('#nameError').html('');
                    $('#displayError').html('');
                    $('#priorityError').html('');
                    $('.categorysub').html('');
                    $('#subcategory_form').trigger("reset");
                    $('.modal-title').html("{{lang('Add New SubCategory')}}");
                    $('.categorysub').select2({
                        minimumResultsForSearch: '',
                    });
                    $.post('category/all', function(data){
                        $('.categorysub').html(data);
                    });

                    $('#addsubcategory').modal('show');


                });

                /* When click edit category */
                $('body').on('click', '.edit-subcategory', function () {
                    var subcategory_id = $(this).data('id');
                    $('.categorysub').select2({
                        minimumResultsForSearch: '',
                    });
                    $.get('subcategories/' + subcategory_id  + '/edit', function (data) {
                        $('#subcategory_form').trigger("reset");
                        $('#nameError').html('');
                        $('#displayError').html('');
                        $('#priorityError').html('');
                        $('.categorysub').html('');
                        $('.modal-title').html("{{lang('Edit Subcategory')}}");
                        $('#btnsave').val("edit-testimonial");
                        $('#addsubcategory').modal('show');
                        $('#subcategory_id').val(data.subcategory.id);
                        $('#name').val(data.subcategory.subcategoryname);
                        $('.categorysub').html(data.categorylist);
                        if (data.subcategory.status == "1")
                        {
                            $('#myonoffswitch18').prop('checked', true);
                        }
                    })
                });


                // Category form submit
                $('body').on('submit', '#subcategory_form', function (e) {
                    e.preventDefault();
                    var actionType = $('#btnsave').val();
                    var fewSeconds = 2;
                    $('#btnsave').html('Sending ... <i class="fa fa-spinner fa-spin"></i>');
                    $('#btnsave').prop('disabled', true);
                        setTimeout(function(){
                            $('#btnsave').prop('disabled', false);
                        }, fewSeconds*1000);
                    var formData = new FormData(this);
                    $.ajax({
                        type:'POST',
                        url: "{{route('subcategorys.store')}}",
                        data: formData,
                        cache:false,
                        contentType: false,
                        processData: false,
                        success: (data) => {
                            if(data.errors){
                                $('#nameError').html('');
                                $('#displayError').html('');
                                $('#priorityError').html('');
                                $('#nameError').html(data.errors.subcategoryname);
                                $('#displayError').html(data.errors.display);
                                $('#priorityError').html(data.errors.priority);
                                $('#btnsave').html('{{lang('Save Changes')}}');

                            }
                            if(data.success){
                                $('#nameError').html('');
                                $('#displayError').html('');
                                $('#priorityError').html('');
                                $('#subcategory_form').trigger("reset");
                                $('#addsubcategory').modal('hide');
                                $('#btnsave').html('{{lang('Save Changes')}}');
                                toastr.success(data.success);
                                if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                    $('#support-articlelists').DataTable().clear().destroy();
                                }
                                tableData = data.subcategory;
                                loadTable(tableData);
                            }

                        },
                        error: function(data){
                            toastr.error('{{lang('SubCategory name already exists', 'alerts')}}');
                            $('#btnsave').html('{{lang('Save Changes')}}');
                        }
                    });
                });

                //status On Off
                $('body').on('change', '.stswitch', function(){
                    let id = $(this).data('id');
                    let status = $(this).prop('checked') == true ? '1' : '0';
                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: '{{route('category.admin.subcategorystatusupdate')}}',
                        data: {
                            'status': status,
                            'id': id,
                        },
                        success:function(data){
                            toastr.success(data.success);
                        },
                        error:function(data){

                        }
                    });
                });

                // Delete subcategory
                $('body').on('click', '.delete-subcategory', function(){
                    let parent = $(this).closest('tr');
                    let id = $(this).data('id');
                    swal({
                        title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                        text: "{{lang('This might erase your records permanently', 'alerts')}}",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            $.ajax({
                                type: "POST",
                                dataType: "json",
                                url: '{{route('category.admin.subcategorydelete')}}',
                                data: {
                                    'id': id,
                                },
                                success:function(data){
                                    toastr.success(data.success);
                                    $(parent[0]).addClass('fade-out');
                                    let newData = tableData.filter(item => item.id != parseInt(id));
                                    tableData = newData;
                                    setTimeout(() => {
                                        parent[0].remove();
                                        if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                            $('#support-articlelists').DataTable().clear().destroy();
                                        }
                                        loadTable(tableData);
                                    }, 1500);
                                },
                                error:function(data){

                                }
                            });
                        }
                    });
                });

                //Mass Delete
                $('body').on('click', '#massdelete', function () {
                    var parent = [];
                    var id = [];
                    $('.checkall:checked').each(function(){
                        parent.push($(this).closest('tr'));
                        id.push($(this).val());
                    });
                    if(id.length > 0){
                        swal({
                            title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                            text: "{{lang('This might erase your records permanently', 'alerts')}}",
                            icon: "warning",
                            buttons: true,
                            dangerMode: true,
                        })
                        .then((willDelete) => {
                            if (willDelete) {
                                $.ajax({
                                    url:"{{ url('admin/subcategory/deleteall')}}",
                                    method:"GET",
                                    data:{id:id},
                                    success:function(data)
                                    {
                                        toastr.success(data.success);
                                        parent.forEach(function(row) {
                                            row.addClass('fade-out');
                                        });
                                        let newData = tableData.filter(item => !id.includes(String(item.id)));
                                        tableData = newData;
                                        setTimeout(() => {
                                            parent.forEach(function(row) {
                                                row.remove();
                                            });
                                            if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                                $('#support-articlelists').DataTable().clear().destroy();
                                            }
                                            $('#customCheckAll').prop('checked', false);
                                            loadTable(tableData);
                                        }, 1500);
                                    },
                                    error:function(data){

                                    }
                                });
                            }
                        });
                    }else{
                        toastr.error('{{lang('Please select at least one check box.', 'alerts')}}');
                    }
                });

                $(document).ready(function() {

                    $(document).on('click', '#customCheckAll', function() {
                        $('.checkall').prop('checked', this.checked);
                        updateMassDeleteVisibility();
                    });

                    // Handle individual checkboxes
                    $(document).on('click', '.checkall', function() {
                        updateCustomCheckAll();
                        updateMassDeleteVisibility();
                    });

                    // Handle pagination controls
                    $(document).on('click', '.pagination a', function() {
                        // Assuming '.pagination a' is the selector for your pagination controls
                        setTimeout(function() {
                            updateMassDeleteVisibility();
                        }, 100);
                    });

                    // Initialize the "Select All" checkbox to unchecked
                    $('#customCheckAll').prop('checked', false);

                    // Function to update the visibility of the mass delete button
                    function updateMassDeleteVisibility() {
                        if ($('.checkall:checked').length == 0) {
                            $('#massdelete').hide();
                        } else {
                            $('#massdelete').show();
                        }
                    }

                    // Function to update the state of the "Select All" checkbox
                    function updateCustomCheckAll() {
                        var totalCheckboxes = $('.checkall').length;
                        var checkedCheckboxes = $('.checkall:checked').length;

                        if (checkedCheckboxes === totalCheckboxes) {
                            $('#customCheckAll').prop('checked', true);
                        } else {
                            $('#customCheckAll').prop('checked', false);
                        }
                    }
                });
            })(jQuery);
        })
    });

</script>

@endsection


@section('modal')

@include('admin.category.subcategorymodal')

@endsection

