@extends('layouts.adminmaster')

@section('styles')
    <!-- INTERNAL Data table css -->
    <link href="{{ asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}?v=<?php echo time(); ?>"
        rel="stylesheet" />
    <link href="{{ asset('build/assets/plugins/datatable/responsive.bootstrap5.css') }}?v=<?php echo time(); ?>" rel="stylesheet" />

    <!-- INTERNAL Sweet-Alert css -->
    <link href="{{ asset('build/assets/plugins/sweet-alert/sweetalert.css') }}?v=<?php echo time(); ?>" rel="stylesheet" />

    <style>
        #hideAfterloading {
            position: absolute;
            top: 100px;
            left: 45%;
        }
    </style>
@endsection

@section('content')

    <!--Page header-->
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{ lang('Category') }}</span></h4>
        </div>
    </div>
    <!--End Page header-->

    <!--Category List -->
    <div class="col-xl-12 col-lg-12 col-md-12">
        <div class="card ">
            <div class="card-header border-0 d-sm-flex d-block">
                <h4 class="card-title">{{ lang('Category List') }}</h4>
                <div class="card-options mt-sm-max-2 d-sm-flex d-block">
                    @can('Category Create')
                        <a href="javascript:void(0)" class="btn btn-secondary me-3 mb-sm-0 mb-2"
                            id="create-new-testimonial">{{ lang('Add Category') }}</a>
                    @endcan

                        @if (setting('ENVATO_ON') == 'on')
                            <button class="btn btn-info mb-sm-0 mb-2"
                                id="envatoapiassign">{{ lang('Envato Api Assign') }}</button>
                        @endif

                </div>
            </div>
            <div class="card-body" style="min-height: 250px;">
                <div class="table-responsive spruko-delete">
                    @can('Category Delete')
                        <button id="massdelete" class="btn btn-outline-light btn-sm mb-4 data-table-btn"  style="display: none;"><i
                                class="fe fe-trash"></i> {{ lang('Delete') }}</button>
                    @endcan
                    <table class="table table-bordered border-bottom text-nowrap w-100" id="support-category">
                        <thead>
                            <tr>
                                <th>{{ lang('Sl.No') }}</th>
                                @can('Category Delete')
                                    <th width="10">
                                        <input type="checkbox" id="customCheckAll" class="form-check-input">
                                        <label for="customCheckAll"></label>
                                    </th>
                                @endcan
                                @cannot('Category Delete')
                                    <th width="10">
                                        <input type="checkbox" id="customCheckAll" class="form-check-input" disabled>
                                        <label for="customCheckAll"></label>
                                    </th>
                                @endcannot
                                <th>{{ lang('Category Name') }}</th>
                                <th>{{ lang('Ticket/Knowledge') }}</th>
                                <th>{{ lang('Assigned Priority') }}</th>
                                <th>{{ lang('Status') }}</th>
                                <th>{{ lang('Actions') }}</th>
                            </tr>
                        </thead>
                        <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                            <p>{{lang('loading.. Please Wait')}}</p>
                        </div>
                    </table>
                </div>
            </div>
        </div>
    </div>
    </div>
    <!-- List Category List -->

@endsection


@section('scripts')
    <!-- INTERNAL Vertical-scroll js-->
    <script src="{{ asset('build/assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js') }}?v=<?php echo time(); ?>"></script>

    <!-- INTERNAL Data tables -->
    <script src="{{ asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/dataTables.responsive.min.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js') }}?v=<?php echo time(); ?>"></script>

    <!-- INTERNAL Index js-->
    @vite(['resources/assets/js/support/support-sidemenu.js'])

    <!--File BROWSER -->
    @vite(['resources/assets/js/form-browser.js'])

    <!-- INTERNAL Sweet-Alert js-->
    <script src="{{ asset('build/assets/plugins/sweet-alert/sweetalert.min.js') }}?v=<?php echo time(); ?>"></script>

    <script type="text/javascript">

        "use strict";

        document.addEventListener("DOMContentLoaded", (event) => {

            let tableData = @json($categories);
            let delPerm = @json(Auth::user()->can('Category Delete'));
            let editPerm = @json(Auth::user()->can('Category Edit'));
            var SITEURL = '{{ url('') }}';

            var dataTable;
            var tableDropDown;

            loadTable(tableData);

            function truncateTitle(title) {
                const maxLength = 40;
                return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
            }

            function loadTable(tableData) {
                document.getElementById('hideAfterloading')?.classList.remove('d-none');
                document.getElementById('theadShow')?.classList.add('d-none');
                if (tableDropDown)
                    tableDropDown.destroy();

                if (dataTable)
                    dataTable.destroy();

                if (document.getElementById('tableBody'))
                    document.getElementById('tableBody').remove();

                let createTbody = document.createElement('tbody');
                createTbody.setAttribute('id', "tableBody");
                let rows = tableData.map((data, index) => {

                    var subcatexists = false;
                    if(data.subcategorydata){
                        subcatexists = true;
                    }

                    var categorypriority = '';
                    if(data.priority){
                        if (data.priority == 'Low'){
                            categorypriority = `<span class="badge badge-success-light">${data.priority}</span>`;
                        }else if(data.priority == 'High'){
                            categorypriority = `<span class="badge badge-danger-light">${data.priority}</span>`;
                        }else if(data.priority == 'Critical'){
                            categorypriority = `<span class="badge badge-danger-dark">${data.priority}</span>`;
                        }else{
                            categorypriority = `<span class="badge badge-warning-light">${data.priority}</span>`;
                        }
                    }else{
                        categorypriority = '~';
                    }

                    return `
                        <tr>
                            <td>${index + 1}</td>
                            <td>
                                ${delPerm && subcatexists ? `<input type="checkbox" name="student_checkbox[]" class="checkall form-check-input" value="${data.id}" />` : '~'}
                            </td>

                            <td>${data.name}</td>

                            <td>${data.display}</td>

                            <td>
                                ${categorypriority}
                            </td>

                            <td>
                                ${editPerm ?
                                    (data.status == '1'
                                    ?
                                    `
                                        <label class="custom-switch form-switch mb-0">
                                            <input type="checkbox" name="status" data-id="${data.id}"
                                                id="myonoffswitch${data.id}" value="1"
                                                class="custom-switch-input tswitch" checked>
                                            <span class="custom-switch-indicator"></span>
                                        </label>
                                    `
                                    :
                                    `
                                        <label class="custom-switch form-switch mb-0">
                                            <input type="checkbox" name="status" data-id="${data.id}"
                                                id="myonoffswitch${data.id}" value="1"
                                                class="custom-switch-input tswitch">
                                            <span class="custom-switch-indicator"></span>
                                        </label>
                                    `
                                    )
                                    : '~'
                                }
                            </td>

                            <td>
                                <div class="d-flex">
                                    ${editPerm
                                        ?
                                        `
                                            <a href="javascript:void(0)" data-id="${data.id}" class="action-btns1 edit-testimonial"> <i class="feather feather-edit text-primary" data-id="${data.id}"data-bs-toggle="tooltip" data-bs-placement="top" title="{{ lang('Edit') }}"></i></a>
                                        `
                                        :
                                        '~'
                                    }
                                    ${delPerm
                                        ?
                                        `
                                            <a href="javascript:void(0)" data-id="${data.id}" class="action-btns1 delete-category"> <i class="feather feather-trash-2 text-danger" data-id="${data.id}"data-bs-toggle="tooltip" data-bs-placement="top" title="{{ lang('Delete') }}"></i></a>
                                        `
                                        :
                                        '~'
                                    }
                                </div>
                            </td>
                        </tr>
                    `;
                });

                if (tableData.length == 0)
                    createTbody.innerHTML = ` `;
                else
                    createTbody.innerHTML = rows.join('');

                document.getElementById('support-category').appendChild(createTbody);

                document.getElementById('hideAfterloading')?.classList.add('d-none');
                document.getElementById('theadShow')?.classList.remove('d-none');

                $(document).ready(function() {

                    var SITEURL = '{{ url('') }}';

                    // Csrf field
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    let prev = {!! json_encode(lang('Previous')) !!};
                    let next = {!! json_encode(lang('Next')) !!};
                    let nodata = {!! json_encode(lang('No data available in table')) !!};
                    let noentries = {!! json_encode(lang('No entries to show')) !!};
                    let showing = {!! json_encode(lang('showing page')) !!};
                    let ofval = {!! json_encode(lang('of')) !!};
                    let maxRecordfilter = {!! json_encode(lang('- filtered from ')) !!};
                    let maxRecords = {!! json_encode(lang('records')) !!};
                    let entries = {!! json_encode(lang('entries')) !!};
                    let show = {!! json_encode(lang('Show')) !!};
                    let search = {!! json_encode(lang('Search')) !!};
                    // Datatable
                    $('#support-category').dataTable({
                        language: {
                            searchPlaceholder: search,
                            scrollX: "100%",
                            sSearch: '',
                            paginate: {
                                previous: prev,
                                next: next
                            },
                            emptyTable: nodata,
                            infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                            info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                            infoEmpty: noentries,
                            lengthMenu: `${show} _MENU_ ${entries} `,
                        },
                        order: [],
                        columnDefs: [{
                            "orderable": false,
                            "targets": [0, 1, 4]
                        }],
                    });


                    // select2 js
                    $('.form-select').select2({
                        minimumResultsForSearch: Infinity,
                        width: '100%'
                    });

                    $('.form-select').on('focus', function() {
                        $(this).attr('aria-hidden', 'false');
                    });
                });


                initializeTooltips();

                function initializeTooltips() {
                    var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                    tooltipElements.forEach(function(element) {
                        new bootstrap.Tooltip(element);
                    });
                }
            }

            $(function() {
                (function($) {

                    // Variables
                    var SITEURL = '{{ url('') }}';

                    let elementToToggle = null;
                    /*  When user click add category button */
                    $('#create-new-testimonial').on('click', function(event) {
                        elementToToggle = event.target;
                        $('#btnsave').val("create-product");
                        $('#testimonial_id').val('');
                        $('#testimonial_form').trigger("reset");
                        $('.modal-title').html("{{ lang('Add New Category') }}");

                        $.post('category/all', function(data) {
                            $('.categorysub').html(data);
                            $('.categorysub').select2({
                                dropdownParent: ".sprukosubcat",
                                minimumResultsForSearch: '',
                                width: '100%',
                            });

                        });
                        $('#addtestimonial').modal('show');

                        checkPro()
                    });

                    function checkPro() {
                        let displayOpt = document.querySelectorAll('.display');
                        displayOpt.forEach((ele, index) => {
                            ele.addEventListener('click', function() {
                                let subCat = document.querySelector('#priority_hide');
                                if (ele.value === 'knowledge') {
                                    subCat.style.display = "none";
                                } else {

                                    subCat.style.display = "block";
                                }
                            })
                        });
                    }

                    /* When click edit category */
                    $('body').on('click', '.edit-testimonial', function(event) {
                        elementToToggle = event.target;
                        var testimonial_id = $(this).data('id');
                        $.get('categories/' + testimonial_id + '/edit', function(data) {
                            $('#nameError').html('');
                            $('#displayError').html('');
                            $('#priorityError').html('');
                            $('.modal-title').html("{{ lang('Edit Category') }}");
                            $('#btnsave').val("edit-testimonial");
                            $('#addtestimonial').modal('show');
                            $('#testimonial_id').val(data.post.id);
                            $('#name').val(data.post.name);
                            if (data.post.display == "both") {
                                $('#display').prop('checked', true);
                            }
                            if (data.post.display == "ticket") {
                                $('#display1').prop('checked', true);
                            }
                            if (data.post.display == "knowledge") {
                                $('#display2').prop('checked', true);
                            }
                            if (data.post.priority == "Low") {
                                $('#priority').prop('checked', true);
                            }
                            if (data.post.priority == "Medium") {
                                $('#priority1').prop('checked', true);
                            }
                            if (data.post.priority == "High") {
                                $('#priority2').prop('checked', true);
                            }
                            if (data.post.priority == "Critical") {
                                $('#priority3').prop('checked', true);
                            }
                            if (data.post.status == "1") {
                                $('#myonoffswitchmain').prop('checked', true);
                            }
                            $('.categorysub').select2({
                                dropdownParent: ".sprukosubcat",
                                minimumResultsForSearch: '',
                                width: '100%',

                            });
                            $('.categorysub').html(data.output);

                            let displayOpt = document.querySelectorAll('.display');
                            displayOpt.forEach((ele, index) => {
                                if (ele.checked) {
                                    let subCat = document.querySelector('#priority_hide');
                                    if (ele.value === 'knowledge') {
                                        subCat.style.display = "none";
                                    } else {

                                        subCat.style.display = "block";
                                    }
                                }
                            })
                            checkPro();


                        })
                    });

                    $('#testimonial_form .btnsave').on('click', function() {
                        elementToToggle.checked = !elementToToggle.checked;
                    })

                    /* When click delete category */
                    $('body').on('click', '.delete-category', function() {
                        let parent = $(this).closest('tr');
                        var _id = $(this).data("id");
                        swal({
                            title: `{{ lang('Are you sure you want to continue?', 'alerts') }}`,
                            text: "{{ lang('This might erase your records permanently', 'alerts') }}",
                            icon: "warning",
                            buttons: true,
                            dangerMode: true,
                        })
                        .then((willDelete) => {
                            if (willDelete) {
                                $.ajax({
                                    type: "get",
                                    url: SITEURL + "/admin/categories/" + _id,
                                    success: function(data) {
                                        toastr.success(data.success);
                                        $(parent[0]).addClass('fade-out');
                                        let newData = tableData.filter(item => item.id != parseInt(_id));
                                        tableData = newData;
                                        setTimeout(() => {
                                            parent[0].remove();
                                            if ($.fn.DataTable.isDataTable('#support-category')) {
                                                $('#support-category').DataTable().clear().destroy();
                                            }
                                            loadTable(tableData);
                                        }, 1500);
                                    },
                                    error: function(data) {
                                        console.log('Error:', data);
                                    }
                                });
                            }
                        });
                    });

                    // Category status change
                    $('body').on('click', '.tswitch', function() {
                        var _id = $(this).data("id");
                        var status = $(this).prop('checked') == true ? '1' : '0';
                        $.ajax({
                            type: "get",
                            url: SITEURL + "/admin/categories/status" + _id,
                            data: {
                                'status': status
                            },
                            success: function(data) {
                                toastr.success(data.success);
                                // location.reload();
                            },
                            error: function(data) {
                                console.log('Error:', data);
                            }
                        });
                    });

                    // Category form submit
                    $('body').on('submit', '#testimonial_form', function(e) {
                        e.preventDefault();
                        var actionType = $('#btnsave').val();
                        var fewSeconds = 2;
                        $('#btnsave').html('Sending ... <i class="fa fa-spinner fa-spin"></i>');
                        $('#btnsave').prop('disabled', true);
                        setTimeout(function() {
                            $('#btnsave').prop('disabled', false);
                        }, fewSeconds * 1000);
                        var formData = new FormData(this);
                        $.ajax({
                            type: 'POST',
                            url: SITEURL + "/admin/categories/create",
                            data: formData,
                            cache: false,
                            contentType: false,
                            processData: false,
                            success: (data) => {
                                if (data.errors) {
                                    $('#nameError').html('');
                                    $('#displayError').html('');
                                    $('#nameError').html(data.errors.name);
                                    if(data?.errors?.display){
                                        $('#displayError').html('The View on field is required');
                                    }
                                    $('#btnsave').html('{{ lang('Save Changes') }}');

                                }
                                if (data.success) {
                                    $('#nameError').html('');
                                    $('#displayError').html('');
                                    $('#testimonial_form').trigger("reset");
                                    $('#addtestimonial').modal('hide');
                                    $('#btnsave').html('{{ lang('Save Changes') }}');
                                    toastr.success(data.success);
                                    // location.reload();
                                    if ($.fn.DataTable.isDataTable('#support-category')) {
                                        $('#support-category').DataTable().clear().destroy();
                                    }
                                    tableData = data.categories;
                                    loadTable(tableData);
                                }

                            },
                            error: function(data) {
                                toastr.error('{{ lang('Category name already exists', 'alerts') }}');
                                $('#btnsave').html('{{ lang('Save Changes') }}');
                            }
                        });
                    });

                    // Assign Envato api validation
                    $('#envatoapiassign').on('click', function() {

                        $('.modal-title').html("{{ lang('Assign Envato Api') }}");
                        $('#category_form').trigger("reset");
                        $('.select2_envato').select2({

                            minimumResultsForSearch: '',
                            placeholder: "Search",
                            width: '100%'

                        });

                        $.get('categorylist/', function(data) {
                            $('#categorys').html(data);
                        });
                        $('#addEnvatoapi').modal('show');

                    });

                    // Submit the form of envato api assigning
                    $('body').on('submit', '#categoryenvato_form', function(e) {
                        e.preventDefault();
                        $('#envatocatbtnsave').html('Sending ... <i class="fa fa-spinner fa-spin"></i>');
                        var formData = new FormData(this);
                        $.ajax({
                            type: 'POST',
                            url: SITEURL + "/admin/categoryenvatoassign",
                            data: formData,
                            cache: false,
                            contentType: false,
                            processData: false,
                            success: (data) => {
                                $('#envatocatbtnsave').html(`{{lang('Save')}}`);
                                toastr.success(data.success);
                                $('#category_form').trigger("reset");
                                $('#addEnvatoapi').modal('hide');
                            },
                            error: (data) => {
                                $('#envatocatbtnsave').html(`{{lang('Save')}}`);
                            }
                        });
                    });

                    //Mass Delete
                    $('body').on('click', '#massdelete', function() {
                        var parent = [];
                        var id = [];
                        $('.checkall:checked').each(function() {
                            parent.push($(this).closest('tr'));
                            id.push($(this).val());
                        });
                        if (id.length > 0) {
                            swal({
                                    title: `{{ lang('Are you sure you want to continue?', 'alerts') }}`,
                                    text: "{{ lang('This might erase your records permanently', 'alerts') }}",
                                    icon: "warning",
                                    buttons: true,
                                    dangerMode: true,
                                })
                                .then((willDelete) => {
                                    if (willDelete) {
                                        $.ajax({
                                            url: "{{ route('category.deleteall') }}",
                                            method: "GET",
                                            data: {
                                                id: id
                                            },
                                            success: function(data) {
                                                toastr.success(data.success);
                                                parent.forEach(function(row) {
                                                    row.addClass('fade-out');
                                                });
                                                let newData = tableData.filter(item => !id.includes(String(item.id)));
                                                tableData = newData;
                                                setTimeout(() => {
                                                    parent.forEach(function(row) {
                                                        row.remove();
                                                    });
                                                    if ($.fn.DataTable.isDataTable('#support-category')) {
                                                        $('#support-category').DataTable().clear().destroy();
                                                    }
                                                    $('#customCheckAll').prop('checked', false);
                                                    loadTable(tableData);
                                                }, 1500);
                                            },
                                            error: function(data) {

                                            }
                                        });
                                    }
                                });
                        } else {
                            toastr.error('{{ lang('Please select at least one check box.', 'alerts') }}');
                        }
                    });


                    $(document).ready(function() {

                        $(document).on('click', '#customCheckAll', function() {
                            $('.checkall').prop('checked', this.checked);
                            updateMassDeleteVisibility();
                        });

                        // Handle individual checkboxes
                        $(document).on('click', '.checkall', function() {
                            updateCustomCheckAll();
                            updateMassDeleteVisibility();
                        });

                        // Handle pagination controls
                        $(document).on('click', '.pagination a', function() {
                            // Assuming '.pagination a' is the selector for your pagination controls
                            setTimeout(function() {
                                updateMassDeleteVisibility();
                            }, 100);
                        });

                        // Initialize the "Select All" checkbox to unchecked
                        $('#customCheckAll').prop('checked', false);

                        // Function to update the visibility of the mass delete button
                        function updateMassDeleteVisibility() {
                            if ($('.checkall:checked').length == 0) {
                                $('#massdelete').hide();
                            } else {
                                $('#massdelete').show();
                            }
                        }

                        // Function to update the state of the "Select All" checkbox
                        function updateCustomCheckAll() {
                            var totalCheckboxes = $('.checkall').length;
                            var checkedCheckboxes = $('.checkall:checked').length;

                            if (checkedCheckboxes === totalCheckboxes) {
                                $('#customCheckAll').prop('checked', true);
                            } else {
                                $('#customCheckAll').prop('checked', false);
                            }
                        }
                    });


                })(jQuery);
            })
        });
    </script>
@endsection


@section('modal')
    @include('admin.category.modal')

    @include('admin.category.groupmodal')

    @include('admin.category.envatocategorylist')
@endsection
