@extends('layouts.adminmaster')
@section('styles')
<style>
    @media (max-width: 1268px) {
        .responsive-width {
            max-width: fit-content;
        }
    }

    #hideAfterloading {
        position: absolute;
        top: 100px;
        left: 45%;
    }
</style>
    <!-- INTERNAL Data table css -->
    <link href="{{ asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}?v=<?php echo time(); ?>"
        rel="stylesheet" />
    <link href="{{ asset('build/assets/plugins/datatable/responsive.bootstrap5.css') }}?v=<?php echo time(); ?>" rel="stylesheet" />
@endsection

@section('content')


    {{-- ADDONS TABLE START --}}
    {{-- page header start --}}
    <div class="page-header d-sm-flex d-block">
        <div class="page-leftheader">
            <div class="page-title">{{ lang('Addons') }}</div>
        </div>

    </div>
    {{-- page header start --}}

    {{-- card start --}}
    <div class="card">
        <div class="card-header  border-0">
            <h4 class="card-title">{{ lang('Addons') }}</h4>

        </div>

        <div class="card-body" style="min-height: 250px;">
            <div class="table-responsive spruko-delete">

                <table class="table table-bordered border-bottom text-nowrap ticketdeleterow w-100" id="addonTable">
                    <thead>
                        <tr>
                            <th width="10">{{ lang('Sl.No') }}</th>

                            <th>{{ lang('Addon Type') }}</th>
                            <th>{{ lang('Name') }}</th>
                            <th>{{ lang('Icon') }}</th>
                            <th>{{ lang('Version') }}</th>
                            <th>{{ lang('Status') }}</th>
                            <th>{{ lang('Last Updated') }}</th>
                            <th>{{ lang('Actions') }}</th>
                        </tr>
                    </thead>
                    <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                        <p>{{lang('loading.. Please Wait')}}</p>
                    </div>
                </table>
            </div>
        </div>
    </div>


    {{-- card end --}}



    {{-- ADDONS TABLE END --}}
@endsection

@section('modal')
    @include('admin.addons.modal')
    @include('admin.addons.update')
@endsection

@section('scripts')
    <!-- INTERNAL Data tables -->
    <script src="{{ asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/dataTables.responsive.min.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/datatablebutton.min.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/buttonbootstrap.min.js') }}?v=<?php echo time(); ?>"></script>
    <!-- INTERNAL Sweet-Alert js-->
    <script src="{{asset('build/assets/plugins/sweet-alert/sweetalert.min.js')}}"></script>

    <!-- INTERNAL Sweet-Alert css -->
    <link href="{{asset('build/assets/plugins/sweet-alert/sweetalert.css')}}" rel="stylesheet" />


    <script src="{{ asset('build/assets/plugins/jquery/jquery-ui.js') }}?v=<?php echo time(); ?>"></script>

    <script type="text/javascript">
        "use strict";

        document.addEventListener("DOMContentLoaded", (event) => {

            let tableData = @json($addondata);

            let dateFormat = @json(setting('date_format'));
            let editPerm = @json(Auth::user()->can('Addon Edit'));

            var dataTable;
            var tableDropDown;

            loadTable(tableData);

            function truncateTitle(title) {
                const maxLength = 40;
                return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
            }

            function formatfjy(createdTime) {
                const options = { year: 'numeric', month: 'long', day: 'numeric' };
                const date = new Date(createdTime);
                return date.toLocaleDateString('en-US', options);
            }

            function loadTable(tableData) {
                document.getElementById('hideAfterloading')?.classList.remove('d-none');
                document.getElementById('theadShow')?.classList.add('d-none');
                if (tableDropDown)
                    tableDropDown.destroy();

                if (dataTable)
                    dataTable.destroy();

                if (document.getElementById('tableBody'))
                    document.getElementById('tableBody').remove();

                let createTbody = document.createElement('tbody');
                createTbody.setAttribute('id', "tableBody");

                let rows = tableData.map((data, index) => {
                    var imageurl = "{{ asset(':imageviewurl') }}".replace(':imageviewurl', data.image);

                    return `
                        <tr class="odd">
                            <td class="sorting_1">${index + 1}</td>

                            <td class="font-weight-semibold">${data.type}</td>

                            <td class="font-weight-semibold">${data.name}</td>

                            <td>
                                <img src="${imageurl}" width="50px" height="50px" alt="erre" class="responsive-width">
                            </td>

                            <td>${data.version}</td>

                            <td>
                                <label class="custom-switch form-switch mb-0">
                                    ${editPerm ?
                                        `<input type="checkbox" name="status" data-id="${data.id}" id="storageAddonstatus-${data.id}" value="1"  class="custom-switch-input tswitch" ${data.addonstatus ? checked : ''}>
                                        <span class="custom-switch-indicator"></span>`
                                        :
                                        '~'
                                    }
                                </label>
                            </td>

                            <td>
                                <span>${formatfjy(data.created_at)}</span>
                            </td>

                            <td>
                                <div class="d-flex">
                                    <a href="javascript:void(0);" class="action-btns1" id="updatemodal-${data.id}" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{ lang('Update credentials') }}"><i class="feather feather-edit text-primary"></i></a>
                                </div>
                            </td>

                        </tr>
                    `;
                });

                if (tableData.length == 0)
                    createTbody.innerHTML = ` `;
                else
                    createTbody.innerHTML = rows.join('');


                // Append the tbody to your table
                // Replace 'your-table-id' with the actual ID of your table element
                document.getElementById('addonTable').appendChild(createTbody);

                document.getElementById('hideAfterloading')?.classList.add('d-none');
                document.getElementById('theadShow')?.classList.remove('d-none');

                $(document).ready(function() {

                    var SITEURL = '{{ url('') }}';

                    // Csrf field
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });


                    let prev = {!! json_encode(lang('Previous')) !!};
                    let next = {!! json_encode(lang('Next')) !!};
                    let nodata = {!! json_encode(lang('No data available in table')) !!};
                    let noentries = {!! json_encode(lang('No entries to show')) !!};
                    let showing = {!! json_encode(lang('showing page')) !!};
                    let ofval = {!! json_encode(lang('of')) !!};
                    let maxRecordfilter = {!! json_encode(lang('- filtered from ')) !!};
                    let maxRecords = {!! json_encode(lang('records')) !!};
                    let entries = {!! json_encode(lang('entries')) !!};
                    let show = {!! json_encode(lang('Show')) !!};
                    let search = {!! json_encode(lang('Search')) !!};
                    // Datatable

                    $('#addonTable').dataTable({
                        language: {
                            searchPlaceholder: search,
                            scrollX: "100%",
                            sSearch: '',
                            paginate: {
                                previous: prev,
                                next: next
                            },
                            emptyTable: nodata,
                            infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                            info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                            infoEmpty: noentries,
                            lengthMenu: `${show} _MENU_ ${entries} `,
                        },
                        order: [],
                        columnDefs: [{
                            "orderable": false,
                            "targets": [0, 1, 4]
                        }],
                    });


                    $('.form-select').select2({
                        minimumResultsForSearch: Infinity,
                        width: '100%'
                    });

                    $('.form-select').on('focus', function() {
                        $(this).attr('aria-hidden', 'false');
                    });
                });


                initializeTooltips();

                function initializeTooltips() {
                    var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                    tooltipElements.forEach(function(element) {
                        new bootstrap.Tooltip(element);
                    });
                }


            }

            $(function() {

                // Variables
                var SITEURL = '{{ url('') }}';
                let elementToToggle = null;

                //trigger next modal
                $("#addaddonmodal").on("click", function(event) {
                    elementToToggle = event.target;
                    $('#addonform').trigger("reset");
                    $('#addonsave').html("Add");
                    $('.modal-title').html("{{ lang('Upload Addon') }}");
                    $('#addonmodal').modal('show');
                });

                $('#addonmodal #addonclosebtn').on('click', function() {
                    elementToToggle.checked = !elementToToggle.checked;
                })

                //trigger update modal
                @foreach ($addondata as $addon)
                    var isRequestInProgress = false;
                    document.querySelector('#updatemodal-{{ $addon->id }}')?.addEventListener('click', function() {
                        if (isRequestInProgress) {
                            return;
                        }

                        isRequestInProgress = true;
                        document.querySelector('#updateform').reset();
                        var addonid = this.getAttribute('data-id');
                        var $this = this;
                        $this.disabled = true;

                        document.querySelector('#addonData').innerHTML = '';

                        fetch(SITEURL + '/admin/addons/' + addonid)
                            .then(function(response) {
                                return response.json();
                            })
                            .then(function(data) {

                                document.querySelector('#updatemodall').style.display = 'block';
                                $('.modal-title').html("{{ lang('Update') }} " + data[1] +
                                    " {{ lang('Credentials') }}");
                                document.querySelector('#addonid').value = data[2];
                                document.querySelector('#updatesave').innerHTML = "Save";
                                var i = 1;
                                for (var element of data[0]) {
                                    var formGroup = document.createElement('div');
                                    formGroup.className = 'form-group';
                                    var label = document.createElement('label');
                                    label.className = 'form-label';
                                    label.innerHTML = '<span class="addon" id="label"></span> ' + element +
                                        '<span class="text-red">*</span>';
                                    var input = document.createElement('input');
                                    input.type = 'text';
                                    input.name = element;
                                    input.className = 'form-control';
                                    input.placeholder = 'Enter ' + element;
                                    input.id = 'id' + i;
                                    input.required = true;
                                    var errorMessage = document.createElement('span');
                                    errorMessage.className = 'text-red';
                                    errorMessage.id = element + 'Error';
                                    formGroup.appendChild(label);
                                    formGroup.appendChild(input);
                                    formGroup.appendChild(errorMessage);
                                    document.querySelector('#addonData').appendChild(formGroup);
                                    i++;
                                }
                                if (data[3]) {
                                    if (document.querySelector('#id1')) {
                                        document.querySelector('#id1').value = data[3]['access_key_id'];
                                    }
                                    if (document.querySelector('#id2')) {
                                        document.querySelector('#id2').value = data[3]['secret_access_key'];
                                    }
                                    if (document.querySelector('#id3')) {
                                        document.querySelector('#id3').value = data[3]['default_region'];
                                    }
                                    if (document.querySelector('#id4')) {
                                        document.querySelector('#id4').value = data[3]['bucket'];
                                    }
                                    if (document.querySelector('#id5')) {
                                        document.querySelector('#id5').value = data[3]['endpoint'];
                                    }
                                }
                                new bootstrap.Modal(document.querySelector('#updatemodall')).show();
                                isRequestInProgress = false;
                            })
                            .catch(function(error) {
                                console.error('Error:', error);
                                isRequestInProgress = false;
                            });
                    });
                @endforeach

                //update credentials
                $('body').on("click", "#updatesave", function() {
                    var form = document.getElementById('updateform');
                    var formData = new FormData(form);

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: '{{ route('update.credentials') }}',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,

                        success: function(data) {
                            toastr.success('{{ lang('Updated successfully .', 'alerts') }}');
                            location.reload();

                        },
                        error: function(data) {
                            toastr.error('{{ lang('Please fill required fields.', 'alerts') }}');
                        }
                    });
                });

                //status on and off
                @foreach ($addondata as $addon)
                    $('body').on('change', '#addonstatus-{{ $addon->id }}', function() {
                        var _id = $(this).data("id");

                        var status = $(this).prop('checked') == true ? '1' : '0';
                            if(status == '1'){
                                swal({
                                title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                                text: "{{lang('If you enable it, this will be Active.', 'alerts')}}",
                                icon: "warning",
                                buttons: true,
                                dangerMode: true,
                                })
                            .then((willDelete) => {
                                if (willDelete) {
                                    $.ajax({
                                    type: "post",
                                    url: SITEURL + "/admin/addons/statuschange/" + _id,
                                    data: {
                                        'status': status
                                    },
                                    success: function(data) {

                                        if (data == 1) {
                                            toastr.error('{{ lang('Please setup credentials .', 'alerts') }}');
                                            $('#addonstatus-{{ $addon->id }}').prop('checked', false);

                                        } else {
                                            if(data ==3){
                                                toastr.error('{{ lang('Something went wrong .', 'alerts') }}');
                                                $('#addonstatus-{{ $addon->id }}').prop('checked', false);
                                            }else{

                                                toastr.success('{{ lang('Updated successfully .', 'alerts') }}');
                                            }

                                        }

                                        // location.reload();
                                    },
                                    error: function(data) {
                                        console.log('Error:', data);
                                    }
                            });


                                }else{
                                    $('#addonstatus-{{ $addon->id }}').prop('checked', false);
                                }


                            });
                        }else{
                            $.ajax({
                                    type: "post",
                                    url: SITEURL + "/admin/addons/statuschange/" + _id,
                                    data: {
                                        'status': status
                                    },
                                    success: function(data) {
                                        if (data == 1) {
                                            toastr.error('{{ lang('Please setup credentials .', 'alerts') }}');
                                            $('#addonstatus-{{ $addon->id }}').prop('checked', false);

                                        } else {

                                            toastr.success('{{ lang('Updated successfully .', 'alerts') }}');
                                        }

                                        // location.reload();
                                    },
                                    error: function(data) {
                                        console.log('Error:', data);
                                    }
                            });
                        }
                    });



                @endforeach



                //storage addon status
                @foreach ($storageAddons as $addon)
                    $('body').on('change', '#storageAddonstatus-{{ $addon->id }}', function() {
                        var _id = $(this).data("id");

                        var status = $(this).prop('checked') == true ? '1' : '0';
                            if(status == '1'){
                                swal({
                                title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                                text: "{{lang('If you enable it, this will become the default storage.', 'alerts')}}",
                                icon: "warning",
                                buttons: true,
                                dangerMode: true,
                                })
                            .then((willDelete) => {
                                if (willDelete) {
                                    $.ajax({
                                    type: "post",
                                    url: SITEURL + "/admin/addons/statuschange/" + _id,
                                    data: {
                                        'status': status
                                    },
                                    success: function(data) {

                                        if (data == 1) {
                                            toastr.error('{{ lang('Please setup credentials .', 'alerts') }}');
                                            $('#storageAddonstatus-{{ $addon->id }}').prop('checked', false);

                                        } else {
                                            if(data ==3){
                                                toastr.error('{{ lang('Something went wrong .', 'alerts') }}');
                                                $('#storageAddonstatus-{{ $addon->id }}').prop('checked', false);
                                            }else{
                                                toastr.success('{{ lang('Updated successfully .', 'alerts') }}');
                                                location.reload();

                                            }

                                        }


                                    },
                                    error: function(data) {
                                        console.log('Error:', data);
                                    }
                            });


                                }else{
                                    $('#storageAddonstatus-{{ $addon->id }}').prop('checked', false);
                                }


                            });
                        }else{
                            $.ajax({
                                    type: "post",
                                    url: SITEURL + "/admin/addons/statuschange/" + _id,
                                    data: {
                                        'status': status
                                    },
                                    success: function(data) {
                                        if (data == 1) {
                                            toastr.error('{{ lang('Please setup credentials .', 'alerts') }}');
                                            $('#storageAddonstatus-{{ $addon->id }}').prop('checked', false);

                                        } else {

                                            toastr.success('{{ lang('Successfully disabled .', 'alerts') }}');
                                        }

                                        // location.reload();
                                    },
                                    error: function(data) {
                                        console.log('Error:', data);
                                    }
                            });
                        }
                    });



                @endforeach

                // Application Purchase Code Validation
                var isRequestInValid = false;
                $("body").on('keyup', '#applicationPurchasecode', function() {

                    let value = $(this).val();
                    let item = "application";
                    if (value != '') {
                        if(value.length == '36'){

                            if (isRequestInValid) {
                                return;
                            }
                            isRequestInValid = true;
                            $.ajax({
                                url: "{{ route('application.EnavatoVerify') }}",
                                method: "POST",
                                data: {data: value,item:item},

                                dataType:"json",

                                success: function (data) {

                                    if(data.valid){
                                        $("#purchasecode").prop("disabled", false);
                                        // Enable the addon file input
                                        toastr.success(data.success);
                                    }else{
                                        $("#purchasecode").prop("disabled", true);
                                        toastr.error(data.error);
                                    }
                                    isRequestInValid = false;

                                },
                                error: function (data) {

                                }
                            });
                        }else if(value.length > 36){
                            toastr.error('Invalid Purchase Code.');
                            $("#purchasecode").prop("disabled", true);
                            $("#addon").prop("disabled", true);
                        }else{
                            $("#purchasecode").prop("disabled", true);
                            $("#addon").prop("disabled", true);
                        }
                    }else{
                        toastr.error('Purchase Code field is Required');
                        $('.purchasecode').attr('disabled', true);
                        $("#addon").prop("disabled", true);
                        $('#envato_id').css('border', '1px solid #e13a3a');

                    }
                });



                // Addon Purchase Code Validation
                var isRequestAddon = false;
                $("body").on('keyup', '#purchasecode', function() {

                    let value = $(this).val();
                    let item = "addon";

                    if (value != '') {
                        if(value.length == '36'){

                            if (isRequestAddon) {
                                return;
                            }
                            isRequestAddon = true;
                            $.ajax({
                                url: "{{ route('application.EnavatoVerify') }}",
                                method: "POST",
                                data: {data: value,item:item},

                                dataType:"json",

                                success: function (data) {

                                    if(data.valid){
                                        // Enable the addon file input

                                        $("#addon").prop("disabled", false);
                                        $("#addonsave").prop("disabled", false);
                                        toastr.success(data.success);
                                    }else{
                                        $("#purchasecode").prop("disabled", true);
                                        toastr.error(data.error);
                                    }
                                    isRequestAddon = false;

                                },
                                error: function (data) {

                                }
                            });
                        }else if(value.length > 36){
                            toastr.error('Invalid purchase code.');
                            $("#addon").prop("disabled", true);
                            $("#addonsave").prop("disabled", true);
                        }else{
                            $("#addon").prop("disabled", true);
                            $("#addonsave").prop("disabled", true);
                        }
                    }else{
                        toastr.error('Purchase Code field is Required');
                        $("#addon").prop("disabled", true);
                        $("#addonsave").prop("disabled", true);
                        $('#envato_id').css('border', '1px solid #e13a3a');
                    }
                });



                //addons save
                $('body').on("click", "#addonsave", function() {
                    var form = document.getElementById('addonform');
                    var formData = new FormData(form);
                    $('#addonform').submit(function(event) {
                        event.preventDefault();
                    });
                    $('#loadingIndicator').show();

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: '{{ route('addon.setup') }}',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,

                        success: function(data) {

                            var toastrMessage = '';
                            switch (data) {
                                case 0:
                                    toastrMessage = `{{ lang('Invalid Purchase code.', 'alerts') }}`;
                                    break;
                                case 1:
                                    toastrMessage =
                                        `{{ lang('Invalid file format. Please upload a ZIP file.', 'alerts') }}`;
                                    break;
                                case 2:
                                    toastrMessage = `{{ lang('Failed to open the ZIP file.', 'alerts') }}`;
                                    break;
                                case 3:
                                    toastrMessage = `{{ lang('livachatAddon.json file missing.', 'alerts') }}`;
                                    break;
                                case 4:
                                    toastrMessage = `{{ lang('Failed to save addon.', 'alerts') }}`;
                                    break;
                                case 5:
                                    toastrMessage =
                                        `{{ lang('Something went wrong please try again.', 'alerts') }}`;
                                    break;
                                case 6:
                                    toastrMessage = `{{ lang('Addon already exists.', 'alerts') }}`;
                                    break;
                                case 7:
                                    toastrMessage =
                                        `{{ lang('Invalid purchase code for this item .', 'alerts') }}`;
                                    break;
                                case 8:
                                    toastrMessage = `{{ lang('Invalid Purchase code.', 'alerts') }}`;
                                    break;
                                case 9:
                                    toastrMessage = `{{ lang('Purchase code is already used.', 'alerts') }}`;
                                    break;
                                case 10:
                                    toastrMessage = `{{ lang('The buyer name of the addon does not match the buyer name of the application. Please verify and ensure that both names match or contact support for assistance.', 'alerts') }}`;
                                    break;
                                case 11:
                                    toastrMessage = `{{ lang('The purchase code is valid, but it is associated with a different installation URL. Please make sure you are using the correct purchase code for this installation.', 'alerts') }}`;
                                    break;
                                default:
                                    $('#addonmodal').modal('hide');
                                    $('#loadingIndicator').hide();
                                    toastr.success(data.success);
                                    location.reload();
                                    return;
                            }

                            $('#loadingIndicator').hide();
                            toastr.error(toastrMessage);

                        },
                        error: function(data) {
                            $('#loadingIndicator').hide();
                            toastr.error('{{ lang('Please fill required fields.', 'alerts') }}');
                        }
                    });
                });
            });
        });

    </script>
@endsection
