<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use DB;

class EmailTemplatesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('email_templates')->insert([
            [
                'code' => 'customer_send_ticket_created',
                'title' => 'Send email to customer, when a ticket is created.',
                'subject' => 'We received your ticket successfully.',
                'body' => '<p>Dear {{ticket_username}},</p><p><br></p><p>We would like to acknowledge that we have received your request and a ticket has been created.</p><p>A support representative will be reviewing your request and will send you a personal response.(usually within 24 hours).</p><p><br></p><p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'ticket_username,ticket_title,ticket_id,ticket_status,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'code' => 'admin_send_email_ticket_created',
                'title' => 'Send email to admin when ticket is created',
                'subject' => 'New ticket has been created.',
                'body' => '<p>Dear Admin,</p><p>A ticket has been created with Ticket ID {{ticket_id}}.&nbsp;<br></p><p>Assign the ticket to support representatives who will be reviewing the request.</p><p>To view the status of the ticket or add comments, please visit,</p><p><a href="{{ticket_admin_url}}" target="_blank">{{ticket_admin_url}}</a></p><p><br></p><p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'ticket_username,ticket_id, ticket_title,ticket_status,ticket_description,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],
            // When ticke get reply by Admin
            [
                'code' => 'customer_send_ticket_reply',
                'title' => 'Send email to customers, when they get reply to ticket.',
                'subject' => 'You got reply for the ticket',
                'body' => '<p>Our support representatives have started reviewing your request.<br></p><p>Thank you for reaching us</p><p>Your Ticket Title: {{ticket_title}}<br></p><p>Your Ticket ID: {{ticket_id}}</p><p>Recent Reply: {{comment}}</p><p><br></p><p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'ticket_username,ticket_title,ticket_id,ticket_status,comment,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // When ticket is closed by Admin/Employee
            [
                'code' => 'customer_rating',
                'title' => 'Customer rating for agents.',
                'subject' => 'Your ticket {{ticket_id}} has been closed successfully.',
                'body' => '<p class="root-block-node" data-paragraphid="33" data-from-init="true" data-changed="false">Dear {{ticket_username}},</p><p class="root-block-node" data-paragraphid="34" data-from-init="true" data-changed="false">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Your ticket {{ticket_id}} has been closed by our support team. We’re always looking for ways to improve and would love to know how we did recently.</p><p class="root-block-node" data-paragraphid="34" data-from-init="true" data-changed="false">How would you rate the support you received?</p><p>Please click on the link to rate us:&nbsp;<a href="{{ratinglink}}">Click here</a></p><p class="root-block-node" data-changed="false" data-paragraphid="45"><br></p><p class="root-block-node" data-changed="false" data-paragraphid="45">Sincerely,<br></p><p class="root-block-node" data-changed="false" data-paragraphid="45">Support Team</p>',
                'variables_used' => 'closed_agent_name,closed_agent_role,ticket_username,ticket_title,ticket_id,comment,ticket_status,ratinglink,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],
            // forgot password link user & admin
             [
                'code' => 'forget_password',
                'title' => 'Send an email when admin panel users forget their password.',
                'subject' => 'Password Reset Email Link',
                'body' => '<p class="root-block-node" data-paragraphid="51" data-from-init="true" data-changed="false">Hi there,</p><p class="root-block-node" data-paragraphid="53" data-from-init="true" data-changed="false">Looks like you lost your password.</p><p class="root-block-node" data-paragraphid="52" data-from-init="true" data-changed="false">To regain access to your account</p><p>Please click the link below to reset your account password.</p><p><a href="{{reset_password_url}}">Reset Password</a>&nbsp;</p><p><br></p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>
                ',
                'variables_used' => 'reset_password_url',
                'created_at' => now(),
                'updated_at' => now()
            ],
            // When admin creates a employee then send email to employee email
            [
                'code' => 'employee_send_registration_details',
                'title' => 'Send email to employee, when employee is created by admin',
                'subject' => 'Your account has been successfully created by our support team. ',
                'body' => '<p>Dear {{username}},</p><p>Your account has been successfully created by our support team.</p><p>Please visit the URL {{url}} and use the below credentials to access your account.</p><p> Email : {{useremail}}<br>Name : {{username}}<br>Password : {{userpassword}}</p><p><br></p><p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'userpassword,username,useremail,url',
                'created_at' => now(),
                'updated_at' => now()
            ],

            [
                'code' => 'customer_send_ticket_overdue',
                'title' => 'Send email to employees, when Ticket is Overdue.',
                'subject' => 'Your ticket status has been overdue.',
                'body' => '<p class="root-block-node" data-paragraphid="2" data-from-init="true" data-changed="false">Dear Admin Panel Users,</p><p>
                </p><p class="root-block-node" data-paragraphid="10" data-from-init="true" data-changed="false">This ticket status has been overdue for {{ticket_overduetime}} days. </p><p class="root-block-node" data-paragraphid="10" data-from-init="true" data-changed="false">Please give attention to the ticket. The customer is waiting for your response.</p><p class="root-block-node" data-paragraphid="10" data-from-init="true" data-changed="false"><br></p><p> Title : {{ticket_title}}<br>Ticket URL : <a href="{{ticket_admin_url}}">VIEW Ticket</a></p><p><br></p><p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'ticket_username,ticket_title,ticket_overduetime,ticket_id,ticket_description,ticket_status,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],

            [
                'code' => 'customer_send_ticket_response',
                'title' => 'When the customer does not respond to the ticket, an email is sent to the customer.',
                'subject' => 'Waiting for your response to the ticket.',
                'body' => '<p>Dear {{ticket_username}},<br></p><p class="root-block-node" data-paragraphid="6" data-from-init="true" data-changed="false">Your ticket is in an idle state. Our team is waiting for your response.</p><p class="root-block-node" data-paragraphid="6" data-from-init="true" data-changed="false">If you do not respond to this ticket {{ticket_id}}, it will be automatically closed after {{ticket_closingtime}} days.</p><p class="root-block-node" data-paragraphid="2" data-from-init="true" data-changed="false">
                </p><p class="root-block-node" data-paragraphid="8" data-from-init="true" data-changed="true"><br></p><p> Title : {{ticket_title}}</p><p><br></p><p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'ticket_username,ticket_closingtime,ticket_title,ticket_id,ticket_description,ticket_status,replystatus',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'code' => 'customer_send_ticket_autoclose',
                'title' => 'Send email to customer, when a ticket is autoclosed.',
                'subject' => 'Your Ticket has been Closed Succesfully',
                'body' => '<p class="root-block-node" data-paragraphid="2" data-from-init="true" data-changed="false">Dear {{ticket_username}},</p><p class="root-block-node" data-paragraphid="11" data-from-init="true" data-changed="false">Your ticket has been closed successfully because there was no response from your end, so the ticket was closed automatically&nbsp;{{ticket_id}}.&nbsp;</p><p class="root-block-node" data-paragraphid="12" data-from-init="true" data-changed="false">If you want to reopen this ticket, please log in to your portal.</p><p> Title : {{ticket_title}}</p><p><br></p><p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'ticket_username,ticket_id,ticket_title,ticket_description,ticket_status',
                'created_at' => now(),
                'updated_at' => now()
            ],

            [
                'code' => 'admin_send_email_ticket_reply',
                'title' => 'Send email to admin, when customer replies to ticket',
                'subject' => 'You got reply from the customer',
                'body' => '<p>Hey Admin, </p><p>You have got a reply from customer. Please respond to the ticket.</p><p>Please visit the application to&nbsp;<a href="{{ticket_admin_url}}" style="">ViewTicket</a></p><p>Ticket Title: {{ticket_title}}<br></p><p>Ticket ID: {{ticket_id}}</p><p>Client Last Reply: {{comment}}</p><p><br></p><p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'ticket_username,ticket_title,ticket_id,ticket_status,comment,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'code' => 'when_ticket_assign_to_other_employee',
                'title' => 'Send email to employee, when a ticket is assigned.',
                'subject' => 'You have been assigned a ticket.',
                'body' => '<p>Dear User,<br></p>
                    <p>You have been assigned a ticket.</p>
                    <p>Please visit the application and respond accordingly. <br></p>
                    <p><a href="{{ticket_admin_url}}" style="">Click-here </a>to view ticket.<br></p>
                    <p>User Name: {{ticket_username}}<br></p>
                    <p>Ticket Title: {{ticket_title}}<br></p>
                    <p>Ticket ID: {{ticket_id}}</p>
                    <p><br></p>
                    <p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'ticket_username,ticket_id,ticket_title,ticket_description,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // When ticket closed  by Admin no rating
            [
                'code' => 'send_mail_to_customer_when_ticket_closed_by_admin',
                'title' => 'Send mail to customer when ticket closed by admin',
                'subject' => 'Your ticket {{ticket_id}} has been closed successfully.',
                'body' => '<p class="root-block-node" data-paragraphid="33" data-from-init="true" data-changed="false">Dear {{ticket_username}},</p><p class="root-block-node" data-paragraphid="34" data-from-init="true" data-changed="false">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Your ticket {{ticket_id}} has been closed by our team support.</p>
                <p class="root-block-node" data-changed="false" data-paragraphid="45">Sincerely,<br></p><p class="root-block-node" data-changed="false" data-paragraphid="45">Support Team</p>',
                'variables_used' => 'closed_agent_name,closed_agent_role,ticket_username,ticket_title,ticket_id,comment,ticket_status,ratinglink,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // When ticket closed  by Admin mail to agent or admin
            [
                'code' => 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent',
                'title' => 'Send mail to agent and admin when ticket closed by admin or agent',
                'subject' => 'The ticket has been closed.',
                'body' => '<p class="root-block-node" data-paragraphid="33" data-from-init="true" data-changed="false">Dear Admin panel user,</p><p class="root-block-node" data-paragraphid="34" data-from-init="true" data-changed="false">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; The ticket {{ticket_id}} has been closed by our support team {{closed_agent_role}} {{closed_agent_name}}.</p>
                <p class="root-block-node" data-changed="false" data-paragraphid="45">Sincerely,<br></p><p class="root-block-node" data-changed="false" data-paragraphid="45">Support Team</p>',
                'variables_used' => 'closed_agent_name,closed_agent_role,ticket_username,ticket_title,ticket_id,comment,ticket_status,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'code' => 'send_mail_admin_panel_users_when_category_changed',
                'title' => 'Send mail to admin panel users when ticket category changed',
                'subject' => 'The ticket category has been changed.',
                'body' => '<p class="root-block-node" data-paragraphid="33" data-from-init="true" data-changed="false">Dear Admin panel user,</p>
                        <p class="root-block-node" data-paragraphid="34" data-from-init="true" data-changed="false">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; The ticket {{ticket_id}}  category has been changed.</p>
                        <p class="root-block-node" data-changed="false" data-paragraphid="45">Sincerely,<br></p><p class="root-block-node" data-changed="false" data-paragraphid="45">Support Team</p>',
                'variables_used' => 'ticket_id,ticket_title,ticket_description,ticket_status,ticket_oldcategory,ticket_changedcategory,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'code' => 'send_mail_customer_when_category_changed',
                'title' => 'Send mail to customers when ticket category is changed',
                'subject' => 'The category has been changed.',
                'body' => '<p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">Dear {{ticket_username}},</p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">This email is to let you know that you have selected the wrong category {{ticket_oldcategory}} for this project. Our support team has changed it to the right category, {{ticket_changedcategory}}.</p>
                <p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p>
                <p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'ticket_username,ticket_id,ticket_title,ticket_description,ticket_status,ticket_oldcategory,ticket_changedcategory,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'code' => 'send_mail_to_admin_when_ticket_note_created',
                'title' => 'Send mail to admin when ticket note is created.',
                'subject' => 'A ticket note for {{ticket_id}} is created.',
                'body' => '<p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">Dear Admin,</p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">This email is to let you know that {{note_username}} has added a new note for a ticket {{ticket_id}}.</p>
                <p></p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false"><b>Note by employee&nbsp;</b>: </p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">{{ticket_note}}</p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false"><b>Ticket URL</b> :</p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">{{ticket_admin_url}}&nbsp;</p>
                <p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p>
                <p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'ticket_id,note_username,ticket_note,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],

            [
                'code' => 'customer_send_guestticket_created',
                'title' => 'Send email to customer, when ticket is created.',
                'subject' => 'We received your ticket successfully.',
                'body' => '<p>Dear {{ticket_username}},</p><p><br></p><p>We would like to acknowledge that we have received your request and a ticket has been created.</p><p>A support representative will be reviewing your request and will send you a personal response 1-2 bussiness days.</p><p><br></p><p>We appreciate your patience.</p><p><br></p><p>Sincerely,</p><p>Support Team</p>',
                'variables_used' => 'ticket_username,ticket_id,ticket_title,ticket_status,ticket_description,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],

            [
                'code' => 'customer_send_guestticket_created_with_attachment_failed',
                'title' => 'Send an email to the customer  when the file attachment is failed.',
                'subject' => 'We received your ticket successfully. But upload attachment was failed.',
                'body' => '<p>Dear {{ticket_username}},</p><p><br></p><p>We would like to acknowledge that we have received your request and a ticket has been created.</p><p>A support representative will be reviewing your request and will send you a personal response 1-2 bussiness days.</p><p>File upload failed, Please make sure that the file size is within the allowed limits and that the file format is supported.</p><p>Allowed Limits of Files&nbsp; :&nbsp;</p><p>File Formats : {{ticket_file_format}}</p><p>File Size : {{ticket_file_size}} MB</p><p>Max Files that can be uploaded : {{ticket_file_count}}</p><p>We appreciate your patience.</p><p><br></p><p>Sincerely,</p><p>Support Team</p>',
                'variables_used' => 'ticket_id,ticket_username,ticket_title,ticket_file_format,ticket_file_size,ticket_file_count,ticket_description',
                'created_at' => now(),
                'updated_at' => now()
            ],

            [
                'code' => 'send_mail_to_customer_when_does_not_has_fileupload_permission',
                'title' => 'Send email to cusotmer, when does not has file upload permission.',
                'subject' => 'We received your reply for this ticket. But you are not having file upload permission.',
                'body' => '<p>Dear {{ticket_username}},</p><p>We received your reply regarding the ticket. However, it appears that you do not have file upload permissions for this platform, which prevents you from uploading files.</p><p><br></p><p>Sincerely,</p><p>Support Team</p>',
                'variables_used' => 'ticket_username',
                'created_at' => now(),
                'updated_at' => now()
            ],

            [
                'code' => 'customer_send_ticket_created_that_holiday_or_announcement',
                'title' => 'Send an email to the customer during ticket creation or responding to the ticket in the case of a holiday.',
                'subject' => 'We have successfully received your ticket/response even though we are on holiday.',
                'body' => '<p>Dear {{ticket_username}},</p><p style="color: #252525;">We hope this response finds you well. Thank you for reaching out to us and submitting your ticket/response. We confirm that we have successfully received your request, and our team appreciates your trust in our support services.</p><p style="color: #252525;">However, we regret to inform you that today is a company-wide holiday, and our support representatives are currently away from the office. As a result, we won’t be able to review and address your ticket until we return to work.</p><p style="color: #252525;">Rest assured, as soon as we are back in the office, one of our experienced support representatives will thoroughly review your ticket and provide you with a prompt response.</p><p style="color: #252525;">We kindly request your understanding and patience during this time.</p><p style="color: #252525;">We apologize for any inconvenience this delay may cause and assure you that we will do our best to make it up to you with an accurate and timely response.</p><p style="color: #252525;">If you have any additional information to add to your ticket or if there are any changes to your request, please don’t hesitate to update your ticket, and we will review the updated information once we are back in the office.</p><p style="color: #252525;">Thank you for your understanding and cooperation. We look forward to assisting you upon our return.</p><p><br></p><p>Sincerely,</p><p>Support Team</p>',
                'variables_used' => 'ticket_username,ticket_title,ticket_id,ticket_status,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'code' => 'two_factor_authentication_otp_send',
                'title' => 'Two factor authentication verification otp',
                'subject' => 'Verify Two factor authentication otp.',
                'body' => '<p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">Dear {{name}},</p><p class="root-block-node" data-paragraphid="17" data-from-init="true" data-changed="false">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; {{otp}} is your one time password (otp) to login into application.</p><p class="root-block-node" data-paragraphid="17" data-from-init="true" data-changed="false">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; {{email}}</p><p class="root-block-node" data-paragraphid="17" data-from-init="true" data-changed="false">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Please do not share your otp’s with anyone.</p>
                <p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p>
                <p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'otp,email,name',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'code' => 'send_a_reply_to_the_customer_when_a_customer_responds_to_a_closed_email_ticket',
                'title' => 'Send a reply to the customer, when a customer responds to a closed email to ticket',
                'subject' => 'This is Information for closed email to ticket.',
                'body' => '<p>Dear {{ticket_username}},</p><p style="color: #252525;">We hope this response finds you well. We want to inform you that the ticket you recently tried to reply to has been closed in our system. We apologize for any inconvenience this may have caused.</p><p style="color: #252525;">If your initial query was resolved to your satisfaction, we are pleased to have been of assistance. However, if you have any additional questions, concerns, or new inquiries, we kindly request you to create a new ticket for each of them.</p><p style="color: #252525;">Creating a new ticket allows us to ensure proper tracking, prioritization, and a timely response from our support representatives. This approach enables us to deliver efficient and focused support tailored to each individual query.</p><ol style="color: #252525;">
                </ol><p style="color: #252525;">Rest assured, we are committed to resolving your queries and providing the best possible support experience.</p><p style="color: #252525;">Thank you for your understanding and cooperation in this matter. We value your continued trust in our services and are eager to assist you further.</p><p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'ticket_id,ticket_username,ticket_title,ticket_description,url',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'code' => 'send_mail_customer_when_a_customer_responds_to_a_restricted_mails',
                'title' => 'Send an email to the customer, when they reply to a general email sent to them by the application.',
                'subject' => 'You are not allowed to reply to this email.',
                'body' => '<p>Dear User,</p><p>Thank you for reaching out to us. Please note that the email you have received is an automated system-generated response and is not intended to receive direct replies. Our system has processed your inquiry and is actively working to address any concerns you may have raised.</p><p>Sincerely,</p><p>Support Team</p>',
                'variables_used' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'code' => 'Send_email_to_admin_users_when_change_email',
                'title' => 'Send an email to the admin users when their email address is updated.',
                'subject' => 'Email Verification: Reset Your Email Address',
                'body' => '<div>Hello {{username}},</div><div><br></div><div>We have received a request to change the email address associated with your account from {{useremail}} to a new email address.</div><div><br></div><div>To complete the process, please click on the link below:</div><div><br></div><div><a href="{{ticket_admin_url}}" target="_blank">{{ticket_admin_url}}</a></div><div><br></div><div>If you did not initiate this request or if you have any concerns, please contact our support team for assistance.</div><div><br></div><div>Thank you,</div><div>Support Team</div>',
                'variables_used' => 'username,useremail,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'code' => 'Send_email_to_customer_when_change_email_otp_verification',
                'title' => 'When the admin panel users changes their email address, an email should be sent with OTP verification.',
                'subject' => 'OTP Verification Required: Email Address Change Request',
                'body' => '<p>Dear {{username}},</p><p>We have received a request to change the email address associated with your account. To proceed with this change, please enter the following one-time password (OTP):</p><p>OTP: {{otp}}</p><p>Email address to be changed: {{useremail}}</p><p>Please do not share your OTP with anyone for security reasons.</p><p>If you did not initiate this request or if you have any concerns, please contact our support team for assistance.</p><p><br></p><p>Best regards,</p><p>Support Team</p>',
                'variables_used' => 'username,useremail,admin_url,otp',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // livechat email template
            [
                'code' => 'send_mail_to_livechat_cust_when_noresponse',
                'title' => 'Send an email to the livechat customer when there is no response to their last message.',
                'subject' => 'No response for the livechat message',
                'body' => '<p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">Dear {{livechat_cust_name}},<br></p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">We hope this email finds you well.</p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">We wanted to follow up on our recent LiveChat conversation. Our dedicated agent was happy to assist you and provided a detailed response to your inquiry.<br></p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">Here’s a recap of the last message from our agent:</p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">{{livechat_last_message_date}}<br>{{livechat_last_message}}</p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">Your last login url is : {{ last_login_url }},&nbsp; please do visit to continue chat.</p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">If you have any further questions, need clarification, or require additional assistance, please don’t hesitate to reach out. Our team is here to help you every step of the way.<br></p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">Your satisfaction is our top priority, and we want to ensure that your experience with us is excellent. We are committed to providing you with the best possible service.</p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">We appreciate your business and look forward to hearing from you soon.<br><br>Best regards,<br></p>',
                'variables_used' => 'livechat_cust_name,livechat_last_message_date,livechat_last_message,last_login_url',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // two factor authentication disabled by admin
            [
                'code' => 'send_mail_to_users_when_two_factor_authentication_disabled',
                'title' => 'Send an email alert to users when two factor authenticataion is disabled by admin.',
                'subject' => 'Two-Factor Authentication Disabled.',
                'body' => '<p>Dear {{username}},</p>
                <p>We’re reaching out to inform you that your two-factor authentication (2FA) has been disabled by our administrative team.</p>
                <p>Please be assured that your account security remains our top priority, and this action was taken for reasons that require your attention. It could be due to a variety of factors, including security protocol updates, account maintenance, or specific circumstances related to your account.</p>
                <p>To ensure the continued security of your account, we strongly recommend re-enabling two-factor authentication as soon as possible. 2FA provides an additional layer of security that helps safeguard your account from unauthorized access.</p>
                <ol>
                <li>Here are the steps to re-enable two-factor authentication:</li>
                <li>Log in to your account using your username and password.</li>
                <li>Navigate to the two-factor authentication settings within your account profile.</li>
                </ol>
                <p>Follow the prompts to set up two-factor authentication using your preferred method (e.g., Google authenticator app, email).</p>
                <p>If you encounter any difficulties or have questions regarding this matter, please don’t hesitate to reach out to our support team. We’re here to assist you every step of the way.</p>
                <p>Thank you for your attention to this matter and for your cooperation in maintaining the security of your account.</p><p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'username',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // status changed in the tikcets process
            [
                'code' => 'send_mail_admin_panel_users_when_status_changed',
                'title' => 'Send an email to admin panel users when ticket status changes.',
                'subject' => 'The ticket status has been changed.',
                'body' => '<p class="root-block-node" data-paragraphid="33" data-from-init="true" data-changed="false">Dear Admin panel user,</p>
                <p class="root-block-node" data-paragraphid="34" data-from-init="true" data-changed="false">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; The ticket {{ticket_id}}  status has been changed to {{ticket_status}}.</p>
                <p class="root-block-node" data-changed="false" data-paragraphid="45">Sincerely,<br></p><p class="root-block-node" data-changed="false" data-paragraphid="45">Support Team</p>',
                'variables_used' => 'ticket_id,ticket_status',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'code' => 'send_mail_customer_when_status_changed',
                'title' => 'Send an email to customers when the ticket status is changed.',
                'subject' => 'The status has been changed.',
                'body' => '<p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">Dear {{ticket_username}},</p><p class="root-block-node" data-paragraphid="16" data-from-init="true" data-changed="false">This email is to let you know that your ticket staus has been changed to {{ticket_status}}.</p>
                <p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p>
                <p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'ticket_username,ticket_status',
                'created_at' => now(),
                'updated_at' => now()
            ],

        ]);
    }
}
