<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('live_visitors', function (Blueprint $table) {
            $table->id();
            $table->string('visitor_unique_id');
            $table->bigInteger('cust_id')->unsigned()->nullable();
            $table->bigInteger('user_id')->unsigned()->nullable();
            $table->longText('username');
            $table->string('browser_info');
            $table->string('login_ip');
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('countrycode')->nullable();
            $table->string('country')->nullable();
            $table->string('Login_url')->nullable();
            $table->string('status')->nullable();
            $table->string('profile_bg_color')->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('cust_id')->references('id')->on('live_chat_customers')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('live_visitors');
    }
};
