<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('firstname');
            $table->string('lastname');
            $table->string('empid')->nullable();
            $table->longText('name')->nullable();
            $table->string('gender')->nullable();
            $table->string('dashboard')->nullable();
            $table->string('personalworkhours')->nullable();
            $table->string('personal24hours')->nullable();
            $table->string('provider_id')->nullable();
            $table->string('email')->unique();
            $table->bigInteger('phone')->nullable();
            $table->longText('skills')->nullable();
            $table->longText('languagues')->nullable();
            $table->string('status');
            $table->timestamp('last_activity')->nullable();
            $table->string('twofactorauth')->nullable();
            $table->string('google2fa_secret')->nullable();
            $table->string('image')->nullable();
            $table->string('profileurl')->nullable();
            $table->string('storage_disk')->nullable();
            // $table->timestamp('email_verified_at')->nullable();
            $table->boolean('verified')->default(false);
            $table->string('password')->nullable();
            $table->string('country')->nullable();
            $table->string('timezone')->nullable();
            $table->bigInteger('darkmode')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });


        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->string('firstname')->nullable();
            $table->string('lastname')->nullable();
            $table->longText('username')->nullable();
            $table->string('gender')->nullable();
            $table->string('provider_id')->nullable();
            $table->string('email')->unique();
            $table->string('logintype')->nullable();
            $table->string('userType');
            $table->string('google2fa_secret')->nullable();
            $table->string('voilated')->nullable();
            $table->string('violatednote')->nullable();
            $table->string('status');
            $table->timestamp('last_activity')->nullable();
            $table->string('phone')->nullable();
            $table->integer('phoneVerified')->default(0);
            $table->integer('phonesmsenable')->default(0);
            $table->string('image')->nullable();
            $table->string('storage_disk')->nullable();
            // $table->timestamp('email_verified_at')->nullable();
            $table->boolean('verified')->default(false);
            $table->string('password')->nullable();
            $table->datetime('last_login_at')->nullable();
            $table->datetime('inactive_date')->nullable();
            $table->datetime('last_logins_at')->nullable();
            $table->string('last_login_ip')->nullable();
            $table->string('country')->nullable();
            $table->string('timezone')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('customers');
    }
}
