<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\LiveChatConversations;
use App\Models\Ticket\Ticket;
use App\Models\Ticket\Comment;

class LiveChatCustomers extends Model
{
    use HasFactory;

    protected $fillable = [
        'cust_unique_id',
        'username',
        'name',
        'email',
        'chat_flow_messages',
        'engage_conversation',
        'file_upload_permission',
        'mobile_number',
        'browser_info',
        'country',
        'state',
        'mark_as_unread',
        'city',
        'Login_url',
        'full_address',
        'timezone',
        'userType',
        'status',
        'banstatus',
        'profile_bg_color',
        'verified',
        'login_at',
        'login_ip',
    ];

    protected $dates = ['login_at'];

    public function livechatconversation()
    {
        return $this->hasMany(LiveChatConversations::class,'livechat_cust_id');
    }

    public function latestConversation()
    {
        return $this->hasOne(LiveChatConversations::class, 'livechat_cust_id')
            ->latest('created_at');
    }

    public function tickets()
    {
        return $this->hasMany(Ticket::class, 'cust_id');
    }

    public function livevisitorscust()
    {
        return $this->hasMany(LiveVisitors::class, 'cust_id');
    }

    public function comments()
    {
        return $this->hasMany(Comment::class, 'cust_id');
    }
}
