<?php

namespace App\Imports;

use App\Models\User;
use Spatie\Permission\Models\Role;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Validators\Failure;
use Throwable;
use Exception;
use Illuminate\Support\Facades\Hash;
use App\Models\usersettings;

class UserImport implements ToModel, WithHeadingRow, WithValidation
{
    use Importable;


    protected $nonExistentRoles = [];

    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        $role = Role::where('name', $row['role'])->first();
        if($role){
            $user = User::where('email', $row['email'])->first();

            if ($user) {
                $user->update([
                    'firstname'     => $row['firstname'],
                    'lastname'     => $row['lastname'],
                    'name'     => $row['firstname'].' '.$row['lastname'],
                    'email'    => $row['email'],
                    'password' => Hash::make($row['password']),
                ]);
            } else {
                $user = new User([
                    'firstname'     => $row['firstname'],
                    'lastname'     => $row['lastname'],
                    'name'     => $row['firstname'].' '.$row['lastname'],
                    'email'    => $row['email'],
                    'empid'    => $row['empid'],
                    'password' => Hash::make($row['password']),
                    'status' => '1',
                    'verified' => '1',
                    'darkmode' => setting('DARK_MODE')
                ]);
            }

            $usersetting = new usersettings();
            $usersetting->users_id = $user->id;
            $usersetting->emailnotifyon = '1';
            $usersetting->save();

            $user->assignRole($role);

            session()->put('employeeimported', $user);
            return $user;
        }else{
            $this->nonExistentRoles[] = $row['role'];
        }
    }

    public function rules(): array
    {
        return  [
            '*.firstname' => ['required','alpha_num'],
            '*.lastname' => ['required','alpha_num'],
            '*.email' => ['required','string', 'email', 'unique:users,email'],
            '*.password' => ['required'],
            '*.empid' => ['required', 'unique:users,empid'],
            '*.role' => ['required'],
        ];
    }

    public function __destruct()
    {
        if (!empty($this->nonExistentRoles)) {
            throw new Exception(implode(', ', $this->nonExistentRoles) . ' roles are not existing in your application, please provide existing roles or create new role for this.');
        }
    }
}
