<?php

namespace App\Http\Controllers;

use App\Events\ChatMessageEvent;
use App\Models\Apptitle;
use App\Models\Employeerating;
use App\Models\Footertext;
use App\Models\Pages;
use App\Models\Ratingtoken;
use App\Models\Seosetting;
use App\Models\Subcategorychild;
use App\Models\Ticket\Comment;
use App\Models\Ticket\Ticket;
use App\Models\User;
use App\Models\Userrating;
use Auth;
use Illuminate\Http\Request;
use App\Models\APIData;
use App\Models\CategoryEnvato;
use App\Models\Ticket\Category;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

class GuestticketController extends Controller
{

    public function envatoverify(Request $request)
    {
        if ($request->data) {

            $apidatatoken = APIData::first();

            $envato_license = $request->data;

            $url = "https://api.envato.com/v3/market/author/sale?code=" . $envato_license;
            $curl = curl_init($url);

            $personal_api_token = $apidatatoken != null ? $apidatatoken->envatoapitoken : '';

            /*Correct header for the curl extension*/
            $header = array();
            $header[] = 'Authorization: Bearer ' . $personal_api_token;
            $header[] = 'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:41.0) Gecko/20100101 Firefox/41.0';
            $header[] = 'timeout: 20';
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);

            /*Connect to the API, and get values from there*/
            $envatoCheck = curl_exec($curl);
            curl_close($curl);

            $envatoCheck = json_decode($envatoCheck);

            $firstone = isset($envatoCheck->error);

            $secondone = null;
            if($firstone == true){
                $personal_api_token = $apidatatoken != null ? $apidatatoken->envatoapitokensecond : '';
                $header = array();
                $header[] = 'Authorization: Bearer ' . $personal_api_token;
                $header[] = 'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:41.0) Gecko/20100101 Firefox/41.0';
                $header[] = 'timeout: 100';
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
                $envatoCheck = curl_exec($curl);
                curl_close($curl);
                $envatoCheck = json_decode($envatoCheck);
                if(isset($envatoCheck->error)){
                    $secondone = true;
                }
            }

            if($secondone == true){
                $personal_api_token = $apidatatoken != null ? $apidatatoken->envatoapitokenthird : '';
                $header = array();
                $header[] = 'Authorization: Bearer ' . $personal_api_token;
                $header[] = 'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:41.0) Gecko/20100101 Firefox/41.0';
                $header[] = 'timeout: 100';
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
                $envatoCheck = curl_exec($curl);
                curl_close($curl);

                $envatoCheck = json_decode($envatoCheck);
            }

            /*Variable request from the API*/
            $date = new \DateTime(isset($envatoCheck->supported_until) ? $envatoCheck->supported_until : false);
            $support_date = $date->format('Y-m-d H:i:s');
            $sold = new \DateTime(isset($envatoCheck->sold_at) ? $envatoCheck->sold_at : false);
            $sold_at = $sold->format('Y-m-d H:i:s');
            $buyer = (isset($envatoCheck->buyer) ? $envatoCheck->buyer : false);
            $license = (isset($envatoCheck->license) ? $envatoCheck->license : false);
            $count = (isset($envatoCheck->purchase_count) ? $envatoCheck->purchase_count : false);
            $support_amount = (isset($envatoCheck->support_amount) ? $envatoCheck->support_amount : false);
            $item = (isset($envatoCheck->item->previews->landscape_preview->landscape_url) ? $envatoCheck->item->previews->landscape_preview->landscape_url : false);

            /*If Purchase code exists, But Purchase ended*/
            if (isset($envatoCheck->item->name) && (date('Y-m-d H:i:s') >= $support_date)) {
                return response()->json(['valid' => 'expried', 'message' => lang('The purchase code has been verified, but your product support has expired.', 'alerts'), 'key' => $envato_license, 'name' => $envatoCheck->item->name]);

            }

            /*If Purchase code exists, display client information*/
            if (isset($envatoCheck->item->name) && (date('Y-m-d H:i:s') < $support_date)) {
                return response()->json(['valid' => 'true', 'message' => lang('The purchase code has been validated and is supported.', 'alerts'), 'key' => $envato_license, 'name' => $envatoCheck->item->name]);
            }

            /*If Purchase Code doesn't exist,*/
            if (!isset($envatoCheck->item->name)) {
                return response()->json(['valid' => 'false', 'message' => lang('The Purchase Code is invalid.', 'alerts')]);
            }

        }
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function rating($ticket_id)
    {
        $ratingticket = Ratingtoken::where('token', $ticket_id)->first();
        if (!$ratingticket) {
            return redirect('/')->with("error", lang('Your rating has already been submitted.', 'alerts'));
        }
        $ticket = Ticket::where('id', $ratingticket->ticket_id)->first();

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        $rating = $ticket->comments()->whereNotNull('user_id')->get();
        $comment = Comment::select('user_id')->where('ticket_id', $ticket->id)->distinct()->get();

        if ($rating->isEmpty()) {
            return redirect()->back()->with("success", lang('Your comment has be submitted.', 'alerts'));
        } else {
            return view('guestticket.rating', compact('ticket', 'title', 'comment', 'footertext'))->with($data);
        }

    }

    public function star5($id)
    {

        $user = User::with('usetting')->findorFail($id);
        $user->usetting->increment('star5');
        $user->usetting->update();

        return redirect('/')->with('success', lang('Thank you for rating us.', 'alerts'));

    }

    public function star4($id)
    {

        $user = User::with('usetting')->findorFail($id);
        $user->usetting->increment('star4');
        $user->usetting->update();

        return redirect('/')->with('success', lang('Thank you for rating us.', 'alerts'));

    }

    public function star3($id)
    {

        $user = User::with('usetting')->findorFail($id);
        $user->usetting->increment('star3');
        $user->usetting->update();

        return redirect('/')->with('success', lang('Thank you for rating us.', 'alerts'));

    }

    public function star2($id)
    {

        $user = User::with('usetting')->findorFail($id);
        $user->usetting->increment('star2');
        $user->usetting->update();

        return redirect('/')->with('success', lang('Thank you for rating us.', 'alerts'));

    }

    public function star1($id)
    {

        $user = User::with('usetting')->findorFail($id);
        $user->usetting->increment('star1');
        $user->usetting->update();

        return redirect('/')->with('success', lang('Thank you for rating us.', 'alerts'));
    }

    public function ticketrating(Request $req)
    {
        $req->validate([
            'ratingticket' => 'required',
        ]);

        $ticketfinding = Ticket::find($req->ticket_id);

        $ratingticket = Userrating::where('ticket_id', $req->ticket_id)->first();
        if ($ratingticket) {
            $ratingticket->ratingstar = $req->ratingticket;
            $ratingticket->ratingcomment = $req->ratingcomment;
            $ratingticket->update();

            $employeeratingloop = Employeerating::where('urating_id', $ratingticket->id)->get();
            foreach ($employeeratingloop as $employeeratings) {
                $employeeratings->delete();
            }

            $commentsfind = $ticketfinding->comments()->where('user_id', '!=', null)->distinct()->get();

            $processedUserIds = [];

            foreach ($commentsfind as $commentfinds) {
                if (!in_array($commentfinds->user_id, $processedUserIds)) {
                    $employeerating = new Employeerating();
                    $employeerating->urating_id = $ratingticket->id;
                    $employeerating->rating = $ratingticket->ratingstar;
                    $employeerating->user_id = $commentfinds->user_id;
                    $employeerating->save();

                    $processedUserIds[] = $commentfinds->user_id;
                }
            }

            $newcomment = Comment::create([
                'ticket_id' => $ticketfinding->id,
                'user_id' => null,
                'cust_id' => $ticketfinding->cust->id,
                'comment' => 'Customer has been rated for you '. $employeerating->rating . ' star',
                'commenttype' => 'tickethistory',
            ]);

            event(new ChatMessageEvent(null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,$ticketfinding->id,$ticketfinding->cust->id,$newcomment,'tickethistory',$ticketfinding->cust->username));

        } else {

            $ticketrating = new Userrating();
            $ticketrating->ticket_id = $req->ticket_id;
            $ticketrating->ratingstar = $req->ratingticket;
            $ticketrating->ratingcomment = $req->ratingcomment;
            $ticketrating->cust_id = $ticketfinding->cust->id;
            $ticketrating->save();

            $ticketsfind = Ticket::where('id', $req->ticket_id)->first();
            $commentsfind = $ticketsfind->comments()->where('user_id', '!=', null)->distinct()->get();

            $processedUserIds = []; // Create an array to keep track of processed user IDs.

            foreach ($commentsfind as $commentfinds) {
                // Check if the user ID has already been processed.
                if (!in_array($commentfinds->user_id, $processedUserIds)) {
                    $employeerating = new Employeerating();
                    $employeerating->urating_id = $ticketrating->id;
                    $employeerating->rating = $ticketrating->ratingstar;
                    $employeerating->user_id = $commentfinds->user_id;
                    $employeerating->save();

                    $processedUserIds[] = $commentfinds->user_id;
                }
            }

            $newcomment = Comment::create([
                'ticket_id' => $ticketfinding->id,
                'user_id' => null,
                'cust_id' => $ticketfinding->cust->id,
                'comment' => 'Customer has been rated for you '. $employeerating->rating . ' star',
                'commenttype' => 'tickethistory',
            ]);

            event(new ChatMessageEvent(null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,$ticketfinding->id,$ticketfinding->cust->id,$newcomment,'tickethistory',$ticketfinding->cust->username));

        }
        $ratingticketdelete = Ratingtoken::where('ticket_id', $req->ticket_id)->first();
        $ratingticketdelete->delete();

        return redirect('/')->with('success', lang('Thank you for rating us.', 'alerts'));

    }
    /// end rating system ///

    public function imagedestroy($id)
    {
        //For Deleting Users
        $commentss = Media::findOrFail($id);
        $commentss->delete();
        return response()->json([
            'success' => lang('The image has been deleted successfully!', 'alerts'),
        ]);
    }

    public function subcategorylist(Request $request)
    {

        $parent_id = $request->cat_id;

        $categoryfind = Category::find($parent_id);
        $subcategoriess = Subcategorychild::where('category_id', $parent_id)->get();

        $subcatstatusexisting = null;
        $output = '';
        $myArray = [];

        if ($subcategoriess->isNotEmpty()) {
            $output .= '<option label="select subcategory"></option>';
            foreach ($subcategoriess as $subcats) {
                $sucatss = $subcats->subcatlists()->where('status', '1')->get();
                if ($sucatss->isNotEmpty()) {
                    $subcatstatusexisting = 'statusexisting';
                    foreach ($sucatss as $subcategory) {
                        $myArray[] = $subcategory;
                        $output .= '<option value="' . $subcategory->id . '">' . $subcategory->subcategoryname . '</option>';
                    }
                }

            }
        }

        $subcategories = [];

        $categoryenvato = CategoryEnvato::where('category_id', $parent_id)->get();

        $data = [
            'subCatStatus' => $myArray,
            'subcategoriess' => $output,
            'subcategories' => $subcategories,
            'envatosuccess' => $categoryenvato,
            'subcatstatusexisting' => $subcatstatusexisting,
            'categorypriority' => $categoryfind->priority,
        ];
        return response()->json($data
            , 200);
    }

    public function notificationalerts()
    {

        if (Auth::check() && Auth::user()) {
            $data = Auth::user()->unreadNotifications()->where('notifiable', '0')->get();
            $dataa = $data->count();
            return response()->json($data, 200);
        }

    }

    public function notificationalertsread()
    {
        if (Auth::check() && Auth::user()) {
            $data = Auth::user()->unreadNotifications()->get();
            foreach ($data as $dataas) {
                $dataas->notifiable = '1';
                $dataas->update();

            }
            return response()->noContent();
        }
    }

    public function notificationsreading()
    {
        $notify = auth()->user()->unreadNotifications()->paginate(2);
        $data['notifys'] = $notify;
        return view('includes.admin.allnotify')->with($data);
    }

    public function badgecount()
    {

        $badgecount = auth()->user()->unreadNotifications->count();
        $data['badgecount'] = $badgecount;
        return view('includes.admin.badgecount')->with($data);
    }

    public function markasreadcount()
    {

        $badgecount = auth()->user()->unreadNotifications->count();
        $data['badgecount'] = $badgecount;
        return view('includes.admin.markasreadcount')->with($data);
    }

    public function allnotifycount()
    {

        $badgecount = auth()->user()->unreadNotifications->count();
        $data['badgecount'] = $badgecount;
        return view('includes.admin.allnotify')->with($data);
    }

    public function cnotificationalerts()
    {

        if (Auth::guard('customer')->check() && Auth::guard('customer')->user()) {
            $data = Auth::guard('customer')->user()->unreadNotifications()->where('notifiable', '0')->get();
            $dataa = $data->count();
            return response()->json($data, 200);
        }

    }

    public function cnotificationalertsread()
    {
        if (Auth::guard('customer')->check() && Auth::guard('customer')->user()) {
            $data = Auth::guard('customer')->user()->unreadNotifications()->get();
            foreach ($data as $dataas) {
                $dataas->notifiable = '1';
                $dataas->update();

            }
            return response()->noContent();
        }
    }

    public function cnotificationsreading()
    {

        $notify = auth()->guard('customer')->user()->unreadNotifications()->paginate(2);
        $data['notifys'] = $notify;
        return view('includes.user.allnotify')->with($data);
    }

    public function cbadgecount()
    {

        $badgecount = auth()->guard('customer')->user()->unreadNotifications->count();
        $data['badgecount'] = $badgecount;
        return view('includes.user.badgecount')->with($data);
    }
    public function cmarkasreadcount()
    {

        $badgecount = auth()->guard('customer')->user()->unreadNotifications->count();
        $data['badgecount'] = $badgecount;
        return view('includes.user.markasreadcount')->with($data);
    }

    public function callnotifycount()
    {

        $badgecount = auth()->guard('customer')->user()->unreadNotifications->count();
        $data['badgecount'] = $badgecount;
        return view('includes.user.allnotify')->with($data);
    }

    public function markallnotify()
    {
        auth()->guard('customer')->user()->unreadNotifications->markAsRead();

        return response()->noContent();
    }


    public function editticketsubject(Request $request)
    {
        $ticket = Ticket::findOrFail($request->ticketId);
        $ticket->subject = $request->editsubject;
        $ticket->message = strip_tags($request->editmessage);
        $ticket->save();

        return response()->json(['ticketdata' => $ticket, 'success' => lang('Updated successfully.', 'alerts')]);

    }


}
