<?php

namespace App\Http\Controllers\Admin;

use App\Events\ChatMessageEvent;
use App\Http\Controllers\Controller;
use App\Models\LiveChatConversations;
use App\Models\LiveChatCustomers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log, Illuminate\Support\Str;


class WhatsappController extends Controller
{

    public function verifyWebhook(Request $request)
    {
        Log::info('verifyWebhook:', $request->all());

        $mode = $request->query('hub_mode');
        $verifyToken = $request->query('hub_verify_token');
        $expectedVerifyToken = setting('whatsappVerifyToken'); // Fetch the expected token

        // Check the mode and verify token
        if ($mode === 'subscribe' && $verifyToken === $expectedVerifyToken) {
            // Send back the hub_challenge as plain text
            return response($request->query('hub_challenge'), 200)
                ->header('Content-Type', 'text/plain');
        } else {
            // Log a message for failed verification
            Log::warning('Webhook Verification Failed:', [
                'received_mode' => $mode,
                'received_verify_token' => $verifyToken
            ]);

            // Return a 403 response if verification fails
            return response('Forbidden', 403);
        }
    }

    public function handleIncomingMessage(Request $request)
    {

        $message = 'Incoming WhatsApp message: ' . json_encode($request->all());
        Log::info($message);

        $data = json_decode($request->getContent(), true);

        if (isset($data['entry'][0]['changes'][0]['value']['messages'][0]['type']) && $data['entry'][0]['changes'][0]['value']['messages'][0]['type'] == 'audio') {
            return response()->json([], 200);
        }

        // if a response of unsuported type is captured in the webhook data, we are returning it directly. in future we may show that an unsupported message is recieved from customer.
        if (isset($data['entry'][0]['changes'][0]['value']['messages'][0]['errors'])) {
            return response()->json([], 200);
        }

        if (isset($data['entry'][0]['changes'][0]['value']['statuses'])) {
            Log::info('statuses' . json_encode($data));
            $sentData = $data['entry'][0]['changes'][0]['value']['statuses'][0]['status'];
            $userMessageId = $data['entry'][0]['changes'][0]['value']['statuses'][0]['id'];
            if ($sentData == 'sent') {
                $originalMessage = LiveChatConversations::where('messageId', $userMessageId)->first();
                if (isset($originalMessage)) {
                    $originalMessage->status = 'sent';
                    $originalMessage->save();
                }
                return response()->json([], 200);
            } elseif ($sentData == 'delivered') {
                $originalMessage = LiveChatConversations::where('messageId', $userMessageId)->first();
                if (isset($originalMessage)) {
                    $originalMessage->status = 'delivered';
                    $originalMessage->save();
                    event(new ChatMessageEvent(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 'delivered', $userMessageId));
                }
            } elseif ($sentData == 'read') {
                $originalMessage = LiveChatConversations::where('messageId', $userMessageId)->first();
                if (isset($originalMessage)) {
                    $originalMessage->status = 'seen';
                    $originalMessage->save();
                    event(new ChatMessageEvent(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 'read', $userMessageId));
                }
            }
            return response()->json([], 200);
        }

        $businessAccId = $data['entry'][0]['id'];
        $phoneNumberId = $data['entry'][0]['changes'][0]['value']['metadata']['phone_number_id'];
        $userPhoneNumber = $data['entry'][0]['changes'][0]['value']['contacts'][0]['wa_id'];
        $userName = $data['entry'][0]['changes'][0]['value']['contacts'][0]['profile']['name'];
        $messageType = $data['entry'][0]['changes'][0]['value']['messages'][0]['type'];
        if ($messageType == 'text') {
            $message = $data['entry'][0]['changes'][0]['value']['messages'][0]['text']['body'];
        } else {
            $mediaId = $data['entry'][0]['changes'][0]['value']['messages'][0]['image']['id'];
            $imageData = Http::withHeaders([
                'Authorization' => 'Bearer ' . setting('whatsappToken'),
            ])->get('https://graph.facebook.com/' . setting('whatsAppGraphAPIVersion') . '/' . $mediaId);
            $message = $imageData->json()['url'];
        }
        $messageId = $data['entry'][0]['changes'][0]['value']['messages'][0]['id'];
        $messagingProduct = $data['entry'][0]['changes'][0]['value']['messaging_product'];
        $displayPhoneNumber = $data['entry'][0]['changes'][0]['value']['metadata']['display_phone_number'];

        if ($messagingProduct == 'whatsapp' && $businessAccId == setting('businessAccId') && $phoneNumberId == setting('whatsPhoneNumberId') && $displayPhoneNumber == setting('whatsappNumber')) {
            $user = LiveChatCustomers::where('mobile_number', $userPhoneNumber)->first();
            // if user already customer, create only message
            if (isset($user)) {
                // $cust = LiveChatCustomers::find($user->id);
                if ($user->status == 'solved') {
                    $user->status = "";

                    $userWithConversation = clone $user;
                    $userWithConversation->latestConversation = $message;

                    event(new ChatMessageEvent($user->username, 'newUser', null, null, null, null, null, null, null, null, null, null, null, null, null, $userWithConversation));
                    // event(new ChatMessageEvent($user->username, 'newUser', null, null, null, null, null, null));
                    // event(new ChatMessageEvent($user->username, 'newUser', null, null, null, null, null, null, null, null, null, null, null, null, null, $user));
                }
                $user->updated_at = now();
                $user->save();

                $newconversation = new LiveChatConversations();
                $newconversation->unique_id = $user->cust_unique_id;
                $newconversation->livechat_cust_id = $user->id;
                $newconversation->livechat_username = $user->username;
                $newconversation->message = $message;
                $newconversation->message_type = $messageType;
                $newconversation->messageId = $messageId;
                if ($messageType == 'image') {
                    $newconversation->message_type = $messageType;
                    event(new ChatMessageEvent($user->username, $message, $user->id, $user->id, null, null, null, null, null, null, $messageType));
                } else {
                    event(new ChatMessageEvent($user->username, $message, $user->id, $user->id));
                }
                $newconversation->save();
            } else {
                // if not user, then create customer and add message
                $cust = new LiveChatCustomers();
                $cust->cust_unique_id = Str::uuid();
                $cust->username = $userName;
                $cust->mobile_number = $userPhoneNumber;
                $cust->file_upload_permission = 1;
                $cust->userType = 'WhatsApp';
                $cust->login_at = now();
                $cust->profile_bg_color = randomColorGenerator(0.5);
                $cust->save();

                $userWithConversation = clone $cust;
                $userWithConversation->latestConversation = $message;

                event(new ChatMessageEvent($cust->username, 'newUser', $cust->id, null, null, null, null, null, null, null, null, null, null, null, null, $userWithConversation));
                // event(new ChatMessageEvent($cust->username, 'newUser', $cust->id, null, null, null, null, null));
                // event(new ChatMessageEvent($cust->username, 'newUser', $cust->id, null, null, null, null, null, null, null, null, null, null, null, null, $cust));

                $newconversation = new LiveChatConversations();
                $newconversation->unique_id = $cust->cust_unique_id;
                $newconversation->livechat_cust_id = $cust->id;
                $newconversation->livechat_username = $cust->username;
                $newconversation->message = $message;
                $newconversation->message_type = $messageType;
                $newconversation->messageId = $messageId;
                if ($messageType == 'image') {
                    $newconversation->message_type = $messageType;
                    event(new ChatMessageEvent($cust->username, $message, $cust->id, $cust->id, null, null, null, null, null, null, $messageType));
                } else {
                    event(new ChatMessageEvent($cust->username, $message, $cust->id, $cust->id));
                }
                $newconversation->save();
            }
            return response()->json([], 200);
        }

        return response()->json([], 200);
    }
}
