<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Events\ChatMessageEvent;
use App\Models\LiveChatCustomers;
use App\Models\LiveChatConversations;
use App\Models\LiveVisitors;
use Illuminate\Support\Str;
use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\Seosetting;
use App\Models\Pages;
use Session;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;

class VisitorsController extends Controller
{
    public function livevisitors(Request $request)
    {
        $cust = new LiveVisitors();
        $cust->visitor_unique_id = Str::random(9);
        $cust->username = 'New Visitor';
        $cust->browser_info = $request->browserinfo;
        $cust->login_ip = $request->ipaddress;
        $cust->city = $request->city;
        $cust->state = $request->state;
        $cust->countrycode = $request->countrycode;
        $cust->country = $request->country;
        $cust->Login_url = $request->loginurl;
        $cust->status = 'online';
        $cust->profile_bg_color = randomColorGenerator(0.5);
        $cust->save();

        event(new ChatMessageEvent(null, null,null,null,null,null,null,null,null,null,null,null,$cust));
        return response()->json(['success' => 'your live chat process is started.','visitordata' => $cust]);

    }

    public function livevisitorsstatus(Request $request)
    {
        $visitors = LiveVisitors::where('visitor_unique_id',$request->id)->first();
        $visitors->status = 'online';
        $visitors->save();

        event(new ChatMessageEvent(null, null,null,null,null,null,null,null,null,null,null,null,null,$visitors));
    }

    public function livevisitorsview(Request $request)
    {
        $this->authorize('Visitors Access');

        $customers = LiveVisitors::whereNull('user_id')->latest('updated_at')->get();
        $data['customers'] = $customers;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        $data['livevisitorscount'] = LiveVisitors::whereNull('user_id')->where('status','online')->count();
        $data['overallvisitorscount'] = LiveVisitors::whereNull('user_id')->count();

        return view('admin.customers.livevisitors')->with($data)->with('i', (request()->input('page', 1) - 1) * 5);
    }

    public function livevisitorengage(Request $request)
    {

        $livevisitor = LiveVisitors::find($request->custId);

        $livecust = LiveChatCustomers::where('cust_unique_id',$livevisitor->visitor_unique_id)->first();
        if(!$livecust){
            $livecust = new LiveChatCustomers();
            $livecust->cust_unique_id = $livevisitor->visitor_unique_id;
            $livecust->username = $livevisitor->username;
            $livecust->email = $livevisitor->visitor_unique_id;
            $livecust->mobile_number = 'not mentioned';
            $livecust->userType = 'livevisitor';
            $livecust->browser_info = $livevisitor->browser_info;
            $livecust->login_ip = $livevisitor->login_ip;
            $livecust->city = $livevisitor->city;
            $livecust->state = $livevisitor->state;
            $livecust->country = $livevisitor->country;
            $livecust->Login_url = $livevisitor->Login_url;
            $livecust->profile_bg_color = $livevisitor->profile_bg_color;
            $livecust->save();

            $user = Auth::user();
            $existingEngageConversation = [];
            $existingEngageConversation[] = json_decode($user);
            $livecust->engage_conversation = json_encode($existingEngageConversation);
            $livecust->save();

            $livevisitor->user_id = $user->id;
            $livevisitor->save();

            $newconversation = new LiveChatConversations();
            $newconversation->unique_id = $livecust->cust_unique_id;
            $newconversation->livechat_user_id = $user->id;
            $newconversation->livechat_username = $user->name;
            $newconversation->message = $user->name. ' joined the discussion at';
            $newconversation->status = 'comment';
            $newconversation->save();

            $livecust->encrypted_id = Crypt::encrypt($livecust->id);

            $conversationData = json_decode($livecust->engage_conversation, true);
            foreach ($conversationData as &$conversation) {
                if (is_object($conversation)) {
                    $conversation = (array) $conversation;
                }
            }

            $conversationCount = count($conversationData);

            $namesString = implode(', ', array_map(fn($item) => $item['name'], $conversationData));

            $avatarHtml = '';

            foreach ($conversationData as $key => $LiveCustmer) {
                if ($key < 2) {
                    if($LiveCustmer['image']){
                        $baseUrl = route('getprofile.url', ['imagePath' => $LiveCustmer['image'], 'storage_disk' => $LiveCustmer['storage_disk']]);
                    }else{
                        $baseUrl = asset('/uploads/profile/user-profile.png');
                    }
                    $avatarHtml .= '<span class="avatar brround avatar-sm" '
                        . 'style="background-image: url(' . $baseUrl  . ')" '
                        . 'data-bs-toggle="tooltip" data-bs-placement="top" '
                        . 'data-bs-title="' . htmlspecialchars($LiveCustmer['name']) . '" '
                        . 'title="' . htmlspecialchars($LiveCustmer['firstname']) . '"></span>';
                }
            }

            if ($conversationCount > 2) {
                $avatarHtml .= '<span class="avatar brround bg-light text-dark avatar-sm" '
                    . 'data-bs-toggle="tooltip" data-bs-placement="top" '
                    . 'data-bs-title="' . htmlspecialchars($namesString) . '">+' . ($conversationCount - 2) . '</span>';
            }

            $livecust->engagedUserdetailsCont = $avatarHtml;
            $livecust->reassigncreated = $newconversation->created_at;

            event(new ChatMessageEvent(null,null,$user->id,$livecust->id,null,null,true,$livecust->engage_conversation,$newconversation->message,null,null,null,null,$livevisitor->visitor_unique_id,null,$livecust));

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Engaged Conversation With Livechat Visitors';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
        }
        Session::put('chatsourcefrom', $livecust->id);

        return redirect()->route('admin.myOpenedChats',['chatsourcefrom', 'operatorstartchat']);
    }

    public function sessionclose(Request $request)
    {
        if($request->session()->get('chatsourcefrom') != null){
            $request->session()->forget('chatsourcefrom');
        }

        return response()->json(['success' => 'your live chat process is started.']);
    }
}
