<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Seosetting;
use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\IPLIST;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class IpblockController extends Controller
{
    public function index()
    {

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $iplists = IPLIST::latest()->get();
        $data['iplists'] = $iplists;

        return view('admin.securitysetting.ipblocklist')->with($data);
    }

    public function show($id)
    {

        $ip = IPLIST::find($id);

        return response()->json($ip);
    }


    public function store(Request $request)
    {
        if($request->IP_id != null){
            $request->validate([
                'ip' => 'required|ip',
                'types' => 'required',

            ]);
        }else{
            $request->validate([
                'ip' => 'required|ip|unique:i_p_l_i_s_t_s,ip',
                'types' => 'required',

            ]);
        }

        $ipId = $request->IP_id;
        $ipdata =  [
            'ip' => $request->ip,
            'types' => $request->types,

        ];


        $ipdtaa = IPLIST::updateOrCreate(['id' => $ipId], $ipdata);

        $ipdataupdate = IPLIST::find($ipdtaa->id);
        if ($ipdataupdate->entrytype != 'Auto') {
            $ipdataupdate->entrytype = 'Manual';
        }
        $ipdataupdate->update();

        $iplists = IPLIST::latest()->get();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = $ipId != null ? 'IP address Updated' : 'IP address Created';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        if($ipId != null){
            $statustext = lang('The IP address updated successfully.', 'alerts');
        }else{
            $statustext = lang('The IP address created successfully.', 'alerts');
        }

        return response()->json(['code' => 200, 'success' => $statustext, 'data' => $ipdtaa, 'iplists' => $iplists], 200);
    }

    public function destroy($id)
    {

        $ipdelete = IPLIST::find($id);
        $ipdelete->delete();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'IP address Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('The IP address has been successfully removed.', 'alerts')]);
    }


    public function allipblocklistdelete(Request $request)
    {
        $id_array = $request->input('id');

        $sendmails = IPLIST::whereIn('id', $id_array)->get();

        foreach ($sendmails as $sendmail) {
            $sendmail->delete();
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'IP address Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('The IP address has been successfully removed.', 'alerts')]);
    }

    public function resetipblock($id)
    {

        $ipreset = IPLIST::find($id);
        $ipreset->types = 'Unlock';
        $ipreset->update();
        $iplists = IPLIST::latest()->get();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'IP Block Resetted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('Updated Successfully', 'alerts'), 'iplists' => $iplists]);
    }
}
