<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\Seosetting;
use App\Models\Pages;
use App\Models\FaqCategory;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class FaqCategoryController extends Controller
{
    public function index()
    {

        $this->authorize('FAQ Category Access');
        $basic = Apptitle::first();
        $data['basic'] = $basic;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        $faqcategory = FaqCategory::latest()->get();
        $data['faqcategorys'] = $faqcategory;

        return view('admin.faq.faqcategoryindex')->with($data);

    }

    public function storeupdate(Request $request)
    {
        $this->authorize('FAQ Category Create');
        $validate = FaqCategory::find($request->faqcat_id);
        if(!$validate){
            $request->validate([
                'faqcategoryname'=> 'required|max:255|unique:faq_categories',

            ]);
        }
        if($validate){
            if($request->faqcategoryname == $validate->faqcategoryname){
                $request->validate([
                    'faqcategoryname'=> 'required|max:255',

                ]);
            }else{
                $request->validate([
                    'faqcategoryname'=> 'required|max:255|unique:faq_categories',

                ]);
            }
        }
        $faqcategory_id = $request->faqcat_id;
                $faqcategory_data =  [
                    'faqcategoryname' => $request->faqcategoryname,
                    'status' => $request->status ? '1' : '0',
                ];
        $faqcategory = FaqCategory::updateOrCreate(['id' => $faqcategory_id], $faqcategory_data);

        $toatlfaqcat = FaqCategory::latest()->get();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = $faqcategory_id != null ? 'FAQ Category Updated' : 'FAQ Category Created';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        if($faqcategory_id != null){
            return response()->json(['code'=>200, 'success'=> lang('The FAQ Category has been successfully updated.', 'alerts'),'data' => $faqcategory,'toatlfaqcat' => $toatlfaqcat], 200);
        }else{
            return response()->json(['code'=>200, 'success'=> lang('The FAQ Category has been successfully created.', 'alerts'),'data' => $faqcategory,'toatlfaqcat' => $toatlfaqcat], 200);
        }
    }

    public function faqcategorylist(Request $request)
    {
        $this->authorize('FAQ Category Edit');
        $faqcategorylist = FaqCategory::get();

        $faqcatlist = '';

        $faqcatlist .= '<option label ="Select Faq Category"></option>';
        foreach($faqcategorylist as $faqcategorylists)
        {
            $faqcatlist .= '<option value='.$faqcategorylists->id.'>'.$faqcategorylists->faqcategoryname.'</option>';
        }

        return response()->json($faqcatlist, 200);

    }

    public function edit($id)
    {
        $this->authorize('FAQ Category Edit');

        $faqsubcatlist = FaqCategory::find($id);
        return response()->json($faqsubcatlist);

    }

    public function destroy($id)
    {
        $this->authorize('FAQ Category Delete');

        $faqsubcatdelete = FaqCategory::find($id);
        $faqsubcatdelete->delete();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'FAQ Category Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('Deleted Successfully', 'alerts')], 200);

    }

    public function allfaqcategorydelete(Request $request)
    {
        $this->authorize('FAQ Category Delete');
        $id_array = $request->input('id');

        $allfaqcategorydeletes = FaqCategory::whereIn('id', $id_array)->get();

        foreach($allfaqcategorydeletes as $allfaqcategorydelete){
            $allfaqcategorydelete->delete();

        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Multiple FAQ Categories Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success'=> lang('Deleted Successfully', 'alerts')]);
    }


    public function status(Request $request, $id)
    {
        $this->authorize('FAQ Category Edit');
        $calID = FaqCategory::find($id);
        $calID->status = $request->status;
        $calID->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'FAQ Category Status Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code'=>200, 'success'=>lang('Updated Successfully', 'alerts')], 200);

    }
}
