<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\FAQ;
use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\Seosetting;
use App\Models\Pages;
use App\Models\FaqCategory;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class FAQController extends Controller
{
    public function index()
	{

     	$this->authorize('FAQs Access');
        $faq = FAQ::with('faqcategory')->get();
        $data['faqs'] = $faq;

        $basic = Apptitle::first();
        $data['basic'] = $basic;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        return view('admin.faq.index')->with($data)->with('i', (request()->input('page', 1) - 1) * 5);
    }


    public function faqcreate()
    {
        $this->authorize('FAQs Create');
        $basic = Apptitle::first();
        $data['basic'] = $basic;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        $faqcategory = FaqCategory::where('status',1)->latest()->get();
        $data['faqcategorys'] = $faqcategory;

        return view('admin.faq.faqcat')->with($data);
    }

    public function store(Request $request)
  	{
        $request->validate([
            'question'=> 'required|max:255',
            'answer' => 'required',
            'faqcatsname' => 'required',
        ]);

        $faq = FAQ::updateOrCreate(
            ['id' => $request->faq_id],
            [	'question' => $request->question,
                'answer' => $request->answer,
                'faqcat_id' => $request->faqcatsname,
                'status' => $request->status == 'on' ? 1 : 0
            ]
        );

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = $request->faq_id != null ? 'FAQ Updated' : 'FAQ Created';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        if($request->faq_id != null){
            return redirect()->route('faq.index')->with('success', lang('The FAQ has been successfully updated.', 'alerts'));
        }else{
            return redirect()->route('faq.index')->with('success', lang('The FAQ has been successfully created.', 'alerts'));
        }

  	}

    public function show($id)
    {
        $this->authorize('FAQs Edit');

        $basic = Apptitle::first();
        $data['basic'] = $basic;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        $faq = FAQ::find($id);
        $data['faq'] = $faq;

        $faqcategory = FaqCategory::where('status',1)->latest()->get();
        $data['faqcategorys'] = $faqcategory;

        return view('admin.faq.faqcatedit')->with($data);
    }

	public function destroy($id)
	{
		$this->authorize('FAQs Delete');
		$faq = FAQ::find($id);
		$faq->delete();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'FAQ Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

		return response()->json(['success'=>lang('The FAQ has been successfully deleted.', 'alerts')]);
	}


	public function allfaqdelete(Request $request)
	{
		$id_array = $request->input('id');

		$sendmails = FAQ::whereIn('id', $id_array)->get();

		foreach($sendmails as $sendmail){
			$sendmail->delete();

		}

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Multiple FAQ’s Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

		return response()->json(['success'=> lang('The FAQ has been successfully deleted.', 'alerts')]);

	}

	public function faq(Request $request)
	{
		$request->validate([
			'faqtitle'=> 'required|max:255',
		]);

		if($request->faqsub){
			$request->validate([
				'faqsub' => 'max:255'
			]);
		}
		$calID = ['id' => $request->id];
		$calldetails = [

			'faqtitle'  => $request->faqtitle,
			'faqsub'    => $request->faqsub,
			'faqcheck'  => $request->has('faqcheck') ? 'on' : 'off',

		];

		$callaction = Apptitle::updateOrCreate(
		['id' => $calID], $calldetails);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'FAQ’s Section Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

		return redirect()->back()->with('success', lang('Updated Successfully', 'alerts'));
	}

	public function status(Request $request, $id)
    {
        $calID = FAQ::find($id);
        $calID->status = $request->status;
        $calID->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'FAQ Status Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code'=>200, 'success'=> lang('Updated Successfully', 'alerts')], 200);

    }

}
