<?php

namespace App\Http\Controllers\Admin;

use App\Events\ChatMessageEvent;
use App\Events\LiveNotification;
use App\Http\Controllers\Controller;
use App\Jobs\MailSend;
use Illuminate\Http\Request;

use App\Models\Ticket\Comment;
use App\Models\Ticket\Ticket;
use App\Models\User;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use App\Notifications\TicketCreateNotifications;
use Mail;
use App\Models\Ratingtoken;
use App\Models\CCMAILS;
use App\Models\EmailTemplate;
use Symfony\Component\Mime\Email;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;

class CommentsController extends Controller
{

    public function postComment(Request $request,  $ticket_id)
    {

        if ($request->status == 'Solved') {

            $this->validate($request, [
                'comment' => 'required'
            ]);
            $comment = Comment::create([
                'ticket_id' => $request->input('ticket_id'),
                'user_id' => Auth::user()->id,
                'cust_id' => null,
                'comment' => $request->input('comment'),
            ]);

            foreach ($request->input('comments', []) as $file) {
                $provider =  storage()->provider;
                $provider::mediaupload($comment, 'uploads/comment/' . $file, 'comments');
            }

            $ticket = Ticket::with('users','selfassign')->where('ticket_id', $ticket_id)->firstOrFail();
            $ticket->status = 'Closed';
            $ticket->replystatus = $request->input('status');
            // Auto Close Ticket
            $ticket->auto_close_ticket = null;
            // Auto Response Ticket
            $ticket->auto_replystatus = null;
            $ticket->last_reply = now();
            $ticket->closing_ticket = now();
            $ticket->auto_overdue_ticket = null;
            $ticket->overduestatus = null;
            $ticket->importantticket = null;
            $ticket->closedby_user = Auth::id();
            $ticket->lastreply_mail = Auth::id();

            if ($request->reopen_on_off == null) {
                $ticket->ticketreopen = 'stopreopen';
            } else {
                $ticket->ticketreopen = null;
            }
            $ticket->update();

            $ratingtoken =  Ratingtoken::create([

                'token' => str_random(64),
                'ticket_id' => $ticket->id,
            ]);

            $closed_agent = User::findOrFail(Auth::id());
            $ccemailsend = CCMAILS::where('ticket_id', $ticket->id)->first();


            if (setting('ticketrating') == 'on') {
                $ticketData = [
                    'closed_agent_name' => $closed_agent->name,
                    'closed_agent_role' => $closed_agent->getRoleNames()[0],
                    'ticket_username' => $ticket->cust->username,
                    'ticket_title' => $ticket->subject,
                    'ticket_id' => $ticket->ticket_id,
                    'comment' => $comment->comment,
                    'ticket_status' => $ticket->status,
                    'ticket_admin_url' => fetchticketviewurl($ticket),
                    'ticket_category' => $ticket->category != null ? $ticket->category->name : 'Category not available',
                    'item_name' => $ticket->item_name != null ? $ticket->item_name : 'Item Name not available',
                ];
            } else {
                $ticketData = [
                    'closed_agent_name' => $closed_agent->name,
                    'closed_agent_role' => $closed_agent->getRoleNames()[0],
                    'ticket_username' => $ticket->cust->username,
                    'ticket_title' => $ticket->subject,
                    'ticket_id' => $ticket->ticket_id,
                    'comment' => $comment->comment,
                    'ticket_status' => $ticket->status,
                    'ratinglink' => route('guest.rating', $ratingtoken->token),
                    'ticket_admin_url' => fetchticketviewurl($ticket),
                    'ticket_category' => $ticket->category != null ? $ticket->category->name : 'Category not available',
                    'item_name' => $ticket->item_name != null ? $ticket->item_name : 'Item Name not available',
                ];
            }

            $comment->image_url = $comment->getMedia('comments');

            $imageurlagent = null;
            if($comment->user_id == '741741741'){
                $imageurlagent = asset('botprofile/'.setting('bot_image'));
            }else{
                $imageurlagent = userprofileimage(Auth::user());
            }

            $ticketinfo = view('admin.superadmindashboard.allticketsinfo', compact('ticket'))->render();
            $comment->ticketinfo = $ticketinfo;
            $comment->ticketclosingreply = 'ticketclosingreply';
            $comment->assigneduserprofile = $ticket->selfassign != null ? userprofileimage($ticket->selfassign) : null;
            $comment->ticketencryptedId = Crypt::encrypt($ticket->id);
            $comment->ticketfulldata = $ticket;

            event(new ChatMessageEvent(null,null,null,null,null,null,$imageurlagent,Auth::user(),null,null,null,null,null,null,null,null,$ticket->id,$ticket->cust->id,$comment,'agentticketreply',$ticket->cust->username));

            $comment = Comment::create([
                'ticket_id' => $ticket->id,
                'user_id' => Auth::user()->id,
                'cust_id' => null,
                'comment' => 'Ticket status changed to Solved',
                'commenttype' => 'tickethistory',
            ]);

            $comment->ticketinfo = $ticketinfo;

            event(new ChatMessageEvent(null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,$ticket->id,$ticket->cust->id,$comment,'tickethistory',Auth::user()->name));

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Ticket status changed to Solved';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            try {

                if ($ticket->tickettype == 'emalitoticket') {
                    $replySubject = 'Re: ' . $ticket->subject;
                    if (setting('ticketrating') == 'on') {
                        $emailtempcode = 'send_mail_to_customer_when_ticket_closed_by_admin';
                    } else {
                        $emailtempcode = 'customer_rating';
                    }

                    $emailtemplate = EmailTemplate::where('code', $emailtempcode)->first();
                    $body = $emailtemplate->body;

                    $imap_username = setting('IMAP_USERNAME');

                    foreach ($ticketData as $key => $value) {
                        $body = str_replace('{{' . $key . '}}', $value, $body);
                        $body = str_replace('{{ ' . $key . ' }}', $value, $body);
                    }
                    $fileNames = [];


                    $email = (new Email())->html($body);

                    Mail::raw('', function ($message) use ($email, $ticket, $imap_username, $replySubject, $comment, &$fileNames) {
                        $message->from($imap_username)
                            ->to($ticket->cust->email)
                            ->subject($replySubject)
                            ->getHeaders()->addTextHeader('In-Reply-To', '<' . $ticket->MessageID . '>');

                        foreach ($comment->getMedia('comments') as $commentss) {
                            if (!file_exists('public/temp/')) {
                                mkdir('public/temp/', 0777, true);
                            }
                            $localTempFilePath = 'public/temp/' . $commentss->file_name;
                            $existprovider = existprovider($commentss->disk);
                            if ($existprovider)
                                $contentPath = $existprovider->provider::tempImage($commentss, $localTempFilePath);

                            $message->attach($contentPath);
                            $fileNames[] = $localTempFilePath;
                        }

                        $message->getHeaders()->addTextHeader('References', '<' . $ticket->MessageID . '>');
                        $message->setBody($email->getBody(), 'text/html');
                    });

                    foreach ($fileNames as $filePath) {
                        if (file_exists($filePath)) {
                            \File::delete($filePath);
                        }
                    }
                } else {
                    if (setting('ticketrating') == 'on') {
                        dispatch((new MailSend($ticket->cust->email, 'send_mail_to_customer_when_ticket_closed_by_admin', $ticketData)));
                    } else {
                        dispatch((new MailSend($ticket->cust->email, 'customer_rating', $ticketData)));
                    }
                }

                $assigneuser = User::find($ticket->selfassignuser_id);
                if($assigneuser != null){
                    $assigneuser->notify(new TicketCreateNotifications($ticket));
                    event(new LiveNotification($ticket->ticket_id . 'this ticket has been closed.',$ticket->id,$assigneuser,$ticket,fetchticketviewurl($ticket)));
                    if($assigneuser->usetting->emailnotifyon == 1){
                        dispatch((new MailSend($assigneuser->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                    }
                }

                $users = User::get();
                foreach($users as $user){
                    if($user->can('All Tickets') && $user->usetting->emailnotifyon == 1 && $user->id != $ticket->selfassignuser_id){
                        $user->notify(new TicketCreateNotifications($ticket));
                        event(new LiveNotification($ticket->ticket_id . 'this ticket has been closed.',$user,$ticket,fetchticketviewurl($ticket)));
                        dispatch((new MailSend($user->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                    }
                }

                if ($ccemailsend->ccemails != null) {
                    dispatch((new MailSend($ccemailsend->ccemails, 'CCmail_sendemail_whenticketclosed', $ticketData)));
                }


            } catch (\Exception $e) {
                return response()->json(['success' => lang('The response to the ticket was successful.', 'alerts')]);
            }

            return response()->json(['success' => lang('The response to the ticket was successful.', 'alerts')]);
        } else {



            $this->validate($request, [
                'comment' => 'required'
            ]);
            $tic = Ticket::where('ticket_id', $ticket_id)->firstOrFail();

            if ($tic->comments()->get() != null) {
                $comm = $tic->comments()->update([
                    'display' => null
                ]);
            }

            $comment = Comment::create([
                'ticket_id' => $request->input('ticket_id'),
                'user_id' => Auth::user()->id,
                'cust_id' => null,
                'comment' => $request->input('comment'),
                'display' => 1,
            ]);

            foreach ($request->input('comments', []) as $file) {
                $provider =  storage()->provider;
                $provider::mediaupload($comment, 'uploads/comment/' . $file, 'comments');
            }

            $ticket = Ticket::where('ticket_id', $ticket_id)->firstOrFail();
            $ticket->status = $request->input('status');
            $ticket->replystatus = 'Waiting';
            if ($request->status == 'On-Hold') {
                $ticket->note = $request->input('note');
                // Auto Close Ticket
                $ticket->auto_close_ticket = null;
                // Auto Response Ticket
                $ticket->auto_replystatus = null;
                //Auto Overdue Ticket
                $ticket->auto_overdue_ticket = null;
                $ticket->overduestatus = null;
            } else {
                // Auto Closing Ticket
                if (setting('AUTO_CLOSE_TICKET') == 'no') {
                    $ticket->auto_close_ticket = null;
                } else {
                    if (setting('AUTO_CLOSE_TICKET_TIME') == '0') {
                        $ticket->auto_close_ticket = null;
                    } else {
                        if (Auth::check() && Auth::user()) {
                            if ($ticket->status == 'Closed') {
                                $ticket->auto_close_ticket = null;
                            } else {
                                $ticket->auto_close_ticket = now()->addHours(setting('AUTO_RESPONSETIME_TICKET_TIME'))->addDays(setting('AUTO_CLOSE_TICKET_TIME'));
                            }
                        }
                    }
                }
                // End Auto Close Ticket

                // Auto Response Ticket

                if (setting('AUTO_RESPONSETIME_TICKET') == 'no') {
                    $ticket->auto_replystatus = null;
                } else {
                    if (setting('AUTO_RESPONSETIME_TICKET_TIME') == '0') {
                        $ticket->auto_replystatus = null;
                    } else {
                        if (Auth::check() && Auth::user()) {
                            $ticket->auto_replystatus = now()->addHours(setting('AUTO_RESPONSETIME_TICKET_TIME'));
                        }
                    }
                }
                // End Auto Response Ticket

                // Auto Overdue Ticket
                if (setting('AUTO_OVERDUE_TICKET') == 'no') {
                    $ticket->auto_overdue_ticket = null;
                    $ticket->overduestatus = null;
                } else {
                    if (setting('AUTO_OVERDUE_TICKET_TIME') == '0') {
                        $ticket->auto_overdue_ticket = null;
                        $ticket->overduestatus = null;
                    } else {
                        if (Auth::check() && Auth::user()) {
                            if ($ticket->status == 'Closed') {
                                $ticket->auto_overdue_ticket = null;
                                $ticket->overduestatus = null;
                            } else {
                                $ticket->auto_overdue_ticket = null;
                                $ticket->overduestatus = null;
                            }
                        }
                    }
                }
                // End Auto Overdue Ticket
            }
            $ticket->last_reply = now();
            $ticket->lastreply_mail = Auth::id();
            $ticket->importantticket = null;
            $ticket->closedby_user = null;
            $ticket->update();

            $ccemailsend = CCMAILS::where('ticket_id', $ticket->id)->first();

            $ticketData = [
                'ticket_username' => $ticket->cust->username,
                'ticket_title' => $ticket->subject,
                'ticket_id' => $ticket->ticket_id,
                'ticket_status' => $ticket->status,
                'comment' => $comment->comment,
                'ticket_admin_url' => fetchticketviewurl($ticket),
                'ticket_category' => $ticket->category != null ? $ticket->category->name : 'Category not available',
                'item_name' => $ticket->item_name != null ? $ticket->item_name : 'Item Name not available',
            ];

            $commentimages = [];
            foreach($comment->getMedia('comments') as $media){
                array_push($commentimages,$media->geturl());
            }

            $comment->image_url = $commentimages;

            $imageurlagent = null;
            if($comment->user_id == '741741741'){
                $imageurlagent = asset('botprofile/'.setting('bot_image'));
            }else{
                $imageurlagent = userprofileimage(Auth::user());
            }

            event(new ChatMessageEvent(null,null,null,null,null,null,$imageurlagent,Auth::user(),null,null,null,null,null,null,null,null,$ticket->id,$ticket->cust->id,$comment,'agentticketreply',$ticket->cust->username));

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Replied To The Ticket';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            try {

                if ($ticket->tickettype == 'emalitoticket') {
                    $imap_username = setting('IMAP_USERNAME');

                    $replySubject = 'Re: ' . $ticket->subject;
                    $emailtemplate = EmailTemplate::where('code', 'customer_send_ticket_reply')->first();
                    $body = $emailtemplate->body;

                    foreach ($ticketData as $key => $value) {
                        $body = str_replace('{{' . $key . '}}', $value, $body);
                        $body = str_replace('{{ ' . $key . ' }}', $value, $body);
                    }
                    $fileNames = [];

                    try {

                        Mail::send([], [], function ($message) use ($ticket, $replySubject, $body, $comment, $imap_username, &$fileNames) {
                            $message->to($ticket->cust->email)
                                ->from($imap_username)
                                ->subject($replySubject)
                                ->html($body);
                            foreach ($comment->getMedia('comments') as $commentss) {
                                if (!file_exists('public/temp/')) {
                                    mkdir('public/temp/', 0777, true);
                                }
                                $localTempFilePath = 'public/temp/' . $commentss->file_name;
                                $existprovider = existprovider($commentss->disk);
                                if ($existprovider)
                                    $contentPath = $existprovider->provider::tempImage($commentss, $localTempFilePath);

                                $message->attach($contentPath);
                                $fileNames[] = $localTempFilePath;
                            }
                            $headers = $message->getHeaders();
                            $headers->addTextHeader('In-Reply-To', '<' . $ticket->MessageID . '>');
                            $headers->addTextHeader('References', '<' . $ticket->MessageID . '>');
                        });
                    } catch (\Exception $e) {

                    }

                    foreach ($fileNames as $filePath) {
                        if (file_exists($filePath)) {
                            \File::delete($filePath);
                        }
                    }

                } else {
                    dispatch((new MailSend($ticket->cust->email, 'customer_send_ticket_reply', $ticketData)));
                }

                if ($ccemailsend && $ccemailsend->ccemails) {
                    dispatch((new MailSend($ccemailsend->ccemails, 'customer_send_ticket_reply', $ticketData)));
                }


            } catch (\Exception $e) {
                return response()->json(['success' => lang('The response to the ticket was successful.', 'alerts')]);
            }

            return response()->json(['success' => lang('The response to the ticket was successful.', 'alerts')]);
        }
    }

    public function storeMedia(Request $request)
    {
        $path = public_path('uploads/comment');

        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }

        $file = $request->file('file');

        $name =  time() . '' . $file->getClientOriginalName();

        $file->move($path, $name);

        return response()->json([
            'name'          => $name,
            'original_name' => $file->getClientOriginalName(),
        ]);
    }

    public function imagedestroy($id)
    {
        //For Deleting Users
        $commentss = Media::findOrFail($id);
        $commentss->delete();
        return response()->json([
            'success' => lang('Deleted Successfully', 'alerts')
        ]);
    }
}
