<?php

namespace App\Http\Controllers\Admin;

use App\Events\ChatMessageEvent;
use App\Http\Controllers\Controller;
use App\Jobs\MailSend;
use Illuminate\Http\Request;

use App\Models\Ticket\Category;
use App\Models\Ticket\Ticket;
use DB;
use App\Models\Apptitle;
use App\Models\CategoryEnvato;
use App\Models\Footertext;
use App\Models\Seosetting;
use App\Models\Pages;
use App\Models\User;
use App\Models\Subcategory;
use App\Models\Subcategorychild;
use App\Models\Ticket\Comment;
use Illuminate\Support\Facades\Validator;
use Response;
use Str;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class CategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('Category Access');

            $categories = DB::table('categories')->paginate();
            $data['categories'] = $categories;

            $title = Apptitle::first();
            $data['title'] = $title;

            $footertext = Footertext::first();
            $data['footertext'] = $footertext;

            $seopage = Seosetting::first();
            $data['seopage'] = $seopage;

            $post = Pages::all();
            $data['page'] = $post;

            $categories = Category::with('subcategorydata')->get();
            $data['categories'] = $categories;

            return view('admin.category.index')-> with($data)->with('i', (request()->input('page', 1) - 1) * 5);

    }

    public function status(Request $request, $id)
    {
            $calID = Category::find($id);
            $calID ->status = $request->status;
            $calID ->save();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Category Status Updated';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['code'=>200, 'success'=> lang('Updated successfully', 'alerts')], 200);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        if($request->display == 'knowledge'){
            $prirority = null;
        }else{
            $prirority = $request->priority;
        }

        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'display' => 'required|in:both,ticket,knowledge',

        ]);

        if($validator->passes()){


            $testiId = $request->testimonial_id;
            $categoryfind = Category::find($testiId);
            if($categoryfind){
                if($categoryfind->categoryslug == null){

                    $testi =  [
                        'name' => $request->name,
                        'display' => $request->display,
                        'priority' => $prirority,
                        'categoryslug' => Str::slug($request->name, '-'),
                        'status' => $request->status ?  '1' :  '0',
                    ];
                }
                if($categoryfind->categoryslug != null){

                    $testi =  [
                        'name' => $request->name,
                        'display' => $request->display,
                        'priority' => $prirority,
                        'status' => $request->status ?  '1' :  '0',
                    ];
                }
            }
            if(!$categoryfind){
                $testi =  [
                    'name' => $request->name,
                    'display' => $request->display,
                    'priority' => $prirority,
                    'categoryslug' => Str::slug($request->name, '-'),
                    'status' => $request->status ?  '1' :  '0',
                ];
            }



            $testimonial = Category::updateOrCreate(['id' => $testiId], $testi);

            $categories = Category::with('subcategorydata')->get();
            $data['categories'] = $categories;

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = $testiId != null ? 'Category Updated' : 'Category Created';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            if($testiId != null){
                $statustext = lang('The category was successfully updated.', 'alerts');
            }else{
                $statustext = lang('The category created successfully.', 'alerts');
            }

            return response()->json(['code'=>200, 'success'=> $statustext,'data' => $testimonial, 'categories' => $categories], 200);
        }else{
            return Response::json(['errors' => $validator->errors()]);
        }



    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $this->authorize('Category Edit');
        $post = Category::find($id);

        $data = [
            'post' => $post,
        ];
        return response()->json($data);

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('Category Edit');
        $categories = Category::where('id', $id)->findOrFail();
        $data['categories'] = $categories;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $title = Apptitle::first();
        $data['title'] = $title;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        return view('admin.category.showcategory')-> with($data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'catogorynam' => 'required|string|max:255',

        ]);
        $Category = Category::findOrFail($id);

        $Category->name = $request->input('catogorynam');
        $Category->update();
        return redirect('/admin/categories')->with('success', lang('The category was successfully updated.', 'alerts'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->authorize('Category Delete');
        $Category = Category::findOrFail($id);

        $Category->delete();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Category Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success'=> lang('The category was successfully deleted.', 'alerts')]);
    }



    public function agentshowcreate(Request $request)
    {

        $data =  $request->assigned_id;
        $cat = Category::find($data);
        $cat->update($request->only(['assigned_name']));

        if($request->input('assigned_user_id')){
            foreach ($request->input('assigned_user_id') as $value) {
                $assigned_user_id[] = $value;
            }
        }

        $cat->catagent()->sync($request->get('assigned_user_id'));

        return response()->json(['success'=> lang('Updated successfully', 'alerts')]);

    }

    /// category list

    public function categorylist(Request $req, $ticket_id)
    {

        if($req->ajax()){
            $output = '';
            $category = Category::whereIn('display',['ticket', 'both'])->where('status', '1')->get();


            $totalrow = $category->count();
            $ticket = DB::table('tickets')->where('ticket_id', $ticket_id)->first();

            $envatoassignstatus = null;
            if($ticket->category_id != null){
                $envatocat = Category::find($ticket->category_id);

                if($envatocat != null){
                    $envatoassigncat = $envatocat->envato->first();
                    if($envatoassigncat != null){
                        $envatoassignstatus = 'assignedtoenvato';
                    }else{
                        $envatoassignstatus = null;
                    }
                }else{
                    $envatoassignstatus = null;
                }
            }
            if($totalrow > 0){
                $output .='<option label="Select Category"></option>';
                foreach($category as $categories){
                    $output .= '
                    <option  value="'.$categories->id.'"'.($categories->id == $ticket->category_id ? 'selected': '').'>'.$categories->name.'</option>
                    ';
                }
            }else{
                $output .= '
                <option label="No Data Found"></option>
                ';
            }

            $subcategory = '';
            $ticket1 = DB::table('tickets')->where('ticket_id', $ticket_id)->first();
            $category1 = Subcategorychild::where('category_id',$ticket1->category_id)->get();

            $myArray = [];
            $totalrow1 = $category1->count();
            if($totalrow1 > 0){
                $subcategory .='<option label="Select Category"></option>';
                foreach($category1 as $categories){

                    foreach ($categories->subcatlists()->where('status', '1')->get() as $subcategorylist) {
                      $myArray[] = $subcategorylist;
                       $subcategory .= '
                        <option  value="'.$subcategorylist->id.'"'.($subcategorylist->id == $ticket1->subcategory ? 'selected': '').'>'.$subcategorylist->subcategoryname.'</option>
                        ';
                    }

                }
            }

            $data = array(
                'subCatStatus' =>$myArray,
                'table_data' => $output,
                'total_data' => $totalrow,
                'ticket' => $ticket,
                'subcategoryt' => $subcategory,
                'envatoassignstatus' => $envatoassignstatus,
            );

          return response()->json($data, 200);
        }


    }


    public function categorychange(Request $req)
    {
        $categories = CategoryEnvato::where('category_id',$req->category)->first();

        if(setting('ENVATO_ON') == 'on' && $categories != null){
            if($req->envato_id == 'undefined' || $req->envato_id == null || isset($req->envato_id) == false){
                return response()->json(['message' => 'envatoerror', 'error' => lang('Please enter valid purchasecode to change the category.', 'alerts')], 500);
            }
        }

        $subcategoriess = Subcategorychild::where('category_id', $req->category)->pluck('subcategory_id')->toArray();
        if($subcategoriess != null && $req->subscategory != null && !in_array($req->subscategory, $subcategoriess)){
            return response()->json(['message' => 'subcaterror', 'error' => lang('Please select correct subcategory to change the category.', 'alerts')], 500);
        }

        $this->validate($req, [
            'category' => 'required',
        ]);

        $ticketcategory = Ticket::find($req->ticket_id);
        if($ticketcategory->category_id != null && $ticketcategory->category_id == $req->category && $ticketcategory->subcategory == $req->subscategory){
            return response()->json(['error' => lang('you are not change anything if you want update it change anything.', 'alerts')]);
        }

        if($ticketcategory->category_id == null){
            $oldcategoryName = '';
        }else{
            //old category name
            $oldcategory = Category::find($ticketcategory->category_id);
            $oldcategoryName = $oldcategory->name;
        }

        $ticketcategory->category_id = $req->category;
        $ticketcategory->project = $req->project;
        $ticketcategory->subcategory = $req->subscategory;
        $categories = CategoryEnvato::where('category_id',$req->category)->first();
        if($req->envato_id && $categories){
            $ticketcategory->purchasecode = encrypt($req->envato_id);
            $ticketcategory->purchasecodesupport = $req->envato_support;
            if($req->productname){
                $ticketcategory->item_name = $req->productname;
            }
        }else{
            $ticketcategory->purchasecode = null;
            $ticketcategory->purchasecodesupport = null;
            $ticketcategory->item_name = null;
        }




        $findcat = Category::find($req->category);
        // new category or changed category
        $changedcategory = $findcat->name;
        $ticketcategory->priority = $findcat->priority;
        $ticketcategory->update();

        $comment = Comment::create([
            'ticket_id' => $ticketcategory->id,
            'user_id' => Auth::user()->id,
            'cust_id' => null,
            'comment' => 'Ticket category changed',
            'commenttype' => 'tickethistory',
        ]);

        $ticketData = [
            'ticket_username' => $ticketcategory->cust->username,
            'ticket_id' => $ticketcategory->ticket_id,
            'ticket_title' => $ticketcategory->subject,
            'ticket_description' => $ticketcategory->message,
            'ticket_status' => $ticketcategory->status,
            'ticket_oldcategory' => $oldcategoryName,
            'ticket_changedcategory' => $changedcategory,
            'ticket_admin_url' => fetchticketviewurl($ticketcategory),
            'ticket_category' => $ticketcategory->category != null ? $ticketcategory->category->name : 'Category not available',
            'item_name' => $ticketcategory->item_name != null ? $ticketcategory->item_name : 'Item Name not available',
        ];


        $ticket = $ticketcategory;
        $ticketinfo = view('admin.superadmindashboard.allticketsinfo', compact('ticket'))->render();
        $comment->ticketinfo = $ticketinfo;

        event(new ChatMessageEvent(null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,$ticketcategory->id,$ticketcategory->cust->id,$comment,'tickethistory',Auth::user()->name));

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Ticket category changed';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        try{
            $assigneuser = User::find($ticketcategory->selfassignuser_id);
            if($assigneuser->usetting->emailnotifyon == 1 && Auth::id() != $assigneuser->id){
                dispatch((new MailSend($assigneuser->email, 'send_mail_admin_panel_users_when_category_changed', $ticketData)));
            }

            $users = User::get();
            foreach($users as $user){
                if($user->can('All Tickets') && $user->usetting->emailnotifyon == 1 && $user->id != $ticketcategory->selfassignuser_id  && Auth::id() != $user->id){
                    dispatch((new MailSend($user->email, 'send_mail_admin_panel_users_when_category_changed', $ticketData)));
                }
            }
        }
        catch(\Exception $e){
            return response()->json(['success' => lang('Updated successfully', 'alerts')]);
        }

        return response()->json(['success' => lang('Updated successfully', 'alerts')]);


    }

    public function categorylistshow(Request $request)
    {

        if($request->ajax()){

            $output = '';
            $category = Category::whereIn('display',['ticket', 'both'])->where('status', '1')->get();

            $categoryenvato = CategoryEnvato::pluck('category_id')->toArray();


            $totalrow = $category->count();

            if($totalrow > 0){
                $output .='<option label="Select Category"></option>';
                foreach($category as $categories){
                    $output .= '
                    <option  value="'.$categories->id.'" '.(in_array($categories->id, $categoryenvato) ? 'selected':'' ).'>'.$categories->name.'</option>
                    ';
                }
            }
            return response()->json($output, 200);
        }

    }

    public function categoryenvatoassign(Request $r)
    {

        if($r->input('categorys_id') != null){

            $categories = CategoryEnvato::get();

            foreach($categories as $category){

                $category->truncate();
            }
            foreach($r->input('categorys_id') as $value){

                $category = CategoryEnvato::create([
                    'category_id' => $value,
                    'envato_enable' => '1'
                ]);

            }
        }else{

            $categories = CategoryEnvato::get();

            foreach($categories as $category){

                $category->truncate();
            }
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Category Envato Api Assign Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('Updated successfully', 'alerts'), 200]);


    }

    public function subcategoryindex()
    {
        $this->authorize('Subcategory Access');
        $subcategory = Subcategory::with('subcategorylist.subcatlistss')->get();
        $data['subcategory'] = $subcategory;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        return view('admin.category.subcategory')->with($data);
    }

    public function categorygetall(Request $request)
    {
        $categoryall = Category::where('status', 1)->get();

        $output = '';
        if($categoryall != ''){
            $output .= '<option label="No Parent"></option>';
            foreach($categoryall as $catall){
                $output .= '<option value="'.$catall->id.'">'.$catall->name.' </option>';
            }
        }
        return response()->json($output);
    }

    public function subcategorystore(Request $request)
    {


        $validate = Subcategory::find($request->subcategory_id);

        if(!$validate){
            $validator = Validator::make($request->all(), [
                'subcategoryname' => 'required|string|max:255|unique:subcategorysd',

            ]);
        }
        if($validate){
            if($validate->subcategoryname == $request->subcategoryname){
                $validator = Validator::make($request->all(), [
                    'subcategoryname' => 'required|string|max:255',

                ]);
            }else{
                $validator = Validator::make($request->all(), [
                    'subcategoryname' => 'required|string|max:255|unique:subcategorysd',

                ]);
            }
        }

        if($validator->passes()){

            $testiId = $request->subcategory_id;
            $testi =  [
                'subcategoryname' => $request->subcategoryname,
                'status' => $request->status ?  '1' :  '0',
            ];
            $testimonial = Subcategory::updateOrCreate(['id' => $testiId], $testi);

            if($request->parent_id){
                foreach ($request->parent_id as $value) {
                    $parent_id[] = $value;
                }
            }

            $testimonial->subcategorysync()->sync($request->get('parent_id'));

            $subcategory = Subcategory::with('subcategorylist.subcatlistss')->get();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = $testiId != null ? 'subcategory Updated' : 'subcategory Created';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            if($testiId != null){
                return response()->json(['code'=>200, 'success'=> lang('The subcategory was successfully updated.', 'alerts'),'data' => $testimonial,'subcategory' => $subcategory], 200);
            }else{
                return response()->json(['code'=>200, 'success'=> lang('The subcategory was successfully created.', 'alerts'),'data' => $testimonial,'subcategory' => $subcategory], 200);
            }
        }else{
            return Response::json(['errors' => $validator->errors()]);
        }
    }

    public function subcategoryshow($id)
    {
        $subcategory = Subcategory::find($id);

        if(request()->ajax()){
            $categoryall = Category::get();

            $categoryArray = Subcategorychild::where("subcategory_id",$id)->pluck('category_id')->toArray();


            $output = '';
            if($categoryall != ''){
                $output .= '<option label="No Parent"></option>';
                foreach($categoryall as $catall){
                    $output .= '<option value="'.$catall->id.'"'.($catall->id  ? in_array($catall->id,$categoryArray) ?  'selected' : '' : '').'>'.$catall->name.' </option>';
                }
            }
        }
        $data = [
            'subcategory' => $subcategory,
            'categorylist' => $output
        ];
        return response()->json($data);

    }

    public function subcategorystatusupdate(Request $request)
    {
        $subcategorystatus = Subcategory::find($request->id);
        $subcategorystatus->status = $request->status;
        $subcategorystatus->update();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'subcategory Status Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json([$subcategorystatus, 'success' => lang('Updated successfully', 'alerts')], 200);
    }

    public function subcategorydelete(Request $request)
    {
        $subcategorydelete = Subcategory::find($request->id);
        $subcategorydelete->delete();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'subcategory Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json([$subcategorydelete, 'success' => lang('Deleted successfully', 'alerts')], 200);
    }


    public function categorymassdestroy(Request $request)
    {
        $category_id_array = $request->input('id');

        $articles = Category::whereIn('id', $category_id_array)->get();

        foreach($articles as $article){

            $article->delete();
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Multiple Categories Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success'=> lang('The category was successfully deleted.', 'alerts')]);

    }


    public function subcategorydeleteall(Request $request)
    {
        $subcategory_id_array = $request->input('id');

        $subcats = Subcategory::whereIn('id', $subcategory_id_array)->get();

        foreach($subcats as $subcat){

            $subcat->delete();
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Multiple subcategories Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success'=> lang('The subcategory was successfully deleted.', 'alerts')]);
    }


}
