<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\Seosetting;
use App\Models\Bussinesshours;
use App\Models\PersonalBusinessHours;
use App\Models\Setting;
use App\Models\User;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class BussinesshourController extends Controller
{
    public function index()
    {
        $this->authorize('Business Hours Access');
        $basic = Apptitle::first();
        $data['basic'] = $basic;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $bussiness1 = Bussinesshours::where('no_id', '1')->first();
        $data['bussiness1'] = $bussiness1;
        $bussiness2 = Bussinesshours::where('no_id', '2')->first();
        $data['bussiness2'] = $bussiness2;
        $bussiness3 = Bussinesshours::where('no_id', '3')->first();
        $data['bussiness3'] = $bussiness3;
        $bussiness4 = Bussinesshours::where('no_id', '4')->first();
        $data['bussiness4'] = $bussiness4;
        $bussiness5 = Bussinesshours::where('no_id', '5')->first();
        $data['bussiness5'] = $bussiness5;
        $bussiness6 = Bussinesshours::where('no_id', '6')->first();
        $data['bussiness6'] = $bussiness6;
        $bussiness7 = Bussinesshours::where('no_id', '7')->first();
        $data['bussiness7'] = $bussiness7;

        return view('admin.bussinesshour.index')->with($data);
    }

    public function businesshoursreset()
    {
        $this->authorize('Business Hours Access');

        $businesshours = Bussinesshours::get();
        foreach($businesshours as $businesshour){
            $businesshour->delete();
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Business hours Resetted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('Business hours Resetted successfully.')], 200);
    }

    public function store(Request $request)
    {

        if($request->starttime1 != null || $request->endtime1 != null ||$request->starttime2 != null || $request->endtime2 != null || $request->starttime3 != null || $request->endtime3 != null || $request->starttime4 != null || $request->endtime4 != null || $request->starttime5 != null || $request->endtime5 != null || $request->starttime6 != null || $request->endtime6 != null || $request->starttime7 != null || $request->endtime7 != null)
        {
            if($request->starttime1 != $request->endtime1 ||$request->starttime2 != $request->endtime2 || $request->starttime3 != $request->endtime3 || $request->starttime4 != $request->endtime4 ||$request->starttime5 != $request->endtime5 || $request->starttime6 != $request->endtime6 || $request->starttime7 != $request->endtime7){

                $this->bussinessstore($request);
                return redirect()->back()->with('success', lang('Updated successfully', 'alerts'));
            }
            else{

                return redirect()->back()->with('error', lang('Cannot Update the data', 'alerts'));
            }
        }
        $this->bussinessstore($request);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Business Hours Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return redirect()->back()->with('success', lang('Updated successfully', 'alerts'));
    }

    private function bussinessstore($request)
    {
        $bussinessid1 = $request->bussinessid1;
        $bussiness1 = $request->bussiness1;
        $starttime1 = $request->starttime1;
        $endtime1 = $request->endtime1;
        $status1 = $request->status1;
        $breakstarttime1 = $request->breakstart1;
        $breakendtime1 = $request->breakend1;

        $ticket1 = [
            'no_id' => $bussinessid1,
            'weeks' => $bussiness1,
            'starttime' => $starttime1,
            'endtime' => $endtime1,
            'status' => $status1,
            'breakstarttime' => $breakstarttime1,
            'breakendtime' => $breakendtime1,
        ];
        $buss1 = Bussinesshours::updateOrCreate(['no_id' => $bussinessid1], $ticket1);

        $bussinessid2 = $request->bussinessid2;
        $bussiness2 = $request->bussiness2;
        $starttime2 = $request->starttime2;
        $endtime2 = $request->endtime2;
        $status2 = $request->status2;
        $breakstarttime2 = $request->breakstart2;
        $breakendtime2 = $request->breakend2;

        $ticket2 = [
            'no_id' => $bussinessid2,
            'weeks' => $bussiness2,
            'starttime' => $starttime2,
            'endtime' => $endtime2,
            'status' => $status2,
            'breakstarttime' => $breakstarttime2,
            'breakendtime' => $breakendtime2,
        ];
        $buss2 = Bussinesshours::updateOrCreate(['no_id' => $bussinessid2], $ticket2);

        $bussinessid3 = $request->bussinessid3;
        $bussiness3 = $request->bussiness3;
        $starttime3 = $request->starttime3;
        $endtime3 = $request->endtime3;
        $status3 = $request->status3;
        $breakstarttime3 = $request->breakstart3;
        $breakendtime3 = $request->breakend3;

        $ticket3 = [
            'no_id' => $bussinessid3,
            'weeks' => $bussiness3,
            'starttime' => $starttime3,
            'endtime' => $endtime3,
            'status' => $status3,
            'breakstarttime' => $breakstarttime3,
            'breakendtime' => $breakendtime3,
        ];
        $buss3 = Bussinesshours::updateOrCreate(['no_id' => $bussinessid3], $ticket3);

        $bussinessid4 = $request->bussinessid4;
        $bussiness4 = $request->bussiness4;
        $starttime4 = $request->starttime4;
        $endtime4 = $request->endtime4;
        $status4 = $request->status4;
        $breakstarttime4 = $request->breakstart4;
        $breakendtime4 = $request->breakend4;

        $ticket4 = [
            'no_id' => $bussinessid4,
            'weeks' => $bussiness4,
            'starttime' => $starttime4,
            'endtime' => $endtime4,
            'status' => $status4,
            'breakstarttime' => $breakstarttime4,
            'breakendtime' => $breakendtime4,
        ];
        $buss4 = Bussinesshours::updateOrCreate(['no_id' => $bussinessid4], $ticket4);

        $bussinessid5 = $request->bussinessid5;
        $bussiness5 = $request->bussiness5;
        $starttime5 = $request->starttime5;
        $endtime5 = $request->endtime5;
        $status5 = $request->status5;
        $breakstarttime5 = $request->breakstart5;
        $breakendtime5 = $request->breakend5;

        $ticket5 = [
            'no_id' => $bussinessid5,
            'weeks' => $bussiness5,
            'starttime' => $starttime5,
            'endtime' => $endtime5,
            'status' => $status5,
            'breakstarttime' => $breakstarttime5,
            'breakendtime' => $breakendtime5,
        ];
        $buss5 = Bussinesshours::updateOrCreate(['no_id' => $bussinessid5], $ticket5);

        $bussinessid6 = $request->bussinessid6;
        $bussiness6 = $request->bussiness6;
        $starttime6 = $request->starttime6;
        $endtime6 = $request->endtime6;
        $status6 = $request->status6;
        $breakstarttime6 = $request->breakstart6;
        $breakendtime6 = $request->breakend6;

        $ticket6 = [
            'no_id' => $bussinessid6,
            'weeks' => $bussiness6,
            'starttime' => $starttime6,
            'endtime' => $endtime6,
            'status' => $status6,
            'breakstarttime' => $breakstarttime6,
            'breakendtime' => $breakendtime6,
        ];
        $buss6 = Bussinesshours::updateOrCreate(['no_id' => $bussinessid6], $ticket6);

        $bussinessid7 = $request->bussinessid7;
        $bussiness7 = $request->bussiness7;
        $starttime7 = $request->starttime7;
        $endtime7 = $request->endtime7;
        $status7 = $request->status7;
        $breakstarttime7 = $request->breakstart7;
        $breakendtime7 = $request->breakend7;

        $ticket7 = [
            'no_id' => $bussinessid7,
            'weeks' => $bussiness7,
            'starttime' => $starttime7,
            'endtime' => $endtime7,
            'status' => $status7,
            'breakstarttime' => $breakstarttime7,
            'breakendtime' => $breakendtime7,
        ];
        $buss7 = Bussinesshours::updateOrCreate(['no_id' => $bussinessid7], $ticket7);



    }

    public function fullhours(Request $request)
    {
        if($request->fullhours == 'off'){
            $businesshours = Bussinesshours::get();
            foreach($businesshours as $businesshour){
                $businesshour->delete();
            }

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Business Hours Disabled 24 Hours';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
        }else{
            $businesshours = Bussinesshours::get();
            $barray = ['Mon','Tue','Wed','Thu','Fri','Sat','Sun'];
            $dayIndex = 0;
            if($businesshours->isEmpty()){
                $no_id_Index = 0;
                foreach($barray as $barrays){
                    $business = Bussinesshours::create([
                        'no_id' => $no_id_Index + 1,
                        'weeks' => $barrays,
                        'status' => 'Opened',
                        'starttime' => '24H',
                        'endtime' => null,
                        'breakstarttime' => null,
                        'breakendtime' => null,
                    ]);

                    $no_id_Index = $no_id_Index + 1;
                }
            }else{
                foreach($businesshours as $businesshour){
                    $businesshour->weeks = $barray[$dayIndex];
                    $dayIndex = ($dayIndex + 1) % count($barray);
                    $businesshour->status = 'Opened';
                    $businesshour->starttime = '24H';
                    $businesshour->endtime = null;
                    $businesshour->breakstarttime = null;
                    $businesshour->breakendtime = null;
                    $businesshour->save();
                }
            }

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Business Hours Enabled 24 Hours';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
        }

        $fullpermission = Setting::where('key','24hoursbusinessswitch')->first();
        $fullpermission->value = $request->fullhours;
        $fullpermission->save();

        if($request->removetype == 'erase'){
            $personals = PersonalBusinessHours::get();
            foreach($personals as $personal){
                $personal->delete();
            }
            $users = User::get();
            foreach($users as $user){
                $user->personalworkhours = null;
                $user->personal24hours = null;
                $user->save();
            }
        }

        return response()->json(['success' => lang('Updated successfully')], 200);
    }
}
