<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\Seosetting;
use App\Models\Pages;
use App\Models\Timezone;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class ApptitleController extends Controller
{
	public function index()
	{
		$this->authorize('General Setting Access');
		$basic = Apptitle::first();

		$title = Apptitle::first();
		$data['title'] = $title;

		$footertext = Footertext::first();
		$data['footertext'] = $footertext;

		$seopage = Seosetting::first();
		$data['seopage'] = $seopage;

		$post = Pages::all();
		$data['page'] = $post;

		$timezones = Timezone::get();
		$data['timezones'] = $timezones;

		// cronjob command setup
		if (strpos($_SERVER['SERVER_SOFTWARE'], 'Hostinger') !== false || strpos($_SERVER['SERVER_SOFTWARE'], 'Cloudways') !== false || strpos($_SERVER['SERVER_SOFTWARE'], 'AAPanel') !== false) {
			$croncommanddata = '/usr/bin/php ' . base_path() . '/artisan schedule:run >> /dev/null 2>&1';
		} elseif (strpos($_SERVER['SERVER_SOFTWARE'], 'CloudPanel') !== false) {
			$croncommanddata = '/usr/bin/php ' . base_path() . '/artisan schedule:run >> /dev/null 2>&1';
		} elseif ($_SERVER['SERVER_NAME'] == 'localhost' && $_SERVER['DOCUMENT_ROOT'] == 'C:/xampp/htdocs') {
			$croncommanddata = 'php artisan schedule:work';
		} else {
			$croncommanddata = '/usr/local/bin/php ' . base_path() . '/artisan schedule:run >> /dev/null 2>&1';
		}

		$data['croncommanddata'] = $croncommanddata;

		return view('admin.generalsetting.apptitle', compact('basic', 'title', 'footertext'))->with($data);
	}

	public function store(Request $request)
	{
		$validationRules = [
			'title' => 'required',
			'image'  => 'sometimes|mimes:jpg,jpeg,png,svg|max:5120',
			'image1' => 'sometimes|mimes:jpg,jpeg,png,svg|max:5120',
			'image2' => 'sometimes|mimes:jpg,jpeg,png,svg|max:5120',
			'image3' => 'sometimes|mimes:jpg,jpeg,png,svg|max:5120',
			'image4' => 'sometimes|mimes:jpg,jpeg,png,svg|max:5120',
		];

		// Validate all files at once
		$request->validate($validationRules);
		$calID = ['id' => $request->id];

		$calldetails = [
			'title' => $request->title,
			'checkbox' => $request->input('checkbox'),
		];

		// light logo upload
		if ($files = $request->file('image')) {
			//delete old file
			$testiimage = Apptitle::find($request->id);
			$provider  = existprovider($testiimage->image_storage_disk ?? 'public')->provider;
			$provider::delete('/uploads/logo/logo/' . $testiimage->image);

			//insert new file
			$profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
			$provider = storage()->provider;
			$provider::uploadImage($files, '/uploads/logo/logo/', $profileImage);
			$calldetails['image'] = "$profileImage";
			$calldetails['image_storage_disk'] = storage()->storage_disk ?? 'public';
		}

		// dark logo upload
		if ($files = $request->file('image1')) {
			//delete old file
			$testiimage1 = Apptitle::find($request->id);
			$provider  = existprovider($testiimage1->image1_storage_disk ?? 'public')->provider;
			$provider::delete('/uploads/logo/darklogo/' . $testiimage1->image);

			//insert new file
			$profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
			$provider = storage()->provider;
			$provider::uploadImage($files, '/uploads/logo/darklogo/', $profileImage);
			$calldetails['image1'] = "$profileImage";
			$calldetails['image1_storage_disk'] = storage()->storage_disk ?? 'public';
		}

		// Dark-Icon upload
		if ($files = $request->file('image2')) {
			//delete old file
			$testiimage2 = Apptitle::find($request->id);
			$provider  = existprovider($testiimage2->image2_storage_disk ?? 'public')->provider;
			$provider::delete('/uploads/logo/icon/' . $testiimage2->image2);

			//insert new file
			$profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
			$provider = storage()->provider;
			$provider::uploadImage($files, '/uploads/logo/icon/', $profileImage);
			$calldetails['image2'] = "$profileImage";
			$calldetails['image2_storage_disk'] = storage()->storage_disk ?? 'public';
		}

		// Light-Icon upload
		if ($files = $request->file('image3')) {
			//delete old file
			$testiimage3 = Apptitle::find($request->id);
			$provider  = existprovider($testiimage3->image3_storage_disk ?? 'public')->provider;
			$provider::delete('/uploads/logo/darkicon/' . $testiimage3->image3);

			//insert new file
			$profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
			$provider = storage()->provider;
			$provider::uploadImage($files, '/uploads/logo/darkicon/', $profileImage);
			$calldetails['image3'] = "$profileImage";
			$calldetails['image3_storage_disk'] = storage()->storage_disk ?? 'public';
		}

		// Upload Favicon uploa
		if ($files = $request->file('image4')) {
			//delete old file
			$testiimage4 = Apptitle::find($request->id);
			$provider  = existprovider($testiimage4->image4_storage_disk ?? 'public')->provider;
			$provider::delete('/uploads/logo/favicons/' . $testiimage4->image4);

			//insert new file
			$profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
			$provider = storage()->provider;
			$provider::uploadImage($files, '/uploads/logo/favicons/', $profileImage);
			$calldetails['image4'] = "$profileImage";
			$calldetails['image4_storage_disk'] = storage()->storage_disk ?? 'public';
		}

		$callaction = Apptitle::updateOrCreate(['id' => $calID], $calldetails);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'App Title & Logos Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

		return redirect()->back()->with('success', lang('Updated successfully', 'alerts'));
	}

	public function bannerpage()
	{
		$this->authorize('Banner Access');
		$basic = Apptitle::first();

		$title = Apptitle::first();
		$data['title'] = $title;

		$footertext = Footertext::first();
		$data['footertext'] = $footertext;

		$seopage = Seosetting::first();
		$data['seopage'] = $seopage;

		$post = Pages::all();
		$data['page'] = $post;


		return view('admin.generalsetting.bannerpage', compact('basic', 'title', 'footertext'))->with($data);
	}

	public function bannerstore(Request $request)
	{
		$this->authorize('Banner Access');
		$request->validate([
			'searchtitle' => 'required|string|max:255',

		]);

		if ($request->searchsub) {
			$request->validate([
				'searchsub' => 'string|max:255',

			]);
		}
		$calID = ['id' => $request->id];
		$calldetails = [
			'searchtitle' => $request->searchtitle,
			'searchsub' => $request->searchsub,

		];

		$callaction = Apptitle::updateOrCreate(['id' => $calID], $calldetails);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Banner Section Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

		return redirect()->back()->with('success', lang('Updated successfully', 'alerts'));
	}

	public function footer()
	{

		$title = Apptitle::first();
		$data['title'] = $title;

		$footertext = Footertext::first();
		$data['footertext'] = $footertext;

		$seopage = Seosetting::first();
		$data['seopage'] = $seopage;

		$post = Pages::all();
		$data['page'] = $post;

		return view('admin.footer.index')->with($data);
	}

	public function footerstore(Request $request)
	{

		$request->validate([
			'copyright' => 'required',

		]);
		$calID = ['id' => $request->id];
		$calldetails = [

			'copyright' => $request->copyright,

		];
		$callaction = Footertext::updateOrCreate(
			['id' => $calID],
			$calldetails
		);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Footer Section Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

		return redirect()->back()->with('success', lang('Updated successfully', 'alerts'));
	}


	public function logodelete(Request $request)
	{
		$logo = Apptitle::find($request->id);
		if ($request->logo == 'logo1') {
			if ($logo->image != null) {
				$provider  = existprovider($logo->image_storage_disk ?? 'public')->provider;
				$provider::delete('/uploads/logo/logo/' . $logo->image);
			}
			$logo->image = null;
			$logo->image_storage_disk = null;
			$logo->update();
		}
		if ($request->logo == 'logo2') {
			if ($logo->image1 != null) {
				$provider  = existprovider($logo->image1_storage_disk ?? 'public')->provider;
				$provider::delete('/uploads/logo/darklogo/' . $logo->image1);
			}
			$logo->image1 = null;
			$logo->image1_storage_disk = null;
			$logo->update();
		}
		if ($request->logo == 'logo3') {
			if ($logo->image2 != null) {
				$provider  = existprovider($logo->image2_storage_disk ?? 'public')->provider;
				$provider::delete('/uploads/logo/icon/' . $logo->image2);
			}
			$logo->image2 = null;
			$logo->image2_storage_disk = null;
			$logo->update();
		}
		if ($request->logo == 'logo4') {
			if ($logo->image3 != null) {
				$provider  = existprovider($logo->image3_storage_disk ?? 'public')->provider;
				$provider::delete('/uploads/logo/darkicon/' . $logo->image3);
			}
			$logo->image3 = null;
			$logo->image3_storage_disk = null;
			$logo->update();
		}
		if ($request->logo == 'logo5') {
			if ($logo->image4 != null) {
				$provider  = existprovider($logo->image4_storage_disk ?? 'public')->provider;
				$provider::delete('/uploads/logo/favicons/' . $logo->image4);
			}
			$logo->image4 = null;
			$logo->image4_storage_disk = null;
			$logo->update();
		}

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'App Logo Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

		return response()->json(['success' => lang('Updated successfully', 'alerts'), 200]);
	}
}
