<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\usersettings;
use App\Models\Employeerating;
use App\Models\Customer;
use App\Models\Countries;
use App\Models\Timezone;
use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\Seosetting;
use App\Models\Pages;
use Hash;
use App\Jobs\MailSend;
use App\Models\VerifyUser;
use App\Models\VerifyOtp;
use App\Models\Announcement;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use PragmaRX\Google2FA\Google2FA;
use App\Models\Holiday;
use App\Models\senduserlist;
use App\Models\LiveChatCustomers;
use App\Models\PersonalBusinessHours;
use App\Models\AgentGroupConversation;
use App\Models\LiveChatConversations;
use Illuminate\Support\Facades\Crypt;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class AdminprofileController extends Controller
{
    use ThrottlesLogins,AuthenticatesUsers {
        logout as performLogout;
    }
    public function index()
    {
        $user = User::get();
        $data['users'] = $user;

        $country = Countries::all();
        $data['countries'] = $country;

        $timezones = Timezone::get();
        $data['timezones'] = $timezones;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        if (Auth::check() && Auth::user()->id) {
            $avgrating1 = Employeerating::where('user_id', Auth::id())->where('rating', '1')->count();
            $avgrating2 = Employeerating::where('user_id', Auth::id())->where('rating', '2')->count();
            $avgrating3 = Employeerating::where('user_id', Auth::id())->where('rating', '3')->count();
            $avgrating4 = Employeerating::where('user_id', Auth::id())->where('rating', '4')->count();
            $avgrating5 = Employeerating::where('user_id', Auth::id())->where('rating', '5')->count();

            $avgr = ((5 * $avgrating5) + (4 * $avgrating4) + (3 * $avgrating3) + (2 * $avgrating2) + (1 * $avgrating1));
            $avggr = ($avgrating1 + $avgrating2 + $avgrating3 + $avgrating4 + $avgrating5);

            if ($avggr == 0) {
                $avggr = 1;
                $avg = $avgr / $avggr;
            } else {
                $avg = $avgr / $avggr;
            }
        }

        $bussiness1 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '1')->first();
        $data['bussiness1'] = $bussiness1;
        $bussiness2 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '2')->first();
        $data['bussiness2'] = $bussiness2;
        $bussiness3 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '3')->first();
        $data['bussiness3'] = $bussiness3;
        $bussiness4 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '4')->first();
        $data['bussiness4'] = $bussiness4;
        $bussiness5 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '5')->first();
        $data['bussiness5'] = $bussiness5;
        $bussiness6 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '6')->first();
        $data['bussiness6'] = $bussiness6;
        $bussiness7 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '7')->first();
        $data['bussiness7'] = $bussiness7;

        return view('admin.profile.adminprofile', compact('avg'))->with($data);
    }

    public function adminemailchange(Request $request)
    {
        $user = User::where('email', $request->email)->first();
        if(Hash::check($request->password, $user->password)){
            $emaildata = [
                'username' => $user->name,
                'useremail' => $user->email,
                'ticket_admin_url' => route('adminemailupdate',$user->email),
            ];

            try {

                dispatch((new MailSend($user->email, 'Send_email_to_admin_users_when_change_email', $emaildata)));

            } catch (\Exception$e) {

            }

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Attempt To Email Change';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['success' => lang('Please check your email to change email id, we send a mail to your email.', 'alerts'), 'message' => 'linksend']);
        }else{
            return response()->json(['error' => lang('You are entered invalid password.', 'alerts'), 'message' => 'wrongpassword']);
        }
    }

    public function userpasswordverify(Request $request)
    {
        $user = User::where('email', $request->email)->first();
        if(Hash::check($request->password, $user->password)){
            return response()->json(['success' => lang('Correct password.', 'alerts'), 'message' => $request->twofactorname == 'emailtwofact' ? 'email2famatched' : 'google2famatched']);
        }else{
            return response()->json(['error' => lang('You are entered invalid password.', 'alerts'), 'message' => 'wrongpassword']);
        }
    }

    public function adminemailupdate(Request $request, $id)
    {

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        $now = now();
        $announcement = announcement::whereDate('enddate', '>=', $now->toDateString())->whereDate('startdate', '<=', $now->toDateString())->get();
        $data['announcement'] = $announcement;

        $announcements = Announcement::whereNotNull('announcementday')->get();
        $data['announcements'] = $announcements;

        $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', '1')->get();
        $data['holidays'] =  $holidays;

        $data['oldemail'] = $id;

        return view('admin.profile.updateemail')->with($data);
    }

    public function adminnewemailstore(Request $request)
    {
        if($request->email == null){
            return response()->json(['error' => lang('Please enter a valid email ID to update your email address.', 'alerts'), 'email' => 'emptyemail']);
        }

        $user = User::where('email', $request->oldemail)->first();
        if($user->email == $request->email){
            return response()->json(['error' => lang('This email is already linked to your account.', 'alerts'), 'email' => 'already']);
        }

        $request->validate([
            'email' => 'required|email|max:255|indisposable|unique:users',
        ]);

        $otpdata = VerifyOtp::where('type', 'emailupdate')->where('cust_id', $request->email)->first();
        $user = User::where('email', $request->oldemail)->first();

        if ($otpdata) {
            $otpdata->otp = rand(100000, 999999);
            $otpdata->update();
            if ($request->session()->has('emailupdate')) {
                $request->session()->forget('emailupdate');
            }
            $request->session()->put('emailupdate', $otpdata->cust_id);
            $custemailchange = [
                'otp' => $otpdata->otp,
                'useremail' => $otpdata->cust_id,
                'username' => $user->name,
            ];

            try {

                dispatch((new MailSend($otpdata->cust_id, 'Send_email_to_customer_when_change_email_otp_verification', $custemailchange)));

            } catch (\Exception$e) {
                return response()->json(['error' => $e->getMessage(), 'errortype' => 'sendingfail']);
            }
            return response()->json(['success' => lang('Please check your email to verify otp.', 'alerts'), 'otp' => 'exists']);
        }
        if (!$otpdata) {
            $verifyOtp = VerifyOtp::create([
                'cust_id' => $request->email,
                'otp' => rand(100000, 999999),
                'type' => 'emailupdate',
            ]);

            if ($request->session()->has('emailupdate')) {
                $request->session()->forget('emailupdate');
            }
            $request->session()->put('emailupdate', $verifyOtp->cust_id);

            $custemailchange = [
                'otp' => $verifyOtp->otp,
                'useremail' => $verifyOtp->cust_id,
                'username' => $user->name,
            ];

            try {

                dispatch((new MailSend($verifyOtp->cust_id, 'Send_email_to_customer_when_change_email_otp_verification', $custemailchange)));

            } catch (\Exception$e) {
                return response()->json(['error' => $e->getMessage(), 'errortype' => 'sendingfail']);
            }

            return response()->json(['success' => lang('Please check your email to verify otp.', 'alerts'), 'otp' => 'exists']);
        }
    }

    public function adminnewemailresendotp(Request $request)
    {
        $otpdata = VerifyOtp::where('type', 'emailupdate')->where('cust_id', $request->session()->get('emailupdate'))->first();
        $user = User::where('email', $request->oldemail)->first();

        if ($otpdata != null) {
            $otpdata->otp = rand(100000, 999999);
            $otpdata->update();
            if ($request->session()->has('emailupdate')) {
                $request->session()->forget('emailupdate');
            }
            $request->session()->put('emailupdate', $otpdata->cust_id);
            $custemailchange = [
                'otp' => $otpdata->otp,
                'useremail' => $otpdata->cust_id,
                'username' => $user->name,
            ];

            try {
                dispatch((new MailSend($otpdata->cust_id, 'Send_email_to_customer_when_change_email_otp_verification', $custemailchange)));
            } catch (\Exception$e) {
                return response()->json(['error' => $e->getMessage(), 'errortype' => 'sendingfail']);
            }
            return response()->json(['success' => lang('Please check your email to verify otp.', 'alerts'), 'otp' => 'exists']);
        }else{
            return response()->json(['error' => lang('There is no prevous OTP existing here.', 'alerts'), 'errortype' => 'noprevousotp']);
        }
    }

    public function adminemailupdateotpverify(Request $request, $oldemail)
    {

        if ($request->session()->has('emailupdate')) {
            $emailvalidate = $request->session()->get('emailupdate');
        }
        $verify = VerifyOtp::where('type', 'emailupdate')->where('otp', $request->otp)->first();
        if ($verify) {
            if ($emailvalidate == $verify->cust_id) {
                $userfind = User::where('email', $oldemail)->first();
                $userfind->email = $verify->cust_id;
                $userfind->save();

                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Email Updated';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();

                $this->performLogout($request);
                return redirect()->route('login')->with('success', lang('Your email id updated successfully.', 'alerts'));
            }else{
                return redirect()->back()->with('error', lang('Invalid OTP', 'alerts'));
            }
        } else {
            return redirect()->back()->with('error', lang('Invalid OTP', 'alerts'));
        }

        if (!$verify) {
            return redirect()->back()->with('error', lang('Invalid OTP', 'alerts'));
        }
    }


    public function profileedit()
    {
        $this->authorize('Profile Edit');
        $user = User::get();
        $data['users'] = $user;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        $country = Countries::all();
        $data['countries'] = $country;

        $timezones = Timezone::get();
        $data['timezones'] = $timezones;

        return view('admin.profile.adminprofileupdate')->with($data);
    }

    public function profilesetup(Request $request)
    {

        $this->authorize('Profile Edit');

        $request->validate([
            'firstname' => 'required',
            'lastname' => 'required',
            'image' => $request->hasFile('image') ? 'mimes:jpeg,jpg,png|required|max:5120' : '',
        ]);

        $user_id = Auth::user()->id;

        $user = User::findOrFail($user_id);
        $user->firstname = ucfirst($request->input('firstname'));

        $user->lastname = ucfirst($request->input('lastname'));
        $user->name = ucfirst($request->input('firstname')) . ' ' . ucfirst($request->input('lastname'));
        $user->gender = $request->input('gender');
        $user->languagues = $request->input('languages');
        $user->skills = $request->input('skills');
        $user->phone = $request->input('phone');
        $user->country = $request->input('country');
        $user->timezone = $request->input('timezone');


        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $image_name = time() . '.' . $file->getClientOriginalExtension();
            $provider = storage()->provider;
            $existprovider = existprovider($user->storage_disk);
            if($existprovider)
            $existprovider->provider::delete('/uploads/profile' . "/" . $user->image);
            $upload =  $provider::uploadprofile($file,$image_name);
            if($upload){
                // update profile in agent group conversations
                $group_convers = AgentGroupConversation::where('sender_user_id',$user->id)->get();
                foreach($group_convers as $group_conver){
                    $group_conver->sender_image = $image_name;
                    $group_conver->storage_disk = storage()->storage_disk;
                    $group_conver->save();
                }

                // update profile in livechat engage conversations
                $livecusts = LiveChatCustomers::whereNotNull('engage_conversation')->where('engage_conversation', '!=', '')->get();
                foreach($livecusts as $livecust) {
                    $engageConversations = json_decode($livecust->engage_conversation, true);
                    if (is_array($engageConversations)) {
                        $updated = false;
                        foreach($engageConversations as &$engageConversation) {
                            if($engageConversation['id'] == $user->id) {
                                $engageConversation['image'] = $image_name;
                                $engageConversation['storage_disk'] = storage()->storage_disk;
                                $updated = true;
                            }
                        }
                        if ($updated) {
                            $livecust->engage_conversation = json_encode($engageConversations);
                            $livecust->save();
                        }
                    }
                }

                // update profile in livechatconversations
                $livechatdatas = LiveChatConversations::where('livechat_user_id',$user->id)->get();
                foreach($livechatdatas as $livechatdata){
                    $livechatdata->sender_image = $image_name;
                    $livechatdata->storage_disk = storage()->storage_disk;
                    $livechatdata->save();
                }

                $user->update(['image' => $image_name,'storage_disk' => storage()->storage_disk]);
            }else{
                return redirect('admin/profile')->with('error', lang('Image upload failed please try again.', 'alerts'));
            }
        }

        $user->update();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Profile Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return redirect('admin/profile')->with('success', lang('Your profile has been successfully updated.', 'alerts'));
    }

    public function imageremove(Request $request, $id)
    {

        $user = User::findOrFail($id);
        $existprovider = existprovider($user->storage_disk);
        if($existprovider)
        $existprovider->provider::delete('/uploads/profile' . "/" . $user->image);

        // update profile in agent group conversations
        $group_convers = AgentGroupConversation::where('sender_user_id',$user->id)->get();
        foreach($group_convers as $group_conver){
            $group_conver->sender_image = null;
            $group_conver->storage_disk = null;
            $group_conver->save();
        }

        // update profile in livechat engage conversations
        $livecusts = LiveChatCustomers::whereNotNull('engage_conversation')->where('engage_conversation', '!=', '')->get();
        foreach($livecusts as $livecust) {
            $engageConversations = json_decode($livecust->engage_conversation, true);
            if (is_array($engageConversations)) {
                $updated = false;
                foreach($engageConversations as &$engageConversation) {
                    if($engageConversation['id'] == $user->id) {
                        $engageConversation['image'] = null;
                        $engageConversation['storage_disk'] = null;
                        $updated = true;
                    }
                }
                if ($updated) {
                    $livecust->engage_conversation = json_encode($engageConversations);
                    $livecust->save();
                }
            }
        }

        // update profile in livechatconversations
        $livechatdatas = LiveChatConversations::where('livechat_user_id',$user->id)->get();
        foreach($livechatdatas as $livechatdata){
            $livechatdata->sender_image = null;
            $livechatdata->storage_disk = null;
            $livechatdata->save();
        }

        $user->image = null;
        $user->update();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Profile Image Removed';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('The profile image was successfully removed.', 'alerts')]);
    }


    // Customer function
    public function customers()
    {
        $this->authorize('Customers Access');
        $customers = LiveChatCustomers::with('livechatconversation','tickets')->get();
        $customers = $customers->each(function ($customer) {
            $customer->encrypted_id = Crypt::encrypt($customer->id);
            return $customer;
        });
        $data['customers'] = $customers;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        return view('admin.customers.index')->with($data)->with('i', (request()->input('page', 1) - 1) * 5);
    }

    public function resendverification($email)
    {
        $user = Customer::where('email', '=', $email)->first();

        $existVerifyUser = VerifyUser::where('cust_id', $user->id)->get();
        if ($existVerifyUser != null) {
            foreach ($existVerifyUser as $existVerifyUsers) {
                $existVerifyUsers->delete();
            }
        }

        $verifyUser = VerifyUser::create([
            'cust_id' => $user->id,
            'token' => sha1(time())
        ]);

        $verifyData = [
            'username' => $user->username,
            'email' => $user->email,
            'email_verify_url' => route('verify.email', $verifyUser->token),
        ];

        try {

            dispatch((new MailSend($user->email, 'customer_sendmail_verification', $verifyData)));

        } catch (\Exception $e) {
            return response()->json(['success' => lang('The email verification link was successfully sent. Please check and verify your email.', 'alerts')]);
        }

        return response()->json(['success' => lang('The email verification link was successfully sent. Please check and verify your email.', 'alerts')]);
    }

    public function customersshow($id)
    {
        $this->authorize('Customers Edit');

        $id = decrypt($id);

        $user = Customer::where('id', $id)->first();
        if(!$user)
          abort(404);
        $data['user'] = $user;

        $country = Countries::all();
        $data['countries'] = $country;

        $timezones = Timezone::get();
        $data['timezones'] = $timezones;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        return view('admin.customers.show')->with($data);
    }

    public function unvoilating(Request $request, $id)
    {
        $this->authorize('Customers Edit');

        $cust = Customer::find($id);
        $cust->voilated = null;
        $cust->update();

        return redirect()->back()->with('success', lang('Customer removed from violated customer.', 'alerts'));
    }

    public function customersupdate(Request $request, $id)
    {
        $this->authorize('Customers Edit');

        $request->validate([
            'firstname' => 'required|string|max:255',
            'lastname' => 'required|string|max:255',
            'email' => 'required|string|email|max:255',
        ]);

        if ($request->phone) {
            $request->validate([
                'phone' => 'numeric',
            ]);
        }
        $id = decrypt($id);

        $user = Customer::where('id', $id)->findOrFail($id);

        $userexist = Customer::get();
        $userarray = [];
        foreach ($userexist as $userexists) {
            array_push($userarray, $userexists->email);
        }

        if ($user->email != $request->email && in_array($request->email, $userarray)) {
            return redirect()->back()->with('error', lang('You are given email is already existing please provide correct email.', 'alerts'));
        }

        $user->firstname = $request->input('firstname');
        $user->lastname = $request->input('lastname');
        $user->username = $request->input('firstname') . ' ' . $request->input('lastname');
        $user->email = $request->input('email');
        $user->country = $request->input('country');
        $user->timezone = $request->input('timezone');
        $user->status = $request->input('status');
        $user->voilated = $request->input('voilated');
        $user->update();

        $request->session()->forget('email', $user->email);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Customer Profile Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return redirect('/admin/customer')->with('success', lang('The customer profile was successfully updated.', 'alerts'));
    }

    public function customersdelete($id)
    {
        $this->authorize('Customers Delete');

        $id = decrypt($id);

        $user = LiveChatCustomers::findOrFail($id);

        $ticket = $user->tickets()->get();

        foreach ($ticket as $tickets) {
            foreach ($tickets->getMedia('ticket') as $media) {
                $media->delete();
            }
            foreach ($tickets->comments as $comment) {
                foreach ($comment->getMedia('comments') as $media) {
                    $media->delete();
                }
                $comment->delete();
            }
            $tickets->delete();
        }

        $custnotifications = senduserlist::where('tocust_id',$user->id)->get();
        foreach($custnotifications as $custnotification){
            $custnotifycount = senduserlist::where('mail_id',$custnotification->mail_id)->count();
            if($custnotifycount == 1){
                $custnotification->sendmaildata->delete();
            }
            $custnotification->delete();
        }

        $user->delete();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Customer profile Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('The customer was deleted successfully.', 'alerts')]);
    }


    public function customermassdestroy(Request $request)
    {
        $student_id_arrays = $request->input('id');

        $student_id_array = array_map(function ($encryptedValue) {
            return decrypt($encryptedValue);
        }, $student_id_arrays);

        $customers = LiveChatCustomers::whereIn('id', $student_id_array)->get();

        foreach ($customers as $customer) {

            foreach ($customer->tickets()->get() as $tickets) {
                foreach ($tickets->getMedia('ticket') as $media) {
                    $media->delete();
                }
                foreach ($tickets->comments as $comment) {
                    foreach ($comment->getMedia('comments') as $media) {
                        $media->delete();
                    }
                    $comment->delete();
                }
                $tickets->delete();
            }

            $custnotifications = senduserlist::where('tocust_id',$customer->id)->get();
            foreach($custnotifications as $custnotification){
                $custnotifycount = senduserlist::where('mail_id',$custnotification->mail_id)->count();
                if($custnotifycount == 1){
                    $custnotification->sendmaildata->delete();
                }
                $custnotification->delete();
            }
            $customer->delete();
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Multiple Customers profile Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('The customer was deleted successfully.', 'alerts')]);
    }

    public function usersetting(Request $request)
    {
        $users = User::find($request->user_id);
        $users->darkmode = $request->dark;
        $users->update();
        return response()->json(['code' => 200, 'success' => lang('Updated successfully', 'alerts')], 200);
    }

    public function emailonoff(Request $request)
    {
        $useting = usersettings::where('users_id', $request->userid)->first();

        if ($useting == null) {
            $usettingcreate = new usersettings();
            $usettingcreate->users_id  = $request->userid;
            $usettingcreate->emailnotifyon = $request->emailvalue;
            $usettingcreate->save();
        } else {
            $useting->emailnotifyon = $request->emailvalue;
            $useting->update();
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = $request->emailvalue == '0' ? 'Email Notification Switched off' : 'Email Notification Switched on';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code' => 200, 'success' => lang('Updated successfully', 'alerts')], 200);
    }

    public function emptwofactqr(Request $request)
    {
        $user = User::find($request->cust_id);
        if (!Hash::check($request->password, $user->password)) {
            return response()->json(['error' => 'You are entered an invalid password.', 'message' => 'wrongpassword']);
        } else {
            if ($request->emailcheckstatus == 1) {

                $google2fa = app('pragmarx.google2fa');
                $google2fa_secret = $google2fa->generateSecretKey();
                $email = $user->email;
                $domainname = parse_url(url('/'));
                $request->session()->put('google2faemail', $email);
                $QR_Image = $google2fa->getQRCodeInline(
                    $domainname['host'],
                    config('app.name'),
                    $google2fa_secret
                );
                return response()->json(['success' => lang('Please check your Email', 'alerts'), 'QR_Image' => $QR_Image, 'secret' => $google2fa_secret, 'workprogress' => 'workingmode']);
            } else {

                $user->update(['google2fa_secret' => null,]);

                $user->update(['twofactorauth' => null,]);

                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Disabled Google Two Factor Authentication';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();

                return response()->json(['success' => lang('successfully disabled your two factor authentication.', 'alerts'), 'workprogress' =>
                'notworkingmode']);
            }
        }
    }

    public function empgoogle2faotp(Request $request)
    {

        $otp = $request->otp;

        $user = User::find($request->id);

        $google2fa = new Google2FA();
        $isValidOTP = $google2fa->verifyKey($request->secret_key_value, $otp);
        if ($isValidOTP) {

            $user->update(['twofactorauth' => 'googletwofact', 'google2fa_secret' => encrypt($request->secret_key_value)]);

            $request->session()->put('admingoogleauthid', $user->email);
            return response()->json([[1]]);
        } else {
            return response()->json([[0]]);
        }
    }

    public function empemail2fa(Request $request)
    {

        $user = User::find($request->cust_id);
        if (!Hash::check($request->password, $user->password)) {
            return response()->json(['error' => 'You entered an invalid password.', 'message' => 'wrongpassword']);
        } else {
            if ($request->emailcheckstatus == 1) {
                $user->update(['twofactorauth' => 'emailtwofact',]);
                $request->session()->forget('admintwofactoremail');
                $verifyuser = VerifyOtp::where('cust_id', $user->email);
                if ($verifyuser->exists()) {
                    $verifyuser->delete();
                }
                $request->session()->put('admintwofactoremail', $user->email);
            } else {
                $user->update(['twofactorauth' => null,]);

                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Disabled Email Two Factor Authentication';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();

                return response()->json(['success' => lang('successfully disabled your two factor authentication.', 'alerts'), 'disabled' => true]);
            }

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Enabled Email Two Factor Authentication';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['success' => lang('Email two factor authentication is enabled.', 'alerts'), 'message' => 'emailtwofact']);
        }
    }

    public function emp2faotpverify(Request $request)
    {
        $request->validate([
            'otp' => 'required',
        ]);

        $verifyUser = VerifyOtp::where('cust_id',$request->email)->where('otp', $request->otp)->first();

        if(User::where(['id' =>Auth::id(), 'twofactorauth' => 'emailtwofact'])->exists()){
            if (Auth::user() && session()->get('admintwofactoremail') == Auth::user()->email) {
                return redirect()->route('admin.dashboard');
            }
        }
        if ($verifyUser) {
            $verifyUser->delete();
            if(User::where(['id' =>Auth::id(), 'twofactorauth' => 'emailtwofact'])->exists()){
                session()->put('admintwofactoremail',$request->email);
                return redirect()->route('admin.dashboard');
            }

        }else{
            return redirect()->back()->with(['error' => lang('Invalid otp.', 'alerts')]);
        }
    }


    public function google2faadminlogin($email)
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $now = now();
        $announcement = announcement::whereDate('enddate', '>=', $now->toDateString())->whereDate('startdate', '<=', $now->toDateString())->get();
        $data['announcement'] = $announcement;

        $announcements = Announcement::whereNotNull('announcementday')->get();
        $data['announcements'] = $announcements;

        $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', '1')->get();
        $data['holidays'] =  $holidays;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;


        if (Auth::user() && session()->get('admingoogleauthid') == Auth::user()->email) {
            return redirect()->route('admin.dashboard');
        }

        if (!session()->has('google2faemail')) {
            session()->put('google2faemail', $email);
        }

        $data['email'] = session()->get('google2faemail');

        return view('google2fa.adminindex')->with($data);
    }

    public function admingoogle2faotpverify(Request $request)
    {
        $otp = $request->one_time_password;

        $user = User::where('email', $request->email)->first();

        $google = decrypt($user->google2fa_secret);

        $google2fa = new Google2FA();
        $isValidOTP = $google2fa->verifyKey($google, $otp);


        if ($isValidOTP) {
            $request->session()->put('admingoogleauthid', $user->email);

            return redirect()->route('admin.dashboard');
        } else {

            return redirect()->back()->with('error', 'Invalid otp.');
        }
    }

    public function emailtwofactorlogin($email)
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $now = now();
        $announcement = announcement::whereDate('enddate', '>=', $now->toDateString())->whereDate('startdate', '<=', $now->toDateString())->get();
        $data['announcement'] = $announcement;

        $announcements = Announcement::whereNotNull('announcementday')->get();
        $data['announcements'] = $announcements;

        $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', '1')->get();
        $data['holidays'] =  $holidays;

        $data['email'] = $email;

        if (Auth::user() && session()->get('admintwofactoremail') == Auth::user()->email) {
            return redirect()->route('admin.dashboard');
        }

        $verifyotp = VerifyOtp::where('cust_id', $email)->first();

        if (!$verifyotp) {
            $verifyOtp = VerifyOtp::create([
                'cust_id' => $email,
                'otp' => rand(100000, 999999),
                'type' => 'twofactorotp',
            ]);

            $guestticket = [

                'otp' => $verifyOtp->otp,
                'email' => $verifyOtp->cust_id,
                'name' => 'adminuser',
            ];
            try {

                dispatch((new MailSend($verifyOtp->cust_id, 'two_factor_authentication_otp_send', $guestticket)));

            } catch (\Exception $e) {
            }
        }

        return view('admin.auth.passwords.admintwofactor')->with($data);
    }

    public function resendotp(Request $request, $email)
    {
        if (Auth::user() && session()->get('admintwofactoremail') == Auth::user()->email) {
            return redirect()->route('admin.dashboard');
        }
        $verifyUser = VerifyOtp::where('cust_id', $email)->first();
        if ($verifyUser) {
            $verifyUser->otp = rand(100000, 999999);
            $verifyUser->update();
        }

        $guestticket = [
            'otp' => $verifyUser->otp,
            'email' => $verifyUser->cust_id,
            'name' => 'adminuser',
        ];
        try {

            dispatch((new MailSend($verifyUser->cust_id, 'two_factor_authentication_otp_send', $guestticket)));

        } catch (\Exception $e) {
        }
        return redirect()->route('admin.emailtwofactorlogin', ['email' => $verifyUser->cust_id])->with('success', lang('OTP sent again'));
    }

    public function sessionLogout(Request $request){
       $user = Auth::user();
       if($request->stayin){
            $user->last_activity = now();
            $user->save();
            return response(1);
       }else{
           $user->last_activity = null;
           $user->save();
           Auth::logout();
           return response(1);
       }
    }

    public function domaintransfer()
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        return view('admin.appinfo.domaintransfer')->with($data);
    }

}
