<?php

namespace App\Http\Controllers\Admin;

use Artisan;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Pages;
use App\Models\Apptitle;
use App\Models\Countries;
use App\Models\Footertext;
use App\Models\Seosetting;
use Jenssegers\Agent\Agent;
use App\Models\LiveVisitors;
use App\Models\usersettings;
use Illuminate\Http\Request;
use App\Models\Ticket\Ticket;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;
use App\Models\LiveChatCustomers;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use App\Models\LiveChatConversations;
use Illuminate\Support\Facades\Response;

class AdminDashboardController extends Controller
{
    public function index()
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        $totaltickets = Ticket::get()->count();
        $data['totaltickets'] = $totaltickets;

        $totalactivetickets = Ticket::whereIn('status', ['Re-Open', 'Inprogress', 'On-Hold'])->count();
        $data['totalactivetickets'] = $totalactivetickets;

        $totalclosedtickets = Ticket::where('status', 'Closed')->count();
        $data['totalclosedtickets'] = $totalclosedtickets;

        $replyrecent = Ticket::whereIn('status', ['Re-Open', 'Inprogress', 'On-Hold'])->where('replystatus', 'Replied')->count();
        $data['replyrecent'] = $replyrecent;

        $recentticketcount = Ticket::where('status', 'New')->count();
        $data['recentticketcount'] = $recentticketcount;

        $selfassigncount = Ticket::where('selfassignuser_id', Auth::id())->where('status', '!=', 'Closed')->where('status', '!=', 'Suspend')->count();
        $data['selfassigncount'] = $selfassigncount;

        $myassignedticket = Ticket::leftJoin('ticketassignchildren', 'ticketassignchildren.ticket_id', 'tickets.id')->where('toassignuser_id', Auth::id())->where('status', '!=', 'Closed')->where('status', '!=', 'Suspend')->get();
        $myassignedticketcount = 0;
        foreach ($myassignedticket as $recent) {
            if ($recent->toassignuser_id != null) {
                $myassignedticketcount += 1;
            }
        }
        $data['myassignedticketcount'] = $myassignedticketcount;


        $myclosedticketcount = Ticket::where('closedby_user', Auth::id())->count();
        $data['myclosedticketcount'] = $myclosedticketcount;

        $livecust = LiveChatCustomers::get();

        $newchatcountdata = $livecust->filter(function ($item) {
            if($item->livechatconversation->last() != null){
                return ($item->engage_conversation === null || $item->engage_conversation === '') && $item->status != 'solved' && $item->livechatconversation->last()->delete == null;
            }else{
                $convers = LiveChatConversations::where('unique_id',$item->cust_unique_id)->first();
                if($convers != null && $convers->delete == null){
                    return ($item->engage_conversation === null || $item->engage_conversation === '') && $item->status != 'solved';
                }
            }
        });

        $data['newchatcount'] = $newchatcountdata->count();

        $myopenedcountdata = $livecust->filter(function ($item) {
            $engageConversation = json_decode($item->engage_conversation, true);
            return $item->banstatus !== 'banned' && collect($engageConversation)->contains('id', auth()->id());
        });
        $data['myopenedcount'] = $myopenedcountdata->count();

        $solvedcountdata = $livecust->filter(function ($item) {
            return ($item->engage_conversation === null || $item->engage_conversation === '') && $item->status == 'solved' && $item->banstatus !== 'banned';
        });
        $data['solvedcount'] = $solvedcountdata->count();

        $allticketsdata = Ticket::get();
        $data['allticketscount'] = $allticketsdata->count();

        $myclosedticketsdata = Ticket::where('closedby_user', auth()->id())->get();
        $data['myclosedticketscount'] = $myclosedticketsdata->count();

        $myticketsdata = Ticket::where('selfassignuser_id', auth()->id())->where('status', '!=' ,'Closed')->where('status', '!=' ,'Suspend')->get();
        $data['myticketscount'] = $myticketsdata->count();

        $unassingedticketsdata = Ticket::whereNull('myassignuser_id')->whereNull('selfassignuser_id')->where('status', '!=' ,'Closed')->get();
        $data['unassingedticketscount'] = $unassingedticketsdata->count();

        $visitors = LiveVisitors::get()->groupBy(function($group) {
            return $group->countrycode;
        });

        $countrriesdataCounts = [];
        foreach ($visitors as $countrycode => $items) {
            if($countrycode == 'RU'){
                $countrriesdataCounts[$countrycode] = $items->count();
            }else{
                $countrdata = Countries::where('code', $countrycode)->first();
                $countrriesdataCounts[$countrdata->name] = $items->count();
            }
        }
        arsort($countrriesdataCounts);
        $data['countrriesdataCounts'] = $countrriesdataCounts;

        return view('admin.superadmindashboard.dashboard')->with($data);
    }

    public function chartdatafetch($start,$end,$type)
    {
        $data = [];
        if($type == 'daterange'){
            $startdate = Carbon::parse($start);
            $enddate = Carbon::parse($end);
            if($start == $end){
                for ($date = $startdate; $date->lte($enddate); $date->addDay()) {
                    for ($hour = 0; $hour < 24; $hour++) {
                        $startHour = $date->copy()->setTime($hour, 0, 0);
                        $endHour = $date->copy()->setTime($hour, 59, 59);

                        $ticketcount = Ticket::whereBetween('created_at', [$startHour, $endHour])->count();
                        if(setting('enableInstagram') == 'on' || setting('enableWhatsapp') == 'on'){
                            $chatcount = LiveChatCustomers::where('userType', 'livechat')->whereBetween('created_at', [$startHour, $endHour])->count();
                        }else{
                            $chatcount = LiveChatCustomers::whereBetween('created_at', [$startHour, $endHour])->count();
                        }
                        $instacount = LiveChatCustomers::where('userType','Instagram')->whereBetween('created_at', [$startHour, $endHour])->count();
                        $whatsappcount = LiveChatCustomers::where('userType','WhatsApp')->whereBetween('created_at', [$startHour, $endHour])->count();

                        $data[] = [
                            'label' => $startHour->format('g:i A') . ' - ' . $endHour->format('g:i A'),
                            'value1' => $chatcount,
                            'value2' => $ticketcount,
                            'value3' => $instacount,
                            'value4' => $whatsappcount
                        ];
                    }
                }
            }else{
                for ($date = $startdate; $date->lte($enddate); $date->addDay()) {
                    $ticketcount = Ticket::whereDate('created_at', $date)->count();
                    if(setting('enableInstagram') == 'on' || setting('enableWhatsapp') == 'on'){
                        $chatcount = LiveChatCustomers::where('userType', 'livechat')->whereDate('created_at', $date)->count();
                    }else{
                        $chatcount = LiveChatCustomers::whereDate('created_at', $date)->count();
                    }
                    $instacount = LiveChatCustomers::where('userType','Instagram')->whereDate('created_at', $date)->count();
                    $whatsappcount = LiveChatCustomers::where('userType','WhatsApp')->whereDate('created_at', $date)->count();
                    $data[] = ['label' => $date->format('M') . ' ' . $date->day, 'value1' => $chatcount, 'value2' => $ticketcount, 'value3' => $instacount, 'value4' => $whatsappcount];
                }
            }
        }else{
            $year = $start;

            $months = collect(range(1, 12))->map(function ($month) use ($year) {
                return Carbon::create($year, $month, 1, 0, 0, 0)->format('M');
            });

            foreach($months as $month){
                $ticketcount = Ticket::whereYear('created_at', $year)->whereMonth('created_at', Carbon::parse($month)->month)->count();
                if(setting('enableInstagram') == 'on' || setting('enableWhatsapp') == 'on'){
                    $chatcount = LiveChatCustomers::where('userType', 'livechat')->whereYear('created_at', $year)->whereMonth('created_at', Carbon::parse($month)->month)->count();
                }else{
                    $chatcount = LiveChatCustomers::whereYear('created_at', $year)->whereMonth('created_at', Carbon::parse($month)->month)->count();
                }
                $instacount = LiveChatCustomers::where('userType','Instagram')->whereYear('created_at', $year)->whereMonth('created_at', Carbon::parse($month)->month)->count();
                $whatsappcount = LiveChatCustomers::where('userType','WhatsApp')->whereYear('created_at', $year)->whereMonth('created_at', Carbon::parse($month)->month)->count();
                $data[] = ['label' => $month, 'value1' => $chatcount, 'value2' => $ticketcount, 'value3' => $instacount, 'value4' => $whatsappcount];
            }
        }

        return response()->json($data);
    }

    public function markNotification(Request $request)
    {
        auth()->user()
            ->unreadNotifications
            ->when($request->input('id'), function ($query) use ($request) {
                return $query->where('id', $request->input('id'));
            })
            ->markAsRead();

        return response()->noContent();
    }


    public function autorefresh(Request $request, $id)
    {
        $calID = User::with('usetting')->find($id);
        if ($calID->usetting == null) {
            $usersettings = new usersettings();
            $usersettings->users_id = $request->id;
            $usersettings->ticket_refresh = $request->status;
            $usersettings->save();
        } else {
            $calID->usetting->ticket_refresh = $request->status;
            $calID->usetting->save();
        }

        return response()->json(['code' => 200, 'success' => lang('Updated successfully', 'alerts')], 200);
    }


    public function summernoteimageupload(Request $request)
    {
        $files = $request->file('image');

        $destinationPath = public_path() . "" . '/uploads/data/'; // upload path
        $profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
        $path = $files->move($destinationPath, $profileImage);

        $destinationPath1 = url('/') . '/uploads/data/' . $profileImage;
        return response()->json(['code' => 200, 'data' => $destinationPath1,], 200);
    }


    public function Notificationview($id)
    {
        $notification = auth()->user()->notifications()->where('id', $id)->firstOrFail();
        $data['notifications'] = $notification;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        return view('admin.notification.viewnotification')->with($data);
    }

    public function notifystatus(Request $request)
    {
        $status = $request->statusnotify;

        $perPage = 10;
        $page = $request->page != null ? $request->page : 0;

        if (!$status) {
            $notifications = auth()->user()->notifications()->paginate($perPage, ['*'], 'page', $page)->groupBy(function ($date) {
                return \Carbon\Carbon::parse($date->created_at)->format('Y-m-d');
            });
        } else {
            $notifications =  auth()->user()->notifications()->where(function ($query) use ($status) {
                $query->whereIn('data->status', $status)
                    ->orWhereIn('data->replystatus', $status)
                    ->orWhereIn('data->overduestatus', $status);
            })->paginate($perPage, ['*'], 'page', $page)->groupBy(function ($date) {
                return \Carbon\Carbon::parse($date->created_at)->format('Y-m-d');
            });
        }

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $view = view('admin.notificationpageinclude', compact('notifications', 'title', 'footertext', 'seopage', 'status', 'perPage', 'page'))->render();
        return response()->json(['html' => $view]);
    }

    public function notifysearch(Request $request)
    {
        $status = $request->notifysearch;

        if (isset($status)) {
            $notifications = auth()->user()->notifications()->where(function ($query) use ($status) {
                $keyword = strtolower($status);
                if($keyword == 'new ticket'){
                    $keyword = 'new';
                }
                if($keyword == 'closed ticket'){
                    $keyword = 'closed';
                }
                if($keyword == 'inprogress ticket'){
                    $keyword = 'inprogress';
                }
                $query->whereRaw('LOWER(json_unquote(json_extract(data, "$.title"))) LIKE ?', ["%{$keyword}%"])
                      ->orWhereRaw('LOWER(json_unquote(json_extract(data, "$.ticket_id"))) LIKE ?', ["%{$keyword}%"])
                      ->orWhereRaw('LOWER(json_unquote(json_extract(data, "$.mailsubject"))) LIKE ?', ["%{$keyword}%"])
                      ->orWhereRaw('LOWER(json_unquote(json_extract(data, "$.status"))) LIKE ?', ["%{$keyword}%"])
                      ->orWhereRaw('LOWER(json_unquote(json_extract(data, "$.overduestatus"))) LIKE ?', ["%{$keyword}%"])
                      ->orWhereRaw('LOWER(json_unquote(json_extract(data, "$.replystatus"))) LIKE ?', ["%{$keyword}%"])
                      ->orWhereRaw('LOWER(json_unquote(json_extract(data, "$.mailtext"))) LIKE ?', ["%{$keyword}%"]);
            })->get()->groupBy(function ($date) {
                return \Carbon\Carbon::parse($date->created_at)->format('Y-m-d');
            });
        } else {
            $notifications = auth()->user()->notifications()->paginate()->groupBy(function ($date) {
                return \Carbon\Carbon::parse($date->created_at)->format('Y-m-d');
            });
        }

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $view = view('admin.notificationpageinclude', compact('notifications', 'title', 'footertext', 'seopage'))->render();
        return response()->json(['html' => $view]);
    }

    public function notifydelete(Request $request)
    {
        $id = $request->id;

        $notificationsdelete = auth()->user()->notifications()->find($id);
        $notificationsdelete->delete();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Notification Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('Deleted successfully', 'alerts'), 200]);
    }

    public function markallnotify()
    {
        auth()->user()->unreadNotifications->markAsRead();

        return response()->noContent();
    }

    public function geminiGet(Request $request)
    {

        $spellCheck = setting('spellCheck');
        $wordSuggestions = setting('wordSuggestion');
        $geminiApiKey = setting('geminiApiKey');
        if ($spellCheck == 'on' && $wordSuggestions == 'on') {
            $prompt = "correct the spellings in this sentence: '$request->value' and give only corrected words in the format originalword:correctedword, after correcting words  give continuation for '$request->value' sentence in the format 'suggestion':give next three related words or a simple sentence,give only the most meaningful one, dont add symbols and dont give anything inside in these()";
        } elseif ($spellCheck == 'on' && $wordSuggestions == 'off') {
            $prompt = "correct the spellings in this sentence: '$request->value' and provide only corrected words in the format originalword:correctedword";
        } elseif($spellCheck == 'off' && $wordSuggestions == 'on') {

            $prompt = "give next three words or a sentence related to the sentence provided '{$request->value}'. just give only the most meaningful one don't give previous words and don't add these '',...,*";
        }

        $url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash-latest:generateContent?key={$geminiApiKey}";

        // Send the POST request to the Gemini API
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->post($url, [
            'contents' => [
                [
                    'parts' => [
                        [
                            'text' => $prompt,
                        ]
                    ]
                ]
            ]
        ]);
        // Check for errors in the response
        if ($response->successful()) {
            return response()->json([
                'generated_text' => $response->json('candidates')[0]['content']['parts'][0]['text'] // Get the first candidate's output
            ]);
        } else {
            // Handle the error case
            return response()->json([
                // 'error' => 'Network error '
                'error' => 'Error generating text: ' . $response->body()
            ], 500);
        }
    }

    public function clearcache()
    {
        $log_path = storage_path('logs/laravel.log');
        $geo_path = storage_path('logs/geoip.log');

        if (file_exists($log_path)) {
            file_put_contents($log_path, '', LOCK_EX);
        }
        if (file_exists($geo_path)) {
            file_put_contents($geo_path, '', LOCK_EX);
        }
        Artisan::call('optimize:clear');

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Cache Cleared';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('Cache Clear Successfull', 'alerts')]);
    }
}
