<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\Seosetting;
use App\Models\Pages;
use App\Models\Announcement;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class AdminAnnouncementController extends Controller
{

    public function index()
    {
        $this->authorize('Announcements Access');

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        $announcements = Announcement::latest()->get();
        $data['announcements'] = $announcements;

        // announcement date exceeds today date, the status of the announcement will inactive
        $now = now();
        $announcementsupdate = Announcement::whereDate('enddate', '<', $now->toDateString())->get();
        if($announcementsupdate != null){
            foreach($announcementsupdate as $announcementsupdates){
                $announcementsupdates->status = 0;
                $announcementsupdates->update();
            }
        }

        return view('admin.announcement.index')->with($data);
    }

    public function create(Request $request)
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $normalDay = ['Mon','Tue','Wed','Thu','Fri','Sat','Sun'];
        $data['normalDay'] = $normalDay;

        return view('admin.announcement.create')->with($data);
    }

    public function store(Request $request)
    {

        if($request->announcementday != null)
            if($request->announcementday[0] == null && $request->startdate == null){
                return response()->json(['code'=>500, 'error'=> lang('Please select Date or Day for Announcement.', 'alerts')], 500);
            }


        if($request->announcementday != null&& $request->announcementday[0]){
                $request->validate([
                    'title'=> 'required|max:255',
                    'notice' => 'required',
                    'announcementday' => 'required'
                ]);

                $announcementdayData = $request->announcementday;
                $ancData = [];
                foreach($announcementdayData as $announcementdayDatas){
                    $ancData[] = $announcementdayDatas;
                }
                $ancDataFinal = implode(',',  $ancData);
        }else{

            $request->validate([
                'title'=> 'required|max:255',
                'notice' => 'required',
                'startdate' => 'required',
                'enddate' => 'required',
            ]);
            $ancDataFinal = null;
        }

        if($request->buttonurl != null){
            $request->validate([
                'buttonurl' => 'required|url',
            ]);
        }

        $testi =  [
            'title' => $request->title,
            'notice' => $request->notice,
            'buttonlable' => $request->buttonlable,
            'buttonurl' => $request->buttonurl,
            'startdate' => $request->startdate,
            'enddate' => $request->enddate,
            'primary_color' => $request->primary_color,
            'secondary_color' => $request->secondary_color,
            'status' => $request->status,
            'announcementday' => $ancDataFinal
        ];

        $testimonial = Announcement::Create($testi);


        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Announcement Created';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code'=>200, 'success'=> lang('An announcement has been created successfully.', 'alerts'),'data' => $testimonial], 200);
    }

    public function edit($id)
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $announcementData = Announcement::findOrFail($id);
        $data['announcementData'] = $announcementData;

        $normalDay = ['Mon','Tue','Wed','Thu','Fri','Sat','Sun'];
        $data['normalDay'] = $normalDay;

        $announceDay = explode(',', $announcementData->announcementday);
        $data['announceDay'] = $announceDay;

        return view('admin.announcement.edit')->with($data);
    }

    public function update(Request $request)
    {
        if($request->announcementday == null && $request->startdate == null){
            return response()->json(['code'=>500, 'error'=> lang('Please select Date or Day for Announcement.', 'alerts')], 500);
        }

        if($request->announcementday){
            $request->validate([
                'title'=> 'required|max:255',
                'notice' => 'required',
                'announcementday' => 'required'
            ]);

            $announcementdayData = $request->announcementday;
            $ancData = [];
            foreach($announcementdayData as $announcementdayDatas){
                $ancData[] = $announcementdayDatas;
            }
            $ancDataFinal = implode(',',  $ancData);
        }else{
            $request->validate([
                'title'=> 'required|max:255',
                'notice' => 'required',
                'startdate' => 'required',
                'enddate' => 'required',
            ]);
            $ancDataFinal = null;
        }

        if($request->buttonurl != null){
            $request->validate([
                'buttonurl' => 'required|url',
            ]);
        }

        if($request->startdate != null && $request->enddate != null){
            $ancDataFinal = null;
        }

        $testimonial = Announcement::findOrFail($request->testimonial_id);
        $testimonial->title = $request->title;
        $testimonial->notice = $request->notice;
        $testimonial->buttonlable = $request->buttonlable;
        $testimonial->buttonurl = $request->buttonurl;
        $testimonial->startdate = $request->startdate;
        $testimonial->enddate = $request->enddate;
        $testimonial->primary_color = $request->primary_color;
        $testimonial->secondary_color = $request->secondary_color;
        $testimonial->status = $request->status;
        $testimonial->announcementday = $ancDataFinal;
        $testimonial->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Announcement Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code'=>200, 'success'=> lang('An announcement has been successfully updated.', 'alerts'),'data' => $testimonial], 200);
    }

    public function show($id){

        $post = Announcement::find($id);

        return response()->json($post);
    }


    public function destroy($id){

        $announcement = Announcement::find($id);
        $announcement->delete();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Announcement Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success'=> lang('The announcement was successfully deleted.', 'alerts')]);

    }

    public function allannouncementdelete(Request $request)
    {

        $id_array = $request->input('id');

        $sendmails = Announcement::whereIn('id', $id_array)->get();

        foreach($sendmails as $sendmail){
            $sendmail->delete();

        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Multiple Announcements Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success'=> lang('The announcement was successfully deleted.', 'alerts')]);

    }

    public function status(Request $request, $id)
    {
        $calID = Announcement::find($id);
        $calID ->status = $request->status;
        $calID ->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Announcements Status Changed';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code'=>200, 'success'=> lang('Updated successfully', 'alerts')], 200);

    }
}
