<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
// use Illuminate\Broadcasting\PresenceChannel;
// use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;

class ChatMessageEvent implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $message;
    public $userName;
    public $id;
    public $customerId;
    public $typingMessage;
    public $onlineUserUpdated;
    public $engageUser;
    public $agentInfo;
    public $comments;
    public $userMessageStatusUpdate;
    public $messageType;
    public $onlineStatusUpdate;
    public $visitordata;
    public $visitoruiqueid;
    public $visitoronlinestatus;
    public $custdata;
    public $ticketid;
    public $ticketcustid;
    public $ticketmessage;
    public $ticketmessagetype;
    public $ticketusername;
    public $deliveryStatus;
    public $messageId;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(
        $userName=null,
        $message=null,
        $id=null,
        $customerId=null,
        $typingMessage=null,
        $onlineUserUpdated=null,
        $engageUser=null,
        $agentInfo=null,
        $comments=null,
        $userMessageStatusUpdate=null,
        $messageType=null,
        $onlineStatusUpdate=null,
        $visitordata=null,
        $visitoruiqueid=null,
        $visitoronlinestatus=null,
        $custdata=null,
        $ticketid=null,
        $ticketcustid=null,
        $ticketmessage=null,
        $ticketmessagetype=null,
        $ticketusername=null,
        $deliveryStatus=null,
        $messageId=null
        )
    {
        $this->userName = $userName;
        $this->message = $message;
        $this->id = $id;
        $this->customerId = $customerId;
        $this->typingMessage = $typingMessage;
        $this->onlineUserUpdated = $onlineUserUpdated;
        $this->engageUser = $engageUser;
        $this->agentInfo = $agentInfo;
        $this->comments = $comments;
        $this->userMessageStatusUpdate = $userMessageStatusUpdate;
        $this->messageType = $messageType;
        $this->onlineStatusUpdate = $onlineStatusUpdate;
        $this->visitordata = $visitordata;
        $this->visitoruiqueid = $visitoruiqueid;
        $this->visitoronlinestatus = $visitoronlinestatus;
        $this->custdata = $custdata;
        $this->ticketid = $ticketid;
        $this->ticketcustid = $ticketcustid;
        $this->ticketmessage = $ticketmessage;
        $this->ticketmessagetype = $ticketmessagetype;
        $this->ticketusername = $ticketusername;
        $this->deliveryStatus = $deliveryStatus;
        $this->messageId = $messageId;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        // return new PrivateChannel("livechat.{$this->customerId}");
        return new Channel('liveChat');
    }
}
